/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.data;

import com.cburch.logisim.util.StringGetter;
import java.awt.Component;
import java.awt.Window;
import javax.swing.JTextField;

public abstract class Attribute<V> {
    private final String name;
    private final StringGetter displayName;
    private boolean hidden;

    public Attribute() {
        this("dummy", null, true);
    }

    public Attribute(String name, StringGetter disp) {
        this(name, disp, false);
    }

    public Attribute(String name, StringGetter disp, boolean hidden) {
        this.name = name;
        this.displayName = disp;
        this.hidden = hidden;
    }

    protected Component getCellEditor(V value) {
        return new JTextField(this.toDisplayString(value));
    }

    public Component getCellEditor(Window source, V value) {
        return this.getCellEditor(value);
    }

    public String getDisplayName() {
        return this.displayName != null ? this.displayName.toString() : this.name;
    }

    public String getName() {
        return this.name;
    }

    public V parse(Window source, String value) {
        return this.parse(value);
    }

    public abstract V parse(String var1);

    public String toDisplayString(V value) {
        return value == null ? "" : value.toString();
    }

    public String toStandardString(V value) {
        return value.toString().replaceAll("[\u0000-\u001f]", "").replaceAll("&#.*?;", "");
    }

    public void setHidden(boolean val) {
        this.hidden = val;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isToSave() {
        return true;
    }

    public String toString() {
        return this.name;
    }
}

