/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.data;

import com.cburch.logisim.fpga.data.BoardRectangle;
import com.cburch.logisim.fpga.data.FpgaIoInformationContainer;
import com.cburch.logisim.fpga.gui.BoardManipulator;
import com.cburch.logisim.prefs.AppPreferences;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class SimpleRectangle {
    private int x;
    private int y;
    private int width;
    private int height;
    private final FpgaIoInformationContainer toBeModified;
    private final boolean movemode;
    private boolean show;
    private final boolean fill;

    public SimpleRectangle(MouseEvent e) {
        this.toBeModified = null;
        this.x = e.getX();
        this.y = e.getY();
        this.width = 1;
        this.height = 1;
        this.show = true;
        this.fill = false;
        this.movemode = false;
    }

    public SimpleRectangle(MouseEvent e, FpgaIoInformationContainer IOinfo, float scale) {
        this.toBeModified = IOinfo;
        BoardRectangle rect = IOinfo.getRectangle();
        this.x = AppPreferences.getScaled(rect.getXpos(), scale);
        this.y = AppPreferences.getScaled(rect.getYpos(), scale);
        this.width = AppPreferences.getScaled(rect.getWidth(), scale);
        this.height = AppPreferences.getScaled(rect.getHeight(), scale);
        int offset = AppPreferences.getScaled(5, scale);
        BoardRectangle test = new BoardRectangle(this.x + this.width - offset, this.y + this.height - offset, offset, offset);
        this.show = true;
        this.fill = true;
        this.movemode = test.isPointInside(e.getX(), e.getY()) == false;
    }

    public Rectangle resizeAndGetUpdate(MouseEvent e) {
        int xmin = 0;
        int xmax = 0;
        int ymin = 0;
        int ymax = 0;
        if (this.movemode) {
            xmin = Math.min(Math.min(this.x, e.getX()), e.getX() + this.width);
            xmax = Math.max(Math.max(this.x, this.x + this.width), e.getX() + this.width);
            ymin = Math.min(Math.min(this.y, e.getY()), e.getY() + this.height);
            ymax = Math.max(Math.max(this.y, this.y + this.height), e.getY() + this.height);
            this.x = e.getX();
            this.y = e.getY();
        } else {
            xmin = Math.min(Math.min(this.x, e.getX()), this.x + this.width);
            xmax = Math.max(Math.max(this.x, e.getX()), this.x + this.width);
            ymin = Math.min(Math.min(this.y, e.getY()), this.y + this.height);
            ymax = Math.max(Math.max(this.y, e.getY()), this.y + this.height);
            this.width = e.getX() - this.x;
            this.height = e.getY() - this.y;
        }
        int off = AppPreferences.getScaled(2);
        int off2 = off << 1;
        return new Rectangle(xmin - off, ymin - off, off2 + xmax - xmin, off2 + ymax - ymin);
    }

    public FpgaIoInformationContainer getIoInfo() {
        return this.toBeModified;
    }

    public Rectangle resizeRemoveAndgetUpdate(MouseEvent e) {
        this.show = false;
        return this.resizeAndGetUpdate(e);
    }

    public BoardRectangle getBoardRectangle(float scale) {
        int xmin = Math.min(this.x, this.x + this.width);
        int xmax = Math.max(this.x, this.x + this.width);
        int ymin = Math.min(this.y, this.y + this.height);
        int ymax = Math.max(this.y, this.y + this.height);
        int width = Math.max(AppPreferences.getScaled(5, scale), xmax - xmin);
        int height = Math.max(AppPreferences.getScaled(5, scale), ymax - ymin);
        return new BoardRectangle(AppPreferences.getDownScaled(xmin, scale), AppPreferences.getDownScaled(ymin, scale), AppPreferences.getDownScaled(width, scale), AppPreferences.getDownScaled(height, scale));
    }

    public void paint(Graphics2D g) {
        if (!this.show) {
            return;
        }
        int xmin = Math.min(this.x, this.x + this.width);
        int xmax = Math.max(this.x, this.x + this.width);
        int ymin = Math.min(this.y, this.y + this.height);
        int ymax = Math.max(this.y, this.y + this.height);
        Graphics2D g1 = (Graphics2D)g.create();
        g1.setStroke(new BasicStroke(AppPreferences.getScaled(2)));
        if (this.fill) {
            g1.setColor(this.movemode ? BoardManipulator.moveColor : BoardManipulator.resizeColor);
            g1.fillRect(xmin, ymin, xmax - xmin, ymax - ymin);
        } else {
            g1.setColor(BoardManipulator.defineColor);
            g1.drawRect(xmin, ymin, xmax - xmin, ymax - ymin);
        }
        g1.dispose();
    }
}

