/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.designrulecheck;

import com.cburch.logisim.comp.Component;
import com.cburch.logisim.fpga.designrulecheck.ClockSourceContainer;
import com.cburch.logisim.fpga.designrulecheck.ClockTreeContainer;
import com.cburch.logisim.fpga.designrulecheck.ConnectionPoint;
import com.cburch.logisim.fpga.designrulecheck.Net;
import java.util.ArrayList;
import java.util.List;

public class ClockTreeFactory {
    private ClockSourceContainer sources;
    private final ArrayList<ClockTreeContainer> sourceTrees = new ArrayList();

    public void addClockNet(List<String> hierarchyNames, int clocksourceid, ConnectionPoint connection, boolean isPinClock) {
        ClockTreeContainer destination = null;
        for (ClockTreeContainer search : this.sourceTrees) {
            if (!search.equals(hierarchyNames, clocksourceid)) continue;
            destination = search;
        }
        if (destination == null) {
            destination = new ClockTreeContainer(hierarchyNames, clocksourceid, isPinClock);
            this.sourceTrees.add(destination);
        } else if (!destination.isPinClockSource() && isPinClock) {
            destination.setPinClock();
        }
        destination.addNet(connection);
    }

    public void addClockSource(List<String> hierarchyNames, int clockSourceId, ConnectionPoint connection) {
        ClockTreeContainer destination = null;
        for (ClockTreeContainer search : this.sourceTrees) {
            if (!search.equals(hierarchyNames, clockSourceId)) continue;
            destination = search;
        }
        if (destination == null) {
            destination = new ClockTreeContainer(hierarchyNames, clockSourceId, false);
            this.sourceTrees.add(destination);
        }
        destination.addSource(connection);
    }

    public void clean() {
        for (ClockTreeContainer tree : this.sourceTrees) {
            tree.clear();
        }
        this.sourceTrees.clear();
        if (this.sources != null) {
            this.sources.clear();
        }
    }

    public int getClockSourceId(List<String> hierarchy, Net selectedNet, byte selectedNetBitIndex) {
        for (int i = 0; i < this.sources.getNrofSources(); ++i) {
            for (ClockTreeContainer ThisClockNet : this.sourceTrees) {
                if (!ThisClockNet.equals(hierarchy, i)) continue;
                for (Byte clockEntry : ThisClockNet.getClockEntries(selectedNet)) {
                    if (clockEntry != selectedNetBitIndex) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    public int getClockSourceId(Component comp) {
        if (this.sources == null) {
            return -1;
        }
        return this.sources.getClockId(comp);
    }

    public ClockSourceContainer getSourceContainer() {
        if (this.sources == null) {
            this.sources = new ClockSourceContainer();
        }
        return this.sources;
    }

    public void setSourceContainer(ClockSourceContainer source) {
        this.sources = source;
    }
}

