/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.gui;

import com.cburch.contracts.BaseComponentListenerContract;
import com.cburch.logisim.fpga.Strings;
import com.cburch.logisim.fpga.data.BoardInformation;
import com.cburch.logisim.fpga.data.BoardManipulatorListener;
import com.cburch.logisim.fpga.data.IoComponentsInformation;
import com.cburch.logisim.fpga.file.BoardReaderClass;
import com.cburch.logisim.fpga.file.BoardWriterClass;
import com.cburch.logisim.fpga.file.XmlFileFilter;
import com.cburch.logisim.fpga.gui.BoardManipulator;
import com.cburch.logisim.fpga.gui.FpgaIoInformationSettingsDialog;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.util.LocaleListener;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class BoardEditor
implements ActionListener,
BaseComponentListenerContract,
LocaleListener,
BoardManipulatorListener {
    private final JFrame panel;
    private BoardInformation theBoard = new BoardInformation();
    private final JTextField boardNameInput;
    private final JButton saveButton = new JButton();
    private final JButton loadButton = new JButton();
    private final JButton importButton = new JButton();
    private final JButton cancelButton = new JButton();
    private final JButton fpgaButton = new JButton();
    private final JLabel locTextLabel = new JLabel();
    private final BoardManipulator picturepanel;
    private static final String cancelStr = "cancel";
    private static final String fpgaStr = "fpgainfo";

    public BoardEditor() {
        GridBagConstraints gbc = new GridBagConstraints();
        this.panel = new JFrame();
        this.panel.setResizable(false);
        this.panel.addComponentListener(this);
        this.panel.setDefaultCloseOperation(1);
        GridBagLayout thisLayout = new GridBagLayout();
        this.panel.setLayout(thisLayout);
        this.picturepanel = new BoardManipulator(this.panel);
        this.picturepanel.addComponentListener(this);
        this.picturepanel.addBoardManipulatorListener(this);
        JPanel buttonPanel = new JPanel();
        GridBagLayout buttonLayout = new GridBagLayout();
        buttonPanel.setLayout(buttonLayout);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 2;
        buttonPanel.add((Component)this.locTextLabel, gbc);
        this.boardNameInput = new JTextField(22);
        this.boardNameInput.setEnabled(false);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.fill = 2;
        buttonPanel.add((Component)this.boardNameInput, gbc);
        gbc.gridx = 4;
        gbc.gridy = 1;
        gbc.fill = 2;
        this.cancelButton.setActionCommand(cancelStr);
        this.cancelButton.addActionListener(this);
        buttonPanel.add((Component)this.cancelButton, gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        this.fpgaButton.setActionCommand(fpgaStr);
        this.fpgaButton.addActionListener(this);
        this.fpgaButton.setEnabled(false);
        buttonPanel.add((Component)this.fpgaButton, gbc);
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.fill = 2;
        buttonPanel.add((Component)this.picturepanel.getZoomSlider(), gbc);
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.fill = 2;
        this.loadButton.setActionCommand("load");
        this.loadButton.addActionListener(this);
        this.loadButton.setEnabled(true);
        buttonPanel.add((Component)this.loadButton, gbc);
        gbc.gridx = 4;
        this.importButton.setActionCommand("internal");
        this.importButton.addActionListener(this);
        buttonPanel.add((Component)this.importButton, gbc);
        gbc.gridx = 3;
        gbc.gridy = 1;
        gbc.fill = 2;
        this.saveButton.setActionCommand("save");
        this.saveButton.addActionListener(this);
        this.saveButton.setEnabled(false);
        buttonPanel.add((Component)this.saveButton, gbc);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        this.panel.add((Component)buttonPanel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 2;
        this.panel.add((Component)this.picturepanel, gbc);
        this.panel.setLocationRelativeTo(null);
        this.panel.setVisible(true);
        int screenWidth = (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        int screenHeight = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        int imageWidth = this.picturepanel.getWidth();
        int imageHeight = this.picturepanel.getHeight();
        int imageBorderX = this.panel.getWidth() - imageWidth;
        int imageBorderY = this.panel.getHeight() - imageHeight;
        int zoomX = (screenWidth -= imageBorderX) * 100 / imageWidth;
        int zoomY = (screenHeight -= imageBorderY + (imageBorderY >> 1)) * 100 / imageHeight;
        this.picturepanel.setMaxZoom(Math.min(zoomX, zoomY));
        this.localeChanged();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        switch (e.getActionCommand()) {
            case "cancel": {
                this.clear();
                break;
            }
            case "save": {
                this.panel.setVisible(false);
                this.theBoard.setBoardName(this.boardNameInput.getText());
                Object filename = this.getDirName("", Strings.S.get("FpgaBoardSaveDir"));
                filename = (String)filename + this.theBoard.getBoardName() + ".xml";
                this.theBoard.setComponents(this.picturepanel.getIoComponents());
                BoardWriterClass xmlwriter = new BoardWriterClass(this.theBoard, this.picturepanel.getImage());
                xmlwriter.printXml((String)filename);
                this.clear();
                break;
            }
            case "load": {
                JFileChooser fc = new JFileChooser(Strings.S.get("FpgaBoardLoadFile"));
                fc.setFileSelectionMode(2);
                fc.setFileFilter(XmlFileFilter.XML_FILTER);
                fc.setAcceptAllFileFilterUsed(false);
                int retval = fc.showOpenDialog(null);
                if (retval != 0) break;
                File file = fc.getSelectedFile();
                String FileName = file.getPath();
                BoardReaderClass reader = new BoardReaderClass(FileName);
                this.updateInfo(reader);
                break;
            }
            case "fpgainfo": {
                FpgaIoInformationSettingsDialog.getFpgaInformation(this.panel, this.theBoard);
                if (!this.picturepanel.hasIOComponents() || !this.theBoard.fpga.isFpgaInfoPresent()) break;
                this.saveButton.setEnabled(true);
                break;
            }
            case "internal": {
                String Board = this.getInternalBoardName();
                if (Board == null) break;
                BoardReaderClass reader = new BoardReaderClass(AppPreferences.Boards.getBoardFilePath(Board));
                this.updateInfo(reader);
            }
        }
    }

    private void updateInfo(BoardReaderClass reader) {
        this.theBoard = reader.getBoardInformation();
        this.picturepanel.setBoard(this.theBoard);
        this.picturepanel.repaint();
    }

    private String getInternalBoardName() {
        List<String> boards = AppPreferences.Boards.getBoardNames();
        return (String)OptionPane.showInputDialog(this.panel, Strings.S.get("FpgaBoardSelect"), Strings.S.get("FpgaBoardLoadInternal"), -1, null, boards.toArray(), boards.get(0));
    }

    private String checkIfEndsWithSlash(String path) {
        if (!((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        return path;
    }

    public void clear() {
        if (this.panel.isVisible()) {
            this.panel.setVisible(false);
        }
        this.picturepanel.clear();
        this.theBoard.clear();
        this.boardNameInput.setText("");
        this.saveButton.setEnabled(false);
        this.fpgaButton.setEnabled(false);
        this.loadButton.setEnabled(true);
        this.importButton.setEnabled(true);
    }

    @Override
    public void componentResized(ComponentEvent event) {
        this.panel.pack();
    }

    private String getDirName(String old, String windowName) {
        JFileChooser fc = new JFileChooser(old);
        fc.setFileSelectionMode(1);
        fc.setDialogTitle(windowName);
        int retval = fc.showOpenDialog(null);
        if (retval == 0) {
            File file = fc.getSelectedFile();
            old = this.checkIfEndsWithSlash(file.getPath());
        }
        return old;
    }

    public JFrame getPanel() {
        return this.panel;
    }

    public boolean isActive() {
        return this.panel.isVisible();
    }

    public void setActive() {
        this.clear();
        this.panel.setVisible(true);
    }

    @Override
    public void localeChanged() {
        this.panel.setTitle(Strings.S.get("FPGABoardEditor"));
        this.locTextLabel.setText(Strings.S.get("FpgaBoardName"));
        this.cancelButton.setText(Strings.S.get("FpgaBoardCancel"));
        this.loadButton.setText(Strings.S.get("FpgaBoardLoadExternal"));
        this.importButton.setText(Strings.S.get("FpgaBoardLoadInternal"));
        this.saveButton.setText(Strings.S.get("FpgaBoardSave"));
        this.fpgaButton.setText(Strings.S.get("FpgaBoardFpgaParam"));
        this.panel.pack();
    }

    @Override
    public void boardNameChanged(String newBoardName) {
        this.boardNameInput.setEnabled(true);
        this.boardNameInput.setText(newBoardName);
        this.theBoard.setBoardName(newBoardName);
        this.loadButton.setEnabled(false);
        this.importButton.setEnabled(false);
        this.fpgaButton.setEnabled(true);
        this.saveButton.setEnabled(this.picturepanel.hasIOComponents() && this.theBoard.fpga.isFpgaInfoPresent());
    }

    @Override
    public void componentsChanged(IoComponentsInformation ioComps) {
        this.saveButton.setEnabled(ioComps.hasComponents() && this.theBoard.fpga.isFpgaInfoPresent());
    }
}

