/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.gui;

import com.cburch.draw.shapes.Rectangle;
import com.cburch.logisim.fpga.Strings;
import com.cburch.logisim.fpga.data.BoardInformation;
import com.cburch.logisim.fpga.data.BoardRectangle;
import com.cburch.logisim.fpga.data.DriveStrength;
import com.cburch.logisim.fpga.data.FpgaIoInformationContainer;
import com.cburch.logisim.fpga.data.IoComponentTypes;
import com.cburch.logisim.fpga.data.IoComponentsInformation;
import com.cburch.logisim.fpga.data.IoStandards;
import com.cburch.logisim.fpga.data.LedArrayDriving;
import com.cburch.logisim.fpga.data.PinActivity;
import com.cburch.logisim.fpga.data.PullBehaviors;
import com.cburch.logisim.fpga.data.SevenSegmentScanningDriving;
import com.cburch.logisim.fpga.gui.DialogNotification;
import com.cburch.logisim.fpga.settings.VendorSoftware;
import com.cburch.logisim.std.io.LedArrayGenericHdlGeneratorFactory;
import com.cburch.logisim.std.io.SevenSegment;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class FpgaIoInformationSettingsDialog {
    private static final int INPUT_ID = 0;
    private static final int OUTPUT_ID = 1;
    private static final int IO_ID = 2;
    private static boolean abort;
    private static JComboBox<Integer> decodedBits;
    private static JLabel decodedString;

    private static void buildPinTable(int nr, IoComponentTypes type, JPanel pinPanel, ArrayList<JTextField> LocInputs, ArrayList<String> PinLabels, ArrayList<String> oldLocations) {
        GridBagConstraints gbc = new GridBagConstraints();
        pinPanel.removeAll();
        if (LocInputs.size() == 0) {
            for (int i = 0; i < nr; ++i) {
                JTextField txt = new JTextField(6);
                if (i < oldLocations.size()) {
                    txt.setText(oldLocations.get(i));
                }
                LocInputs.add(txt);
            }
        }
        while (LocInputs.size() < nr) {
            JTextField txt = new JTextField(6);
            LocInputs.add(txt);
            int idx = LocInputs.indexOf(txt);
            if (idx >= oldLocations.size()) continue;
            txt.setText(oldLocations.get(idx));
        }
        while (LocInputs.size() > nr) {
            LocInputs.remove(LocInputs.size() - 1);
        }
        int offset = 0;
        int oldY = 0;
        int maxY = -1;
        for (int i = 0; i < nr; ++i) {
            if (i % 16 == 0) {
                offset = i / 16 * 2;
                gbc.gridy = oldY;
            }
            JLabel LocText = new JLabel(Strings.S.get("FpgaIoLocation", PinLabels.get(i)));
            gbc.gridx = 0 + offset;
            ++gbc.gridy;
            pinPanel.add((Component)LocText, gbc);
            gbc.gridx = 1 + offset;
            pinPanel.add((Component)LocInputs.get(i), gbc);
            maxY = Math.max(gbc.gridy, maxY);
        }
    }

    private static void updateScanningRequirements(int nrOfDigits, int nrOfDecodedBits, char driveMode, FpgaIoInformationContainer info, JPanel pinPanel, ArrayList<JTextField> LocInputs, ArrayList<String> oldLocations, HashMap<Integer, Integer> NrOfPins) {
        int nrOfDecodeBits;
        ArrayList<String> pinLabels = new ArrayList<String>();
        boolean isDecoded = driveMode == '\u0000';
        decodedBits.setVisible(isDecoded);
        decodedString.setVisible(isDecoded);
        if (isDecoded && nrOfDecodedBits < (nrOfDecodeBits = Math.max((int)Math.ceil(Math.log(nrOfDigits) / Math.log(2.0)), nrOfDecodedBits))) {
            decodedBits.setSelectedIndex(nrOfDecodeBits - 1);
            info.setNrOfColumns(nrOfDecodeBits);
        }
        NrOfPins.clear();
        NrOfPins.put(0, 0);
        NrOfPins.put(2, 0);
        int nrOfPins = 8;
        pinLabels.addAll(SevenSegment.getLabels());
        int nrOfControlPins = driveMode == '\u0000' ? Math.max((int)Math.ceil(Math.log(nrOfDigits) / Math.log(2.0)), nrOfDecodedBits) : nrOfDigits;
        nrOfPins += nrOfControlPins;
        String pinName = driveMode == '\u0000' ? "A" : "Seg";
        for (int contrPin = 0; contrPin < nrOfControlPins; ++contrPin) {
            pinLabels.add(String.format("%s%d", pinName, contrPin));
        }
        NrOfPins.put(1, nrOfPins);
        FpgaIoInformationSettingsDialog.buildPinTable(nrOfPins, IoComponentTypes.SevenSegmentScanning, pinPanel, LocInputs, pinLabels, oldLocations);
    }

    private static void updateLedArrayRequirements(int nrOfRows, int nrOfColumns, char driveMode, JPanel pinPanel, ArrayList<JTextField> LocInputs, ArrayList<String> oldLocations, HashMap<Integer, Integer> NrOfPins) {
        ArrayList<String> pinLabels = new ArrayList<String>();
        NrOfPins.clear();
        NrOfPins.put(0, 0);
        NrOfPins.put(2, 0);
        int nrOfPins = 0;
        switch (driveMode) {
            case '\u0000': {
                nrOfPins = nrOfRows * nrOfColumns;
                for (int row = 0; row < nrOfRows; ++row) {
                    for (int col = 0; col < nrOfColumns; ++col) {
                        pinLabels.add("Row_" + row + "_Col_" + col);
                    }
                }
                break;
            }
            case '\u0001': {
                int nrBits = LedArrayGenericHdlGeneratorFactory.getNrOfBitsRequired(nrOfRows);
                nrOfPins = nrBits + nrOfColumns;
                for (int i = 0; i < nrOfPins; ++i) {
                    if (i < nrBits) {
                        pinLabels.add("RowAddress_" + i);
                        continue;
                    }
                    pinLabels.add("Col_" + (i - nrBits));
                }
                break;
            }
            case '\u0002': {
                int nrBits = LedArrayGenericHdlGeneratorFactory.getNrOfBitsRequired(nrOfColumns);
                nrOfPins = nrBits + nrOfRows;
                for (int i = 0; i < nrOfPins; ++i) {
                    if (i < nrBits) {
                        pinLabels.add("ColumnAddress_" + i);
                        continue;
                    }
                    pinLabels.add("Row_" + (i - nrBits));
                }
                break;
            }
            case '\u0003': {
                nrOfPins = nrOfRows * nrOfColumns * 3;
                String preamble = "";
                for (int rgb = 0; rgb < 3; ++rgb) {
                    preamble = switch (rgb) {
                        case 0 -> "Red_";
                        case 1 -> "Green_";
                        default -> "Blue_";
                    };
                    for (int row = 0; row < nrOfRows; ++row) {
                        for (int col = 0; col < nrOfColumns; ++col) {
                            pinLabels.add(preamble + "Row_" + row + "_Col_" + col);
                        }
                    }
                }
                break;
            }
            case '\u0004': {
                int nrBits = LedArrayGenericHdlGeneratorFactory.getNrOfBitsRequired(nrOfRows);
                nrOfPins = nrBits + 3 * nrOfColumns;
                String preamble = "";
                for (int i = 0; i < nrOfPins; ++i) {
                    if (i < nrBits) {
                        pinLabels.add("RowAddress_" + i);
                        continue;
                    }
                    int id = i - nrBits;
                    int rgb = id / nrOfColumns;
                    int col = id % nrOfColumns;
                    preamble = switch (rgb) {
                        case 0 -> "Red_";
                        case 1 -> "Green_";
                        default -> "Blue_";
                    };
                    pinLabels.add(preamble + "Col_" + col);
                }
                break;
            }
            case '\u0005': {
                int nrBits = LedArrayGenericHdlGeneratorFactory.getNrOfBitsRequired(nrOfColumns);
                nrOfPins = nrBits + 3 * nrOfRows;
                String preamble = "";
                for (int i = 0; i < nrOfPins; ++i) {
                    if (i < nrBits) {
                        pinLabels.add("ColumnAddress_" + i);
                        continue;
                    }
                    int id = i - nrBits;
                    int rgb = id / nrOfRows;
                    int col = id % nrOfRows;
                    preamble = switch (rgb) {
                        case 0 -> "Red_";
                        case 1 -> "Green_";
                        default -> "Blue_";
                    };
                    pinLabels.add(preamble + "Row_" + col);
                }
                break;
            }
            default: {
                nrOfPins = 0;
            }
        }
        NrOfPins.put(1, nrOfPins);
        FpgaIoInformationSettingsDialog.buildPinTable(nrOfPins, IoComponentTypes.LedArray, pinPanel, LocInputs, pinLabels, oldLocations);
    }

    private static JPanel getRectPanel(ArrayList<JTextField> rectLocations) {
        JPanel rectPanel = new JPanel();
        rectPanel.setLayout(new GridBagLayout());
        rectPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 2, true), Strings.S.get("FpgaIoRecProp")));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridy = 0;
        gbc.gridx = 0;
        rectPanel.add((Component)new JLabel(Strings.S.get("FpgaIoXpos")), gbc);
        ++gbc.gridy;
        rectPanel.add((Component)new JLabel(Strings.S.get("FpgaIoYpos")), gbc);
        ++gbc.gridy;
        rectPanel.add((Component)new JLabel(Strings.S.get("FpgaIoWidth")), gbc);
        ++gbc.gridy;
        rectPanel.add((Component)new JLabel(Strings.S.get("FpgaIoHeight")), gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        while (gbc.gridy < 4) {
            rectPanel.add((Component)rectLocations.get(gbc.gridy), gbc);
            ++gbc.gridy;
        }
        return rectPanel;
    }

    public static void getSimpleInformationDialog(Boolean deleteButton, IoComponentsInformation IOcomps, FpgaIoInformationContainer info) {
        GridBagConstraints arr;
        JPanel panel;
        HashMap<Integer, Integer> nrOfPins = new HashMap<Integer, Integer>();
        JDialog selWindow = new JDialog(IOcomps.getParentFrame(), String.valueOf((Object)info.getType()) + " " + Strings.S.get("FpgaIoProperties"));
        JPanel contents = new JPanel();
        JComboBox<String> driveInput = new JComboBox<String>(DriveStrength.BEHAVIOR_STRINGS);
        JComboBox<String> pullInput = new JComboBox<String>(PullBehaviors.BEHAVIOR_STRINGS);
        JComboBox<String> activeInput = new JComboBox<String>(PinActivity.BEHAVIOR_STRINGS);
        JComboBox<Integer> inputSize = new JComboBox<Integer>();
        JComboBox<Integer> outputSize = new JComboBox<Integer>();
        JComboBox<Integer> ioSize = new JComboBox<Integer>();
        JComboBox<Integer> rowSize = new JComboBox<Integer>();
        JComboBox<Integer> colSize = new JComboBox<Integer>();
        JComboBox<String> eEncoding = new JComboBox<String>();
        JComboBox<String> mapRotation = new JComboBox<String>();
        ArrayList<JTextField> locInputs = new ArrayList<JTextField>();
        ArrayList<JTextField> locOutputs = new ArrayList<JTextField>();
        ArrayList<JTextField> locIos = new ArrayList<JTextField>();
        ArrayList<String> pinLabels = new ArrayList<String>();
        JPanel arrayPanel = new JPanel();
        JPanel scanningPanel = new JPanel();
        JPanel inputsPanel = new JPanel();
        JPanel outputsPanel = new JPanel();
        JPanel ioPanel = new JPanel();
        boolean abort = false;
        ArrayList<JTextField> rectLocations = new ArrayList<JTextField>();
        ArrayList<String> oldInputLocations = new ArrayList<String>();
        ArrayList<String> oldOutputLocations = new ArrayList<String>();
        ArrayList<String> oldIoLocations = new ArrayList<String>();
        IoComponentTypes myType = info.getType();
        int myRotation = info.getMapRotation();
        BoardRectangle MyRectangle = info.getRectangle();
        if (info.getNrOfPins() == 0) {
            nrOfPins.put(0, IoComponentTypes.getFpgaInputRequirement(myType));
            nrOfPins.put(1, IoComponentTypes.getFpgaOutputRequirement(myType));
            nrOfPins.put(2, IoComponentTypes.getFpgaInOutRequirement(myType));
        } else {
            nrOfPins.put(0, info.getNrOfInputPins());
            nrOfPins.put(1, info.getNrOfOutputPins());
            nrOfPins.put(2, info.getNrOfIoPins());
        }
        for (int cnt = 0; cnt < info.getNrOfPins(); ++cnt) {
            if (cnt < (Integer)nrOfPins.get(0)) {
                oldInputLocations.add(info.getPinLocation(cnt));
                continue;
            }
            if (cnt < (Integer)nrOfPins.get(0) + (Integer)nrOfPins.get(1)) {
                oldOutputLocations.add(info.getPinLocation(cnt));
                continue;
            }
            oldIoLocations.add(info.getPinLocation(cnt));
        }
        ActionListener actionListener = e -> {
            switch (e.getActionCommand()) {
                case "inputSize": {
                    int nr = (Integer)inputSize.getSelectedItem();
                    nrOfPins.put(0, nr);
                    pinLabels.clear();
                    for (int i = 0; i < nr; ++i) {
                        pinLabels.add(IoComponentTypes.getInputLabel(nr, i, myType));
                    }
                    FpgaIoInformationSettingsDialog.buildPinTable(nr, myType, inputsPanel, locInputs, pinLabels, oldInputLocations);
                    selWindow.pack();
                    return;
                }
                case "outputSize": {
                    int nr = (Integer)outputSize.getSelectedItem();
                    nrOfPins.put(1, nr);
                    pinLabels.clear();
                    for (int i = 0; i < nr; ++i) {
                        pinLabels.add(IoComponentTypes.getOutputLabel(nr, 0, 0, i, myType));
                    }
                    FpgaIoInformationSettingsDialog.buildPinTable(nr, myType, outputsPanel, locOutputs, pinLabels, oldOutputLocations);
                    selWindow.pack();
                    return;
                }
                case "ioSize": {
                    int nr = (Integer)ioSize.getSelectedItem();
                    nrOfPins.put(2, nr);
                    pinLabels.clear();
                    for (int i = 0; i < nr; ++i) {
                        pinLabels.add(IoComponentTypes.getIoLabel(nr, i, myType));
                    }
                    FpgaIoInformationSettingsDialog.buildPinTable(nr, myType, ioPanel, locIos, pinLabels, oldIoLocations);
                    selWindow.pack();
                    return;
                }
                case "LedArray": {
                    info.setNrOfRows(rowSize.getSelectedIndex() + 1);
                    info.setNrOfColumns(colSize.getSelectedIndex() + 1);
                    info.setArrayDriveMode((char)eEncoding.getSelectedIndex());
                    FpgaIoInformationSettingsDialog.updateLedArrayRequirements(info.getNrOfRows(), info.getNrOfColumns(), info.getArrayDriveMode(), outputsPanel, locOutputs, oldOutputLocations, nrOfPins);
                    selWindow.pack();
                    return;
                }
                case "ScanningArray": {
                    char driveMode = (char)eEncoding.getSelectedIndex();
                    info.setNrOfRows(rowSize.getSelectedIndex() + 2);
                    info.setArrayDriveMode(driveMode);
                    info.setNrOfColumns(driveMode == '\u0000' ? decodedBits.getSelectedIndex() + 1 : -1);
                    FpgaIoInformationSettingsDialog.updateScanningRequirements(info.getNrOfRows(), info.getNrOfColumns(), info.getArrayDriveMode(), info, outputsPanel, locOutputs, oldOutputLocations, nrOfPins);
                    selWindow.pack();
                    return;
                }
                case "cancel": {
                    info.setType(IoComponentTypes.Unknown);
                    break;
                }
                case "delete": {
                    info.setToBeDeleted();
                }
            }
            selWindow.setVisible(false);
            selWindow.dispose();
        };
        contents.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = -1;
        if (MyRectangle != null) {
            JTextField tf = new JTextField(5);
            tf.setText(Integer.toString(MyRectangle.getXpos()));
            rectLocations.add(tf);
            tf = new JTextField(5);
            tf.setText(Integer.toString(MyRectangle.getYpos()));
            rectLocations.add(tf);
            tf = new JTextField(5);
            tf.setText(Integer.toString(MyRectangle.getWidth()));
            rectLocations.add(tf);
            tf = new JTextField(5);
            tf.setText(Integer.toString(MyRectangle.getHeight()));
            rectLocations.add(tf);
            gbc.fill = 11;
            ++gbc.gridy;
            gbc.gridwidth = 2;
            contents.add((Component)FpgaIoInformationSettingsDialog.getRectPanel(rectLocations), gbc);
            gbc.gridwidth = 1;
        }
        gbc.fill = 2;
        if (IoComponentTypes.hasRotationAttribute(myType).booleanValue()) {
            panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 2, true), Strings.S.get("FpgaRotationDefinition")));
            mapRotation.addItem(Strings.S.get(IoComponentTypes.getRotationString(myType, 0)));
            mapRotation.addItem(Strings.S.get(IoComponentTypes.getRotationString(myType, -90)));
            mapRotation.addItem(Strings.S.get(IoComponentTypes.getRotationString(myType, 90)));
            panel.add(mapRotation, "Center");
            switch (myRotation) {
                case -90: {
                    mapRotation.setSelectedIndex(1);
                    break;
                }
                case 90: {
                    mapRotation.setSelectedIndex(2);
                    break;
                }
                default: {
                    mapRotation.setSelectedIndex(0);
                }
            }
            ++gbc.gridy;
            gbc.gridwidth = 2;
            contents.add((Component)panel, gbc);
            gbc.gridwidth = 1;
        }
        if (myType.equals((Object)IoComponentTypes.LedArray)) {
            panel = new JPanel();
            panel.setLayout(new GridBagLayout());
            panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 2, true), Strings.S.get("FpgaArrayDefinition")));
            arrayPanel.setLayout(new GridBagLayout());
            rowSize.removeAll();
            colSize.removeAll();
            for (int i = 1; i < 33; ++i) {
                rowSize.addItem(i);
                colSize.addItem(i);
            }
            rowSize.setSelectedIndex(info.getNrOfRows() - 1);
            colSize.setSelectedIndex(info.getNrOfColumns() - 1);
            eEncoding.removeAll();
            for (String val : LedArrayDriving.getDisplayStrings()) {
                eEncoding.addItem(val);
            }
            eEncoding.setSelectedIndex(info.getArrayDriveMode());
            rowSize.setActionCommand("LedArray");
            rowSize.addActionListener(actionListener);
            colSize.setActionCommand("LedArray");
            colSize.addActionListener(actionListener);
            eEncoding.setActionCommand("LedArray");
            eEncoding.addActionListener(actionListener);
            arr = new GridBagConstraints();
            arr.gridx = 0;
            arr.gridy = 0;
            arr.gridwidth = 2;
            panel.add((Component)new JLabel(Strings.S.get("FpgaArrayDriving")), arr);
            ++arr.gridy;
            panel.add(eEncoding, arr);
            arr.gridwidth = 1;
            ++arr.gridy;
            panel.add((Component)new JLabel(Strings.S.get("FpgaArrayRows")), arr);
            ++arr.gridx;
            panel.add(rowSize, arr);
            ++arr.gridy;
            panel.add(colSize, arr);
            --arr.gridx;
            panel.add((Component)new JLabel(Strings.S.get("FpgaArrayCols")), arr);
            ++gbc.gridy;
            gbc.gridwidth = 2;
            contents.add((Component)panel, gbc);
            gbc.gridwidth = 1;
        }
        if (myType.equals((Object)IoComponentTypes.SevenSegmentScanning)) {
            panel = new JPanel();
            panel.setLayout(new GridBagLayout());
            panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 2, true), Strings.S.get("FpgaScanningDefinition")));
            scanningPanel.setLayout(new GridBagLayout());
            rowSize.removeAll();
            for (int nrOfSegments = 2; nrOfSegments < 16; ++nrOfSegments) {
                rowSize.addItem(nrOfSegments);
            }
            rowSize.setSelectedIndex(info.getNrOfRows() - 2);
            eEncoding.removeAll();
            for (String val : SevenSegmentScanningDriving.getDisplayStrings()) {
                eEncoding.addItem(val);
            }
            eEncoding.setSelectedIndex(info.getArrayDriveMode());
            decodedBits = new JComboBox();
            for (int nrOfDecodedBits = 1; nrOfDecodedBits < 6; ++nrOfDecodedBits) {
                decodedBits.addItem(nrOfDecodedBits);
            }
            if (info.getArrayDriveMode() != '\u0000') {
                decodedBits.setVisible(false);
            } else {
                decodedBits.setSelectedIndex(info.getNrOfColumns() - 1);
            }
            decodedString = new JLabel(Strings.S.get("FpgaNrOfDecodeBits"));
            decodedBits.setActionCommand("ScanningArray");
            decodedBits.addActionListener(actionListener);
            rowSize.setActionCommand("ScanningArray");
            rowSize.addActionListener(actionListener);
            eEncoding.setActionCommand("ScanningArray");
            eEncoding.addActionListener(actionListener);
            arr = new GridBagConstraints();
            arr.gridx = 0;
            arr.gridy = 0;
            panel.add((Component)new JLabel(Strings.S.get("FpgaScanningDriving")), arr);
            ++arr.gridx;
            panel.add(eEncoding, arr);
            ++arr.gridy;
            panel.add(rowSize, arr);
            --arr.gridx;
            panel.add((Component)new JLabel(Strings.S.get("FpgaNrOfSegments")), arr);
            ++arr.gridy;
            panel.add((Component)decodedString, arr);
            ++arr.gridx;
            panel.add(decodedBits, arr);
            ++gbc.gridy;
            gbc.gridwidth = 2;
            contents.add((Component)panel, gbc);
            gbc.gridwidth = 1;
        }
        if ((Integer)nrOfPins.get(0) > 0) {
            panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 2, true), Strings.S.get("FpgaIoInpPins")));
            inputsPanel.setLayout(new GridBagLayout());
            if (IoComponentTypes.nrOfInputPinsConfigurable(myType)) {
                inputSize.removeAllItems();
                for (int i = 1; i < 129; ++i) {
                    inputSize.addItem(i);
                }
                inputSize.setSelectedItem(nrOfPins.get(0));
                inputSize.addActionListener(actionListener);
                inputSize.setActionCommand("inputSize");
                panel.add(inputSize, "North");
            }
            pinLabels.clear();
            Integer nr = (Integer)nrOfPins.get(0);
            for (int i = 0; i < nr; ++i) {
                pinLabels.add(IoComponentTypes.getOutputLabel(nr, 0, 0, i, myType));
            }
            FpgaIoInformationSettingsDialog.buildPinTable((Integer)nrOfPins.get(0), myType, inputsPanel, locInputs, pinLabels, oldInputLocations);
            panel.add((Component)inputsPanel, "Center");
            ++gbc.gridy;
            gbc.gridwidth = 2;
            contents.add((Component)panel, gbc);
            gbc.gridwidth = 1;
        }
        if ((Integer)nrOfPins.get(1) > 0) {
            panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 2, true), Strings.S.get("FpgaIoOutpPins")));
            outputsPanel.setLayout(new GridBagLayout());
            if (IoComponentTypes.nrOfOutputPinsConfigurable(myType)) {
                outputSize.removeAllItems();
                for (int i = 1; i < 129; ++i) {
                    outputSize.addItem(i);
                }
                outputSize.setSelectedItem(nrOfPins.get(1));
                outputSize.addActionListener(actionListener);
                outputSize.setActionCommand("outputSize");
                panel.add(outputSize, "North");
            }
            if (myType != IoComponentTypes.LedArray && myType != IoComponentTypes.SevenSegmentScanning) {
                pinLabels.clear();
                Integer nr = (Integer)nrOfPins.get(1);
                for (int i = 0; i < nr; ++i) {
                    pinLabels.add(IoComponentTypes.getOutputLabel(nr, 0, 0, i, myType));
                }
                FpgaIoInformationSettingsDialog.buildPinTable(nrOfPins.get(1), myType, outputsPanel, locOutputs, pinLabels, oldOutputLocations);
            } else if (myType == IoComponentTypes.LedArray) {
                FpgaIoInformationSettingsDialog.updateLedArrayRequirements(info.getNrOfRows(), info.getNrOfColumns(), info.getArrayDriveMode(), outputsPanel, locOutputs, oldOutputLocations, nrOfPins);
            } else {
                FpgaIoInformationSettingsDialog.updateScanningRequirements(info.getNrOfRows(), info.getNrOfColumns(), info.getArrayDriveMode(), info, outputsPanel, locOutputs, oldOutputLocations, nrOfPins);
            }
            panel.add((Component)outputsPanel, "Center");
            ++gbc.gridy;
            gbc.gridwidth = 2;
            contents.add((Component)panel, gbc);
            gbc.gridwidth = 1;
        }
        if ((Integer)nrOfPins.get(2) > 0) {
            panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 2, true), Strings.S.get("FpgaIoIOPins")));
            ioPanel.setLayout(new GridBagLayout());
            if (IoComponentTypes.nrOfIoPinsConfigurable(myType)) {
                ioSize.removeAllItems();
                for (int i = 1; i < 129; ++i) {
                    ioSize.addItem(i);
                }
                ioSize.setSelectedItem(nrOfPins.get(2));
                ioSize.addActionListener(actionListener);
                ioSize.setActionCommand("ioSize");
                panel.add(ioSize, "North");
            }
            pinLabels.clear();
            Integer nr = (Integer)nrOfPins.get(2);
            for (int i = 0; i < nr; ++i) {
                pinLabels.add(IoComponentTypes.getIoLabel(nr, i, myType));
            }
            FpgaIoInformationSettingsDialog.buildPinTable(nrOfPins.get(2), myType, ioPanel, locIos, pinLabels, oldIoLocations);
            panel.add((Component)ioPanel, "Center");
            ++gbc.gridy;
            gbc.gridwidth = 2;
            contents.add((Component)panel, gbc);
            gbc.gridwidth = 1;
        }
        JLabel LabText = new JLabel(Strings.S.get("FpgaIoLabel"));
        ++gbc.gridy;
        gbc.gridx = 0;
        contents.add((Component)LabText, gbc);
        JTextField LabelInput = new JTextField(6);
        LabelInput.setText(info.getLabel());
        gbc.gridx = 1;
        contents.add((Component)LabelInput, gbc);
        JLabel StandardText = new JLabel(Strings.S.get("FpgaIoStandard"));
        ++gbc.gridy;
        gbc.gridx = 0;
        contents.add((Component)StandardText, gbc);
        JComboBox<String> StandardInput = new JComboBox<String>(IoStandards.BEHAVIOR_STRINGS);
        if (info.getIoStandard() != '\u00ff') {
            StandardInput.setSelectedIndex(info.getIoStandard());
        } else {
            StandardInput.setSelectedIndex(IOcomps.getDefaultStandard());
        }
        gbc.gridx = 1;
        contents.add(StandardInput, gbc);
        if (IoComponentTypes.OUTPUT_COMPONENT_SET.contains((Object)myType)) {
            JLabel DriveText = new JLabel(Strings.S.get("FpgaIoStrength"));
            ++gbc.gridy;
            gbc.gridx = 0;
            contents.add((Component)DriveText, gbc);
            if (info.getDrive() != '\u00ff') {
                driveInput.setSelectedIndex(info.getDrive());
            } else {
                driveInput.setSelectedIndex(IOcomps.getDefaultDriveStrength());
            }
            gbc.gridx = 1;
            contents.add(driveInput, gbc);
        }
        if (IoComponentTypes.INPUT_COMPONENT_SET.contains((Object)myType)) {
            JLabel PullText = new JLabel(Strings.S.get("FpgaIoPull"));
            ++gbc.gridy;
            gbc.gridx = 0;
            contents.add((Component)PullText, gbc);
            if (info.getPullBehavior() != '\u00ff') {
                pullInput.setSelectedIndex(info.getPullBehavior());
            } else {
                pullInput.setSelectedIndex(IOcomps.getDefaultPullSelection());
            }
            gbc.gridx = 1;
            contents.add(pullInput, gbc);
        }
        if (!IoComponentTypes.IN_OUT_COMPONENT_SET.contains((Object)myType)) {
            JLabel ActiveText = new JLabel(Strings.S.get("FpgaIoActivity", new Object[]{myType}));
            ++gbc.gridy;
            gbc.gridx = 0;
            contents.add((Component)ActiveText, gbc);
            if (info.getActivityLevel() != '\u00ff') {
                activeInput.setSelectedIndex(info.getActivityLevel());
            } else {
                activeInput.setSelectedIndex(IOcomps.getDefaultActivity());
            }
            gbc.gridx = 1;
            contents.add(activeInput, gbc);
        }
        if (deleteButton.booleanValue()) {
            JButton delButton = new JButton();
            delButton.setActionCommand("delete");
            delButton.addActionListener(actionListener);
            delButton.setText(Strings.S.get("FpgaIoDelete"));
            gbc.gridwidth = 2;
            gbc.gridx = 0;
            ++gbc.gridy;
            contents.add((Component)delButton, gbc);
            gbc.gridwidth = 1;
        }
        JButton OkayButton = new JButton(Strings.S.get("FpgaBoardDone"));
        OkayButton.setActionCommand("done");
        OkayButton.addActionListener(actionListener);
        gbc.gridx = 1;
        ++gbc.gridy;
        contents.add((Component)OkayButton, gbc);
        final JButton CancelButton = new JButton(Strings.S.get("FpgaBoardCancel"));
        CancelButton.setActionCommand("cancel");
        CancelButton.addActionListener(actionListener);
        gbc.gridx = 0;
        contents.add((Component)CancelButton, gbc);
        selWindow.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                CancelButton.doClick();
            }
        });
        selWindow.add(new JScrollPane(contents));
        selWindow.pack();
        selWindow.setLocationRelativeTo(IOcomps.getParentFrame());
        selWindow.setModal(true);
        selWindow.setDefaultCloseOperation(0);
        selWindow.setAlwaysOnTop(true);
        abort = false;
        while (!abort) {
            int i;
            int i2;
            selWindow.setVisible(true);
            if (abort |= info.getType().equals((Object)IoComponentTypes.Unknown)) continue;
            int NrPins = nrOfPins.get(0) + nrOfPins.get(1) + nrOfPins.get(2);
            boolean correct = true;
            for (i2 = 0; i2 < nrOfPins.get(0); ++i2) {
                if (!locInputs.get(i2).getText().isEmpty()) continue;
                correct = false;
                DialogNotification.showDialogNotification(IOcomps.getParentFrame(), "Error", Strings.S.get("FpgaIoPinLoc", IoComponentTypes.getInputLabel(nrOfPins.get(0), i2, myType)));
                break;
            }
            if (!correct) continue;
            for (i2 = 0; i2 < nrOfPins.get(1); ++i2) {
                if (!locOutputs.get(i2).getText().isEmpty()) continue;
                correct = false;
                DialogNotification.showDialogNotification(IOcomps.getParentFrame(), "Error", Strings.S.get("FpgaIoPinLoc", IoComponentTypes.getOutputLabel(nrOfPins.get(0), 0, 0, i2, myType)));
                break;
            }
            if (!correct) continue;
            for (i2 = 0; i2 < nrOfPins.get(2); ++i2) {
                if (!locIos.get(i2).getText().isEmpty()) continue;
                correct = false;
                DialogNotification.showDialogNotification(IOcomps.getParentFrame(), "Error", Strings.S.get("FpgaIoPinLoc", IoComponentTypes.getIoLabel(nrOfPins.get(0), i2, myType)));
                break;
            }
            if (!correct) continue;
            if (!rectLocations.isEmpty()) {
                int[] values = new int[4];
                for (i = 0; i < 4; ++i) {
                    try {
                        values[i] = Integer.parseUnsignedInt(rectLocations.get(i).getText());
                        continue;
                    }
                    catch (NumberFormatException e2) {
                        correct = false;
                        String msgKey = switch (i) {
                            case 0 -> "FpgaIoXpos";
                            case 1 -> "FpgaIoYpos";
                            case 2 -> "FpgaIoWidth";
                            default -> "FpgaIoHeight";
                        };
                        DialogNotification.showDialogNotification(IOcomps.getParentFrame(), "Error", Strings.S.get("FpgaIoIntError", Strings.S.get(msgKey), rectLocations.get(i).getText()));
                    }
                }
                if (!correct) continue;
                if (values[0] != MyRectangle.getXpos() || values[1] != MyRectangle.getYpos() || values[2] != MyRectangle.getWidth() || values[3] != MyRectangle.getHeight()) {
                    Rectangle update = new Rectangle(values[0], values[1], values[2], values[3]);
                    if (IOcomps.hasOverlap(MyRectangle, new BoardRectangle(update))) {
                        DialogNotification.showDialogNotification(IOcomps.getParentFrame(), "Error", Strings.S.get("FpgaIoRectError"));
                        continue;
                    }
                    if (update.getX() + update.getWidth() >= 740) {
                        DialogNotification.showDialogNotification(IOcomps.getParentFrame(), "Error", Strings.S.get("FpgaIoRectTWide"));
                        continue;
                    }
                    if (update.getY() + update.getHeight() >= 400) {
                        DialogNotification.showDialogNotification(IOcomps.getParentFrame(), "Error", Strings.S.get("FpgaIoRectTHeigt"));
                        continue;
                    }
                    if (update.getWidth() < 2) {
                        DialogNotification.showDialogNotification(IOcomps.getParentFrame(), "Error", Strings.S.get("FpgaIoRectWNLE"));
                        continue;
                    }
                    if (update.getHeight() < 2) {
                        DialogNotification.showDialogNotification(IOcomps.getParentFrame(), "Error", Strings.S.get("FpgaIoRectHNLE"));
                        continue;
                    }
                    MyRectangle.updateRectangle(update);
                }
            }
            IOcomps.setDefaultStandard(StandardInput.getSelectedIndex());
            info.setNrOfPins(NrPins);
            int idx = 0;
            for (i = 0; i < nrOfPins.get(0); ++i) {
                info.setInputPinLocation(idx++, locInputs.get(i).getText());
            }
            for (i = 0; i < nrOfPins.get(1); ++i) {
                info.setOutputPinLocation(idx++, locOutputs.get(i).getText());
            }
            for (i = 0; i < nrOfPins.get(2); ++i) {
                info.setIOPinLocation(idx++, locIos.get(i).getText());
            }
            if (LabelInput.getText() != null && LabelInput.getText().length() != 0) {
                info.setLabel(LabelInput.getText());
            } else {
                info.setLabel(null);
            }
            info.setIOStandard(IoStandards.getId(StandardInput.getSelectedItem().toString()));
            if (IoComponentTypes.OUTPUT_COMPONENT_SET.contains((Object)myType)) {
                IOcomps.setDefaultDriveStrength(driveInput.getSelectedIndex());
                info.setDrive(DriveStrength.getId(driveInput.getSelectedItem().toString()));
            }
            if (IoComponentTypes.INPUT_COMPONENT_SET.contains((Object)myType)) {
                IOcomps.setDefaultPullSelection(pullInput.getSelectedIndex());
                info.setPullBehavior(PullBehaviors.getId(pullInput.getSelectedItem().toString()));
            }
            if (!IoComponentTypes.IN_OUT_COMPONENT_SET.contains((Object)myType)) {
                IOcomps.setDefaultActivity(activeInput.getSelectedIndex());
                info.setActivityLevel(PinActivity.getId(activeInput.getSelectedItem().toString()));
            }
            int rotation = switch (mapRotation.getSelectedIndex()) {
                case 1 -> -90;
                case 2 -> 90;
                default -> 0;
            };
            info.setMapRotation(rotation);
            abort = true;
        }
        selWindow.dispose();
    }

    public static void getFpgaInformation(Frame panel, BoardInformation TheBoard) {
        JDialog selWindow = new JDialog(panel, Strings.S.get("FpgaBoardFpgaProp"));
        abort = false;
        ActionListener actionListener = e -> {
            if (e.getActionCommand().equals("cancel")) {
                abort = true;
            }
            selWindow.setVisible(false);
        };
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel ClockPanel = new JPanel();
        ClockPanel.setLayout(new GridBagLayout());
        ClockPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 2, true), Strings.S.get("FpgaBoardClkProp")));
        JLabel FreqText = new JLabel(Strings.S.get("FpgaBoardClkFreq"));
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        ClockPanel.add((Component)FreqText, gbc);
        JPanel FreqPanel = new JPanel();
        GridBagLayout FreqLayout = new GridBagLayout();
        FreqPanel.setLayout(FreqLayout);
        JTextField FreqInput = new JTextField(10);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        if (TheBoard.fpga.isFpgaInfoPresent()) {
            FreqInput.setText(Integer.toString(FpgaIoInformationSettingsDialog.getFrequencyValue(TheBoard.fpga.getClockFrequency())));
        }
        FreqPanel.add((Component)FreqInput, gbc);
        String[] freqStrs = new String[]{"Hz", "kHz", "MHz"};
        JComboBox<String> StandardInput = new JComboBox<String>(freqStrs);
        StandardInput.setSelectedIndex(2);
        gbc.gridx = 1;
        if (TheBoard.fpga.isFpgaInfoPresent()) {
            StandardInput.setSelectedIndex(FpgaIoInformationSettingsDialog.getFrequencyIndex(TheBoard.fpga.getClockFrequency()));
        }
        FreqPanel.add(StandardInput, gbc);
        ClockPanel.add((Component)FreqPanel, gbc);
        JLabel LocText = new JLabel(Strings.S.get("FpgaBoardClkLoc"));
        gbc.gridy = 1;
        gbc.gridx = 0;
        ClockPanel.add((Component)LocText, gbc);
        JTextField LocInput = new JTextField();
        if (TheBoard.fpga.isFpgaInfoPresent()) {
            LocInput.setText(TheBoard.fpga.getClockPinLocation());
        }
        gbc.gridx = 1;
        ClockPanel.add((Component)LocInput, gbc);
        JLabel PullText = new JLabel(Strings.S.get("FpgaBoardClkPul"));
        gbc.gridy = 2;
        gbc.gridx = 0;
        ClockPanel.add((Component)PullText, gbc);
        JComboBox<String> PullInput = new JComboBox<String>(PullBehaviors.BEHAVIOR_STRINGS);
        if (TheBoard.fpga.isFpgaInfoPresent()) {
            PullInput.setSelectedIndex(TheBoard.fpga.getClockPull());
        } else {
            PullInput.setSelectedIndex(0);
        }
        gbc.gridx = 1;
        ClockPanel.add(PullInput, gbc);
        JLabel StandardText = new JLabel(Strings.S.get("FpgaBoardClkStd"));
        gbc.gridy = 3;
        gbc.gridx = 0;
        ClockPanel.add((Component)StandardText, gbc);
        JComboBox<String> StdInput = new JComboBox<String>(IoStandards.BEHAVIOR_STRINGS);
        if (TheBoard.fpga.isFpgaInfoPresent()) {
            StdInput.setSelectedIndex(TheBoard.fpga.getClockStandard());
        } else {
            StdInput.setSelectedIndex(0);
        }
        gbc.gridx = 1;
        ClockPanel.add(StdInput, gbc);
        JPanel fpgaPanel = new JPanel();
        fpgaPanel.setLayout(new GridBagLayout());
        fpgaPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 2, true), Strings.S.get("FpgaBoardFpgaProp")));
        JLabel VendorText = new JLabel(Strings.S.get("FpgaBoardFpgaVend"));
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        fpgaPanel.add((Component)VendorText, gbc);
        JComboBox<String> vendorInput = new JComboBox<String>(VendorSoftware.VENDORS);
        if (TheBoard.fpga.isFpgaInfoPresent()) {
            vendorInput.setSelectedIndex(TheBoard.fpga.getVendor());
        } else {
            vendorInput.setSelectedIndex(0);
        }
        gbc.gridx = 1;
        fpgaPanel.add(vendorInput, gbc);
        JLabel familyText = new JLabel(Strings.S.get("FpgaBoardFpgaFam"));
        gbc.gridy = 1;
        gbc.gridx = 0;
        fpgaPanel.add((Component)familyText, gbc);
        JTextField familyInput = new JTextField();
        if (TheBoard.fpga.isFpgaInfoPresent()) {
            familyInput.setText(TheBoard.fpga.getTechnology());
        }
        gbc.gridx = 1;
        fpgaPanel.add((Component)familyInput, gbc);
        JLabel PartText = new JLabel(Strings.S.get("FpgaBoardFpgaPart"));
        gbc.gridy = 2;
        gbc.gridx = 0;
        fpgaPanel.add((Component)PartText, gbc);
        JTextField partInput = new JTextField();
        if (TheBoard.fpga.isFpgaInfoPresent()) {
            partInput.setText(TheBoard.fpga.getPart());
        }
        gbc.gridx = 1;
        fpgaPanel.add((Component)partInput, gbc);
        JLabel BoxText = new JLabel(Strings.S.get("FpgaBoardFpgaPack"));
        gbc.gridy = 3;
        gbc.gridx = 0;
        fpgaPanel.add((Component)BoxText, gbc);
        JTextField boxInput = new JTextField();
        if (TheBoard.fpga.isFpgaInfoPresent()) {
            boxInput.setText(TheBoard.fpga.getPackage());
        }
        gbc.gridx = 1;
        fpgaPanel.add((Component)boxInput, gbc);
        JLabel speedText = new JLabel(Strings.S.get("FpgaBoardFpgaSG"));
        gbc.gridy = 4;
        gbc.gridx = 0;
        fpgaPanel.add((Component)speedText, gbc);
        JTextField speedInput = new JTextField();
        if (TheBoard.fpga.isFpgaInfoPresent()) {
            speedInput.setText(TheBoard.fpga.getSpeedGrade());
        }
        gbc.gridx = 1;
        fpgaPanel.add((Component)speedInput, gbc);
        JLabel unusedPinsText = new JLabel(Strings.S.get("FpgaBoardPinUnused"));
        gbc.gridy = 5;
        gbc.gridx = 0;
        fpgaPanel.add((Component)unusedPinsText, gbc);
        JComboBox<String> unusedPinsInput = new JComboBox<String>(PullBehaviors.BEHAVIOR_STRINGS);
        if (TheBoard.fpga.isFpgaInfoPresent()) {
            unusedPinsInput.setSelectedIndex(TheBoard.fpga.getUnusedPinsBehavior());
        } else {
            unusedPinsInput.setSelectedIndex(0);
        }
        gbc.gridx = 1;
        fpgaPanel.add(unusedPinsInput, gbc);
        JPanel jtagPanel = new JPanel();
        jtagPanel.setLayout(new GridBagLayout());
        jtagPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 2, true), Strings.S.get("FpgaBoardJtagProp")));
        JLabel posText = new JLabel(Strings.S.get("FpgaBoardJtagLoc"));
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.fill = 2;
        jtagPanel.add((Component)posText, gbc);
        JTextField PosInput = new JTextField(5);
        PosInput.setText("1");
        if (TheBoard.fpga.isFpgaInfoPresent()) {
            PosInput.setText(Integer.toString(TheBoard.fpga.getFpgaJTAGChainPosition()));
        }
        gbc.gridx = 1;
        jtagPanel.add((Component)PosInput, gbc);
        JLabel FlashPosText = new JLabel(Strings.S.get("FpgaBoardFlashLoc"));
        gbc.gridy = 1;
        gbc.gridx = 0;
        jtagPanel.add((Component)FlashPosText, gbc);
        JTextField flashPosInput = new JTextField(5);
        flashPosInput.setText("2");
        if (TheBoard.fpga.isFpgaInfoPresent()) {
            flashPosInput.setText(Integer.toString(TheBoard.fpga.getFlashJTAGChainPosition()));
        }
        gbc.gridx = 1;
        gbc.fill = 2;
        jtagPanel.add((Component)flashPosInput, gbc);
        JPanel miscPanel = new JPanel();
        miscPanel.setLayout(new GridBagLayout());
        miscPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 2, true), Strings.S.get("FpgaBoardMiscProp")));
        JLabel flashName = new JLabel(Strings.S.get("FpgaBoardFlashType"));
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        miscPanel.add((Component)flashName, gbc);
        JTextField flashNameInput = new JTextField("");
        if (TheBoard.fpga.isFpgaInfoPresent()) {
            flashNameInput.setText(TheBoard.fpga.getFlashName());
        }
        gbc.gridx = 1;
        miscPanel.add((Component)flashNameInput, gbc);
        JCheckBox usbTmc = new JCheckBox(Strings.S.get("FpgaBoardUSBTMC"));
        usbTmc.setSelected(false);
        if (TheBoard.fpga.isFpgaInfoPresent()) {
            usbTmc.setSelected(TheBoard.fpga.isUsbTmcDownloadRequired());
        }
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        miscPanel.add((Component)usbTmc, gbc);
        GridBagLayout dialogLayout = new GridBagLayout();
        selWindow.setLayout(dialogLayout);
        abort = false;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        selWindow.add((Component)ClockPanel, gbc);
        gbc.gridx = 1;
        selWindow.add((Component)fpgaPanel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        selWindow.add((Component)jtagPanel, gbc);
        gbc.gridx = 1;
        selWindow.add((Component)miscPanel, gbc);
        final JButton cancelButton = new JButton(Strings.S.get("FpgaBoardCancel"));
        cancelButton.addActionListener(actionListener);
        cancelButton.setActionCommand("cancel");
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.fill = 2;
        selWindow.add((Component)cancelButton, gbc);
        selWindow.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                cancelButton.doClick();
            }
        });
        JButton saveButton = new JButton(Strings.S.get("FpgaBoardDone"));
        saveButton.addActionListener(actionListener);
        saveButton.setActionCommand("save");
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.fill = 2;
        selWindow.add((Component)saveButton, gbc);
        selWindow.pack();
        selWindow.setModal(true);
        selWindow.setResizable(false);
        selWindow.setDefaultCloseOperation(0);
        selWindow.setAlwaysOnTop(true);
        selWindow.setLocationRelativeTo(panel);
        boolean saveSettings = false;
        while (!abort && !saveSettings) {
            selWindow.setVisible(true);
            if (abort) continue;
            saveSettings = true;
            switch ((int)FpgaIoInformationSettingsDialog.getFrequency(FreqInput.getText(), StandardInput.getSelectedItem().toString())) {
                case -2: {
                    saveSettings = false;
                    DialogNotification.showDialogNotification(panel, "Error", Strings.S.get("FpgaBoardFreqError"));
                    break;
                }
                case -1: {
                    saveSettings = false;
                    DialogNotification.showDialogNotification(panel, "Error", Strings.S.get("FpgaBoardFracError"));
                    break;
                }
                case 0: {
                    saveSettings = false;
                    DialogNotification.showDialogNotification(panel, "Error", Strings.S.get("FpgaBoardClkReq"));
                    break;
                }
            }
            if (saveSettings && LocInput.getText().isEmpty()) {
                saveSettings = false;
                DialogNotification.showDialogNotification(panel, "Error", Strings.S.get("FpgaBoardClkPin"));
            }
            if (saveSettings && familyInput.getText().isEmpty()) {
                saveSettings = false;
                DialogNotification.showDialogNotification(panel, "Error", Strings.S.get("FpgaBoardFpgaFamMis"));
            }
            if (saveSettings && partInput.getText().isEmpty()) {
                saveSettings = false;
                DialogNotification.showDialogNotification(panel, "Error", Strings.S.get("FpgaBoardFpgaPartMis"));
            }
            if (saveSettings && boxInput.getText().isEmpty()) {
                saveSettings = false;
                DialogNotification.showDialogNotification(panel, "Error", Strings.S.get("FpgaBoardFpgaPacMis"));
            }
            if (saveSettings && speedInput.getText().isEmpty()) {
                saveSettings = false;
                DialogNotification.showDialogNotification(panel, "Error", Strings.S.get("FpgaBoardFpgaSpeedMis"));
            }
            if (!saveSettings) continue;
            TheBoard.fpga.set(FpgaIoInformationSettingsDialog.getFrequency(FreqInput.getText(), StandardInput.getSelectedItem().toString()), LocInput.getText(), PullInput.getSelectedItem().toString(), StdInput.getSelectedItem().toString(), familyInput.getText(), partInput.getText(), boxInput.getText(), speedInput.getText(), vendorInput.getSelectedItem().toString(), unusedPinsInput.getSelectedItem().toString(), usbTmc.isSelected(), PosInput.getText(), flashNameInput.getText(), flashPosInput.getText());
        }
        selWindow.dispose();
    }

    private static int getFrequencyValue(long freq) {
        if (freq % 1000L != 0L) {
            return (int)freq;
        }
        if (freq % 1000000L != 0L) {
            return (int)freq / 1000;
        }
        return (int)freq / 1000000;
    }

    private static int getFrequencyIndex(long freq) {
        if (freq % 1000L != 0L) {
            return 0;
        }
        if (freq % 1000000L != 0L) {
            return 1;
        }
        return 2;
    }

    private static long getFrequency(String chars, String speed) {
        long result = 0L;
        long multiplier = 1L;
        boolean dec_mult = false;
        if ("kHz".equals(speed)) {
            multiplier = 1000L;
        }
        if ("MHz".equals(speed)) {
            multiplier = 1000000L;
        }
        for (int i = 0; i < chars.length(); ++i) {
            if (chars.charAt(i) >= '0' && chars.charAt(i) <= '9') {
                result *= 10L;
                result += (long)(chars.charAt(i) - 48);
                if (!dec_mult || (multiplier /= 10L) != 0L) continue;
                return -1L;
            }
            if (chars.charAt(i) == '.') {
                dec_mult = true;
                continue;
            }
            return -2L;
        }
        return result *= multiplier;
    }
}

