/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.appear;

import com.cburch.logisim.gui.appear.AppearanceCanvas;
import com.cburch.logisim.gui.appear.AppearanceEditHandler;
import com.cburch.logisim.gui.menu.EditHandler;
import com.cburch.logisim.gui.menu.EditPopup;
import com.cburch.logisim.gui.menu.LogisimMenuBar;
import com.cburch.logisim.gui.menu.LogisimMenuItem;
import java.util.HashMap;
import java.util.Map;

public class AppearanceEditPopup
extends EditPopup
implements EditHandler.Listener {
    private static final long serialVersionUID = 1L;
    private final AppearanceCanvas canvas;
    private final EditHandler handler;
    private final Map<LogisimMenuItem, Boolean> enabled;

    public AppearanceEditPopup(AppearanceCanvas canvas) {
        super(true);
        this.canvas = canvas;
        this.handler = new AppearanceEditHandler(canvas);
        this.handler.setListener(this);
        this.enabled = new HashMap<LogisimMenuItem, Boolean>();
        this.handler.computeEnabled();
        this.initialize();
    }

    @Override
    public void enableChanged(EditHandler handler, LogisimMenuItem action, boolean value) {
        this.enabled.put(action, value);
    }

    @Override
    protected void fire(LogisimMenuItem item) {
        if (item == LogisimMenuBar.CUT) {
            this.handler.cut();
        } else if (item == LogisimMenuBar.COPY) {
            this.handler.copy();
        } else if (item == LogisimMenuBar.DELETE) {
            this.handler.delete();
        } else if (item == LogisimMenuBar.DUPLICATE) {
            this.handler.duplicate();
        } else if (item == LogisimMenuBar.RAISE) {
            this.handler.raise();
        } else if (item == LogisimMenuBar.LOWER) {
            this.handler.lower();
        } else if (item == LogisimMenuBar.RAISE_TOP) {
            this.handler.raiseTop();
        } else if (item == LogisimMenuBar.LOWER_BOTTOM) {
            this.handler.lowerBottom();
        } else if (item == LogisimMenuBar.ADD_CONTROL) {
            this.handler.addControlPoint();
        } else if (item == LogisimMenuBar.REMOVE_CONTROL) {
            this.handler.removeControlPoint();
        }
    }

    @Override
    protected boolean isEnabled(LogisimMenuItem item) {
        Boolean value = this.enabled.get(item);
        return value != null && value != false;
    }

    @Override
    protected boolean shouldShow(LogisimMenuItem item) {
        return item == LogisimMenuBar.ADD_CONTROL || item == LogisimMenuBar.REMOVE_CONTROL ? this.canvas.getSelection().getSelectedHandle() != null : true;
    }
}

