/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.appear;

import com.cburch.draw.canvas.Canvas;
import com.cburch.draw.toolbar.ToolbarClickableItem;
import com.cburch.logisim.circuit.appear.CircuitAppearance;
import com.cburch.logisim.gui.appear.AppearanceCanvas;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.gui.icons.ArithmeticIcon;
import com.cburch.logisim.gui.icons.CircuitIcon;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;

public class ResetAppearanceTool
implements ToolbarClickableItem {
    private final AppearanceCanvas canvas;
    private final boolean isClear;
    private final Icon icon;

    public ResetAppearanceTool(Canvas canvas, boolean isClear) {
        AppearanceCanvas appearanceCanvas;
        this.canvas = canvas instanceof AppearanceCanvas ? (appearanceCanvas = (AppearanceCanvas)canvas) : null;
        this.isClear = isClear;
        this.icon = isClear ? new ArithmeticIcon("RST", 3) : new CircuitIcon();
    }

    @Override
    public Dimension getDimension(Object orientation) {
        return new Dimension(this.icon.getIconWidth() + 8, this.icon.getIconHeight() + 8);
    }

    @Override
    public String getToolTip() {
        return this.isClear ? "Restore default custom appearance" : "Clear appearance and load logisim default";
    }

    @Override
    public boolean isSelectable() {
        return false;
    }

    @Override
    public void paintIcon(Component destination, Graphics gfx) {
        this.icon.paintIcon(destination, gfx, 4, 4);
    }

    @Override
    public void clicked() {
        if (this.canvas == null || this.canvas.getCircuit() == null) {
            return;
        }
        CircuitAppearance appearance = this.canvas.getCircuit().getAppearance();
        if (appearance == null) {
            return;
        }
        if (OptionPane.showConfirmDialog(this.canvas, "Are you sure you want to remove the current custom appearance and replace it?", this.isClear ? "Restore default custom appearance" : "Clear appearance and load logisim default", 0) == 0) {
            if (this.isClear) {
                appearance.resetDefaultCustomAppearance();
            } else {
                appearance.loadDefaultLogisimAppearance();
            }
            this.canvas.repaint(this.canvas.getBounds(null));
        }
    }

    @Override
    public void paintPressedIcon(Component destination, Graphics gfx) {
        this.icon.paintIcon(destination, gfx, 4, 4);
    }
}

