/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.appear;

import com.cburch.draw.actions.ModelAddAction;
import com.cburch.draw.actions.ModelRemoveAction;
import com.cburch.draw.model.CanvasModel;
import com.cburch.draw.model.CanvasObject;
import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.SubcircuitFactory;
import com.cburch.logisim.circuit.appear.AppearanceAnchor;
import com.cburch.logisim.circuit.appear.DynamicElement;
import com.cburch.logisim.circuit.appear.DynamicElementProvider;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.appear.AppearanceCanvas;
import com.cburch.logisim.gui.appear.CheckBoxTree;
import com.cburch.logisim.instance.InstanceComponent;
import com.cburch.logisim.instance.StdAttr;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.scijava.swing.checkboxtree.CheckBoxNodeData;

public class ShowStateDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    final JButton ok;
    final JButton cancel;
    RefTreeNode root;
    final CheckBoxTree tree;
    final AppearanceCanvas canvas;

    public ShowStateDialog(JFrame parent, AppearanceCanvas canvas) {
        super((Frame)parent, true);
        this.canvas = canvas;
        this.setDefaultCloseOperation(2);
        Circuit circuit = canvas.getCircuit();
        this.setTitle(Strings.S.get("showStateDialogTitle", circuit.getName()));
        this.root = this.enumerate(circuit, null);
        if (this.root == null) {
            this.root = new RefTreeNode(Strings.S.get("showStateDialogEmptyNode", circuit.getName()));
        }
        this.tree = new CheckBoxTree(this.root);
        this.tree.setCheckingPaths(this.getPaths());
        JScrollPane infoPane = new JScrollPane(this.tree);
        this.ok = new JButton(Strings.S.get("showStateDialogOkButton"));
        this.cancel = new JButton(Strings.S.get("showStateDialogCancelButton"));
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.ok);
        buttonPanel.add(this.cancel);
        Container contents = this.getContentPane();
        contents.setLayout(new BorderLayout());
        contents.add((Component)infoPane, "Center");
        contents.add((Component)buttonPanel, "Last");
        this.pack();
        Dimension pref = contents.getPreferredSize();
        if (pref.width > 750 || pref.height > 550 || pref.width < 200 || pref.height < 150) {
            if (pref.width > 750) {
                pref.width = 750;
            } else if (pref.width < 200) {
                pref.width = 200;
            }
            if (pref.height > 550) {
                pref.height = 550;
            } else if (pref.height < 200) {
                pref.height = 200;
            }
            this.setSize(pref);
        }
    }

    private static void pickPlacement(List<CanvasObject> avoid, DynamicElement shape, Bounds bbox) {
        while (ShowStateDialog.badPosition(avoid, shape)) {
            shape.translate(0, 10);
            Location loc = shape.getLocation();
            if (loc.getX() >= bbox.getX() + bbox.getWidth() || loc.getY() + shape.getBounds().getHeight() < bbox.getY() + bbox.getHeight()) continue;
            shape.translate(10, (bbox.getY() + 9) / 10 * 10 - loc.getY());
        }
    }

    private static boolean badPosition(List<CanvasObject> avoid, CanvasObject shape) {
        for (CanvasObject s : avoid) {
            if (!shape.overlaps(s) && !s.overlaps(shape)) continue;
            return true;
        }
        return false;
    }

    private static DynamicElement.Path toComponentPath(TreePath p) {
        Object[] o = p.getPath();
        InstanceComponent[] elt = new InstanceComponent[o.length - 1];
        for (int i = 1; i < o.length; ++i) {
            Ref r = ((RefTreeNode)o[i]).refData;
            elt[i - 1] = r.ic;
        }
        return new DynamicElement.Path(elt);
    }

    private static TreePath toTreePath(RefTreeNode root, DynamicElement.Path path) {
        Object[] objs = new Object[path.elt.length + 1];
        objs[0] = root;
        for (int i = 1; i < objs.length; ++i) {
            objs[i] = ShowStateDialog.findChild((RefTreeNode)objs[i - 1], path.elt[i - 1]);
            if (objs[i] != null) continue;
            return null;
        }
        return new TreePath(objs);
    }

    private static RefTreeNode findChild(RefTreeNode node, InstanceComponent ic) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            RefTreeNode child = (RefTreeNode)node.getChildAt(i);
            Ref r = child.refData;
            if (!r.ic.getLocation().equals(ic.getLocation()) || !r.ic.getFactory().getName().equals(ic.getFactory().getName())) continue;
            return child;
        }
        return null;
    }

    private TreePath[] getPaths() {
        RefTreeNode root = (RefTreeNode)this.tree.getModel().getRoot();
        ArrayList<TreePath> paths = new ArrayList<TreePath>();
        for (CanvasObject shape : this.canvas.getModel().getObjectsFromBottom()) {
            if (!(shape instanceof DynamicElement)) continue;
            DynamicElement dynEl = (DynamicElement)shape;
            TreePath path = ShowStateDialog.toTreePath(root, dynEl.getPath());
            paths.add(path);
        }
        return paths.toArray(new TreePath[0]);
    }

    private void apply() {
        CanvasModel model = this.canvas.getModel();
        RefTreeNode root = (RefTreeNode)this.tree.getModel().getRoot();
        Bounds boundingBox = Bounds.EMPTY_BOUNDS;
        for (CanvasObject shape : model.getObjectsFromBottom()) {
            boundingBox = boundingBox.add(shape.getBounds());
        }
        Location loc = Location.create(boundingBox.getX(), boundingBox.getY(), true);
        TreePath[] checked = this.tree.getCheckingPaths();
        ArrayList<TreePath> toAdd = new ArrayList<TreePath>(Arrays.asList(checked));
        ArrayList<CanvasObject> toRemove = new ArrayList<CanvasObject>();
        for (CanvasObject shape : model.getObjectsFromBottom()) {
            if (!(shape instanceof DynamicElement)) continue;
            DynamicElement dynEl = (DynamicElement)shape;
            TreePath path = ShowStateDialog.toTreePath(root, dynEl.getPath());
            if (path != null && this.tree.isPathChecked(path)) {
                toAdd.remove(path);
                continue;
            }
            toRemove.add(shape);
        }
        boolean dirty = true;
        if (toRemove.size() > 0) {
            this.canvas.doAction(new ModelRemoveAction(model, toRemove));
            dirty = true;
        }
        toAdd.sort(new CompareByLocations());
        ArrayList<CanvasObject> avoid = new ArrayList<CanvasObject>(model.getObjectsFromBottom());
        for (int i = avoid.size() - 1; i >= 0; --i) {
            if (!(avoid.get(i) instanceof AppearanceAnchor)) continue;
            avoid.remove(i);
        }
        ArrayList<CanvasObject> newShapes = new ArrayList<CanvasObject>();
        for (TreePath path : toAdd) {
            ComponentFactory factory;
            RefTreeNode node = (RefTreeNode)path.getLastPathComponent();
            Ref ref = node.refData;
            if (ref instanceof CircuitRef || !((factory = ref.ic.getFactory()) instanceof DynamicElementProvider)) continue;
            int x = loc.getX();
            int y = loc.getY();
            DynamicElement.Path p = ShowStateDialog.toComponentPath(path);
            DynamicElement shape = ((DynamicElementProvider)((Object)factory)).createDynamicElement(x, y, p);
            ShowStateDialog.pickPlacement(avoid, shape, boundingBox);
            loc = shape.getLocation();
            avoid.add(shape);
            newShapes.add(shape);
        }
        if (newShapes.size() > 0) {
            this.canvas.doAction(new ModelAddAction(model, newShapes));
            dirty = true;
        }
        if (dirty) {
            this.canvas.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.ok) {
            this.apply();
        }
        this.dispose();
    }

    private RefTreeNode enumerate(Circuit circuit, InstanceComponent ic) {
        RefTreeNode root = new RefTreeNode(new CircuitRef(circuit, ic));
        for (com.cburch.logisim.comp.Component c : circuit.getNonWires()) {
            SubcircuitFactory sub;
            RefTreeNode node;
            if (!(c instanceof InstanceComponent)) continue;
            InstanceComponent child = (InstanceComponent)c;
            ComponentFactory factory = child.getFactory();
            if (factory instanceof DynamicElementProvider) {
                root.add(new RefTreeNode(new Ref(child)));
                continue;
            }
            if (!(factory instanceof SubcircuitFactory) || (node = this.enumerate((sub = (SubcircuitFactory)factory).getSubcircuit(), child)) == null) continue;
            root.add(node);
        }
        return root.getChildCount() == 0 ? null : root;
    }

    private static class RefTreeNode
    extends DefaultMutableTreeNode {
        final Ref refData;

        RefTreeNode(Object data) {
            super(new CheckBoxNodeData(data.toString(), false));
            Ref ref;
            this.refData = data instanceof Ref ? (ref = (Ref)data) : null;
        }
    }

    private static class Ref {
        final InstanceComponent ic;

        Ref(InstanceComponent ic) {
            this.ic = ic;
        }

        public String toString() {
            String s = this.ic.getInstance().getAttributeValue(StdAttr.LABEL);
            Location loc = this.ic.getInstance().getLocation();
            Object str = "";
            if (s != null && s.length() > 0) {
                str = (String)str + "\"" + s + "\" ";
            }
            str = (String)str + String.format("%s @ (%d, %d)", this.ic.getFactory(), loc.getX(), loc.getY());
            return str;
        }
    }

    private static class CompareByLocations
    implements Comparator<TreePath> {
        private CompareByLocations() {
        }

        @Override
        public int compare(TreePath a, TreePath b) {
            Object[] aa = a.getPath();
            Object[] bb = b.getPath();
            for (int i = 1; i < aa.length && i < bb.length; ++i) {
                Location locB;
                Ref refA = ((RefTreeNode)aa[i]).refData;
                Ref refB = ((RefTreeNode)bb[i]).refData;
                Location locA = refA.ic.getLocation();
                int diff = locA.compareTo(locB = refB.ic.getLocation());
                if (diff == 0) continue;
                return diff;
            }
            return 0;
        }
    }

    private static class CircuitRef
    extends Ref {
        final Circuit circuit;

        CircuitRef(Circuit c, InstanceComponent ic) {
            super(ic);
            this.circuit = c;
        }

        @Override
        public String toString() {
            return this.ic == null ? Strings.S.get("showStateDialogNodeTitle", this.circuit.getName()) : super.toString();
        }
    }
}

