/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.chrono;

import com.cburch.logisim.circuit.RadixOption;
import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.chrono.ChronoPanel;
import com.cburch.logisim.gui.log.SelectionPanel;
import com.cburch.logisim.gui.log.Signal;
import com.cburch.logisim.gui.log.SignalInfo;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;

public class PopupMenu
extends MouseAdapter {
    private final List<Signal> signals;
    private final ChronoPanel chronoPanel;

    public PopupMenu(ChronoPanel p, List<Signal> s) {
        this.chronoPanel = p;
        this.signals = s;
    }

    public void doPop(MouseEvent e) {
        PopupContents menu = new PopupContents();
        menu.show(e.getComponent(), e.getX(), e.getY());
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.doPop(e);
        }
    }

    private class PopupContents
    extends JPopupMenu {
        private static final long serialVersionUID = 1L;

        public PopupContents() {
            super("Options");
            RadixOption radix = null;
            if (PopupMenu.this.signals.size() > 0) {
                radix = PopupMenu.this.signals.get((int)0).info.getRadix();
                for (int i = 1; i < PopupMenu.this.signals.size(); ++i) {
                    if (PopupMenu.this.signals.get((int)i).info.getRadix() == radix) continue;
                    radix = null;
                    break;
                }
            }
            ButtonGroup g = new ButtonGroup();
            for (RadixOption r : RadixOption.OPTIONS) {
                JRadioButtonMenuItem m = new JRadioButtonMenuItem(r.toDisplayString());
                this.add(m);
                m.setEnabled(PopupMenu.this.signals.size() > 0);
                g.add(m);
                if (r == radix) {
                    m.setSelected(true);
                }
                m.addActionListener(e -> {
                    for (Signal s : this$0.signals) {
                        s.info.setRadix(r);
                    }
                });
            }
            this.addSeparator();
            JMenuItem m = new JMenuItem(Strings.S.get("editClearItem"));
            this.add(m);
            m.setEnabled(PopupMenu.this.signals.size() > 0);
            m.addActionListener(e -> {
                SignalInfo.List items = new SignalInfo.List();
                for (Signal s : this$0.signals) {
                    items.add(s.info);
                }
                this$0.chronoPanel.getModel().remove(items);
            });
            this.addSeparator();
            m = new JMenuItem(Strings.S.get("addRemoveSignals"));
            this.add(m);
            m.addActionListener(e -> SelectionPanel.doDialog(this$0.chronoPanel.getLogFrame()));
        }
    }
}

