/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.icons;

import com.cburch.logisim.prefs.AppPreferences;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import javax.swing.Icon;

public class ErrorIcon
implements Icon {
    private final int wh;
    private boolean forwardArrow = false;
    private boolean backwardArrow = false;

    public ErrorIcon() {
        this.wh = AppPreferences.getIconSize();
    }

    public ErrorIcon(double scale) {
        this.wh = (int)AppPreferences.getScaled(scale * (double)AppPreferences.getIconSize());
    }

    public ErrorIcon(int size) {
        this.wh = AppPreferences.getScaled(size);
    }

    public ErrorIcon(boolean forward, boolean backward) {
        this.wh = AppPreferences.getIconSize();
        if (forward) {
            this.forwardArrow = true;
            this.backwardArrow = false;
        } else {
            this.forwardArrow = false;
            this.backwardArrow = backward;
        }
    }

    public static int scale(int v) {
        return AppPreferences.getScaled(v);
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        int[] ayPos;
        int yOff;
        int[] axPos;
        int seven;
        int six;
        Graphics2D g2 = (Graphics2D)g.create();
        g2.translate(x, y);
        int mywh = !this.forwardArrow && !this.backwardArrow ? this.wh : 3 * this.wh >> 2;
        int xoff = !this.forwardArrow && !this.backwardArrow ? 0 : this.wh >> 3;
        int trd = mywh / 3;
        int[] xPos = new int[]{xoff, xoff + trd, xoff + 2 * trd, xoff + mywh - 1, xoff + mywh - 1, xoff + 2 * trd, xoff + trd, xoff};
        int[] ypos = new int[]{trd, 0, 0, trd, 2 * trd, mywh - 1, mywh - 1, 2 * trd};
        g2.setColor(Color.RED.brighter().brighter());
        g2.fillPolygon(xPos, ypos, 8);
        g2.setStroke(new BasicStroke(ErrorIcon.scale(1)));
        g2.setColor(Color.RED.darker().darker());
        g2.drawPolygon(xPos, ypos, 8);
        g2.setColor(Color.WHITE);
        Font f = g2.getFont().deriveFont((float)mywh / 1.3f).deriveFont(1);
        TextLayout t = new TextLayout("X", f, g2.getFontRenderContext());
        float xc = (float)mywh / 2.0f - (float)t.getBounds().getCenterX() + (float)xoff;
        float yc = (float)mywh / 2.0f - (float)t.getBounds().getCenterY();
        t.draw(g2, xc, yc);
        if (this.forwardArrow) {
            g2.setColor(Color.BLACK);
            int five = 5 * this.wh >> 3;
            six = 6 * this.wh >> 3;
            seven = 7 * this.wh >> 3;
            axPos = new int[]{xoff, five, five, seven, five, five, xoff};
            yOff = AppPreferences.getScaled(1);
            ayPos = new int[]{seven - yOff, seven - yOff, six, seven, this.wh - 1, seven + yOff, seven + yOff};
            g2.fillPolygon(axPos, ayPos, 7);
        }
        if (this.backwardArrow) {
            g2.setColor(Color.BLACK);
            int three = 3 * this.wh >> 3;
            six = 6 * this.wh >> 3;
            seven = 7 * this.wh >> 3;
            axPos = new int[]{seven, three, three, xoff, three, three, seven};
            yOff = AppPreferences.getScaled(1);
            ayPos = new int[]{seven - yOff, seven - yOff, six, seven, this.wh - 1, seven + yOff, seven + yOff};
            g2.fillPolygon(axPos, ayPos, 7);
        }
        g2.dispose();
    }

    @Override
    public int getIconWidth() {
        return this.wh;
    }

    @Override
    public int getIconHeight() {
        return this.wh;
    }
}

