/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.log;

import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.gui.log.SignalInfo;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.util.ArrayList;

public class Signal {
    private static final int CHUNK = 512;
    public int idx;
    public final SignalInfo info;
    private long timeStart;
    private Value[][] val;
    private Value last;
    private long[][] dur;
    private int curSize;
    private int maxSize;
    private short firstIndex;

    public Signal(int idx, SignalInfo info, Value initialValue, long duration, long timeStart, int maxSize) {
        this.idx = idx;
        this.info = info;
        this.timeStart = timeStart;
        this.maxSize = maxSize;
        this.val = new Value[1][maxSize == 0 || maxSize > 512 ? 512 : maxSize];
        this.dur = new long[1][maxSize == 0 || maxSize > 512 ? 512 : maxSize];
        this.curSize = 0;
        this.firstIndex = 0;
        this.extend(initialValue, duration);
    }

    public long omittedDataTime() {
        return this.curSize == this.maxSize ? this.timeStart : 0L;
    }

    public long getEndTime() {
        long t = this.timeStart;
        for (int p = 0; p < this.curSize; ++p) {
            int i = (this.firstIndex + p) % this.curSize;
            t += this.dur[i / 512][i % 512];
        }
        return t;
    }

    public void extend(long duration) {
        if (this.last == null) {
            this.timeStart += duration;
        } else {
            int i = (this.firstIndex + this.curSize - 1) % this.curSize;
            long[] lArray = this.dur[i / 512];
            int n = i % 512;
            lArray[n] = lArray[n] + duration;
        }
    }

    public void extend(Value v, long duration) {
        if (v.getWidth() != this.info.getWidth()) {
            System.out.printf("*** notice: value width mismatch for %s: width=%d bits, newVal=%s (%d bits)\n", this.info, this.info.getWidth(), v, v.getWidth());
        }
        if (this.last != null && this.last.equals(v)) {
            int i = (this.firstIndex + this.curSize - 1) % this.curSize;
            long[] lArray = this.dur[i / 512];
            int n = i % 512;
            lArray[n] = lArray[n] + duration;
            return;
        }
        this.last = v;
        int c = this.val.length;
        int cap = 512 * (c - 1) + this.val[c - 1].length;
        if (this.curSize < cap) {
            this.val[this.curSize / 512][this.curSize % 512] = v;
            this.dur[this.curSize / 512][this.curSize % 512] = duration;
            ++this.curSize;
        } else if (this.curSize < this.maxSize || this.maxSize <= 0) {
            Value[][] val2 = new Value[c + 1][];
            long[][] dur2 = new long[c + 1][];
            System.arraycopy(this.val, 0, val2, 0, c);
            System.arraycopy(this.dur, 0, dur2, 0, c);
            val2[c] = new Value[this.maxSize == 0 || this.maxSize - cap > 512 ? 512 : this.maxSize - cap];
            dur2[c] = new long[this.maxSize == 0 || this.maxSize - cap > 512 ? 512 : this.maxSize - cap];
            this.val = val2;
            this.dur = dur2;
            this.val[this.curSize / 512][this.curSize % 512] = v;
            this.dur[this.curSize / 512][this.curSize % 512] = duration;
            ++this.curSize;
        } else {
            this.timeStart += this.dur[this.firstIndex / 512][this.firstIndex % 512];
            this.val[this.firstIndex / 512][this.firstIndex % 512] = v;
            this.dur[this.firstIndex / 512][this.firstIndex % 512] = duration;
            this.firstIndex = (short)(this.firstIndex + 1);
            if (this.firstIndex >= this.maxSize) {
                this.firstIndex = 0;
            }
        }
    }

    public void replaceRecent(Value v, long duration) {
        if (this.last == null || this.curSize == 0) {
            throw new IllegalStateException("signal should have at least " + duration + " ns of data");
        }
        int i = (this.firstIndex + this.curSize - 1) % this.curSize;
        if (this.dur[i / 512][i % 512] == duration) {
            this.val[i / 512][i % 512] = v;
            this.last = v;
            int j = (i + this.curSize - 1) % this.curSize;
            if (this.curSize > 1 && this.val[j / 512][j % 512].equals(v)) {
                long[] lArray = this.dur[j / 512];
                int n = j % 512;
                lArray[n] = lArray[n] + duration;
                --this.curSize;
                if (i % 512 == 0) {
                    int c = this.val.length - 1;
                    Value[][] valueNew = new Value[c][];
                    long[][] durNew = new long[c][];
                    System.arraycopy(this.val, 0, valueNew, 0, c);
                    System.arraycopy(this.dur, 0, durNew, 0, c);
                    this.val = valueNew;
                    this.dur = durNew;
                }
            }
        } else if (this.dur[i / 512][i % 512] > duration) {
            long[] lArray = this.dur[i / 512];
            int n = i % 512;
            lArray[n] = lArray[n] - duration;
            this.extend(v, duration);
        } else if (this.curSize == 1 && this.dur[i / 512][i % 512] + this.timeStart >= duration) {
            this.timeStart -= duration - this.dur[i / 512][i % 512];
            this.val[i / 512][i % 512] = v;
            this.dur[i / 512][i % 512] = duration;
            this.last = v;
        } else {
            throw new IllegalStateException("signal data should be at least " + duration + " ns in duration, but only " + this.dur[i / 512][i % 512] + " in last signal");
        }
    }

    private void retainOnly(int offset, int amt, int cap) {
        int c = (amt + 512 - 1) / 512;
        int last = cap == 0 ? 512 : Math.min(512, cap - (c - 1) * 512);
        Value[][] v = new Value[c][];
        long[][] d = new long[c][];
        for (int i = 0; i < c; ++i) {
            v[i] = new Value[i < c - 1 ? 512 : last];
            d[i] = new long[i < c - 1 ? 512 : last];
        }
        for (int p = 0; p < amt; ++p) {
            int i = (this.firstIndex + offset + p) % this.curSize;
            v[p / 512][p % 512] = this.val[i / 512][i % 512];
            d[p / 512][p % 512] = this.dur[i / 512][i % 512];
        }
        this.val = v;
        this.dur = d;
        this.firstIndex = 0;
        this.curSize = amt;
    }

    public void resize(int newMaxSize) {
        if (newMaxSize == this.maxSize) {
            return;
        }
        if (newMaxSize == 0 || newMaxSize > this.maxSize) {
            this.retainOnly(0, this.curSize, newMaxSize);
        } else if (this.curSize <= newMaxSize) {
            int c = this.val.length;
            int cap = 512 * (c - 1) + this.val[c - 1].length;
            if (cap > newMaxSize) {
                int last = Math.min(512, newMaxSize - (c - 1) * 512);
                Value[] v = new Value[last];
                long[] d = new long[last];
                System.arraycopy(this.val[c - 1], 0, v, 0, last);
                System.arraycopy(this.dur[c - 1], 0, d, 0, last);
                this.val[c - 1] = v;
                this.dur[c - 1] = d;
            }
        } else {
            int discard = this.maxSize - newMaxSize;
            for (int p = 0; p < discard; ++p) {
                int i = (this.firstIndex + p) % this.curSize;
                this.timeStart += this.dur[i / 512][i % 512];
            }
            this.retainOnly(discard, newMaxSize, newMaxSize);
        }
        this.maxSize = newMaxSize;
    }

    public void reset(Value v, long duration) {
        if (this.val.length > 1) {
            Value[][] val2 = new Value[1][];
            long[][] dur2 = new long[1][];
            val2[0] = this.val[0];
            dur2[0] = this.dur[0];
            this.val = val2;
            this.dur = dur2;
        }
        this.last = null;
        this.curSize = 0;
        this.firstIndex = 0;
        this.extend(v, duration);
    }

    public Value getValue(long t) {
        if (t < this.timeStart) {
            return null;
        }
        int width = this.info.getWidth();
        long tt = this.timeStart;
        for (int p = 0; p < this.curSize; ++p) {
            int i = (this.firstIndex + p) % this.curSize;
            long d = this.dur[i / 512][i % 512];
            if (t < tt + d) {
                return this.val[i / 512][i % 512].extendWidth(width, Value.FALSE);
            }
            tt += d;
        }
        return null;
    }

    public String getFormattedValue(long t) {
        Value v = this.getValue(t);
        return v == null ? "-" : this.info.format(v);
    }

    public String format(Value v) {
        return this.info.format(v);
    }

    public String getFormattedMaxValue() {
        int width = this.info.getWidth();
        return this.format(Value.createKnown(BitWidth.create(width), -1L));
    }

    public String getFormattedMinValue() {
        int width = this.info.getWidth();
        return this.format(Value.createKnown(BitWidth.create(width), 0L));
    }

    public String getName() {
        return this.info.getDisplayName();
    }

    public int getWidth() {
        return this.info.getWidth();
    }

    public static class List
    extends ArrayList<Signal>
    implements Transferable {
        public static final DataFlavor dataFlavor;
        public static final DataFlavor[] dataFlavors;

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return dataFlavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return dataFlavor.equals(flavor);
        }

        static {
            DataFlavor f = null;
            try {
                f = new DataFlavor(String.format("%s;class=\"%s\"", "application/x-java-jvm-local-objectref", List.class.getName()));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            dataFlavor = f;
            dataFlavors = new DataFlavor[]{dataFlavor};
        }
    }

    public class Iterator {
        public int position = 0;
        public long time;
        public long duration;
        public Value value;

        public Iterator() {
            this.time = Signal.this.timeStart;
            short i = Signal.this.firstIndex;
            int width = Signal.this.info.getWidth();
            this.value = Signal.this.val[i / 512][i % 512].extendWidth(width, Value.FALSE);
            this.duration = Signal.this.dur[i / 512][i % 512];
        }

        public Iterator(long t) {
            this();
            if (t > this.time) {
                this.advance(t - this.time);
            }
        }

        public String getFormattedValue() {
            return this.value == null ? "-" : Signal.this.info.format(this.value);
        }

        public boolean advance() {
            if (this.position == Signal.this.curSize - 1) {
                this.value = null;
                this.duration = 0L;
                return false;
            }
            ++this.position;
            this.time += this.duration;
            int i = (Signal.this.firstIndex + this.position) % Signal.this.curSize;
            int width = Signal.this.info.getWidth();
            this.value = Signal.this.val[i / 512][i % 512].extendWidth(width, Value.FALSE);
            this.duration = Signal.this.dur[i / 512][i % 512];
            return true;
        }

        public boolean advance(long timeFwd) {
            if (this.value == null) {
                return false;
            }
            if (timeFwd <= 0L) {
                return true;
            }
            long t = this.time + timeFwd;
            while (t >= this.time + this.duration) {
                if (this.advance()) continue;
                return false;
            }
            this.duration -= t - this.time;
            this.time = t;
            return true;
        }
    }
}

