/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.menu;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.circuit.Simulator;
import com.cburch.logisim.fpga.menu.MenuFpga;
import com.cburch.logisim.gui.generic.LFrame;
import com.cburch.logisim.gui.menu.LogisimMenuItem;
import com.cburch.logisim.gui.menu.MenuEdit;
import com.cburch.logisim.gui.menu.MenuFile;
import com.cburch.logisim.gui.menu.MenuHelp;
import com.cburch.logisim.gui.menu.MenuItem;
import com.cburch.logisim.gui.menu.MenuProject;
import com.cburch.logisim.gui.menu.MenuSimulate;
import com.cburch.logisim.gui.menu.SimulateListener;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.util.LocaleListener;
import com.cburch.logisim.util.LocaleManager;
import com.cburch.logisim.util.WindowMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JMenuBar;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LogisimMenuBar
extends JMenuBar {
    public static final LogisimMenuItem PRINT = new LogisimMenuItem("Print");
    public static final LogisimMenuItem EXPORT_IMAGE = new LogisimMenuItem("ExportImage");
    public static final LogisimMenuItem CUT = new LogisimMenuItem("Cut");
    public static final LogisimMenuItem COPY = new LogisimMenuItem("Copy");
    public static final LogisimMenuItem PASTE = new LogisimMenuItem("Paste");
    public static final LogisimMenuItem DELETE = new LogisimMenuItem("Delete");
    public static final LogisimMenuItem DUPLICATE = new LogisimMenuItem("Duplicate");
    public static final LogisimMenuItem SELECT_ALL = new LogisimMenuItem("SelectAll");
    public static final LogisimMenuItem RAISE = new LogisimMenuItem("Raise");
    public static final LogisimMenuItem LOWER = new LogisimMenuItem("Lower");
    public static final LogisimMenuItem RAISE_TOP = new LogisimMenuItem("RaiseTop");
    public static final LogisimMenuItem LOWER_BOTTOM = new LogisimMenuItem("LowerBottom");
    public static final LogisimMenuItem ADD_CONTROL = new LogisimMenuItem("AddControl");
    public static final LogisimMenuItem REMOVE_CONTROL = new LogisimMenuItem("RemoveControl");
    public static final LogisimMenuItem[] EDIT_ITEMS = new LogisimMenuItem[]{CUT, COPY, PASTE, DELETE, DUPLICATE, SELECT_ALL, RAISE, LOWER, RAISE_TOP, LOWER_BOTTOM, ADD_CONTROL, REMOVE_CONTROL};
    public static final LogisimMenuItem ADD_VHDL = new LogisimMenuItem("AddVhdl");
    public static final LogisimMenuItem IMPORT_VHDL = new LogisimMenuItem("ImportVhdl");
    public static final LogisimMenuItem ADD_CIRCUIT = new LogisimMenuItem("AddCircuit");
    public static final LogisimMenuItem MOVE_CIRCUIT_UP = new LogisimMenuItem("MoveCircuitUp");
    public static final LogisimMenuItem MOVE_CIRCUIT_DOWN = new LogisimMenuItem("MoveCircuitDown");
    public static final LogisimMenuItem SET_MAIN_CIRCUIT = new LogisimMenuItem("SetMainCircuit");
    public static final LogisimMenuItem REMOVE_CIRCUIT = new LogisimMenuItem("RemoveCircuit");
    public static final LogisimMenuItem EDIT_LAYOUT = new LogisimMenuItem("EditLayout");
    public static final LogisimMenuItem EDIT_APPEARANCE = new LogisimMenuItem("EditAppearance");
    public static final LogisimMenuItem TOGGLE_APPEARANCE = new LogisimMenuItem("ToggleEditLayoutAppearance");
    public static final LogisimMenuItem REVERT_APPEARANCE = new LogisimMenuItem("RevertAppearance");
    public static final LogisimMenuItem ANALYZE_CIRCUIT = new LogisimMenuItem("AnalyzeCircuit");
    public static final LogisimMenuItem CIRCUIT_STATS = new LogisimMenuItem("GetCircuitStatistics");
    public static final LogisimMenuItem SIMULATE_STOP = new LogisimMenuItem("SimulateStop");
    public static final LogisimMenuItem SIMULATE_RUN = new LogisimMenuItem("SimulateRun");
    public static final LogisimMenuItem SIMULATE_RUN_TOGGLE = new LogisimMenuItem("SimulateRun");
    public static final LogisimMenuItem SIMULATE_STEP = new LogisimMenuItem("SimulateStep");
    public static final LogisimMenuItem SIMULATE_VHDL_ENABLE = new LogisimMenuItem("SimulateVhdlEnable");
    public static final LogisimMenuItem GENERATE_VHDL_SIM_FILES = new LogisimMenuItem("GenerateVhdlSimFiles");
    public static final LogisimMenuItem TICK_ENABLE = new LogisimMenuItem("TickEnable");
    public static final LogisimMenuItem TICK_HALF = new LogisimMenuItem("TickHalf");
    public static final LogisimMenuItem TICK_FULL = new LogisimMenuItem("TickFull");
    public final MenuFile file;
    public final MenuEdit edit;
    public final MenuProject project;
    public final MenuSimulate simulate;
    public final MenuHelp help;
    public final MenuFpga fpga;
    private final LFrame parent;
    private final MyListener listener;
    private final Project saveProj;
    private final Project baseProj;
    private final Project simProj;
    private final HashMap<LogisimMenuItem, MenuItem> menuItems = new HashMap();
    private final ArrayList<ChangeListener> enableListeners;
    private SimulateListener simulateListener = null;

    public LogisimMenuBar(LFrame parent, Project saveProj, Project baseProj, Project simProj) {
        this.parent = parent;
        this.listener = new MyListener();
        this.saveProj = saveProj;
        this.baseProj = baseProj;
        this.simProj = simProj;
        this.enableListeners = new ArrayList();
        this.file = new MenuFile(this);
        this.add(this.file);
        this.edit = new MenuEdit(this);
        this.add(this.edit);
        this.project = new MenuProject(this);
        this.add(this.project);
        this.simulate = new MenuSimulate(this);
        this.add(this.simulate);
        this.fpga = new MenuFpga(parent, this, saveProj);
        this.add(this.fpga);
        this.add(new WindowMenu(parent));
        this.help = new MenuHelp(this);
        this.add(this.help);
        LocaleManager.addLocaleListener(this.listener);
        this.listener.localeChanged();
    }

    public void disableFile() {
        this.file.setEnabled(false);
    }

    public void disableProject() {
        this.project.setEnabled(false);
    }

    public void addActionListener(LogisimMenuItem which, ActionListener l) {
        MenuItem item = this.menuItems.get(which);
        if (item != null) {
            item.addActionListener(l);
        }
    }

    public void addEnableListener(ChangeListener l) {
        this.enableListeners.add(l);
    }

    public void doAction(LogisimMenuItem which) {
        MenuItem item = this.menuItems.get(which);
        item.actionPerformed(new ActionEvent(item, 1001, which.toString()));
    }

    public KeyStroke getAccelerator(LogisimMenuItem which) {
        MenuItem item = this.menuItems.get(which);
        return item == null ? null : item.getAccelerator();
    }

    void fireEnableChanged() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener listener : this.enableListeners) {
            listener.stateChanged(e);
        }
    }

    void fireStateChanged(Simulator sim, CircuitState state) {
        if (this.simulateListener != null) {
            this.simulateListener.stateChangeRequested(sim, state);
        }
    }

    LFrame getParentFrame() {
        return this.parent;
    }

    public Project getSaveProject() {
        return this.saveProj;
    }

    public Project getBaseProject() {
        return this.baseProj;
    }

    public Project getSimulationProject() {
        return this.simProj;
    }

    public boolean isEnabled(LogisimMenuItem item) {
        MenuItem menuItem = this.menuItems.get(item);
        return menuItem != null && menuItem.isEnabled();
    }

    void registerItem(LogisimMenuItem which, MenuItem item) {
        this.menuItems.put(which, item);
    }

    public void removeActionListener(LogisimMenuItem which, ActionListener l) {
        MenuItem item = this.menuItems.get(which);
        if (item != null) {
            item.removeActionListener(l);
        }
    }

    public void removeEnableListener(ChangeListener l) {
        this.enableListeners.remove(l);
    }

    public void setCircuitState(Simulator sim, CircuitState state) {
        this.simulate.setCurrentState(sim, state);
    }

    public void setEnabled(LogisimMenuItem which, boolean value) {
        MenuItem item = this.menuItems.get(which);
        if (item != null) {
            item.setEnabled(value);
        }
    }

    public void setSimulateListener(SimulateListener l) {
        this.simulateListener = l;
    }

    private class MyListener
    implements LocaleListener {
        private MyListener() {
        }

        @Override
        public void localeChanged() {
            LogisimMenuBar.this.file.localeChanged();
            LogisimMenuBar.this.edit.localeChanged();
            LogisimMenuBar.this.project.localeChanged();
            LogisimMenuBar.this.fpga.localeChanged();
            LogisimMenuBar.this.simulate.localeChanged();
            LogisimMenuBar.this.help.localeChanged();
        }
    }
}

