/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.menu;

import com.cburch.draw.model.CanvasModelEvent;
import com.cburch.draw.model.CanvasModelListener;
import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.circuit.Simulator;
import com.cburch.logisim.file.LibraryEvent;
import com.cburch.logisim.file.LibraryListener;
import com.cburch.logisim.file.LogisimFile;
import com.cburch.logisim.gui.appear.RevertAppearanceAction;
import com.cburch.logisim.gui.generic.CardPanel;
import com.cburch.logisim.gui.main.ExportImage;
import com.cburch.logisim.gui.main.Frame;
import com.cburch.logisim.gui.main.Print;
import com.cburch.logisim.gui.main.StatisticsDialog;
import com.cburch.logisim.gui.menu.LogisimMenuBar;
import com.cburch.logisim.gui.menu.MenuListener;
import com.cburch.logisim.gui.menu.ProjectCircuitActions;
import com.cburch.logisim.gui.menu.SimulateListener;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.proj.ProjectEvent;
import com.cburch.logisim.proj.ProjectListener;
import com.cburch.logisim.tools.AddTool;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;

public class MainMenuListener
extends MenuListener {
    protected final Frame frame;
    protected final FileListener fileListener = new FileListener();
    protected final ProjectMenuListener projectListener = new ProjectMenuListener();
    protected final SimulateMenuListener simulateListener = new SimulateMenuListener();

    public MainMenuListener(Frame frame, LogisimMenuBar menubar) {
        super(menubar);
        this.frame = frame;
    }

    public void register(CardPanel mainPanel) {
        this.fileListener.register();
        this.editListener.register();
        this.projectListener.register();
        this.simulateListener.register();
    }

    protected class FileListener
    implements ActionListener {
        protected FileListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object src = event.getSource();
            Project proj = MainMenuListener.this.frame.getProject();
            if (src == LogisimMenuBar.EXPORT_IMAGE) {
                ExportImage.doExport(proj);
            } else if (src == LogisimMenuBar.PRINT) {
                Print.doPrint(proj);
            }
        }

        public void register() {
            MainMenuListener.this.menubar.addActionListener(LogisimMenuBar.EXPORT_IMAGE, this);
            MainMenuListener.this.menubar.addActionListener(LogisimMenuBar.PRINT, this);
        }
    }

    protected class ProjectMenuListener
    implements ProjectListener,
    LibraryListener,
    ActionListener,
    PropertyChangeListener,
    CanvasModelListener {
        protected ProjectMenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Circuit cur;
            Object src = event.getSource();
            Project proj = MainMenuListener.this.frame.getProject();
            Circuit circuit = cur = proj == null ? null : proj.getCurrentCircuit();
            if (src == LogisimMenuBar.ADD_CIRCUIT) {
                ProjectCircuitActions.doAddCircuit(proj);
            } else if (src == LogisimMenuBar.ADD_VHDL) {
                ProjectCircuitActions.doAddVhdl(proj);
            } else if (src == LogisimMenuBar.IMPORT_VHDL) {
                ProjectCircuitActions.doImportVhdl(proj);
            } else if (src == LogisimMenuBar.MOVE_CIRCUIT_UP) {
                ProjectCircuitActions.doMoveCircuit(proj, cur, -1);
            } else if (src == LogisimMenuBar.MOVE_CIRCUIT_DOWN) {
                ProjectCircuitActions.doMoveCircuit(proj, cur, 1);
            } else if (src == LogisimMenuBar.SET_MAIN_CIRCUIT) {
                ProjectCircuitActions.doSetAsMainCircuit(proj, cur);
            } else if (src == LogisimMenuBar.REMOVE_CIRCUIT) {
                ProjectCircuitActions.doRemoveCircuit(proj, cur);
            } else if (src == LogisimMenuBar.EDIT_LAYOUT) {
                MainMenuListener.this.frame.setEditorView("layout");
            } else if (src == LogisimMenuBar.EDIT_APPEARANCE) {
                MainMenuListener.this.frame.setEditorView("appearance");
            } else if (src == LogisimMenuBar.TOGGLE_APPEARANCE) {
                boolean viewAppearance = MainMenuListener.this.frame.getEditorView().equals("appearance");
                MainMenuListener.this.frame.setEditorView(viewAppearance ? "layout" : "appearance");
            } else if (src == LogisimMenuBar.REVERT_APPEARANCE) {
                proj.doAction(new RevertAppearanceAction(cur));
            } else if (src == LogisimMenuBar.ANALYZE_CIRCUIT) {
                ProjectCircuitActions.doAnalyze(proj, cur);
            } else if (src == LogisimMenuBar.CIRCUIT_STATS) {
                StatisticsDialog.show(MainMenuListener.this.frame, proj.getLogisimFile(), cur);
            }
        }

        public void computeEnabled() {
            Project proj = MainMenuListener.this.frame == null ? null : MainMenuListener.this.frame.getProject();
            LogisimFile file = proj == null ? null : proj.getLogisimFile();
            Circuit cur = proj == null ? null : proj.getCurrentCircuit();
            int curIndex = file == null ? -1 : file.indexOfCircuit(cur);
            String editorView = MainMenuListener.this.frame == null ? "" : MainMenuListener.this.frame.getEditorView();
            boolean viewAppearance = editorView.equals("appearance");
            boolean viewLayout = editorView.equals("layout");
            boolean canSetMain = false;
            boolean canMoveUp = false;
            boolean canMoveDown = false;
            boolean canRemove = false;
            boolean canRevert = false;
            if (curIndex >= 0) {
                List<AddTool> tools = proj.getLogisimFile().getTools();
                canSetMain = proj.getLogisimFile().getMainCircuit() != cur;
                canMoveUp = curIndex > 0;
                canMoveDown = curIndex < tools.size() - 1;
                canRemove = tools.size() > 1;
                canRevert = viewAppearance && !cur.getAppearance().isDefaultAppearance();
            }
            MainMenuListener.this.menubar.setEnabled(LogisimMenuBar.ADD_CIRCUIT, true);
            MainMenuListener.this.menubar.setEnabled(LogisimMenuBar.ADD_VHDL, true);
            MainMenuListener.this.menubar.setEnabled(LogisimMenuBar.IMPORT_VHDL, true);
            MainMenuListener.this.menubar.setEnabled(LogisimMenuBar.MOVE_CIRCUIT_UP, canMoveUp);
            MainMenuListener.this.menubar.setEnabled(LogisimMenuBar.MOVE_CIRCUIT_DOWN, canMoveDown);
            MainMenuListener.this.menubar.setEnabled(LogisimMenuBar.SET_MAIN_CIRCUIT, canSetMain);
            MainMenuListener.this.menubar.setEnabled(LogisimMenuBar.REMOVE_CIRCUIT, canRemove);
            MainMenuListener.this.menubar.setEnabled(LogisimMenuBar.EDIT_LAYOUT, viewAppearance);
            MainMenuListener.this.menubar.setEnabled(LogisimMenuBar.EDIT_APPEARANCE, viewLayout);
            MainMenuListener.this.menubar.setEnabled(LogisimMenuBar.TOGGLE_APPEARANCE, true);
            MainMenuListener.this.menubar.setEnabled(LogisimMenuBar.REVERT_APPEARANCE, canRevert);
            MainMenuListener.this.menubar.setEnabled(LogisimMenuBar.ANALYZE_CIRCUIT, true);
            MainMenuListener.this.menubar.setEnabled(LogisimMenuBar.CIRCUIT_STATS, true);
            MainMenuListener.this.fireEnableChanged();
        }

        protected void computeRevertEnabled() {
            boolean oldValue;
            Project proj = MainMenuListener.this.frame.getProject();
            LogisimFile file = proj.getLogisimFile();
            Circuit cur = proj.getCurrentCircuit();
            boolean isProjectCircuit = file.contains(cur);
            boolean viewAppearance = MainMenuListener.this.frame.getEditorView().equals("appearance");
            boolean canRevert = isProjectCircuit && viewAppearance && !cur.getAppearance().isDefaultAppearance();
            if (canRevert != (oldValue = MainMenuListener.this.menubar.isEnabled(LogisimMenuBar.REVERT_APPEARANCE))) {
                MainMenuListener.this.menubar.setEnabled(LogisimMenuBar.REVERT_APPEARANCE, canRevert);
                MainMenuListener.this.fireEnableChanged();
            }
        }

        @Override
        public void libraryChanged(LibraryEvent event) {
            this.computeEnabled();
        }

        @Override
        public void modelChanged(CanvasModelEvent event) {
            this.computeRevertEnabled();
        }

        @Override
        public void projectChanged(ProjectEvent event) {
            int action = event.getAction();
            if (action == 1) {
                Object object = event.getOldData();
                if (object instanceof Circuit) {
                    Circuit old = (Circuit)object;
                    old.getAppearance().removeCanvasModelListener(this);
                }
                if ((object = event.getData()) instanceof Circuit) {
                    Circuit circ = (Circuit)object;
                    circ.getAppearance().addCanvasModelListener(this);
                }
                this.computeEnabled();
            } else if (action == 0) {
                this.computeEnabled();
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            this.computeEnabled();
        }

        void register() {
            Project proj = MainMenuListener.this.frame.getProject();
            if (proj == null) {
                return;
            }
            proj.addProjectListener(this);
            proj.addLibraryListener(this);
            MainMenuListener.this.frame.addPropertyChangeListener("editorView", this);
            MainMenuListener.this.frame.addPropertyChangeListener("explorerView", this);
            Circuit circ = proj.getCurrentCircuit();
            if (circ != null) {
                circ.getAppearance().addCanvasModelListener(this);
            }
            MainMenuListener.this.menubar.addActionListener(LogisimMenuBar.ADD_CIRCUIT, this);
            MainMenuListener.this.menubar.addActionListener(LogisimMenuBar.ADD_VHDL, this);
            MainMenuListener.this.menubar.addActionListener(LogisimMenuBar.IMPORT_VHDL, this);
            MainMenuListener.this.menubar.addActionListener(LogisimMenuBar.MOVE_CIRCUIT_UP, this);
            MainMenuListener.this.menubar.addActionListener(LogisimMenuBar.MOVE_CIRCUIT_DOWN, this);
            MainMenuListener.this.menubar.addActionListener(LogisimMenuBar.SET_MAIN_CIRCUIT, this);
            MainMenuListener.this.menubar.addActionListener(LogisimMenuBar.REMOVE_CIRCUIT, this);
            MainMenuListener.this.menubar.addActionListener(LogisimMenuBar.EDIT_LAYOUT, this);
            MainMenuListener.this.menubar.addActionListener(LogisimMenuBar.EDIT_APPEARANCE, this);
            MainMenuListener.this.menubar.addActionListener(LogisimMenuBar.TOGGLE_APPEARANCE, this);
            MainMenuListener.this.menubar.addActionListener(LogisimMenuBar.REVERT_APPEARANCE, this);
            MainMenuListener.this.menubar.addActionListener(LogisimMenuBar.ANALYZE_CIRCUIT, this);
            MainMenuListener.this.menubar.addActionListener(LogisimMenuBar.CIRCUIT_STATS, this);
            this.computeEnabled();
        }
    }

    protected class SimulateMenuListener
    implements ProjectListener,
    SimulateListener {
        protected SimulateMenuListener() {
        }

        @Override
        public void projectChanged(ProjectEvent event) {
            if (event.getAction() == 4) {
                MainMenuListener.this.menubar.setCircuitState(MainMenuListener.this.frame.getProject().getSimulator(), MainMenuListener.this.frame.getProject().getCircuitState());
            }
        }

        void register() {
            Project proj = MainMenuListener.this.frame.getProject();
            proj.addProjectListener(this);
            MainMenuListener.this.menubar.setSimulateListener(this);
            MainMenuListener.this.menubar.setCircuitState(proj.getSimulator(), proj.getCircuitState());
        }

        @Override
        public void stateChangeRequested(Simulator sim, CircuitState state) {
            if (state != null) {
                MainMenuListener.this.frame.getProject().setCircuitState(state);
            }
        }
    }
}

