/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.menu;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.file.LoadedLibrary;
import com.cburch.logisim.file.LogisimFile;
import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.main.StatisticsDialog;
import com.cburch.logisim.gui.menu.ProjectCircuitActions;
import com.cburch.logisim.gui.menu.ProjectLibraryActions;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.tools.AddTool;
import com.cburch.logisim.tools.Library;
import com.cburch.logisim.tools.Tool;
import com.cburch.logisim.vhdl.base.VhdlContent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class Popups {
    public static JPopupMenu forCircuit(Project proj, AddTool tool, Circuit circ) {
        return new CircuitPopup(proj, tool, circ);
    }

    public static JPopupMenu forVhdl(Project proj, AddTool tool, VhdlContent vhdl) {
        return new VhdlPopup(proj, tool, vhdl);
    }

    public static JPopupMenu forLibrary(Project proj, Library lib, boolean isTop) {
        return new LibraryPopup(proj, lib, isTop);
    }

    public static JPopupMenu forProject(Project proj) {
        return new ProjectPopup(proj);
    }

    public static JPopupMenu forTool(Project proj, Tool tool) {
        return null;
    }

    private static class CircuitPopup
    extends JPopupMenu
    implements ActionListener {
        final Project proj;
        final Circuit circuit;
        final JMenuItem analyze = new JMenuItem(Strings.S.get("projectAnalyzeCircuitItem"));
        final JMenuItem stats = new JMenuItem(Strings.S.get("projectGetCircuitStatisticsItem"));
        final JMenuItem main = new JMenuItem(Strings.S.get("projectSetAsMainItem"));
        final JMenuItem remove = new JMenuItem(Strings.S.get("projectRemoveCircuitItem"));
        final JMenuItem editLayout = new JMenuItem(Strings.S.get("projectEditCircuitLayoutItem"));
        final JMenuItem editAppearance = new JMenuItem(Strings.S.get("projectEditCircuitAppearanceItem"));

        CircuitPopup(Project proj, Tool tool, Circuit circuit) {
            super(Strings.S.get("circuitMenu"));
            this.proj = proj;
            this.circuit = circuit;
            this.add(this.editLayout);
            this.editLayout.addActionListener(this);
            this.add(this.editAppearance);
            this.editAppearance.addActionListener(this);
            this.add(this.analyze);
            this.analyze.addActionListener(this);
            this.add(this.stats);
            this.stats.addActionListener(this);
            this.addSeparator();
            this.add(this.main);
            this.main.addActionListener(this);
            this.add(this.remove);
            this.remove.addActionListener(this);
            boolean canChange = proj.getLogisimFile().contains(circuit);
            LogisimFile file = proj.getLogisimFile();
            if (circuit == proj.getCurrentCircuit()) {
                if (proj.getFrame().getEditorView().equals("appearance")) {
                    this.editAppearance.setEnabled(false);
                } else {
                    this.editLayout.setEnabled(false);
                }
            }
            this.main.setEnabled(canChange && file.getMainCircuit() != circuit);
            this.remove.setEnabled(canChange && file.getCircuitCount() > 1 && proj.getDependencies().canRemove(circuit));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == this.editLayout) {
                this.proj.setCurrentCircuit(this.circuit);
                this.proj.getFrame().setEditorView("layout");
            } else if (source == this.editAppearance) {
                this.proj.setCurrentCircuit(this.circuit);
                this.proj.getFrame().setEditorView("appearance");
            } else if (source == this.analyze) {
                ProjectCircuitActions.doAnalyze(this.proj, this.circuit);
            } else if (source == this.stats) {
                JFrame frame = (JFrame)SwingUtilities.getRoot(this);
                StatisticsDialog.show(frame, this.proj.getLogisimFile(), this.circuit);
            } else if (source == this.main) {
                ProjectCircuitActions.doSetAsMainCircuit(this.proj, this.circuit);
            } else if (source == this.remove) {
                ProjectCircuitActions.doRemoveCircuit(this.proj, this.circuit);
            }
        }
    }

    private static class VhdlPopup
    extends JPopupMenu
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        final Project proj;
        final VhdlContent vhdl;
        final JMenuItem edit = new JMenuItem(Strings.S.get("projectEditVhdlItem"));
        final JMenuItem remove = new JMenuItem(Strings.S.get("projectRemoveVhdlItem"));

        VhdlPopup(Project proj, Tool tool, VhdlContent vhdl) {
            super(Strings.S.get("vhdlMenu"));
            this.proj = proj;
            this.vhdl = vhdl;
            this.add(this.edit);
            this.edit.addActionListener(this);
            this.add(this.remove);
            this.remove.addActionListener(this);
            this.edit.setEnabled(vhdl != proj.getFrame().getHdlEditorView());
            boolean canChange = proj.getLogisimFile().contains(vhdl);
            this.remove.setEnabled(canChange && proj.getDependencies().canRemove(vhdl));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == this.edit) {
                this.proj.setCurrentHdlModel(this.vhdl);
            } else if (source == this.remove) {
                ProjectCircuitActions.doRemoveVhdl(this.proj, this.vhdl);
            }
        }
    }

    private static class LibraryPopup
    extends JPopupMenu
    implements ActionListener {
        final Project proj;
        final Library lib;
        final JMenuItem unload = new JMenuItem(Strings.S.get("projectUnloadLibraryItem"));
        final JMenuItem reload = new JMenuItem(Strings.S.get("projectReloadLibraryItem"));

        LibraryPopup(Project proj, Library lib, boolean isTop) {
            super(Strings.S.get("libMenu"));
            this.proj = proj;
            this.lib = lib;
            this.add(this.unload);
            this.unload.addActionListener(this);
            this.add(this.reload);
            this.reload.addActionListener(this);
            this.unload.setEnabled(isTop);
            this.reload.setEnabled(isTop && lib instanceof LoadedLibrary);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src == this.unload) {
                ProjectLibraryActions.doUnloadLibrary(this.proj, this.lib);
            } else if (src == this.reload) {
                this.proj.getLogisimFile().getLoader().reload((LoadedLibrary)this.lib);
            }
        }
    }

    private static class ProjectPopup
    extends JPopupMenu
    implements ActionListener {
        final Project proj;
        final JMenuItem add = new JMenuItem(Strings.S.get("projectAddCircuitItem"));
        final JMenuItem vhdl = new JMenuItem(Strings.S.get("projectAddVhdlItem"));
        final JMenu load = new JMenu(Strings.S.get("projectLoadLibraryItem"));
        final JMenuItem loadBuiltin = new JMenuItem(Strings.S.get("projectLoadBuiltinItem"));
        final JMenuItem loadLogisim = new JMenuItem(Strings.S.get("projectLoadLogisimItem"));
        final JMenuItem loadJar = new JMenuItem(Strings.S.get("projectLoadJarItem"));

        ProjectPopup(Project proj) {
            super(Strings.S.get("projMenu"));
            this.proj = proj;
            this.load.add(this.loadBuiltin);
            this.loadBuiltin.addActionListener(this);
            this.load.add(this.loadLogisim);
            this.loadLogisim.addActionListener(this);
            this.load.add(this.loadJar);
            this.loadJar.addActionListener(this);
            this.add(this.add);
            this.add.addActionListener(this);
            this.add(this.vhdl);
            this.vhdl.addActionListener(this);
            this.add(this.load);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src == this.add) {
                ProjectCircuitActions.doAddCircuit(this.proj);
            } else if (src == this.vhdl) {
                ProjectCircuitActions.doAddVhdl(this.proj);
            } else if (src == this.loadBuiltin) {
                ProjectLibraryActions.doLoadBuiltinLibrary(this.proj);
            } else if (src == this.loadLogisim) {
                ProjectLibraryActions.doLoadLogisimLibrary(this.proj);
            } else if (src == this.loadJar) {
                ProjectLibraryActions.doLoadJarLibrary(this.proj);
            }
        }
    }
}

