/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.menu;

import com.cburch.contracts.BaseWindowFocusListenerContract;
import com.cburch.logisim.analyze.gui.Analyzer;
import com.cburch.logisim.analyze.gui.AnalyzerManager;
import com.cburch.logisim.analyze.model.Var;
import com.cburch.logisim.circuit.Analyze;
import com.cburch.logisim.circuit.AnalyzeException;
import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.file.LogisimFile;
import com.cburch.logisim.file.LogisimFileActions;
import com.cburch.logisim.fpga.designrulecheck.CorrectLabel;
import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.std.wiring.Pin;
import com.cburch.logisim.tools.AddTool;
import com.cburch.logisim.tools.Library;
import com.cburch.logisim.tools.Tool;
import com.cburch.logisim.util.SyntaxChecker;
import com.cburch.logisim.vhdl.base.VhdlContent;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Map;
import java.util.SortedMap;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ProjectCircuitActions {
    private ProjectCircuitActions() {
    }

    private static void analyzeError(Project proj, String message) {
        OptionPane.showMessageDialog(proj.getFrame(), message, Strings.S.get("analyzeErrorTitle"), 0);
    }

    private static void configureAnalyzer(Project proj, Circuit circuit, Analyzer analyzer, Map<Instance, String> pinNames, ArrayList<Var> inputVars, ArrayList<Var> outputVars) {
        analyzer.getModel().setVariables(inputVars, outputVars);
        if (inputVars.size() == 0 || outputVars.size() == 0) {
            analyzer.setSelectedTab(0);
            return;
        }
        try {
            Analyze.computeExpression(analyzer.getModel(), circuit, pinNames);
            analyzer.setSelectedTab(2);
            return;
        }
        catch (AnalyzeException ex) {
            OptionPane.showMessageDialog(proj.getFrame(), ex.getMessage(), Strings.S.get("analyzeNoExpressionTitle"), 1);
            Analyze.computeTable(analyzer.getModel(), proj, circuit, pinNames);
            analyzer.setSelectedTab(1);
            return;
        }
    }

    public static void doAddCircuit(Project proj) {
        String name = ProjectCircuitActions.promptForCircuitName(proj.getFrame(), proj.getLogisimFile(), "");
        if (name != null) {
            Object error = null;
            if (name.isEmpty()) {
                error = Strings.S.get("circuitNameMissingError");
            } else if (CorrectLabel.isKeyword(name, false)) {
                error = "\"" + name + "\": " + Strings.S.get("circuitNameKeyword");
            } else if (ProjectCircuitActions.nameIsInUse(proj, name)) {
                error = "\"" + name + "\": " + Strings.S.get("circuitNameExists");
            } else {
                String nameMessage = SyntaxChecker.getErrorMessage(name);
                if (nameMessage != null) {
                    error = "\"" + name + "\": " + Strings.S.get("circuitNameInvalidName") + "\n" + nameMessage;
                }
            }
            if (error != null) {
                OptionPane.showMessageDialog(proj.getFrame(), error, Strings.S.get("circuitCreateTitle"), 0);
            } else {
                Circuit circuit = new Circuit(name, proj.getLogisimFile(), proj);
                proj.doAction(LogisimFileActions.addCircuit(circuit));
                proj.setCurrentCircuit(circuit);
            }
        }
    }

    private static boolean nameIsInUse(Project proj, String name) {
        for (Library mylib : proj.getLogisimFile().getLibraries()) {
            if (!ProjectCircuitActions.nameIsInLibraries(mylib, name)) continue;
            return true;
        }
        for (AddTool mytool : proj.getLogisimFile().getTools()) {
            if (!name.equalsIgnoreCase(mytool.getName())) continue;
            return true;
        }
        return false;
    }

    private static boolean nameIsInLibraries(Library lib, String name) {
        for (Library library : lib.getLibraries()) {
            if (!ProjectCircuitActions.nameIsInLibraries(library, name)) continue;
            return true;
        }
        for (Tool tool : lib.getTools()) {
            if (!name.equalsIgnoreCase(tool.getName())) continue;
            return true;
        }
        return false;
    }

    public static void doAddVhdl(Project proj) {
        VhdlContent content;
        String name = ProjectCircuitActions.promptForVhdlName(proj.getFrame(), proj.getLogisimFile(), "");
        if (name != null && (content = VhdlContent.create(name, proj.getLogisimFile())) != null) {
            proj.doAction(LogisimFileActions.addVhdl(content));
            proj.setCurrentHdlModel(content);
        }
    }

    public static void doImportVhdl(Project proj) {
        String vhdl = proj.getLogisimFile().getLoader().vhdlImportChooser(proj.getFrame());
        if (vhdl == null) {
            return;
        }
        VhdlContent content = VhdlContent.parse(null, vhdl, proj.getLogisimFile());
        if (content == null) {
            return;
        }
        if (VhdlContent.labelVHDLInvalidNotify(content.getName(), proj.getLogisimFile())) {
            return;
        }
        proj.doAction(LogisimFileActions.addVhdl(content));
        proj.setCurrentHdlModel(content);
    }

    public static void doAnalyze(Project proj, Circuit circuit) {
        SortedMap<Instance, String> pinNames = Analyze.getPinLabels(circuit);
        ArrayList<Var> inputVars = new ArrayList<Var>();
        ArrayList<Var> outputVars = new ArrayList<Var>();
        int numInputs = 0;
        int numOutputs = 0;
        for (Map.Entry<Instance, String> entry : pinNames.entrySet()) {
            Instance pin = entry.getKey();
            boolean isInput = Pin.FACTORY.isInputPin(pin);
            int width = pin.getAttributeValue(StdAttr.WIDTH).getWidth();
            Var v = new Var(entry.getValue(), width);
            if (isInput) {
                inputVars.add(v);
                numInputs += width;
                continue;
            }
            outputVars.add(v);
            numOutputs += width;
        }
        if (numInputs > 20) {
            ProjectCircuitActions.analyzeError(proj, Strings.S.get("analyzeTooManyInputsError", "20"));
            return;
        }
        if (numOutputs > 256) {
            ProjectCircuitActions.analyzeError(proj, Strings.S.get("analyzeTooManyOutputsError", "256"));
            return;
        }
        Analyzer analyzer = AnalyzerManager.getAnalyzer(proj.getFrame());
        analyzer.getModel().setCurrentCircuit(proj, circuit);
        ProjectCircuitActions.configureAnalyzer(proj, circuit, analyzer, pinNames, inputVars, outputVars);
        if (!analyzer.isVisible()) {
            analyzer.setVisible(true);
        }
        analyzer.toFront();
    }

    public static void doMoveCircuit(Project proj, Circuit cur, int delta) {
        AddTool tool = proj.getLogisimFile().getAddTool(cur);
        if (tool != null) {
            int oldPos = proj.getLogisimFile().indexOfCircuit(cur);
            int newPos = oldPos + delta;
            int toolsCount = proj.getLogisimFile().getTools().size();
            if (newPos >= 0 && newPos < toolsCount) {
                proj.doAction(LogisimFileActions.moveCircuit(tool, newPos));
            }
        }
    }

    public static void doRemoveCircuit(Project proj, Circuit circuit) {
        if (proj.getLogisimFile().getCircuits().size() == 1) {
            OptionPane.showMessageDialog(proj.getFrame(), Strings.S.get("circuitRemoveLastError"), Strings.S.get("circuitRemoveErrorTitle"), 0);
        } else if (!proj.getDependencies().canRemove(circuit)) {
            OptionPane.showMessageDialog(proj.getFrame(), Strings.S.get("circuitRemoveUsedError"), Strings.S.get("circuitRemoveErrorTitle"), 0);
        } else {
            proj.doAction(LogisimFileActions.removeCircuit(circuit));
        }
    }

    public static void doRemoveVhdl(Project proj, VhdlContent vhdl) {
        if (!proj.getDependencies().canRemove(vhdl)) {
            OptionPane.showMessageDialog(proj.getFrame(), Strings.S.get("circuitRemoveUsedError"), Strings.S.get("circuitRemoveErrorTitle"), 0);
        } else {
            proj.doAction(LogisimFileActions.removeVhdl(vhdl));
        }
    }

    public static void doSetAsMainCircuit(Project proj, Circuit circuit) {
        proj.doAction(LogisimFileActions.setMainCircuit(circuit));
    }

    private static String promptForCircuitName(JFrame frame, Library lib, String initialValue) {
        return ProjectCircuitActions.promptForNewName(frame, lib, initialValue, false);
    }

    private static String promptForVhdlName(JFrame frame, LogisimFile file, String initialValue) {
        String name = ProjectCircuitActions.promptForNewName(frame, file, initialValue, true);
        if (name == null) {
            return null;
        }
        if (VhdlContent.labelVHDLInvalidNotify(name, file)) {
            return null;
        }
        return name;
    }

    private static String promptForNewName(JFrame frame, Library lib, String initialValue, boolean vhdl) {
        String prompt;
        String title;
        if (vhdl) {
            title = Strings.S.get("vhdlNameDialogTitle");
            prompt = Strings.S.get("vhdlNamePrompt");
        } else {
            title = Strings.S.get("circuitNameDialogTitle");
            prompt = Strings.S.get("circuitNamePrompt");
        }
        final JTextField field = new JTextField(15);
        field.setText(initialValue);
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel strut = new JPanel(null);
        strut.setPreferredSize(new Dimension(3 * field.getPreferredSize().width / 2, 0));
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.weightx = 1.0;
        gbc.fill = 0;
        gbc.anchor = 21;
        JLabel label = new JLabel(prompt);
        gbl.setConstraints(label, gbc);
        JPanel panel = new JPanel(gbl);
        panel.add(label);
        gbl.setConstraints(field, gbc);
        panel.add(field);
        JLabel error = new JLabel(" ");
        gbl.setConstraints(error, gbc);
        panel.add(error);
        gbl.setConstraints(strut, gbc);
        panel.add(strut);
        JOptionPane pane = new JOptionPane(panel, 3, 2);
        pane.setInitialValue(field);
        JDialog dlog = pane.createDialog(frame, title);
        dlog.addWindowFocusListener(new BaseWindowFocusListenerContract(){

            @Override
            public void windowGainedFocus(WindowEvent arg0) {
                field.requestFocus();
            }
        });
        field.selectAll();
        dlog.pack();
        dlog.setVisible(true);
        field.requestFocusInWindow();
        Object action = pane.getValue();
        if (!(action instanceof Integer) || (Integer)action != 0) {
            return null;
        }
        return field.getText().trim();
    }
}

