/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.start;

import com.cburch.logisim.Main;
import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.file.LoadFailedException;
import com.cburch.logisim.file.Loader;
import com.cburch.logisim.file.LogisimFileActions;
import com.cburch.logisim.fpga.download.Download;
import com.cburch.logisim.fpga.file.BoardReaderClass;
import com.cburch.logisim.generated.BuildInfo;
import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.generic.CanvasPane;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.gui.icons.ErrorIcon;
import com.cburch.logisim.gui.icons.InfoIcon;
import com.cburch.logisim.gui.icons.QuestionIcon;
import com.cburch.logisim.gui.icons.WarningIcon;
import com.cburch.logisim.gui.main.Print;
import com.cburch.logisim.gui.menu.LogisimMenuBar;
import com.cburch.logisim.gui.menu.WindowManagers;
import com.cburch.logisim.gui.start.MacOsAdapter;
import com.cburch.logisim.gui.start.SplashScreen;
import com.cburch.logisim.gui.start.TtyInterface;
import com.cburch.logisim.gui.test.TestBench;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.proj.ProjectActions;
import com.cburch.logisim.tools.Library;
import com.cburch.logisim.util.JFileChoosers;
import com.cburch.logisim.util.LineBuffer;
import com.cburch.logisim.util.LocaleManager;
import com.cburch.logisim.util.MacCompatibility;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ContainerEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.help.JHelp;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.apache.commons.cli.help.HelpFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Startup
implements AWTEventListener {
    static final Logger logger = LoggerFactory.getLogger(Startup.class);
    private static Startup startupTemp = null;
    private final ArrayList<File> filesToOpen = new ArrayList();
    private final HashMap<File, File> substitutions = new HashMap();
    private final ArrayList<File> filesToPrint = new ArrayList();
    final boolean isTty;
    private File templFile = null;
    private boolean templEmpty = false;
    private boolean templPlain = false;
    private String testVector = null;
    private String circuitToTest = null;
    private boolean exitAfterStartup = false;
    private boolean showSplash;
    private File loadFile;
    private File saveFile;
    private int ttyFormat = 0;
    private boolean initialized = false;
    private SplashScreen monitor = null;
    private String testCircuitPathInput = null;
    private String testCircuitImpPath = null;
    private boolean doFpgaDownload = false;
    private double testTickFrequency = -1.0;
    private String testCircuitImpName = null;
    private String testCircuitImpBoard = null;
    private final String testCircuitImpMapFile;
    private Boolean testCircuitHdlOnly = false;
    private String testCircPathInput = null;
    private String testCircPathOutput = null;
    private static final String ARG_TEST_CIRCUIT_SHORT = "b";
    private static final String ARG_TEST_CIRCUIT_LONG = "test-circuit";
    private static final String ARG_TEST_FGPA_SHORT = "f";
    private static final String ARG_TEST_FGPA_LONG = "test-fpga";
    private static final String ARG_GATES_SHORT = "g";
    private static final String ARG_GATES_LONG = "gates";
    private static final String ARG_HELP_SHORT = "h";
    private static final String ARG_HELP_LONG = "help";
    private static final String ARG_LOAD_SHORT = "l";
    private static final String ARG_LOAD_LONG = "load";
    private static final String ARG_SAVE_LONG = "save";
    private static final String ARG_GEOMETRY_SHORT = "m";
    private static final String ARG_GEOMETRY_LONG = "geometry";
    private static final String ARG_TEST_CIRC_GEN_SHORT = "n";
    private static final String ARG_TEST_CIRC_GEN_LONG = "new-file-format";
    private static final String ARG_LOCALE_SHORT = "o";
    private static final String ARG_LOCALE_LONG = "locale";
    private static final String ARG_CLEAR_PREFS_LONG = "clear-prefs";
    private static final String ARG_SUBSTITUTE_SHORT = "s";
    private static final String ARG_SUBSTITUTE_LONG = "substitute";
    private static final String ARG_TTY_SHORT = "t";
    private static final String ARG_TTY_LONG = "tty";
    private static final String ARG_TEMPLATE_SHORT = "u";
    private static final String ARG_TEMPLATE_LONG = "user-template";
    private static final String ARG_VERSION_SHORT = "v";
    private static final String ARG_VERSION_LONG = "version";
    private static final String ARG_TEST_VECTOR_SHORT = "w";
    private static final String ARG_TEST_VECTOR_LONG = "test-vector";
    private static final String ARG_NO_SPLASH_LONG = "no-splash";
    private static final String ARG_MAIN_CIRCUIT = "toplevel-circuit";
    private static RC lastHandlerRc;
    private static boolean testFpgaFlagTickFreqSet;

    private Startup(boolean isTty) {
        this.testCircuitImpMapFile = null;
        this.isTty = isTty;
        this.showSplash = !isTty;
    }

    static void doOpen(File file) {
        if (startupTemp != null) {
            startupTemp.doOpenFile(file);
        }
    }

    static void doPrint(File file) {
        if (startupTemp != null) {
            startupTemp.doPrintFile(file);
        }
    }

    protected static boolean parseBool(String option) throws IllegalArgumentException {
        List<String> positives = List.of("yes", "y", "1", "true", ARG_TTY_SHORT);
        List<String> negatives = List.of("no", ARG_TEST_CIRC_GEN_SHORT, "0", "false", ARG_TEST_FGPA_SHORT);
        String flag = option.toLowerCase();
        if (positives.contains(flag)) {
            return true;
        }
        if (negatives.contains(flag)) {
            return false;
        }
        throw new IllegalArgumentException(LineBuffer.format("Invalid boolean flag value. Use '{{1}}' for positives and '{{2}}' for negatives.", String.join((CharSequence)", ", positives), String.join((CharSequence)", ", negatives)));
    }

    protected static RC printHelp(Options opts) {
        Startup.printVersion();
        System.out.println();
        HelpFormatter.Builder builder = HelpFormatter.builder();
        builder.setShowSince(false);
        HelpFormatter formatter = builder.get();
        List<Option> sortedOpts = formatter.sort(opts);
        try {
            formatter.printHelp("Logisim-evolution", null, sortedOpts, null, true);
        }
        catch (Exception ex) {
            System.out.println("Print help failed: " + ex.getMessage());
        }
        return RC.QUIT;
    }

    protected static RC printVersion() {
        System.out.println("Logisim-evolution v4.0.0");
        System.out.println("https://github.com/logisim-evolution/");
        System.out.println(LineBuffer.format("{{1}} ({{2}})", "(Not built from Git repo)", "2025-09-09T13:07:58+0000"));
        System.out.println(LineBuffer.format("{{1}} ({{2}})", BuildInfo.jvm_version, BuildInfo.jvm_vendor));
        return RC.QUIT;
    }

    protected static void addOption(Options opts, String stringBaseKey, String longKey) {
        Startup.addOption(opts, stringBaseKey, longKey, null, 0);
    }

    protected static void addOption(Options opts, String stringBaseKey, String longKey, int expectedArgsCount) {
        Startup.addOption(opts, stringBaseKey, longKey, null, expectedArgsCount);
    }

    protected static void addOption(Options opts, String stringBaseKey, String longKey, String shortKey, int expectedArgsCount) {
        Option.Builder builder = Option.builder(shortKey).longOpt(longKey).desc(Strings.S.get(stringBaseKey));
        if (expectedArgsCount == -2 || expectedArgsCount > 0) {
            String argNameKey = LineBuffer.format("{{1}}ArgName", stringBaseKey);
            builder.argName(Strings.S.get(argNameKey));
            builder.numberOfArgs(expectedArgsCount);
        }
        opts.addOption(builder.get());
    }

    protected static void addOption(Options opts, String stringBaseKey, String shortKey, String longKey) {
        Startup.addOption(opts, stringBaseKey, shortKey, longKey, 0);
    }

    public boolean shallQuit() {
        return lastHandlerRc == RC.QUIT;
    }

    public static Startup parseArgs(String[] args) {
        Startup startup;
        CommandLine cmd;
        Options opts = new Options();
        Startup.addOption(opts, "argHelpOption", ARG_HELP_LONG, ARG_HELP_SHORT);
        Startup.addOption(opts, "argVersionOption", ARG_VERSION_LONG, ARG_VERSION_SHORT);
        Startup.addOption(opts, "argTtyOption", ARG_TTY_LONG, ARG_TTY_SHORT, 1);
        Startup.addOption(opts, "argTestImplement", ARG_TEST_FGPA_LONG, ARG_TEST_FGPA_SHORT, -2);
        Startup.addOption(opts, "argClearOption", ARG_CLEAR_PREFS_LONG);
        Startup.addOption(opts, "argSubOption", ARG_SUBSTITUTE_LONG, ARG_SUBSTITUTE_SHORT, 2);
        Startup.addOption(opts, "argLoadOption", ARG_LOAD_LONG, ARG_LOAD_SHORT, 1);
        Startup.addOption(opts, "argSaveOption", ARG_SAVE_LONG, 1);
        Startup.addOption(opts, "argGatesOption", ARG_GATES_LONG, ARG_GATES_SHORT, 1);
        Startup.addOption(opts, "argGeometryOption", ARG_GEOMETRY_LONG, ARG_GEOMETRY_SHORT, 1);
        Startup.addOption(opts, "argLocaleOption", ARG_LOCALE_LONG, ARG_LOCALE_SHORT, 1);
        Startup.addOption(opts, "argTemplateOption", ARG_TEMPLATE_LONG, ARG_TEMPLATE_SHORT, 1);
        Startup.addOption(opts, "argNoSplashOption", ARG_NO_SPLASH_LONG);
        Startup.addOption(opts, "argMainCircuitOption", ARG_MAIN_CIRCUIT, 1);
        Startup.addOption(opts, "argTestVectorOption", ARG_TEST_VECTOR_LONG, ARG_TEST_VECTOR_SHORT, 2);
        Startup.addOption(opts, "argTestCircuitOption", ARG_TEST_CIRCUIT_LONG, ARG_TEST_CIRCUIT_SHORT, 1);
        Startup.addOption(opts, "argTestCircGenOption", ARG_TEST_CIRC_GEN_LONG, ARG_TEST_CIRC_GEN_SHORT, 2);
        try {
            cmd = new DefaultParser().parse(opts, args);
        }
        catch (UnrecognizedOptionException ex) {
            logger.error("Unrecognized option: '" + String.valueOf(ex) + ".);");
            logger.error("Use --help for more info.");
            return null;
        }
        catch (ParseException ex) {
            logger.error("Failed processing command line arguments.");
            return null;
        }
        boolean isTty = false;
        boolean shallClearPreferences = false;
        if (cmd.hasOption(ARG_TTY_SHORT) || cmd.hasOption(ARG_TEST_FGPA_SHORT) || cmd.hasOption(ARG_TEST_FGPA_LONG)) {
            isTty = true;
            Main.headless = true;
        } else {
            shallClearPreferences = cmd.hasOption(ARG_CLEAR_PREFS_LONG);
        }
        if (!isTty) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            AppPreferences.handleGraphicsAcceleration();
        }
        startupTemp = startup = new Startup(isTty);
        if (!isTty) {
            MacOsAdapter.addListeners();
        }
        if (shallClearPreferences) {
            AppPreferences.clear();
        }
        Iterator<Option> optionIter = cmd.iterator();
        while (optionIter.hasNext()) {
            RC optHandlerRc;
            Option opt = optionIter.next();
            lastHandlerRc = optHandlerRc = (switch (opt.getLongOpt()) {
                case ARG_HELP_LONG -> Startup.printHelp(opts);
                case ARG_VERSION_LONG -> Startup.printVersion();
                case ARG_TTY_LONG -> Startup.handleArgTty(startup, opt);
                case ARG_SUBSTITUTE_LONG -> Startup.handleArgSubstitute(startup, opt);
                case ARG_LOAD_LONG -> Startup.handleArgLoad(startup, opt);
                case ARG_SAVE_LONG -> Startup.handleArgSave(startup, opt);
                case ARG_GATES_LONG -> Startup.handleArgGates(startup, opt);
                case ARG_GEOMETRY_LONG -> Startup.handleArgGeometry(startup, opt);
                case ARG_LOCALE_LONG -> Startup.handleArgLocale(startup, opt);
                case ARG_TEMPLATE_LONG -> Startup.handleArgTemplate(startup, opt);
                case ARG_NO_SPLASH_LONG -> Startup.handleArgNoSplash(startup, opt);
                case ARG_TEST_VECTOR_LONG -> Startup.handleArgTestVector(startup, opt);
                case ARG_TEST_FGPA_LONG -> Startup.handleArgTestFpga(startup, opt);
                case ARG_TEST_CIRCUIT_LONG -> Startup.handleArgTestCircuit(startup, opt);
                case ARG_TEST_CIRC_GEN_LONG -> Startup.handleArgTestCircGen(startup, opt);
                case ARG_MAIN_CIRCUIT -> Startup.handleArgMainCircuit(startup, opt);
                default -> RC.OK;
            });
            switch (optHandlerRc.ordinal()) {
                case 2: {
                    return startup;
                }
            }
        }
        for (String arg : cmd.getArgs()) {
            startup.filesToOpen.add(new File(arg));
        }
        if (startup.exitAfterStartup && startup.filesToOpen.isEmpty()) {
            Startup.printHelp(opts);
            return null;
        }
        if (startup.isTty && startup.filesToOpen.isEmpty()) {
            logger.error(Strings.S.get("ttyNeedsFileError"));
            return null;
        }
        if (startup.loadFile != null && !startup.isTty) {
            logger.error(Strings.S.get("loadNeedsTtyError"));
            return null;
        }
        if (startup.saveFile != null && !startup.isTty) {
            logger.error(Strings.S.get("saveNeedsTtyError"));
            return null;
        }
        return startup;
    }

    private static RC handleArgTty(Startup startup, Option opt) {
        String[] stringArray;
        int n;
        int n2;
        String ttyVal = opt.getValue();
        String[] fmts = ttyVal.split(",");
        if (fmts.length > 0 && (n2 = 0) < (n = (stringArray = fmts).length)) {
            int val;
            String singleFmt = stringArray[n2];
            switch (singleFmt.trim()) {
                case "table": {
                    int n3 = 1;
                    break;
                }
                case "speed": {
                    int n3 = 2;
                    break;
                }
                case "tty": {
                    int n3 = 4;
                    break;
                }
                case "halt": {
                    int n3 = 8;
                    break;
                }
                case "stats": {
                    int n3 = 16;
                    break;
                }
                case "binary": {
                    int n3 = 128;
                    break;
                }
                case "hex": {
                    int n3 = 256;
                    break;
                }
                case "csv": {
                    int n3 = 64;
                    break;
                }
                case "tabs": {
                    int n3 = 32;
                    break;
                }
                default: {
                    int n3 = val = 0;
                }
            }
            if (val == 0) {
                logger.error(Strings.S.get("ttyFormatError"));
                return RC.QUIT;
            }
            startup.ttyFormat |= val;
            return RC.OK;
        }
        logger.error(Strings.S.get("ttyFormatError"));
        return RC.QUIT;
    }

    private static RC handleArgSubstitute(Startup startup, Option opt) {
        File fileA = new File(opt.getValues()[0]);
        File fileB = new File(opt.getValues()[1]);
        if (!startup.substitutions.containsKey(fileA)) {
            startup.substitutions.put(fileA, fileB);
            return RC.OK;
        }
        logger.error(Strings.S.get("argDuplicateSubstitutionError"));
        return RC.QUIT;
    }

    private static RC handleArgLoad(Startup startup, Option opt) {
        if (startup.loadFile != null) {
            logger.error(Strings.S.get("loadMultipleError"));
            return RC.WARN;
        }
        String fileName = opt.getValue();
        startup.loadFile = new File(fileName);
        return RC.OK;
    }

    private static RC handleArgSave(Startup startup, Option opt) {
        if (startup.saveFile != null) {
            logger.error(Strings.S.get("saveMultipleError"));
            return RC.WARN;
        }
        String fileName = opt.getValue();
        startup.saveFile = new File(fileName);
        return RC.OK;
    }

    private static RC handleArgGates(Startup startup, Option opt) {
        String gateShape = opt.getValue().toLowerCase();
        if ("ansi".equals(gateShape)) {
            AppPreferences.GATE_SHAPE.set("shaped");
            return RC.OK;
        }
        if ("iec".equals(gateShape)) {
            AppPreferences.GATE_SHAPE.set("rectangular");
            return RC.OK;
        }
        logger.error(Strings.S.get("argGatesOptionError"));
        return RC.QUIT;
    }

    private static RC handleArgGeometry(Startup startup, Option opt) {
        String geometry = opt.getValue();
        String[] wxh = geometry.split("[xX]");
        if (wxh.length != 2 || wxh[0].length() < 1 || wxh[1].length() < 1) {
            logger.error(Strings.S.get("argGeometryError"));
            return RC.QUIT;
        }
        int p = wxh[1].indexOf(43, 1);
        String loc = null;
        int x = 0;
        int y = 0;
        if (p >= 0) {
            loc = wxh[1].substring(p + 1);
            wxh[1] = wxh[1].substring(0, p);
            String[] xy = loc.split("\\+");
            if (xy.length != 2 || xy[0].length() < 1 || xy[1].length() < 1) {
                logger.error(Strings.S.get("argGeometryError"));
                return RC.QUIT;
            }
            try {
                x = Integer.parseInt(xy[0]);
                y = Integer.parseInt(xy[1]);
            }
            catch (NumberFormatException e) {
                logger.error(Strings.S.get("argGeometryError"));
                return RC.QUIT;
            }
        }
        int w = 0;
        int h = 0;
        try {
            w = Integer.parseInt(wxh[0]);
            h = Integer.parseInt(wxh[1]);
        }
        catch (NumberFormatException e) {
            logger.error(Strings.S.get("argGeometryError"));
            return RC.QUIT;
        }
        if (w <= 0 || h <= 0) {
            logger.error(Strings.S.get("argGeometryError"));
            return RC.QUIT;
        }
        AppPreferences.WINDOW_WIDTH.set(w);
        AppPreferences.WINDOW_HEIGHT.set(h);
        if (loc != null) {
            AppPreferences.WINDOW_LOCATION.set(x + "," + y);
        }
        return RC.OK;
    }

    private static RC handleArgLocale(Startup startup, Option opt) {
        Startup.setLocale(opt.getValue());
        return RC.OK;
    }

    private static RC handleArgTemplate(Startup startup, Option opt) {
        if (startup.templFile != null || startup.templEmpty || startup.templPlain) {
            logger.error(Strings.S.get("argOneTemplateError"));
            return RC.QUIT;
        }
        String option = opt.getValue();
        File file = new File(option);
        if (file.exists()) {
            startup.templFile = file;
            if (!startup.templFile.canRead()) {
                logger.error(Strings.S.get("templateCannotReadError", file));
                return RC.QUIT;
            }
            return RC.OK;
        }
        if (option.equalsIgnoreCase("empty")) {
            startup.templEmpty = true;
            return RC.OK;
        }
        if (option.equalsIgnoreCase("plain")) {
            startup.templPlain = true;
            return RC.OK;
        }
        logger.error(Strings.S.get("argOneTemplateError"));
        return RC.QUIT;
    }

    private static RC handleArgNoSplash(Startup startup, Option opt) {
        startup.showSplash = false;
        return RC.OK;
    }

    private static RC handleArgTestVector(Startup startup, Option opt) {
        startup.circuitToTest = opt.getValues()[0];
        startup.testVector = opt.getValues()[1];
        startup.showSplash = false;
        startup.exitAfterStartup = true;
        return RC.OK;
    }

    private static RC handleArgMainCircuit(Startup startup, Option opt) {
        startup.circuitToTest = opt.getValues()[0];
        return RC.OK;
    }

    private static RC handleArgTestFpgaParseArg(Startup startup, String argVal) {
        if ("HDLONLY".equals(argVal)) {
            if (!testFpgaFlagTickFreqSet) {
                startup.testCircuitHdlOnly = true;
            }
            return RC.OK;
        }
        try {
            int freq = Integer.parseUnsignedInt(argVal);
            if (!testFpgaFlagTickFreqSet) {
                startup.testTickFrequency = freq;
                testFpgaFlagTickFreqSet = true;
            }
            return RC.OK;
        }
        catch (NumberFormatException numberFormatException) {
            logger.error(Strings.S.get("argTestUnknownFlagOrValue", String.valueOf(argVal)));
            return RC.QUIT;
        }
    }

    private static RC handleArgTestFpga(Startup startup, Option opt) {
        String[] optArgs = opt.getValues();
        if (optArgs == null) {
            logger.error(Strings.S.get("argTestInvalidArguments"));
            return RC.QUIT;
        }
        int argsCnt = optArgs.length;
        if (argsCnt < 3 || argsCnt > 5) {
            logger.error(Strings.S.get("argTestInvalidArguments"));
            return RC.QUIT;
        }
        startup.testCircuitImpPath = optArgs[0];
        startup.testCircuitImpName = optArgs[1];
        startup.testCircuitImpBoard = optArgs[2];
        RC handlerRc = RC.OK;
        if (argsCnt >= 4 && (handlerRc = Startup.handleArgTestFpgaParseArg(startup, optArgs[3])) == RC.QUIT) {
            return handlerRc;
        }
        if (argsCnt >= 5 && (handlerRc = Startup.handleArgTestFpgaParseArg(startup, optArgs[4])) == RC.QUIT) {
            return handlerRc;
        }
        startup.doFpgaDownload = true;
        startup.showSplash = false;
        startup.filesToOpen.add(new File(startup.testCircuitImpPath));
        return RC.OK;
    }

    private static RC handleArgTestCircuit(Startup startup, Option opt) {
        String fileName;
        startup.testCircuitPathInput = fileName = opt.getValue();
        startup.filesToOpen.add(new File(fileName));
        startup.showSplash = false;
        startup.exitAfterStartup = true;
        return RC.OK;
    }

    private static RC handleArgTestCircGen(Startup startup, Option opt) {
        String[] optArgs = opt.getValues();
        startup.testCircPathInput = optArgs[0];
        startup.filesToOpen.add(new File(startup.testCircPathInput));
        startup.testCircPathOutput = optArgs[1];
        startup.showSplash = false;
        startup.exitAfterStartup = true;
        return RC.OK;
    }

    private static void setLocale(String lang) {
        Locale[] opts;
        for (Locale locale : opts = Strings.S.getLocaleOptions()) {
            if (!lang.equals(locale.toString())) continue;
            LocaleManager.setLocale(locale);
            return;
        }
        logger.warn(Strings.S.get("invalidLocaleError"));
        logger.warn(Strings.S.get("invalidLocaleOptionsHeader"));
        for (Locale opt : opts) {
            logger.warn("   {}", (Object)opt.toString());
        }
        System.exit(-1);
    }

    private static String getProgramDirectory() {
        File pathOfMainClass = new File(Main.class.getProtectionDomain().getCodeSource().getLocation().getPath());
        return URLDecoder.decode(pathOfMainClass.getParentFile().getAbsolutePath(), StandardCharsets.UTF_8);
    }

    private void doOpenFile(File file) {
        if (this.initialized) {
            ProjectActions.doOpen(null, null, file);
        } else {
            this.filesToOpen.add(file);
        }
    }

    private void doPrintFile(File file) {
        if (this.initialized) {
            Project toPrint = ProjectActions.doOpen(null, null, file);
            Print.doPrint(toPrint);
            toPrint.getFrame().dispose();
        } else {
            this.filesToPrint.add(file);
        }
    }

    List<File> getFilesToOpen() {
        return this.filesToOpen;
    }

    File getLoadFile() {
        return this.loadFile;
    }

    File getSaveFile() {
        return this.saveFile;
    }

    String getCircuitToTest() {
        return this.circuitToTest;
    }

    Map<File, File> getSubstitutions() {
        return Collections.unmodifiableMap(this.substitutions);
    }

    int getTtyFormat() {
        return this.ttyFormat;
    }

    boolean isFpgaDownload() {
        return this.doFpgaDownload;
    }

    boolean fpgaDownload(Project proj) {
        Circuit mainCircuit = proj.getLogisimFile().getCircuit(this.testCircuitImpName);
        if (mainCircuit == null) {
            return false;
        }
        double simTickFreq = mainCircuit.getTickFrequency();
        double downTickFreq = mainCircuit.getDownloadFrequency();
        double usedFrequency = this.testTickFrequency > 0.0 ? this.testTickFrequency : (downTickFreq > 0.0 ? downTickFreq : simTickFreq);
        Download downloader = new Download(proj, this.testCircuitImpName, usedFrequency, new BoardReaderClass(AppPreferences.Boards.getBoardFilePath(this.testCircuitImpBoard)).getBoardInformation(), this.testCircuitImpMapFile, false, false, this.testCircuitHdlOnly, 1.0, 1.0);
        return downloader.runTty();
    }

    private void loadTemplate(Loader loader, File templFile, boolean templEmpty) {
        if (this.showSplash) {
            this.monitor.setProgress(2);
        }
        if (templFile != null) {
            AppPreferences.setTemplateFile(templFile);
            AppPreferences.setTemplateType(2);
        } else if (templEmpty) {
            AppPreferences.setTemplateType(0);
        } else if (this.templPlain) {
            AppPreferences.setTemplateType(1);
        }
    }

    public void run() {
        Loader templLoader;
        int count;
        if (this.isTty) {
            try {
                TtyInterface.run(this);
                System.exit(0);
            }
            catch (Exception t) {
                t.printStackTrace();
                System.exit(-1);
            }
        }
        if (this.showSplash) {
            try {
                this.monitor = new SplashScreen();
                this.monitor.setVisible(true);
            }
            catch (Exception t) {
                this.monitor = null;
                this.showSplash = false;
            }
        }
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 3L);
        if (this.showSplash) {
            this.monitor.setProgress(0);
        }
        if ((count = (templLoader = new Loader(this.monitor)).getBuiltin().getLibrary("Base").getTools().size() + templLoader.getBuiltin().getLibrary("Gates").getTools().size()) < 0) {
            logger.error("FATAL ERROR - no components");
            System.exit(-1);
        }
        Library[] defaultLibraries = templLoader.loadCustomStartupLibraries(Startup.getProgramDirectory() + File.separator + "logisim-defaults");
        this.loadTemplate(templLoader, this.templFile, this.templEmpty);
        if (this.showSplash) {
            this.monitor.setProgress(5);
        }
        WindowManagers.initialize();
        if (MacCompatibility.isSwingUsingScreenMenuBar()) {
            MacCompatibility.setFramelessJMenuBar(new LogisimMenuBar(null, null, null, null));
        } else {
            new LogisimMenuBar(null, null, null, null);
        }
        UIManager.getDefaults().put("Button.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"ENTER", "pressed", "released ENTER", "released", "SPACE", "pressed", "released SPACE", "released"}));
        this.initialized = true;
        if (this.testVector == null && this.testCircPathInput == null) {
            File[] autosaves = new File(System.getProperty("user.home")).listFiles(new FilenameFilter(this){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(".logisim-unnamed-autosave_") && name.endsWith(".circ.autosave");
                }
            });
            for (File autosave : autosaves) {
                boolean retry = false;
                do {
                    retry = false;
                    Object[] options = new String[]{Strings.S.get("saveOption"), Strings.S.get("saveAndLoadOption"), Strings.S.get("discardOption")};
                    int option = OptionPane.showOptionDialog(this.monitor, String.format(Strings.S.get("contentHandleAutosave"), autosave.getName()), Strings.S.get("titleHandleAutosave"), -1, 3, null, options, options[0]);
                    if (option == -1) continue;
                    if (option == 2) {
                        autosave.delete();
                        continue;
                    }
                    JFileChooser chooser = JFileChoosers.createAt(new File(System.getProperty("user.home")));
                    chooser.setFileFilter(Loader.LOGISIM_FILTER);
                    int fileRes = chooser.showSaveDialog(this.monitor);
                    if (fileRes != 0) {
                        retry = true;
                        continue;
                    }
                    File file = chooser.getSelectedFile();
                    if (file.exists()) {
                        int confirm = OptionPane.showConfirmDialog(this.monitor, Strings.S.get("confirmOverwriteMessage"), Strings.S.get("confirmOverwriteTitle"), 0);
                        if (confirm != 0) {
                            retry = true;
                            continue;
                        }
                        file.delete();
                    }
                    if (!autosave.renameTo(file)) {
                        retry = true;
                        continue;
                    }
                    if (option != 1) continue;
                    this.filesToOpen.add(file);
                } while (retry);
            }
        }
        Project proj = null;
        if (this.filesToOpen.isEmpty()) {
            proj = ProjectActions.doNew(this.monitor);
            proj.setStartupScreen(true);
            if (this.showSplash) {
                this.monitor.close();
            }
        } else {
            int numOpened = 0;
            boolean first = true;
            for (File fileToOpen : this.filesToOpen) {
                try {
                    if (this.testVector != null) {
                        proj = ProjectActions.doOpenNoWindow(this.monitor, fileToOpen);
                        proj.doTestVector(this.testVector, this.circuitToTest);
                    } else if (this.testCircPathInput != null && this.testCircPathOutput != null) {
                        proj = ProjectActions.doOpen(this.monitor, fileToOpen, this.substitutions);
                        ProjectActions.doSave(proj, new File(this.testCircPathOutput));
                    } else if (this.testCircuitPathInput != null) {
                        TestBench testB = new TestBench(this.testCircuitPathInput, this.monitor, this.substitutions);
                        if (testB.startTestBench()) {
                            System.out.println("Test bench pass\n");
                            System.exit(0);
                        } else {
                            System.out.println("Test bench fail\n");
                            System.exit(-1);
                        }
                    } else {
                        ProjectActions.doOpen(this.monitor, fileToOpen, this.substitutions);
                    }
                    ++numOpened;
                }
                catch (LoadFailedException ex) {
                    logger.error("{} : {}", (Object)fileToOpen.getName(), (Object)ex.getMessage());
                }
                if (!first) continue;
                first = false;
                if (this.showSplash) {
                    this.monitor.close();
                }
                this.monitor = null;
            }
            if (numOpened == 0) {
                System.exit(-1);
            }
        }
        if (proj != null) {
            proj.doAction(LogisimFileActions.loadLibraries(defaultLibraries, proj.getLogisimFile()));
        }
        for (File fileToPrint : this.filesToPrint) {
            this.doPrintFile(fileToPrint);
        }
        if (this.exitAfterStartup) {
            System.exit(0);
        }
    }

    private boolean hasIcon(Component comp) {
        boolean result = false;
        if (comp instanceof JOptionPane) {
            JOptionPane pane = (JOptionPane)comp;
            for (Component comp1 : pane.getComponents()) {
                result |= this.hasIcon(comp1);
            }
        } else if (comp instanceof JPanel) {
            JPanel panel = (JPanel)comp;
            for (Component comp1 : panel.getComponents()) {
                result |= this.hasIcon(comp1);
            }
        } else if (comp instanceof JLabel) {
            JLabel label = (JLabel)comp;
            return label.getIcon() != null;
        }
        return result;
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        ContainerEvent containerEvent;
        if (event instanceof ContainerEvent && (containerEvent = (ContainerEvent)event).getID() == 300) {
            JOptionPane pane;
            Component container = containerEvent.getChild();
            if (container instanceof JButton || container instanceof JCheckBox || container instanceof JComboBox || container instanceof JToolTip || container instanceof JLabel || container instanceof JFrame || container instanceof JMenuItem || container instanceof JRadioButton || container instanceof JRadioButtonMenuItem || container instanceof JProgressBar || container instanceof JSpinner || container instanceof JTabbedPane || container instanceof JTextField || container instanceof JTextArea || container instanceof JHelp || container instanceof JFileChooser || container instanceof JScrollPane && !(container instanceof CanvasPane) || container instanceof JCheckBoxMenuItem) {
                AppPreferences.setScaledFonts(((JComponent)container).getComponents());
                try {
                    container.setFont(AppPreferences.getScaledFont(containerEvent.getChild().getFont()));
                    container.revalidate();
                    container.repaint();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (container instanceof JOptionPane && this.hasIcon(pane = (JOptionPane)container)) {
                switch (pane.getMessageType()) {
                    case 0: {
                        pane.setIcon(new ErrorIcon());
                        break;
                    }
                    case 3: {
                        pane.setIcon(new QuestionIcon());
                        break;
                    }
                    case 1: {
                        pane.setIcon(new InfoIcon());
                        break;
                    }
                    case 2: {
                        pane.setIcon(new WarningIcon());
                    }
                }
            }
        }
    }

    static {
        testFpgaFlagTickFreqSet = false;
    }

    public static enum RC {
        OK,
        WARN,
        QUIT;

    }
}

