/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.start;

import com.cburch.logisim.analyze.model.TruthTable;
import com.cburch.logisim.analyze.model.Var;
import com.cburch.logisim.circuit.Analyze;
import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.circuit.Propagator;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.file.FileStatistics;
import com.cburch.logisim.file.LoadFailedException;
import com.cburch.logisim.file.Loader;
import com.cburch.logisim.file.LogisimFile;
import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.hex.HexFile;
import com.cburch.logisim.gui.start.Startup;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.std.io.Keyboard;
import com.cburch.logisim.std.io.Tty;
import com.cburch.logisim.std.memory.MemContents;
import com.cburch.logisim.std.memory.Ram;
import com.cburch.logisim.std.wiring.Pin;
import com.cburch.logisim.tools.Library;
import com.cburch.logisim.util.UniquelyNamedThread;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.SortedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TtyInterface {
    public static final int FORMAT_TABLE = 1;
    public static final int FORMAT_SPEED = 2;
    public static final int FORMAT_TTY = 4;
    public static final int FORMAT_HALT = 8;
    public static final int FORMAT_STATISTICS = 16;
    public static final int FORMAT_TABLE_TABBED = 32;
    public static final int FORMAT_TABLE_CSV = 64;
    public static final int FORMAT_TABLE_BIN = 128;
    public static final int FORMAT_TABLE_HEX = 256;
    static final Logger logger = LoggerFactory.getLogger(TtyInterface.class);
    private static boolean lastIsNewline = true;

    private static int countDigits(int num) {
        int digits = 1;
        for (int lessThan = 10; num >= lessThan; lessThan *= 10) {
            ++digits;
        }
        return digits;
    }

    private static void displaySpeed(long tickCount, long elapse) {
        double hertz = (double)tickCount / (double)elapse * 1000.0;
        double precision = hertz >= 100.0 ? 1.0 : (hertz >= 10.0 ? 0.1 : (hertz >= 1.0 ? 0.01 : (hertz >= 0.01 ? 1.0E-4 : 1.0E-7)));
        hertz = (double)((int)(hertz / precision)) * precision;
        String hertzStr = hertz == (double)((int)hertz) ? "" + (int)hertz : "" + hertz;
        System.out.printf(Strings.S.get("ttySpeedMsg") + "\n", hertzStr, tickCount, elapse);
    }

    private static void displayStatistics(LogisimFile file, Circuit circuit) {
        FileStatistics stats = FileStatistics.compute(file, circuit);
        FileStatistics.Count total = stats.getTotalWithSubcircuits();
        int maxName = 0;
        for (FileStatistics.Count count : stats.getCounts()) {
            int nameLength = count.getFactory().getDisplayName().length();
            if (nameLength <= maxName) continue;
            maxName = nameLength;
        }
        String fmt = "%" + TtyInterface.countDigits(total.getUniqueCount()) + "d\t%" + TtyInterface.countDigits(total.getRecursiveCount()) + "d\t";
        String fmtNormal = fmt + "%-" + maxName + "s\t%s\n";
        for (FileStatistics.Count count : stats.getCounts()) {
            Library lib = count.getLibrary();
            String libName = lib == null ? "-" : lib.getDisplayName();
            System.out.printf(fmtNormal, count.getUniqueCount(), count.getRecursiveCount(), count.getFactory().getDisplayName(), libName);
        }
        FileStatistics.Count totalWithout = stats.getTotalWithoutSubcircuits();
        System.out.printf(fmt + "%s\n", totalWithout.getUniqueCount(), totalWithout.getRecursiveCount(), Strings.S.get("statsTotalWithout"));
        System.out.printf(fmt + "%s\n", total.getUniqueCount(), total.getRecursiveCount(), Strings.S.get("statsTotalWith"));
    }

    private static void displayTableRow(ArrayList<Value> prevOutputs, ArrayList<Value> curOutputs) {
        int i;
        boolean shouldPrint = false;
        if (prevOutputs == null) {
            shouldPrint = true;
        } else {
            for (i = 0; i < curOutputs.size(); ++i) {
                Value b;
                Value a = prevOutputs.get(i);
                if (a.equals(b = curOutputs.get(i))) continue;
                shouldPrint = true;
                break;
            }
        }
        if (shouldPrint) {
            for (i = 0; i < curOutputs.size(); ++i) {
                if (i != 0) {
                    System.out.print("\t");
                }
                System.out.print(curOutputs.get(i));
            }
            System.out.println();
        }
    }

    private static boolean displayTableRow(boolean showHeader, ArrayList<Value> prevOutputs, ArrayList<Value> curOutputs, ArrayList<String> headers, ArrayList<String> formats, int format) {
        boolean shouldPrint = false;
        if (prevOutputs == null) {
            shouldPrint = true;
        } else {
            for (int i = 0; i < curOutputs.size(); ++i) {
                Value b;
                Value a = prevOutputs.get(i);
                if (a.equals(b = curOutputs.get(i))) continue;
                shouldPrint = true;
                break;
            }
        }
        if (shouldPrint) {
            String sep = "";
            sep = (format & 0x20) != 0 ? "\t" : ((format & 0x40) != 0 ? "," : " ");
            if (showHeader) {
                int i;
                for (i = 0; i < headers.size(); ++i) {
                    if ((format & 0x20) != 0) {
                        formats.add("%s");
                        continue;
                    }
                    if ((format & 0x40) != 0) {
                        formats.add("%s");
                        continue;
                    }
                    int w = headers.get(i).length();
                    w = Math.max(w, TtyInterface.valueFormat(curOutputs.get(i), format).length());
                    formats.add("%" + w + "s");
                }
                for (i = 0; i < headers.size(); ++i) {
                    if (i != 0) {
                        System.out.print(sep);
                    }
                    System.out.printf(formats.get(i), headers.get(i));
                }
                System.out.println();
            }
            for (int i = 0; i < curOutputs.size(); ++i) {
                if (i != 0) {
                    System.out.print(sep);
                }
                System.out.printf(formats.get(i), TtyInterface.valueFormat(curOutputs.get(i), format));
            }
            System.out.println();
        }
        return shouldPrint;
    }

    private static String valueFormat(Value v, int format) {
        if ((format & 0x80) != 0) {
            return v.toString();
        }
        if ((format & 0x100) != 0) {
            return v.toHexString();
        }
        if (v.getWidth() <= 6) {
            return v.toBinaryString();
        }
        return "0x" + v.toHexString();
    }

    private static void ensureLineTerminated() {
        if (!lastIsNewline) {
            lastIsNewline = true;
            System.out.print('\n');
        }
    }

    private static boolean loadRam(CircuitState circState, File loadFile) throws IOException {
        if (loadFile == null) {
            return false;
        }
        boolean found = false;
        for (Component comp : circState.getCircuit().getNonWires()) {
            ComponentFactory componentFactory = comp.getFactory();
            if (!(componentFactory instanceof Ram)) continue;
            Ram ramFactory = (Ram)componentFactory;
            InstanceState ramState = circState.getInstanceState(comp);
            MemContents m = ramFactory.getContents(ramState);
            HexFile.open(m, loadFile);
            found = true;
        }
        for (CircuitState sub : circState.getSubstates()) {
            found |= TtyInterface.loadRam(sub, loadFile);
        }
        return found;
    }

    private static boolean saveRam(CircuitState circState, File saveFile) throws IOException {
        if (saveFile == null) {
            return false;
        }
        boolean found = false;
        for (Component comp : circState.getCircuit().getNonWires()) {
            ComponentFactory componentFactory = comp.getFactory();
            if (!(componentFactory instanceof Ram)) continue;
            Ram ramFactory = (Ram)componentFactory;
            InstanceState ramState = circState.getInstanceState(comp);
            MemContents m = ramFactory.getContents(ramState);
            HexFile.save(saveFile, m, "v3.0 hex words plain");
            found = true;
        }
        for (CircuitState sub : circState.getSubstates()) {
            found |= TtyInterface.saveRam(sub, saveFile);
        }
        return found;
    }

    private static boolean prepareForTty(CircuitState circState, ArrayList<InstanceState> keybStates) {
        boolean found = false;
        for (Component comp : circState.getCircuit().getNonWires()) {
            ComponentFactory factory = comp.getFactory();
            if (factory instanceof Tty) {
                Tty ttyFactory = (Tty)factory;
                InstanceState ttyState = circState.getInstanceState(comp);
                ttyFactory.sendToStdout(ttyState);
                found = true;
                continue;
            }
            if (!(factory instanceof Keyboard)) continue;
            keybStates.add(circState.getInstanceState(comp));
            found = true;
        }
        for (CircuitState sub : circState.getSubstates()) {
            found |= TtyInterface.prepareForTty(sub, keybStates);
        }
        return found;
    }

    public static void run(Startup args) {
        String circuitToTest;
        LogisimFile file;
        File fileToOpen = args.getFilesToOpen().get(0);
        Loader loader = new Loader(null);
        try {
            file = loader.openLogisimFile(fileToOpen, args.getSubstitutions());
        }
        catch (LoadFailedException e) {
            logger.error("{}", (Object)Strings.S.get("ttyLoadError", fileToOpen.getName()));
            System.exit(-1);
            return;
        }
        Project proj = new Project(file);
        if (args.isFpgaDownload() && !args.fpgaDownload(proj)) {
            System.exit(-1);
        }
        Circuit circuit = (circuitToTest = args.getCircuitToTest()) == null || circuitToTest.length() == 0 ? file.getMainCircuit() : file.getCircuit(circuitToTest);
        int format = args.getTtyFormat();
        if ((format & 0x10) != 0) {
            format &= 0xFFFFFFEF;
            TtyInterface.displayStatistics(file, circuit);
        }
        if (format == 0) {
            System.exit(0);
        }
        SortedMap<Instance, String> pinNames = Analyze.getPinLabels(circuit);
        ArrayList<Instance> outputPins = new ArrayList<Instance>();
        ArrayList<Instance> inputPins = new ArrayList<Instance>();
        Instance haltPin = null;
        for (Map.Entry<Instance, String> entry : pinNames.entrySet()) {
            Instance pin = entry.getKey();
            String pinName = entry.getValue();
            if (Pin.FACTORY.isInputPin(pin)) {
                inputPins.add(pin);
                continue;
            }
            outputPins.add(pin);
            if (!pinName.equals("halt")) continue;
            haltPin = pin;
        }
        if (haltPin == null && (format & 1) != 0) {
            TtyInterface.doTableAnalysis(proj, circuit, pinNames, format);
            return;
        }
        CircuitState circState = CircuitState.createRootState(proj, circuit);
        if (args.getLoadFile() != null) {
            try {
                boolean loaded = TtyInterface.loadRam(circState, args.getLoadFile());
                if (!loaded) {
                    logger.error("{}", (Object)Strings.S.get("loadNoRamError"));
                    System.exit(-1);
                }
            }
            catch (IOException e) {
                logger.error("{}: {}", (Object)Strings.S.get("loadIoError"), (Object)e.toString());
                System.exit(-1);
            }
        }
        circState.getPropagator().propagate();
        int ttyFormat = args.getTtyFormat();
        int simCode = TtyInterface.runSimulation(circState, outputPins, haltPin, ttyFormat);
        if (args.getSaveFile() != null) {
            try {
                boolean saved = TtyInterface.saveRam(circState, args.getSaveFile());
                if (!saved) {
                    logger.error("{}", (Object)Strings.S.get("saveNoRamError"));
                    System.exit(-1);
                }
            }
            catch (IOException e) {
                logger.error("{}: {}", (Object)Strings.S.get("saveIoError"), (Object)e.toString());
                System.exit(-1);
            }
        }
        System.exit(simCode);
    }

    private static int doTableAnalysis(Project proj, Circuit circuit, Map<Instance, String> pinLabels, int format) {
        String pinName;
        Instance pin;
        ArrayList<Iterator<Map.Entry<Instance, String>>> inputPins = new ArrayList<Iterator<Map.Entry<Instance, String>>>();
        ArrayList<Var> inputVars = new ArrayList<Var>();
        ArrayList<String> inputNames = new ArrayList<String>();
        ArrayList<Iterator<Map.Entry<Instance, String>>> outputPins = new ArrayList<Iterator<Map.Entry<Instance, String>>>();
        ArrayList<Var> outputVars = new ArrayList<Var>();
        ArrayList<String> outputNames = new ArrayList<String>();
        ArrayList<String> formats = new ArrayList<String>();
        for (Map.Entry<Instance, String> entry : pinLabels.entrySet()) {
            Iterator<Map.Entry<Instance, String>> pin2 = entry.getKey();
            int n = ((Instance)((Object)pin2)).getAttributeValue(StdAttr.WIDTH).getWidth();
            Var var = new Var(entry.getValue(), n);
            if (Pin.FACTORY.isInputPin((Instance)((Object)pin2))) {
                inputPins.add(pin2);
                for (String name : var) {
                    inputNames.add(name);
                }
                inputVars.add(var);
                continue;
            }
            outputPins.add(pin2);
            for (String name : var) {
                outputNames.add(name);
            }
            outputVars.add(var);
        }
        ArrayList<String> headers = new ArrayList<String>();
        ArrayList<Instance> pinList = new ArrayList<Instance>();
        for (Map.Entry entry : pinLabels.entrySet()) {
            pin = (Instance)entry.getKey();
            pinName = (String)entry.getValue();
            if (!Pin.FACTORY.isInputPin(pin)) continue;
            headers.add(pinName);
            pinList.add(pin);
        }
        for (Map.Entry<Instance, String> entry : pinLabels.entrySet()) {
            pin = entry.getKey();
            pinName = entry.getValue();
            if (Pin.FACTORY.isInputPin(pin)) continue;
            headers.add(pinName);
            pinList.add(pin);
        }
        int inputCount = inputNames.size();
        int n = 1 << inputCount;
        boolean needTableHeader = true;
        HashMap<Instance, Value> valueMap = new HashMap<Instance, Value>();
        for (int i = 0; i < n; ++i) {
            valueMap.clear();
            CircuitState circuitState = CircuitState.createRootState(proj, circuit);
            int incol = 0;
            for (Instance instance : inputPins) {
                int width = instance.getAttributeValue(StdAttr.WIDTH).getWidth();
                Value[] v = new Value[width];
                for (int b = width - 1; b >= 0; --b) {
                    boolean value;
                    v[b] = (value = TruthTable.isInputSet(i, incol++, inputCount)) ? Value.TRUE : Value.FALSE;
                }
                InstanceState pinState = circuitState.getInstanceState(instance);
                Pin.FACTORY.driveInputPin(pinState, Value.create(v));
                valueMap.put(instance, Value.create(v));
            }
            Propagator prop = circuitState.getPropagator();
            prop.propagate();
            for (Instance pin4 : outputPins) {
                if (prop.isOscillating()) {
                    BitWidth width = pin4.getAttributeValue(StdAttr.WIDTH);
                    valueMap.put(pin4, Value.createError(width));
                    continue;
                }
                InstanceState pinState = circuitState.getInstanceState(pin4);
                Value outValue = Pin.FACTORY.getValue(pinState);
                valueMap.put(pin4, outValue);
            }
            ArrayList<Value> arrayList = new ArrayList<Value>();
            for (Instance pin5 : pinList) {
                arrayList.add((Value)valueMap.get(pin5));
            }
            TtyInterface.displayTableRow(needTableHeader, null, arrayList, headers, formats, format);
            needTableHeader = false;
        }
        return 0;
    }

    private static int runSimulation(CircuitState circState, ArrayList<Instance> outputPins, Instance haltPin, int format) {
        boolean showTable = (format & 1) != 0;
        boolean showSpeed = (format & 2) != 0;
        boolean showTty = (format & 4) != 0;
        boolean showHalt = (format & 8) != 0;
        ArrayList<InstanceState> keyboardStates = null;
        StdinThread stdinThread = null;
        if (showTty) {
            keyboardStates = new ArrayList<InstanceState>();
            boolean ttyFound = TtyInterface.prepareForTty(circState, keyboardStates);
            if (!ttyFound) {
                logger.error("{}", (Object)Strings.S.get("ttyNoTtyError"));
                System.exit(-1);
            }
            if (keyboardStates.isEmpty()) {
                keyboardStates = null;
            } else {
                stdinThread = new StdinThread();
                stdinThread.start();
            }
        }
        int retCode = 0;
        long tickCount = 0L;
        long start = System.currentTimeMillis();
        boolean halted = false;
        ArrayList<Value> prevOutputs = null;
        Propagator prop = circState.getPropagator();
        while (true) {
            char[] buffer;
            ArrayList<Value> curOutputs = new ArrayList<Value>();
            for (Instance pin : outputPins) {
                InstanceState pinState = circState.getInstanceState(pin);
                Value val = Pin.FACTORY.getValue(pinState);
                if (pin == haltPin) {
                    halted |= val.equals(Value.TRUE);
                    continue;
                }
                if (!showTable) continue;
                curOutputs.add(val);
            }
            if (showTable) {
                TtyInterface.displayTableRow(prevOutputs, curOutputs);
            }
            if (halted) {
                retCode = 0;
                break;
            }
            if (prop.isOscillating()) {
                retCode = 1;
                break;
            }
            if (keyboardStates != null && (buffer = stdinThread.getBuffer()) != null) {
                for (InstanceState keyState : keyboardStates) {
                    Keyboard.addToBuffer(keyState, buffer);
                }
            }
            prevOutputs = curOutputs;
            ++tickCount;
            prop.toggleClocks();
            prop.propagate();
        }
        long elapse = System.currentTimeMillis() - start;
        if (showTty) {
            TtyInterface.ensureLineTerminated();
        }
        if (showHalt || retCode != 0) {
            if (retCode == 0) {
                logger.error("{}", (Object)Strings.S.get("ttyHaltReasonPin"));
            } else if (retCode == 1) {
                logger.error("{}", (Object)Strings.S.get("ttyHaltReasonOscillation"));
            }
        }
        if (showSpeed) {
            TtyInterface.displaySpeed(tickCount, elapse);
        }
        return retCode;
    }

    public static void sendFromTty(char c) {
        lastIsNewline = c == '\n';
        System.out.print(c);
    }

    private static class StdinThread
    extends UniquelyNamedThread {
        private final LinkedList<char[]> queue = new LinkedList();

        public StdinThread() {
            super("TtyInterface-StdInThread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public char[] getBuffer() {
            LinkedList<char[]> linkedList = this.queue;
            synchronized (linkedList) {
                return this.queue.isEmpty() ? null : this.queue.removeFirst();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            InputStreamReader stdin = new InputStreamReader(System.in);
            char[] buffer = new char[32];
            while (true) {
                try {
                    int nbytes;
                    while ((nbytes = stdin.read(buffer)) <= 0) {
                    }
                    char[] add = new char[nbytes];
                    System.arraycopy(buffer, 0, add, 0, nbytes);
                    LinkedList<char[]> linkedList = this.queue;
                    synchronized (linkedList) {
                        this.queue.addLast(add);
                        continue;
                    }
                }
                catch (IOException iOException) {
                    continue;
                }
                break;
            }
        }
    }
}

