/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.instance;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.instance.InstanceComponent;
import com.cburch.logisim.instance.InstanceData;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import java.awt.Font;
import java.util.List;

public final class Instance
implements Location.At {
    private final InstanceComponent comp;
    public static final int AVOID_TOP = 1;
    public static final int AVOID_RIGHT = 2;
    public static final int AVOID_BOTTOM = 4;
    public static final int AVOID_LEFT = 8;
    public static final int AVOID_SIDES = 10;
    public static final int AVOID_CENTER = 16;

    public static Instance getInstanceFor(Component comp) {
        Instance instance;
        if (comp instanceof InstanceComponent) {
            InstanceComponent instComp = (InstanceComponent)comp;
            instance = instComp.getInstance();
        } else {
            instance = null;
        }
        return instance;
    }

    public static InstanceComponent getComponentFor(Instance instance) {
        return instance.comp;
    }

    static Instance makeFor(InstanceComponent comp) {
        return new Instance(comp);
    }

    private Instance(InstanceComponent comp) {
        this.comp = comp;
    }

    public void addAttributeListener() {
        this.comp.addAttributeListener(this);
    }

    public void fireInvalidated() {
        this.comp.fireInvalidated();
    }

    public AttributeSet getAttributeSet() {
        return this.comp.getAttributeSet();
    }

    public <E> E getAttributeValue(Attribute<E> attr) {
        return this.comp.getAttributeSet().getValue(attr);
    }

    public Bounds getBounds() {
        return this.comp.getBounds();
    }

    public InstanceComponent getComponent() {
        return this.comp;
    }

    public InstanceData getData(CircuitState state) {
        return (InstanceData)state.getData(this.comp);
    }

    public InstanceFactory getFactory() {
        return (InstanceFactory)this.comp.getFactory();
    }

    @Override
    public Location getLocation() {
        return this.comp.getLocation();
    }

    public Location getPortLocation(int index) {
        return this.comp.getEnd(index).getLocation();
    }

    public List<Port> getPorts() {
        return this.comp.getPorts();
    }

    public void recomputeBounds() {
        this.comp.recomputeBounds();
    }

    public void setAttributeReadOnly(Attribute<?> attr, boolean value) {
        this.comp.getAttributeSet().setReadOnly(attr, value);
    }

    public void setData(CircuitState state, InstanceData data) {
        state.setData(this.comp, data);
    }

    public void setPorts(Port[] ports) {
        this.comp.setPorts(ports);
    }

    public void setTextField(Attribute<String> labelAttr, Attribute<Font> fontAttr, int x, int y, int hAlign, int vAlign) {
        this.comp.setTextField(labelAttr, fontAttr, x, y, hAlign, vAlign);
    }

    public void computeLabelTextField(int avoid) {
        Object labelLoc = this.getAttributeValue(StdAttr.LABEL_LOC);
        this.computeLabelTextField(avoid, labelLoc);
    }

    public void computeLabelTextField(int avoid, Object labelLoc) {
        if (avoid != 0) {
            Direction facing = this.getAttributeValue(StdAttr.FACING);
            if (facing == Direction.NORTH) {
                avoid = avoid & 0x10 | avoid << 1 & 0xF | (avoid & 0xF) >> 3;
            } else if (facing == Direction.EAST) {
                avoid = avoid & 0x10 | avoid << 2 & 0xF | (avoid & 0xF) >> 2;
            } else if (facing == Direction.SOUTH) {
                avoid = avoid & 0x10 | avoid << 3 & 0xF | (avoid & 0xF) >> 1;
            }
        }
        Bounds bds = this.getBounds();
        int x = bds.getX() + bds.getWidth() / 2;
        int y = bds.getY() + bds.getHeight() / 2;
        int hAlign = 0;
        int vAlign = 0;
        if (labelLoc == StdAttr.LABEL_CENTER) {
            int offset = 0;
            if ((avoid & 0x10) != 0) {
                offset = 3;
            }
            x = bds.getX() + (bds.getWidth() - offset) / 2;
            y = bds.getY() + (bds.getHeight() - offset) / 2;
        } else if (labelLoc == Direction.NORTH) {
            y = bds.getY() - 2;
            vAlign = 2;
            if ((avoid & 1) != 0) {
                x += 2;
                hAlign = -1;
            }
        } else if (labelLoc == Direction.SOUTH) {
            y = bds.getY() + bds.getHeight() + 2;
            vAlign = -1;
            if ((avoid & 4) != 0) {
                x += 2;
                hAlign = -1;
            }
        } else if (labelLoc == Direction.EAST) {
            x = bds.getX() + bds.getWidth() + 2;
            hAlign = -1;
            if ((avoid & 2) != 0) {
                y -= 2;
                vAlign = 2;
            }
        } else if (labelLoc == Direction.WEST) {
            x = bds.getX() - 2;
            hAlign = 1;
            if ((avoid & 8) != 0) {
                y -= 2;
                vAlign = 2;
            }
        }
        this.setTextField(StdAttr.LABEL, StdAttr.LABEL_FONT, x, y, hAlign, vAlign);
    }
}

