/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.prefs;

import com.cburch.logisim.prefs.AbstractPrefMonitor;
import com.cburch.logisim.prefs.AppPreferences;
import java.util.Objects;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.Preferences;

class PrefMonitorString
extends AbstractPrefMonitor<String> {
    private final String dflt;
    private String value;

    private static boolean isSame(String a, String b) {
        return Objects.equals(a, b);
    }

    public PrefMonitorString(String name, String dflt) {
        super(name);
        this.dflt = dflt;
        Preferences prefs = AppPreferences.getPrefs();
        this.value = prefs.get(name, dflt);
        prefs.addPreferenceChangeListener(this);
    }

    @Override
    public String get() {
        return this.value;
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent event) {
        String newValue;
        String oldValue;
        String name;
        Preferences prefs = event.getNode();
        String prop = event.getKey();
        if (prop.equals(name = this.getIdentifier()) && !PrefMonitorString.isSame(oldValue = this.value, newValue = prefs.get(name, this.dflt))) {
            this.value = newValue;
            AppPreferences.firePropertyChange(name, oldValue, newValue);
        }
    }

    @Override
    public void set(String newValue) {
        String oldValue = this.value;
        if (!PrefMonitorString.isSame(oldValue, newValue)) {
            this.value = newValue;
            AppPreferences.getPrefs().put(this.getIdentifier(), newValue);
        }
    }
}

