/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.gui;

import com.cburch.contracts.BaseMouseListenerContract;
import com.cburch.logisim.circuit.CircuitEvent;
import com.cburch.logisim.circuit.CircuitListener;
import com.cburch.logisim.comp.ComponentEvent;
import com.cburch.logisim.comp.ComponentListener;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.soc.bus.SocBusMenuProvider;
import com.cburch.logisim.soc.data.SocBusStateInfo;
import com.cburch.logisim.soc.data.SocBusTransaction;
import com.cburch.logisim.tools.CircuitStateHolder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public class TraceWindowTableModel
extends AbstractTableModel
implements BaseMouseListenerContract,
SocBusStateInfo.SocBusStateListener,
ComponentListener,
CircuitListener {
    private static final long serialVersionUID = 1L;
    private final SocBusMenuProvider.InstanceInformation parent;
    private final Map<SocBusStateInfo.SocBusState, CircuitStateHolder.HierarchyInfo> myTraceList;
    private JTable table;
    private int boxWidth = 238;

    public TraceWindowTableModel(Map<SocBusStateInfo.SocBusState, CircuitStateHolder.HierarchyInfo> traceList, SocBusMenuProvider.InstanceInformation p) {
        this.myTraceList = traceList;
        this.parent = p;
        this.rebuild();
    }

    public String getColumnHeader(int column) {
        SocBusStateInfo.SocBusState info = this.getInfoAtColumn(column);
        if (info == null || this.myTraceList.get(info) == null) {
            return "BUG";
        }
        this.myTraceList.get(info).registerCircuitListener(this);
        this.myTraceList.get(info).registerComponentListener(this);
        return this.myTraceList.get(info).getName();
    }

    public void setColMod(JTable v) {
        this.table = v;
        this.table.addMouseListener(this);
    }

    public void rebuild() {
        for (SocBusStateInfo.SocBusState i : this.myTraceList.keySet()) {
            if (this.myTraceList.get(i) != null) {
                i.registerListener(this);
                continue;
            }
            i.deregisterListener(this);
        }
        this.fireTableStructureChanged();
        if (this.table != null) {
            for (int i = 0; i < this.getColumnCount(); ++i) {
                this.table.getColumnModel().getColumn(i).setPreferredWidth(AppPreferences.getScaled(this.boxWidth));
            }
            int height = 75;
            this.table.setRowHeight(AppPreferences.getScaled(75));
            this.table.getTableHeader().setPreferredSize(new Dimension(AppPreferences.getScaled(this.boxWidth), AppPreferences.getScaled(20)));
        }
    }

    public int getBoxWidth() {
        return this.boxWidth;
    }

    public void setBoxWidth(int value) {
        this.boxWidth = value;
        this.rebuild();
    }

    @Override
    public int getRowCount() {
        int max = 1;
        for (SocBusStateInfo.SocBusState i : this.myTraceList.keySet()) {
            if (this.myTraceList.get(i) == null || i.getNrOfEntires() <= max) continue;
            max = i.getNrOfEntires();
        }
        return max;
    }

    @Override
    public int getColumnCount() {
        int cols = 0;
        for (SocBusStateInfo.SocBusState i : this.myTraceList.keySet()) {
            if (this.myTraceList.get(i) == null) continue;
            ++cols;
        }
        return cols;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        SocBusStateInfo.SocBusState info = this.getInfoAtColumn(columnIndex);
        if (info == null) {
            return null;
        }
        SocBusStateInfo.SocBusState.SocBusStateTrace stateInfo = info.getEntry(rowIndex, this);
        if (stateInfo != null && stateInfo.getTransaction() != null) {
            SocBusTransaction trans = stateInfo.getTransaction();
            Object master = trans.getTransactionInitiator();
            if (master instanceof com.cburch.logisim.comp.Component) {
                com.cburch.logisim.comp.Component masterComp = (com.cburch.logisim.comp.Component)master;
                masterComp.addComponentListener(this);
            }
            if (trans.getTransactionResponder() != null) {
                trans.getTransactionResponder().addComponentListener(this);
            }
        }
        return stateInfo;
    }

    private SocBusStateInfo.SocBusState getInfoAtColumn(int column) {
        ArrayList<SocBusStateInfo.SocBusState> sortedList = new ArrayList<SocBusStateInfo.SocBusState>();
        for (SocBusStateInfo.SocBusState info : this.myTraceList.keySet()) {
            if (this.myTraceList.get(info) == null) continue;
            if (sortedList.isEmpty()) {
                sortedList.add(info);
                continue;
            }
            boolean inserted = false;
            for (int j = 0; j < sortedList.size(); ++j) {
                String sortedKey = this.myTraceList.get(sortedList.get(j)).getName();
                if (this.myTraceList.get(info).getName().compareTo(sortedKey) > 0) continue;
                sortedList.add(j, info);
                inserted = true;
                break;
            }
            if (inserted) continue;
            sortedList.add(info);
        }
        return column < 0 || column >= sortedList.size() ? null : (SocBusStateInfo.SocBusState)sortedList.get(column);
    }

    @Override
    public void fireCanged(SocBusStateInfo.SocBusState item) {
        if (this.myTraceList.containsKey(item) && this.myTraceList.get(item) != null) {
            this.fireTableDataChanged();
        }
    }

    public TableCellRenderer getCellRenderer() {
        return new CellRenderer();
    }

    public TableCellRenderer getHeaderRenderer() {
        return new HeaderRenderer();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() > 1) {
            Point point = e.getPoint();
            int index = this.table.getColumnModel().getColumnIndexAtX(point.x);
            int realIndex = this.table.getColumnModel().getColumn(index).getModelIndex();
            SocBusStateInfo.SocBusState info = this.getInfoAtColumn(realIndex);
            if (info != null && this.myTraceList.get(info) != null) {
                this.myTraceList.get(info).deregisterCircuitListener(this);
                this.myTraceList.get(info).deregisterComponentListener(this);
                this.myTraceList.put(info, null);
                this.rebuild();
                if (this.getColumnCount() == 0) {
                    this.parent.destroyTraceWindow();
                }
            }
        }
    }

    @Override
    public void labelChanged(ComponentEvent e) {
        this.rebuild();
    }

    @Override
    public void circuitChanged(CircuitEvent event) {
        if (event.getAction() == 0) {
            this.rebuild();
        }
    }

    private static class CellRenderer
    extends JPanel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        private CellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return (JPanel)value;
        }
    }

    private class HeaderRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        private HeaderRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = new JLabel(TraceWindowTableModel.this.getColumnHeader(column));
            label.setBorder(BorderFactory.createEtchedBorder());
            return label;
        }
    }
}

