/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.nios2;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.soc.Strings;
import com.cburch.logisim.soc.data.SocSupport;
import com.cburch.logisim.soc.nios2.Nios2State;
import com.cburch.logisim.soc.nios2.Nios2Support;
import com.cburch.logisim.soc.util.AssemblerAsmInstruction;
import com.cburch.logisim.soc.util.AssemblerExecutionInterface;
import com.cburch.logisim.soc.util.AssemblerToken;
import java.util.ArrayList;

public class Nios2ArithmeticAndLogicalInstructions
implements AssemblerExecutionInterface {
    private static final int INSTR_AND = 0;
    private static final int INSTR_OR = 1;
    private static final int INSTR_XOR = 2;
    private static final int INSTR_NOR = 3;
    private static final int INSTR_ADD = 4;
    private static final int INSTR_SUB = 5;
    private static final int INSTR_MUL = 6;
    private static final int INSTR_DIV = 7;
    private static final int INSTR_DIVU = 8;
    private static final int INSTR_MULXSS = 9;
    private static final int INSTR_MULXUU = 10;
    private static final int INSTR_MULXSU = 11;
    private static final int INSTR_ANDI = 12;
    private static final int INSTR_ORI = 13;
    private static final int INSTR_XORI = 14;
    private static final int INSTR_ANDHI = 15;
    private static final int INSTR_ORHI = 16;
    private static final int INSTR_XORHI = 17;
    private static final int INSTR_ADDI = 18;
    private static final int INSTR_SUBI = 19;
    private static final int INSTR_MULI = 20;
    private static final int INSTR_NOP = 21;
    private static final int INSTR_MOV = 22;
    private static final int INSTR_MOVHI = 23;
    private static final int INSTR_MOVI = 24;
    private static final int INSTR_MOVUI = 25;
    private static final int INSTR_MOVIA = 26;
    private static final int SIGN_EXTEND = 256;
    private static final int PSEUDO_INSTR = 512;
    private static final int DOUBLE_SIZE = 1024;
    private static final String[] AsmOpcodes = new String[]{"AND", "OR", "XOR", "NOR", "ADD", "SUB", "MUL", "DIV", "DIVU", "MULXSS", "MULXUU", "MULXSU", "ANDI", "ORI", "XORI", "ANDHI", "ORHI", "XORHI", "ADDI", "SUBI", "MULI", "NOP", "MOV", "MOVHI", "MOVI", "MOVUI", "MOVIA"};
    private static final Integer[] AsmOpcs = new Integer[]{58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 12, 20, 28, 44, 52, 60, 4, 4, 36, 512, 512, 512, 512, 512, 512};
    private static final Integer[] AsmOpxs = new Integer[]{14, 22, 30, 6, 49, 57, 39, 24, 36, 31, 7, 23, -1, -1, -1, -1, -1, -1, 256, 256, 256, -1, -1, -1, 256, -1, 1024};
    private final ArrayList<String> Opcodes = new ArrayList();
    private final ArrayList<Integer> OpcCodes = new ArrayList();
    private final ArrayList<Integer> OpxCodes = new ArrayList();
    private int instruction;
    private boolean valid;
    private int operation;
    private int destination;
    private int immediate;
    private int sourceA;
    private int sourceB;

    public Nios2ArithmeticAndLogicalInstructions() {
        for (int i = 0; i < AsmOpcodes.length; ++i) {
            this.Opcodes.add(AsmOpcodes[i].toLowerCase());
            this.OpcCodes.add(AsmOpcs[i]);
            this.OpxCodes.add(AsmOpxs[i]);
        }
    }

    @Override
    public boolean execute(Object processorState, CircuitState circuitState) {
        if (!this.valid) {
            return false;
        }
        Nios2State.ProcessorState state = (Nios2State.ProcessorState)processorState;
        int valueB = state.getRegisterValue(this.sourceB);
        int valueA = state.getRegisterValue(this.sourceA);
        int result = 0;
        int imm = this.immediate << 16;
        if (this.operation == 19) {
            imm = -imm;
            this.operation = 18;
        }
        switch (this.operation) {
            case 26: {
                result = this.immediate;
                break;
            }
            case 15: {
                result = valueA & imm;
                break;
            }
            case 12: {
                valueB = this.immediate;
            }
            case 0: {
                result = valueA & valueB;
                break;
            }
            case 16: 
            case 23: {
                result = valueA | imm;
                break;
            }
            case 13: 
            case 25: {
                valueB = this.immediate;
            }
            case 1: {
                result = valueA | valueB;
                break;
            }
            case 3: {
                result = valueA | valueB;
                result ^= 0xFFFFFFFF;
                break;
            }
            case 17: {
                result = valueA ^ imm;
                break;
            }
            case 14: {
                valueB = this.immediate;
            }
            case 2: {
                result = valueA ^ valueB;
                break;
            }
            case 18: 
            case 24: {
                valueB = imm >> 16;
            }
            case 4: 
            case 21: 
            case 22: {
                result = valueA + valueB;
                break;
            }
            case 5: {
                result = valueA - valueB;
                break;
            }
            case 20: {
                valueB = imm >> 16;
            }
            case 6: 
            case 9: {
                long oppA = valueA;
                long oppB = valueB;
                long res = oppA * oppB;
                result = SocSupport.convUnsignedLong(this.operation == 6 ? res : res >> 32);
                break;
            }
            case 7: {
                result = valueA / valueB;
                break;
            }
            case 8: {
                long opA = SocSupport.convUnsignedInt(valueA);
                long opB = SocSupport.convUnsignedInt(valueB);
                long div = opA / opB;
                result = SocSupport.convUnsignedLong(div);
                break;
            }
            case 10: {
                long oppA = SocSupport.convUnsignedInt(valueA);
                long oppB = SocSupport.convUnsignedInt(valueB);
                long res = oppA * oppB;
                result = SocSupport.convUnsignedLong(res >> 32);
                break;
            }
            case 11: {
                long oppA = valueA;
                long oppB = SocSupport.convUnsignedInt(valueB);
                long res = oppA * oppB;
                result = SocSupport.convUnsignedLong(res >> 32);
                break;
            }
            default: {
                return false;
            }
        }
        state.writeRegister(this.destination, result);
        return true;
    }

    @Override
    public String getAsmInstruction() {
        if (!this.valid) {
            return null;
        }
        StringBuilder s = new StringBuilder();
        s.append(this.Opcodes.get(this.operation));
        while (s.length() < 10) {
            s.append(" ");
        }
        if (this.OpcCodes.get(this.operation) == 512) {
            if (this.operation != 21) {
                if (this.operation == 22) {
                    s.append(Nios2State.registerABINames[this.destination]).append(",").append(Nios2State.registerABINames[this.sourceA]);
                } else {
                    int imm = this.immediate;
                    if (this.OpxCodes.get(this.operation) == 256) {
                        imm <<= 16;
                        imm >>= 16;
                    }
                    s.append(Nios2State.registerABINames[this.destination]).append(",").append(imm);
                }
            }
        } else if (this.OpcCodes.get(this.operation) == 58) {
            s.append(Nios2State.registerABINames[this.destination]).append(",").append(Nios2State.registerABINames[this.sourceA]);
            s.append(",").append(Nios2State.registerABINames[this.sourceB]);
        } else {
            int imm = this.immediate;
            if (this.OpxCodes.get(this.operation) == 256) {
                imm = this.immediate << 16;
                imm >>= 16;
            }
            s.append(Nios2State.registerABINames[this.destination]).append(",").append(Nios2State.registerABINames[this.sourceA]).append(",").append(imm);
        }
        return s.toString();
    }

    @Override
    public int getBinInstruction() {
        return this.instruction;
    }

    @Override
    public boolean setAsmInstruction(AssemblerAsmInstruction instr) {
        if (!this.Opcodes.contains(instr.getOpcode().toLowerCase())) {
            return false;
        }
        this.valid = true;
        this.operation = this.Opcodes.indexOf(instr.getOpcode().toLowerCase());
        if (this.operation == 21) {
            if (instr.getNrOfParameters() != 0) {
                this.valid = false;
                instr.setError(instr.getInstruction(), Strings.S.getter("AssemblerExpectedNoArguments"));
                return true;
            }
            this.immediate = 0;
            this.destination = 0;
            this.sourceB = 0;
            this.sourceA = 0;
            this.instruction = Nios2Support.getRTypeInstructionCode(0, 0, 0, this.OpxCodes.get(4));
            instr.setInstructionByteCode(this.instruction, 4);
            return true;
        }
        if (this.operation == 26) {
            if (instr.getNrOfParameters() != 2) {
                this.valid = false;
                instr.setError(instr.getInstruction(), Strings.S.getter("AssemblerExpectedTwoArguments"));
                return true;
            }
            this.valid &= Nios2Support.isCorrectRegister(instr, 0);
            this.destination = Nios2Support.getRegisterIndex(instr, 0);
            AssemblerToken[] param2 = instr.getParameter(1);
            if (param2.length != 1 || !param2[0].isNumber()) {
                this.valid = false;
                instr.setError(param2[0], Strings.S.getter("AssemblerExpextedImmediateOrLabel"));
            }
            this.immediate = param2[0].getNumberValue();
            this.sourceB = 0;
            this.sourceA = 0;
            this.instruction = -1;
            if (this.valid) {
                int[] instrs = new int[2];
                int imm = this.immediate >> 16 & 0xFFFF;
                imm += this.immediate >> 15 & 1;
                instrs[0] = Nios2Support.getITypeInstructionCode(0, this.destination, imm &= 0xFFFF, this.OpcCodes.get(16));
                imm = this.immediate & 0xFFFF;
                instrs[1] = Nios2Support.getITypeInstructionCode(this.destination, this.destination, imm, this.OpcCodes.get(18));
                instr.setInstructionByteCode(instrs, 4);
            }
            return true;
        }
        if (this.operation == 22) {
            if (instr.getNrOfParameters() != 2) {
                this.valid = false;
                instr.setError(instr.getInstruction(), Strings.S.getter("AssemblerExpectedTwoArguments"));
                return true;
            }
            this.valid &= Nios2Support.isCorrectRegister(instr, 0);
            this.valid &= Nios2Support.isCorrectRegister(instr, 1);
            this.destination = Nios2Support.getRegisterIndex(instr, 0);
            this.sourceA = this.sourceB = Nios2Support.getRegisterIndex(instr, 1);
            if (this.valid) {
                this.instruction = Nios2Support.getRTypeInstructionCode(this.sourceA, 0, this.destination, this.OpxCodes.get(4));
                instr.setInstructionByteCode(this.instruction, 4);
            }
            return true;
        }
        if (this.OpcCodes.get(this.operation) == 512) {
            if (instr.getNrOfParameters() != 2) {
                this.valid = false;
                instr.setError(instr.getInstruction(), Strings.S.getter("AssemblerExpectedTwoArguments"));
                return true;
            }
            this.valid &= Nios2Support.isCorrectRegister(instr, 0);
            this.destination = Nios2Support.getRegisterIndex(instr, 0);
            AssemblerToken[] param2 = instr.getParameter(1);
            if (param2.length != 1 || !param2[0].isNumber()) {
                this.valid = false;
                instr.setError(param2[0], Strings.S.getter("AssemblerExpectedImmediateValue"));
            }
            this.immediate = param2[0].getNumberValue();
            this.sourceB = 0;
            this.sourceA = 0;
            switch (this.operation) {
                case 23: 
                case 25: {
                    if (this.immediate >= 65536 || this.immediate < 0) {
                        this.valid = false;
                        instr.setError(param2[0], Strings.S.getter("AssemblerImmediateOutOfRange"));
                    }
                    this.operation = this.operation == 23 ? 16 : 13;
                    break;
                }
                case 24: {
                    if (this.immediate >= 32768 || this.immediate < Short.MIN_VALUE) {
                        this.valid = false;
                        instr.setError(param2[0], Strings.S.getter("AssemblerImmediateOutOfRange"));
                    }
                    this.operation = 18;
                    break;
                }
                default: {
                    this.valid = false;
                    return false;
                }
            }
            if (this.valid) {
                this.instruction = Nios2Support.getITypeInstructionCode(this.sourceA, this.destination, this.immediate, this.OpcCodes.get(this.operation));
                instr.setInstructionByteCode(this.instruction, 4);
            }
            return true;
        }
        if (instr.getNrOfParameters() != 3) {
            this.valid = false;
            instr.setError(instr.getInstruction(), Strings.S.getter("AssemblerExpectedThreeArguments"));
            return true;
        }
        this.valid &= Nios2Support.isCorrectRegister(instr, 0);
        this.valid &= Nios2Support.isCorrectRegister(instr, 1);
        this.destination = Nios2Support.getRegisterIndex(instr, 0);
        this.sourceA = Nios2Support.getRegisterIndex(instr, 1);
        if (this.operation >= 12) {
            this.sourceB = 0;
            AssemblerToken[] param3 = instr.getParameter(2);
            if (param3.length != 1 || !param3[0].isNumber()) {
                this.valid = false;
                instr.setError(param3[0], Strings.S.getter("AssemblerExpectedImmediateValue"));
            }
            this.immediate = param3[0].getNumberValue();
            if (this.OpxCodes.get(this.operation) == 256) {
                if (this.immediate >= 32768 || this.immediate < Short.MIN_VALUE) {
                    this.valid = false;
                    instr.setError(param3[0], Strings.S.getter("AssemblerImmediateOutOfRange"));
                }
            } else if (this.immediate >= 65536 || this.immediate < 0) {
                this.valid = false;
                instr.setError(param3[0], Strings.S.getter("AssemblerImmediateOutOfRange"));
            }
        } else {
            this.immediate = 0;
            this.valid &= Nios2Support.isCorrectRegister(instr, 2);
            this.sourceB = Nios2Support.getRegisterIndex(instr, 2);
        }
        if (this.valid) {
            this.instruction = this.operation >= 12 ? Nios2Support.getITypeInstructionCode(this.sourceA, this.destination, this.immediate, this.OpcCodes.get(this.operation)) : Nios2Support.getRTypeInstructionCode(this.sourceA, this.sourceB, this.destination, this.OpxCodes.get(this.operation));
            instr.setInstructionByteCode(this.instruction, 4);
        }
        return true;
    }

    @Override
    public boolean setBinInstruction(int instr) {
        this.instruction = instr;
        this.valid = false;
        int opcode = Nios2Support.getOpcode(instr);
        if (opcode == 58) {
            if (Nios2Support.getOPXImm(instr, 1) != 0) {
                return false;
            }
            int rcode = Nios2Support.getOPXCode(instr, 1);
            if (this.OpxCodes.contains(rcode)) {
                this.operation = this.OpxCodes.indexOf(rcode);
                this.destination = Nios2Support.getRegCIndex(instr, 1);
                this.sourceA = Nios2Support.getRegAIndex(instr, 1);
                this.sourceB = Nios2Support.getRegBIndex(instr, 1);
                this.immediate = -1;
                this.valid = true;
            }
        } else if (this.OpcCodes.contains(opcode)) {
            this.operation = this.OpcCodes.indexOf(opcode);
            this.destination = Nios2Support.getRegBIndex(instr, 0);
            this.sourceA = this.sourceB = Nios2Support.getRegAIndex(instr, 0);
            this.immediate = Nios2Support.getImmediate(instr, 0);
            this.valid = true;
        }
        if (this.valid) {
            this.convertToPseudo();
        }
        return this.valid;
    }

    private void convertToPseudo() {
        switch (this.operation) {
            case 4: {
                if (this.sourceA == 0 && this.sourceB == 0 && this.destination == 0) {
                    this.operation = 21;
                    break;
                }
                if (this.sourceB != 0) break;
                this.operation = 22;
                break;
            }
            case 16: {
                if (this.sourceA != 0) break;
                this.operation = 23;
                break;
            }
            case 18: {
                if (this.sourceA != 0) break;
                this.operation = 24;
                break;
            }
            case 13: {
                if (this.sourceA != 0) break;
                this.operation = 25;
            }
        }
    }

    @Override
    public boolean performedJump() {
        return false;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public String getErrorMessage() {
        return null;
    }

    @Override
    public ArrayList<String> getInstructions() {
        return this.Opcodes;
    }

    @Override
    public int getInstructionSizeInBytes(String instruction) {
        if (this.Opcodes.contains(instruction.toLowerCase())) {
            int idx = this.Opcodes.indexOf(instruction.toLowerCase());
            return this.OpxCodes.get(idx) == 1024 ? 8 : 4;
        }
        return -1;
    }
}

