/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.nios2;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.soc.Strings;
import com.cburch.logisim.soc.data.SocSupport;
import com.cburch.logisim.soc.nios2.Nios2State;
import com.cburch.logisim.soc.nios2.Nios2Support;
import com.cburch.logisim.soc.util.AssemblerAsmInstruction;
import com.cburch.logisim.soc.util.AssemblerExecutionInterface;
import com.cburch.logisim.soc.util.AssemblerToken;
import java.util.ArrayList;

public class Nios2ComparisonInstructions
implements AssemblerExecutionInterface {
    private static final int INSTR_CMPEQ = 0;
    private static final int INSTR_CMPNE = 1;
    private static final int INSTR_CMPGE = 2;
    private static final int INSTR_CMPGEU = 3;
    private static final int INSTR_CMPLT = 4;
    private static final int INSTR_CMPLTU = 5;
    private static final int INSTR_CMPGT = 6;
    private static final int INSTR_CMPGTU = 7;
    private static final int INSTR_CMPLE = 8;
    private static final int INSTR_CMPLEU = 9;
    private static final int INSTR_CMPEQI = 10;
    private static final int INSTR_CMPNEI = 11;
    private static final int INSTR_CMPGEI = 12;
    private static final int INSTR_CMPGEUI = 13;
    private static final int INSTR_CMPLTI = 14;
    private static final int INSTR_CMPLTUI = 15;
    private static final int INSTR_CMPGTI = 16;
    private static final int INSTR_CMPGTUI = 17;
    private static final int INSTR_CMPLEI = 18;
    private static final int INSTR_CMPLEUI = 19;
    private static final int SIGN_EXTEND = 256;
    private static final int PSEUDO_INSTR = 512;
    private static final String[] AsmOpcodes = new String[]{"CMPEQ", "CMPNE", "CMPGE", "CMPGEU", "CMPLT", "CMPLTU", "CMPGT", "CMPGTU", "CMPLE", "CMPLEU", "CMPEQI", "CMPNEI", "CMPGEI", "CMPGEUI", "CMPLTI", "CMPLTUI", "CMPGTI", "CMPGTUI", "CMPLEI", "CMPLEUI"};
    private static final Integer[] AsmOpcs = new Integer[]{58, 58, 58, 58, 58, 58, 512, 512, 512, 512, 32, 24, 8, 40, 16, 48, 512, 512, 512, 512};
    private static final Integer[] AsmOpxs = new Integer[]{32, 24, 8, 40, 16, 48, 256, -1, 256, -1, 256, 256, 256, -1, 256, -1, 256, -1, 256, -1};
    private final ArrayList<String> Opcodes = new ArrayList();
    private final ArrayList<Integer> OpcCodes = new ArrayList();
    private final ArrayList<Integer> OpxCodes = new ArrayList();
    private int instruction;
    private boolean valid;
    private int operation;
    private int destination;
    private int immediate;
    private int sourceA;
    private int sourceB;

    public Nios2ComparisonInstructions() {
        for (int i = 0; i < AsmOpcodes.length; ++i) {
            this.Opcodes.add(AsmOpcodes[i].toLowerCase());
            this.OpcCodes.add(AsmOpcs[i]);
            this.OpxCodes.add(AsmOpxs[i]);
        }
    }

    @Override
    public boolean execute(Object processorState, CircuitState circuitState) {
        if (!this.valid) {
            return false;
        }
        Nios2State.ProcessorState cpuState = (Nios2State.ProcessorState)processorState;
        int valueA = cpuState.getRegisterValue(this.sourceA);
        int valueB = cpuState.getRegisterValue(this.sourceB);
        int imm = this.OpxCodes.get(this.operation) != 256 ? this.immediate & 0xFFFF : this.immediate << 16 >> 16;
        int result = 0;
        switch (this.operation) {
            case 10: {
                valueB = imm;
            }
            case 0: {
                result = valueA == valueB ? 1 : 0;
                break;
            }
            case 11: {
                valueB = imm;
            }
            case 1: {
                result = valueA != valueB ? 1 : 0;
                break;
            }
            case 12: {
                valueB = imm;
            }
            case 2: {
                result = valueA >= valueB ? 1 : 0;
                break;
            }
            case 13: {
                valueB = imm;
            }
            case 3: {
                long opA = SocSupport.convUnsignedInt(valueA);
                long opB = SocSupport.convUnsignedInt(valueB);
                result = opA >= opB ? 1 : 0;
                break;
            }
            case 14: {
                valueB = imm;
            }
            case 4: {
                result = valueA < valueB ? 1 : 0;
                break;
            }
            case 15: {
                valueB = imm;
            }
            case 5: {
                long opA = SocSupport.convUnsignedInt(valueA);
                long opB = SocSupport.convUnsignedInt(valueB);
                result = opA < opB ? 1 : 0;
                break;
            }
            default: {
                return false;
            }
        }
        cpuState.writeRegister(this.destination, result);
        return true;
    }

    @Override
    public String getAsmInstruction() {
        if (!this.valid) {
            return null;
        }
        StringBuilder s = new StringBuilder();
        s.append(this.Opcodes.get(this.operation));
        while (s.length() < 10) {
            s.append(" ");
        }
        s.append(Nios2State.registerABINames[this.destination]).append(",");
        s.append(Nios2State.registerABINames[this.sourceA]).append(",");
        if (this.operation >= 10) {
            int imm = this.OpxCodes.get(this.operation) != 256 ? this.immediate & 0xFFFF : this.immediate << 16 >> 16;
            s.append(imm);
        } else {
            s.append(Nios2State.registerABINames[this.sourceB]);
        }
        return s.toString();
    }

    @Override
    public int getBinInstruction() {
        return this.instruction;
    }

    @Override
    public boolean setAsmInstruction(AssemblerAsmInstruction instr) {
        this.valid = false;
        if (!this.Opcodes.contains(instr.getOpcode().toLowerCase())) {
            return false;
        }
        this.valid = true;
        this.operation = this.Opcodes.indexOf(instr.getOpcode().toLowerCase());
        if (instr.getNrOfParameters() != 3) {
            this.valid = false;
            instr.setError(instr.getInstruction(), Strings.S.getter("AssemblerExpectedThreeArguments"));
            return true;
        }
        this.valid &= Nios2Support.isCorrectRegister(instr, 0);
        this.valid &= Nios2Support.isCorrectRegister(instr, 1);
        this.destination = Nios2Support.getRegisterIndex(instr, 0);
        this.sourceA = Nios2Support.getRegisterIndex(instr, 1);
        if (this.operation >= 10) {
            AssemblerToken[] param3 = instr.getParameter(2);
            if (param3.length != 1 || !param3[0].isNumber()) {
                this.valid = false;
                instr.setError(param3[0], Strings.S.getter("AssemblerExpectedImmediateValue"));
            }
            this.immediate = param3[0].getNumberValue();
            this.sourceB = 0;
        } else {
            this.valid &= Nios2Support.isCorrectRegister(instr, 2);
            this.sourceB = Nios2Support.getRegisterIndex(instr, 2);
            this.immediate = 0;
        }
        if (!this.valid) {
            return true;
        }
        if (this.OpcCodes.get(this.operation) == 512) {
            switch (this.operation) {
                case 6: {
                    this.operation = 4;
                    int tmp = this.sourceA;
                    this.sourceA = this.sourceB;
                    this.sourceB = tmp;
                    break;
                }
                case 16: {
                    this.operation = 12;
                    ++this.immediate;
                    break;
                }
                case 7: {
                    this.operation = 5;
                    int tmp = this.sourceA;
                    this.sourceA = this.sourceB;
                    this.sourceB = tmp;
                    break;
                }
                case 17: {
                    this.operation = 13;
                    ++this.immediate;
                    break;
                }
                case 8: {
                    this.operation = 2;
                    int tmp = this.sourceA;
                    this.sourceA = this.sourceB;
                    this.sourceB = tmp;
                    break;
                }
                case 18: {
                    this.operation = 14;
                    ++this.immediate;
                    break;
                }
                case 9: {
                    this.operation = 3;
                    int tmp = this.sourceA;
                    this.sourceA = this.sourceB;
                    this.sourceB = tmp;
                    break;
                }
                case 19: {
                    this.operation = 15;
                    ++this.immediate;
                    break;
                }
                default: {
                    this.valid = false;
                    return false;
                }
            }
        }
        if (this.OpxCodes.get(this.operation) == 256) {
            if (this.immediate >= 32768 || this.immediate < Short.MIN_VALUE) {
                this.valid = false;
                instr.setError(instr.getParameter(2)[0], Strings.S.getter("AssemblerImmediateOutOfRange"));
            }
        } else if (this.immediate >= 65536 || this.immediate < 0) {
            this.valid = false;
            instr.setError(instr.getParameter(2)[0], Strings.S.getter("AssemblerImmediateOutOfRange"));
        }
        if (this.valid) {
            this.instruction = this.operation >= 10 ? Nios2Support.getITypeInstructionCode(this.sourceA, this.destination, this.immediate, this.OpcCodes.get(this.operation)) : Nios2Support.getRTypeInstructionCode(this.sourceA, this.sourceB, this.destination, this.OpxCodes.get(this.operation));
            instr.setInstructionByteCode(this.instruction, 4);
        }
        return true;
    }

    @Override
    public boolean setBinInstruction(int instr) {
        this.instruction = instr;
        this.valid = false;
        int opcode = Nios2Support.getOpcode(instr);
        if (opcode == 58) {
            if (Nios2Support.getOPXImm(instr, 1) != 0) {
                return false;
            }
            int opxCode = Nios2Support.getOPXCode(instr, 1);
            if (!this.OpxCodes.contains(opxCode)) {
                return false;
            }
            this.valid = true;
            this.operation = this.OpxCodes.indexOf(opxCode);
            this.destination = Nios2Support.getRegCIndex(instr, 1);
            this.sourceA = Nios2Support.getRegAIndex(instr, 1);
            this.sourceB = Nios2Support.getRegBIndex(instr, 1);
            this.immediate = 0;
        } else {
            if (!this.OpcCodes.contains(opcode)) {
                return false;
            }
            this.valid = true;
            this.operation = this.OpcCodes.indexOf(opcode);
            this.destination = Nios2Support.getRegBIndex(instr, 0);
            this.sourceA = this.sourceB = Nios2Support.getRegAIndex(instr, 0);
            this.immediate = Nios2Support.getImmediate(instr, 0);
        }
        return this.valid;
    }

    @Override
    public boolean performedJump() {
        return false;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public String getErrorMessage() {
        return null;
    }

    @Override
    public ArrayList<String> getInstructions() {
        return this.Opcodes;
    }

    @Override
    public int getInstructionSizeInBytes(String instruction) {
        if (this.Opcodes.contains(instruction.toLowerCase())) {
            return 4;
        }
        return -1;
    }
}

