/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.nios2;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.soc.Strings;
import com.cburch.logisim.soc.data.SocSupport;
import com.cburch.logisim.soc.nios2.Nios2State;
import com.cburch.logisim.soc.nios2.Nios2Support;
import com.cburch.logisim.soc.util.AssemblerAsmInstruction;
import com.cburch.logisim.soc.util.AssemblerExecutionInterface;
import com.cburch.logisim.soc.util.AssemblerToken;
import java.util.ArrayList;

public class Nios2ShiftAndRotateInstructions
implements AssemblerExecutionInterface {
    private static final int INSTR_ROL = 0;
    private static final int INSTR_ROR = 1;
    private static final int INSTR_SLL = 2;
    private static final int INSTR_SRA = 3;
    private static final int INSTR_SRL = 4;
    private static final int INSTR_ROLI = 5;
    private static final int INSTR_SLLI = 6;
    private static final int INSTR_SRAI = 7;
    private static final int INSTR_SRLI = 8;
    private static final String[] AsmOpcodes = new String[]{"ROL", "ROR", "SLL", "SRA", "SRL", "ROLI", "SLLI", "SRAI", "SRLI"};
    private static final Integer[] AsmOpxs = new Integer[]{3, 11, 19, 59, 27, 2, 18, 58, 26};
    private final ArrayList<String> Opcodes = new ArrayList();
    private final ArrayList<Integer> OpxCodes = new ArrayList();
    private int instruction;
    private boolean valid;
    private int operation;
    private int immediate;
    private int sourceA;
    private int sourceB;
    private int sourceC;

    public Nios2ShiftAndRotateInstructions() {
        for (int i = 0; i < AsmOpcodes.length; ++i) {
            this.Opcodes.add(AsmOpcodes[i].toLowerCase());
            this.OpxCodes.add(AsmOpxs[i]);
        }
    }

    @Override
    public boolean execute(Object processorState, CircuitState circuitState) {
        if (!this.valid) {
            return false;
        }
        Nios2State.ProcessorState cpuState = (Nios2State.ProcessorState)processorState;
        int imm = cpuState.getRegisterValue(this.sourceB) & 0x1F;
        int valueA = cpuState.getRegisterValue(this.sourceA);
        int result = 0;
        switch (this.operation) {
            case 5: {
                imm = this.immediate & 0x1F;
            }
            case 0: {
                long opp = SocSupport.convUnsignedInt(valueA) << imm;
                opp |= opp >> 32;
                result = SocSupport.convUnsignedLong(opp);
                break;
            }
            case 1: {
                long opp = SocSupport.convUnsignedInt(valueA) << 32 - imm;
                opp |= opp >> 32;
                result = SocSupport.convUnsignedLong(opp);
                break;
            }
            case 6: {
                imm = this.immediate & 0x1F;
            }
            case 2: {
                result = valueA << imm;
                break;
            }
            case 7: {
                imm = this.immediate & 0x1F;
            }
            case 3: {
                result = valueA >> imm;
                break;
            }
            case 8: {
                imm = this.immediate & 0x1F;
            }
            case 4: {
                long opA = SocSupport.convUnsignedInt(valueA);
                result = SocSupport.convUnsignedLong(opA >>= imm);
                break;
            }
            default: {
                return false;
            }
        }
        cpuState.writeRegister(this.sourceC, result);
        return true;
    }

    @Override
    public String getAsmInstruction() {
        if (!this.valid) {
            return null;
        }
        StringBuilder s = new StringBuilder();
        s.append(this.Opcodes.get(this.operation));
        while (s.length() < 10) {
            s.append(" ");
        }
        s.append(Nios2State.registerABINames[this.sourceC]).append(",");
        s.append(Nios2State.registerABINames[this.sourceA]).append(",");
        if (this.operation < 5) {
            s.append(Nios2State.registerABINames[this.sourceB]);
        } else {
            s.append(this.immediate);
        }
        return s.toString();
    }

    @Override
    public int getBinInstruction() {
        return this.instruction;
    }

    @Override
    public boolean setAsmInstruction(AssemblerAsmInstruction instr) {
        this.valid = false;
        if (!this.Opcodes.contains(instr.getOpcode().toLowerCase())) {
            return false;
        }
        if (instr.getNrOfParameters() != 3) {
            instr.setError(instr.getInstruction(), Strings.S.getter("AssemblerExpectedThreeArguments"));
            return false;
        }
        this.valid = true;
        this.operation = this.Opcodes.indexOf(instr.getOpcode().toLowerCase());
        this.valid &= Nios2Support.isCorrectRegister(instr, 0);
        this.sourceC = Nios2Support.getRegisterIndex(instr, 0);
        this.valid &= Nios2Support.isCorrectRegister(instr, 1);
        this.sourceA = Nios2Support.getRegisterIndex(instr, 1);
        if (this.operation >= 5) {
            this.sourceB = 0;
            AssemblerToken[] param3 = instr.getParameter(2);
            if (param3.length != 1 || !param3[0].isNumber()) {
                this.valid = false;
                instr.setError(param3[0], Strings.S.getter("AssemblerExpectedImmediateValue"));
            }
            this.immediate = param3[0].getNumberValue();
            if (this.immediate > 31 || this.immediate < 0) {
                this.valid = false;
                instr.setError(param3[0], Strings.S.getter("AssemblerImmediateOutOfRange"));
            }
        } else {
            this.immediate = 0;
            this.valid &= Nios2Support.isCorrectRegister(instr, 2);
            this.sourceB = Nios2Support.getRegisterIndex(instr, 2);
        }
        if (this.valid) {
            this.instruction = Nios2Support.getRTypeInstructionCode(this.sourceA, this.sourceB, this.sourceC, this.OpxCodes.get(this.operation), this.immediate);
            instr.setInstructionByteCode(this.instruction, 4);
        }
        return true;
    }

    @Override
    public boolean setBinInstruction(int instr) {
        this.instruction = instr;
        this.valid = false;
        if (Nios2Support.getOpcode(instr) != 58) {
            return false;
        }
        this.valid = true;
        this.sourceA = Nios2Support.getRegAIndex(instr, 1);
        this.sourceB = Nios2Support.getRegBIndex(instr, 1);
        this.sourceC = Nios2Support.getRegCIndex(instr, 1);
        this.immediate = Nios2Support.getOPXImm(instr, 1);
        int opx = Nios2Support.getOPXCode(instr, 1);
        if (!this.OpxCodes.contains(opx)) {
            this.valid = false;
        }
        this.operation = this.OpxCodes.indexOf(opx);
        if (this.operation < 5 && this.immediate != 0 || this.operation >= 5 && this.sourceB != 0) {
            this.valid = false;
        }
        return this.valid;
    }

    @Override
    public boolean performedJump() {
        return false;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public String getErrorMessage() {
        return null;
    }

    @Override
    public ArrayList<String> getInstructions() {
        return this.Opcodes;
    }

    @Override
    public int getInstructionSizeInBytes(String instruction) {
        if (this.Opcodes.contains(instruction.toLowerCase())) {
            return 4;
        }
        return -1;
    }
}

