/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.pio;

import com.cburch.logisim.data.AbstractAttributeSet;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.soc.Strings;
import com.cburch.logisim.soc.data.SocBusInfo;
import com.cburch.logisim.soc.data.SocSimulationManager;
import com.cburch.logisim.soc.memory.SocMemoryAttributes;
import com.cburch.logisim.soc.pio.PioState;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;

public class PioAttributes
extends AbstractAttributeSet {
    public static final AttributeOption PORT_BIDIR = new AttributeOption("bidir", Strings.S.getter("SocPioBidir"));
    public static final AttributeOption PORT_INPUT = new AttributeOption("inputonly", Strings.S.getter("SocPioInputOnly"));
    public static final AttributeOption PORT_OUTPUT = new AttributeOption("outputonly", Strings.S.getter("SocPioOutputOnly"));
    public static final AttributeOption PORT_INOUT = new AttributeOption("inout", Strings.S.getter("SocPioInout"));
    public static final AttributeOption CAPT_RISING = new AttributeOption("rising", Strings.S.getter("SocPioRisingEdge"));
    public static final AttributeOption CAPT_FALLING = new AttributeOption("falling", Strings.S.getter("SocPioFallingEdge"));
    public static final AttributeOption CAPT_ANY = new AttributeOption("any", Strings.S.getter("SocPioAnyEdge"));
    public static final AttributeOption IRQ_LEVEL = new AttributeOption("level", Strings.S.getter("SocPioIrqLevel"));
    public static final AttributeOption IRQ_EDGE = new AttributeOption("edge", Strings.S.getter("SocPioIrQEdge"));
    public static final Attribute<PioState> PIO_STATE = new PIOStateAttribute();
    public static final Attribute<AttributeOption> PIO_DIRECTION = Attributes.forOption("direction", Strings.S.getter("SocPioDirection"), new AttributeOption[]{PORT_BIDIR, PORT_INPUT, PORT_OUTPUT, PORT_INOUT});
    public static final Attribute<Integer> PIO_OUT_RESET = Attributes.forHexInteger("outputresetvalue", Strings.S.getter("SocPioOutputResetValue"));
    public static final Attribute<Boolean> PIO_OUT_BIT = Attributes.forBoolean("outputbitsetclear", Strings.S.getter("SocPioOutputIndividualBits"));
    public static final Attribute<Boolean> PIO_SYNC_CAPT = Attributes.forBoolean("inputssynccapt", Strings.S.getter("SocPioInputsSyncCapture"));
    public static final Attribute<AttributeOption> PIO_CAPT_TYPE = Attributes.forOption("capturetype", Strings.S.getter("SocPioCaptureEdge"), new AttributeOption[]{CAPT_RISING, CAPT_FALLING, CAPT_ANY});
    public static final Attribute<Boolean> PIO_CAPT_BIT = Attributes.forBoolean("inputscaptbit", Strings.S.getter("SocPioInputCaptureBit"));
    public static final Attribute<Boolean> PIO_GEN_IRQ = Attributes.forBoolean("genirq", Strings.S.getter("SocPioGenIRQ"));
    public static final Attribute<AttributeOption> PIO_IRQ_TYPE = Attributes.forOption("irqtype", Strings.S.getter("SicPioIrqType"), new AttributeOption[]{IRQ_LEVEL, IRQ_EDGE});
    private Font labelFont = StdAttr.DEFAULT_LABEL_FONT;
    private Boolean labelVisible = true;
    private PioState state = new PioState();
    private ArrayList<Attribute<?>> myAttributes = new ArrayList();

    public PioAttributes() {
        this.updateAttributeList();
    }

    private boolean updateAttributeList() {
        ArrayList<Attribute<Object>> newList = new ArrayList<Attribute<Object>>();
        boolean changes = false;
        newList.add(SocMemoryAttributes.START_ADDRESS);
        newList.add(StdAttr.WIDTH);
        newList.add(PIO_DIRECTION);
        if (this.state.getPortDirection() != PORT_INPUT) {
            changes |= !this.myAttributes.contains(PIO_OUT_RESET);
            newList.add(PIO_OUT_RESET);
            newList.add(PIO_OUT_BIT);
        } else {
            changes |= this.myAttributes.contains(PIO_OUT_RESET);
        }
        if (this.state.getPortDirection() != PORT_OUTPUT) {
            changes |= !this.myAttributes.contains(PIO_SYNC_CAPT);
            newList.add(PIO_SYNC_CAPT);
            if (this.state.inputIsCapturedSynchronisely().booleanValue()) {
                changes |= !this.myAttributes.contains(PIO_CAPT_TYPE);
                newList.add(PIO_CAPT_TYPE);
                newList.add(PIO_CAPT_BIT);
            } else {
                changes |= this.myAttributes.contains(PIO_CAPT_TYPE);
            }
            newList.add(PIO_GEN_IRQ);
            if (this.state.inputIsCapturedSynchronisely().booleanValue()) {
                changes |= !this.myAttributes.contains(PIO_IRQ_TYPE);
                newList.add(PIO_IRQ_TYPE);
            } else {
                changes |= this.myAttributes.contains(PIO_IRQ_TYPE);
            }
        } else {
            changes |= this.myAttributes.contains(PIO_SYNC_CAPT);
        }
        newList.add(StdAttr.LABEL);
        newList.add(StdAttr.LABEL_FONT);
        newList.add(StdAttr.LABEL_VISIBILITY);
        newList.add(SocSimulationManager.SOC_BUS_SELECT);
        newList.add(PIO_STATE);
        this.myAttributes = newList;
        return changes;
    }

    @Override
    protected void copyInto(AbstractAttributeSet dest) {
        PioAttributes d = (PioAttributes)dest;
        d.labelFont = this.labelFont;
        d.labelVisible = this.labelVisible;
        d.state = new PioState();
        this.state.copyInto(d.state);
    }

    @Override
    public List<Attribute<?>> getAttributes() {
        return this.myAttributes;
    }

    @Override
    public boolean isReadOnly(Attribute<?> attr) {
        return attr == PIO_STATE;
    }

    @Override
    public boolean isToSave(Attribute<?> attr) {
        return attr.isToSave() && attr != PIO_STATE;
    }

    @Override
    public <V> V getValue(Attribute<V> attr) {
        if (attr == SocMemoryAttributes.START_ADDRESS) {
            return (V)this.state.getStartAddress();
        }
        if (attr == StdAttr.WIDTH) {
            return (V)this.state.getNrOfIOs();
        }
        if (attr == PIO_DIRECTION) {
            return (V)this.state.getPortDirection();
        }
        if (attr == StdAttr.LABEL) {
            return (V)this.state.getLabel();
        }
        if (attr == StdAttr.LABEL_FONT) {
            return (V)this.labelFont;
        }
        if (attr == StdAttr.LABEL_VISIBILITY) {
            return (V)this.labelVisible;
        }
        if (attr == SocSimulationManager.SOC_BUS_SELECT) {
            return (V)this.state.getAttachedBus();
        }
        if (attr == PIO_OUT_RESET) {
            return (V)this.state.getOutputResetValue();
        }
        if (attr == PIO_OUT_BIT) {
            return (V)this.state.outputSupportsBitManipulations();
        }
        if (attr == PIO_SYNC_CAPT) {
            return (V)this.state.inputIsCapturedSynchronisely();
        }
        if (attr == PIO_CAPT_TYPE) {
            return (V)this.state.getInputCaptureEdge();
        }
        if (attr == PIO_CAPT_BIT) {
            return (V)this.state.inputCaptureSupportsBitClearing();
        }
        if (attr == PIO_GEN_IRQ) {
            return (V)this.state.inputGeneratesIrq();
        }
        if (attr == PIO_IRQ_TYPE) {
            return (V)this.state.getIrqType();
        }
        if (attr == PIO_STATE) {
            return (V)this.state;
        }
        return null;
    }

    @Override
    public <V> void setValue(Attribute<V> attr, V value) {
        V oldValue = this.getValue(attr);
        if (attr == SocMemoryAttributes.START_ADDRESS) {
            if (this.state.setStartAddress((Integer)value)) {
                this.fireAttributeValueChanged(attr, value, oldValue);
            }
            return;
        }
        if (attr == StdAttr.WIDTH) {
            if (this.state.setNrOfIOs((BitWidth)value)) {
                this.fireAttributeValueChanged(attr, value, oldValue);
            }
            return;
        }
        if (attr == PIO_DIRECTION) {
            if (this.state.setPortDirection((AttributeOption)value)) {
                if (this.updateAttributeList()) {
                    this.fireAttributeListChanged();
                }
                this.fireAttributeValueChanged(attr, value, oldValue);
            }
            return;
        }
        if (attr == PIO_OUT_RESET) {
            if (this.state.setOutputResetValue((Integer)value)) {
                this.fireAttributeValueChanged(attr, value, oldValue);
            }
            return;
        }
        if (attr == PIO_OUT_BIT) {
            if (this.state.setOutputBitManupulations((Boolean)value)) {
                this.fireAttributeValueChanged(attr, value, oldValue);
            }
            return;
        }
        if (attr == PIO_SYNC_CAPT) {
            if (this.state.setInputSynchronousCapture((Boolean)value)) {
                if (this.updateAttributeList()) {
                    this.fireAttributeListChanged();
                }
                this.fireAttributeValueChanged(attr, value, oldValue);
            }
            return;
        }
        if (attr == PIO_CAPT_TYPE) {
            if (this.state.setInputCaptureEdge((AttributeOption)value)) {
                this.fireAttributeValueChanged(attr, value, oldValue);
            }
            return;
        }
        if (attr == PIO_CAPT_BIT) {
            if (this.state.setInputCaptureBitClearing((Boolean)value)) {
                this.fireAttributeValueChanged(attr, value, oldValue);
            }
            return;
        }
        if (attr == PIO_GEN_IRQ) {
            if (this.state.setIrqGeneration((Boolean)value)) {
                if (this.updateAttributeList()) {
                    this.fireAttributeListChanged();
                }
                this.fireAttributeValueChanged(attr, value, oldValue);
            }
            return;
        }
        if (attr == PIO_IRQ_TYPE) {
            if (this.state.setIrqType((AttributeOption)value)) {
                this.fireAttributeValueChanged(attr, value, oldValue);
            }
            return;
        }
        if (attr == StdAttr.LABEL) {
            if (this.state.setLabel((String)value)) {
                this.fireAttributeValueChanged(attr, value, oldValue);
            }
            return;
        }
        if (attr == StdAttr.LABEL_FONT) {
            Font f = (Font)value;
            if (this.labelFont != f) {
                this.labelFont = f;
                this.fireAttributeValueChanged(attr, value, oldValue);
            }
            return;
        }
        if (attr == StdAttr.LABEL_VISIBILITY) {
            Boolean b = (Boolean)value;
            if (b != this.labelVisible) {
                this.labelVisible = b;
                this.fireAttributeValueChanged(attr, value, oldValue);
            }
            return;
        }
        if (attr == SocSimulationManager.SOC_BUS_SELECT) {
            if (this.state.setAttachedBus((SocBusInfo)value)) {
                this.fireAttributeValueChanged(attr, value, oldValue);
            }
            return;
        }
    }

    private static class PIOStateAttribute
    extends Attribute<PioState> {
        private PIOStateAttribute() {
        }

        @Override
        public PioState parse(String value) {
            return null;
        }

        @Override
        public boolean isHidden() {
            return true;
        }
    }
}

