/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.hdl;

import com.cburch.hdl.HdlModel;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.file.FileWriter;
import com.cburch.logisim.fpga.hdlgenerator.AbstractHdlGeneratorFactory;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.std.hdl.VhdlContentComponent;
import com.cburch.logisim.std.hdl.VhdlEntityComponent;
import java.util.ArrayList;

public class VhdlHdlGeneratorFactory
extends AbstractHdlGeneratorFactory {
    public static final String HDL_DIRECTORY = "circuit";

    public VhdlHdlGeneratorFactory() {
        super(HDL_DIRECTORY);
        this.getWiresPortsDuringHDLWriting = true;
    }

    @Override
    public void getGenerationTimeWiresPorts(Netlist theNetlist, AttributeSet attrs) {
        VhdlContentComponent contents = attrs.getValue(VhdlEntityComponent.CONTENT_ATTR);
        HdlModel.PortDescription[] inputs = contents.getInputs();
        HdlModel.PortDescription[] outputs = contents.getOutputs();
        int portId = 0;
        for (HdlModel.PortDescription input : inputs) {
            this.myPorts.add("input", input.getName(), input.getWidthInt(), portId++);
        }
        for (HdlModel.PortDescription output : outputs) {
            this.myPorts.add("output", output.getName(), output.getWidthInt(), portId++);
        }
    }

    public ArrayList<String> getArchitecture(Netlist theNetlist, AttributeSet attrs, String componentName) {
        ArrayList<String> contents = new ArrayList<String>(FileWriter.getGenerateRemark(componentName, theNetlist.projName()));
        VhdlContentComponent content = attrs.getValue(VhdlEntityComponent.CONTENT_ATTR);
        contents.add(content.getLibraries());
        contents.add(content.getArchitecture());
        return contents;
    }

    @Override
    public boolean isHdlSupportedTarget(AttributeSet attrs) {
        return Hdl.isVhdl();
    }
}

