/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.io;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.fpga.data.ComponentMapInformationContainer;
import com.cburch.logisim.gui.icons.ButtonIcon;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceDataSingleton;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstanceLogger;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstancePoker;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.InstanceStateImpl;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.io.AbstractSimpleIoHdlGeneratorFactory;
import com.cburch.logisim.std.io.IoLibrary;
import com.cburch.logisim.tools.key.DirectionConfigurator;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;

public class Button
extends InstanceFactory {
    public static final String _ID = "Button";
    public static final AttributeOption BUTTON_PRESS_ACTIVE = new AttributeOption("active", Strings.S.getter("buttonPressActive"));
    public static final AttributeOption BUTTON_PRESS_PASSIVE = new AttributeOption("passive", Strings.S.getter("buttonPressPassive"));
    public static final Attribute<AttributeOption> ATTR_PRESS = Attributes.forOption("press", Strings.S.getter("buttonPressAttr"), new AttributeOption[]{BUTTON_PRESS_ACTIVE, BUTTON_PRESS_PASSIVE});
    private static final int DEPTH = 3;

    public Button() {
        super(_ID, Strings.S.getter("buttonComponent"), new AbstractSimpleIoHdlGeneratorFactory(true), true);
        this.setAttributes(new Attribute[]{StdAttr.FACING, IoLibrary.ATTR_COLOR, ATTR_PRESS, StdAttr.LABEL, StdAttr.LABEL_LOC, StdAttr.LABEL_FONT, StdAttr.LABEL_COLOR, StdAttr.LABEL_VISIBILITY, StdAttr.MAPINFO}, new Object[]{Direction.EAST, Color.WHITE, BUTTON_PRESS_ACTIVE, "", Direction.WEST, StdAttr.DEFAULT_LABEL_FONT, StdAttr.DEFAULT_LABEL_COLOR, true, new ComponentMapInformationContainer(1, 0, 0)});
        this.setFacingAttribute(StdAttr.FACING);
        this.setIcon(new ButtonIcon());
        this.setKeyConfigurator(new DirectionConfigurator(StdAttr.LABEL_LOC, 512));
        this.setPorts(new Port[]{new Port(0, 0, "output", 1)});
        this.setInstancePoker(Poker.class);
        this.setInstanceLogger(Logger.class);
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        instance.addAttributeListener();
        instance.computeLabelTextField(24);
    }

    @Override
    public Bounds getOffsetBounds(AttributeSet attrs) {
        Direction facing = attrs.getValue(StdAttr.FACING);
        return Bounds.create(-20, -10, 20, 20).rotate(Direction.EAST, facing, 0, 0);
    }

    @Override
    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        if (attr == StdAttr.FACING) {
            instance.recomputeBounds();
            instance.computeLabelTextField(24);
        } else if (attr == StdAttr.LABEL_LOC) {
            instance.computeLabelTextField(24);
        } else if (attr == ATTR_PRESS) {
            InstanceStateImpl instanceImplementation = instance.getComponent().getInstanceStateImpl();
            if (instanceImplementation == null) {
                return;
            }
            CircuitState circuitState = instanceImplementation.getCircuitState();
            if (circuitState == null) {
                return;
            }
            InstanceState state = circuitState.getInstanceState(instance.getComponent());
            if (state == null) {
                return;
            }
            InstanceDataSingleton data = (InstanceDataSingleton)state.getData();
            if (data == null) {
                state.setData(new InstanceDataSingleton(state.getAttributeValue(ATTR_PRESS) == BUTTON_PRESS_PASSIVE ? Value.TRUE : Value.FALSE));
            } else {
                data.setValue(data.getValue() == Value.TRUE ? Value.FALSE : Value.TRUE);
            }
            state.getInstance().fireInvalidated();
        }
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        int depress;
        InstanceDataSingleton data;
        Value defaultButtonState = painter.getAttributeValue(ATTR_PRESS) == BUTTON_PRESS_ACTIVE ? Value.FALSE : Value.TRUE;
        Bounds bds = painter.getBounds();
        int x = bds.getX();
        int y = bds.getY();
        int w = bds.getWidth();
        int h = bds.getHeight();
        Color baseColor = new Color(AppPreferences.COMPONENT_COLOR.get());
        Value val = painter.getShowState() ? ((data = (InstanceDataSingleton)painter.getData()) == null ? defaultButtonState : (Value)data.getValue()) : defaultButtonState;
        Color color = painter.getAttributeValue(IoLibrary.ATTR_COLOR);
        if (!painter.shouldDrawColor()) {
            int hue = (color.getRed() + color.getGreen() + color.getBlue()) / 3;
            color = new Color(hue, hue, hue);
        }
        Graphics g = painter.getGraphics();
        if (val != defaultButtonState) {
            x += 3;
            y += 3;
            Object labelLoc = painter.getAttributeValue(StdAttr.LABEL_LOC);
            depress = labelLoc == StdAttr.LABEL_CENTER || labelLoc == Direction.NORTH || labelLoc == Direction.WEST ? 3 : 0;
            Direction facing = painter.getAttributeValue(StdAttr.FACING);
            if (facing == Direction.NORTH || facing == Direction.WEST) {
                Location p = painter.getLocation();
                int px = p.getX();
                int py = p.getY();
                GraphicsUtil.switchToWidth(g, 3);
                g.setColor(Value.trueColor);
                if (facing == Direction.NORTH) {
                    g.drawLine(px, py, px, py + 10);
                } else {
                    g.drawLine(px, py, px + 10, py);
                }
                GraphicsUtil.switchToWidth(g, 1);
            }
            g.setColor(color);
            g.fillRect(x, y, w - 3, h - 3);
            g.setColor(baseColor);
            g.drawRect(x, y, w - 3, h - 3);
        } else {
            depress = 0;
            int[] xp = new int[]{x, x + w - 3, x + w, x + w, x + 3, x};
            int[] yp = new int[]{y, y, y + 3, y + h, y + h, y + h - 3};
            g.setColor(color.darker());
            g.fillPolygon(xp, yp, xp.length);
            g.setColor(color);
            g.fillRect(x, y, w - 3, h - 3);
            g.setColor(baseColor);
            g.drawRect(x, y, w - 3, h - 3);
            g.drawLine(x + w - 3, y + h - 3, x + w, y + h);
            g.drawPolygon(xp, yp, xp.length);
        }
        g.translate(depress, depress);
        painter.drawLabel();
        g.translate(-depress, -depress);
        painter.drawPorts();
    }

    @Override
    public void propagate(InstanceState state) {
        InstanceDataSingleton data = (InstanceDataSingleton)state.getData();
        Value defaultButtonState = state.getAttributeValue(ATTR_PRESS) == BUTTON_PRESS_ACTIVE ? Value.FALSE : Value.TRUE;
        Value val = data == null ? defaultButtonState : (Value)data.getValue();
        state.setPort(0, val, 1);
    }

    public static class Poker
    extends InstancePoker {
        @Override
        public void mousePressed(InstanceState state, MouseEvent e) {
            this.setValue(state, state.getAttributeValue(ATTR_PRESS) == BUTTON_PRESS_PASSIVE ? Value.FALSE : Value.TRUE);
        }

        @Override
        public void mouseReleased(InstanceState state, MouseEvent e) {
            this.setValue(state, state.getAttributeValue(ATTR_PRESS) == BUTTON_PRESS_PASSIVE ? Value.TRUE : Value.FALSE);
        }

        private void setValue(InstanceState state, Value val) {
            InstanceDataSingleton data = (InstanceDataSingleton)state.getData();
            if (data == null) {
                state.setData(new InstanceDataSingleton(val));
            } else {
                data.setValue(val);
            }
            state.getInstance().fireInvalidated();
        }
    }

    public static class Logger
    extends InstanceLogger {
        @Override
        public String getLogName(InstanceState state, Object option) {
            return state.getAttributeValue(StdAttr.LABEL);
        }

        @Override
        public BitWidth getBitWidth(InstanceState state, Object option) {
            return BitWidth.ONE;
        }

        @Override
        public Value getLogValue(InstanceState state, Object option) {
            InstanceDataSingleton data = (InstanceDataSingleton)state.getData();
            Value defaultButtonState = state.getAttributeValue(ATTR_PRESS) == BUTTON_PRESS_ACTIVE ? Value.FALSE : Value.TRUE;
            return data == null ? defaultButtonState : (Value)data.getValue();
        }

        @Override
        public boolean isInput(InstanceState state, Object option) {
            return true;
        }
    }
}

