/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.io;

import com.cburch.logisim.circuit.appear.DynamicElement;
import com.cburch.logisim.circuit.appear.DynamicElementProvider;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.fpga.data.ComponentMapInformationContainer;
import com.cburch.logisim.gui.icons.LedIcon;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceDataSingleton;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstanceLogger;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.io.AbstractSimpleIoHdlGeneratorFactory;
import com.cburch.logisim.std.io.IoLibrary;
import com.cburch.logisim.std.io.LedShape;
import com.cburch.logisim.tools.key.DirectionConfigurator;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;

public class Led
extends InstanceFactory
implements DynamicElementProvider {
    public static final String _ID = "LED";

    public Led() {
        super(_ID, Strings.S.getter("ledComponent"), new AbstractSimpleIoHdlGeneratorFactory(false), true);
        this.setAttributes(new Attribute[]{StdAttr.FACING, IoLibrary.ATTR_ON_COLOR, IoLibrary.ATTR_OFF_COLOR, IoLibrary.ATTR_ACTIVE, StdAttr.LABEL, StdAttr.LABEL_LOC, StdAttr.LABEL_FONT, StdAttr.LABEL_COLOR, StdAttr.LABEL_VISIBILITY, StdAttr.MAPINFO}, new Object[]{Direction.WEST, new Color(240, 0, 0), Color.DARK_GRAY, Boolean.TRUE, "", Direction.EAST, StdAttr.DEFAULT_LABEL_FONT, StdAttr.DEFAULT_LABEL_COLOR, true, new ComponentMapInformationContainer(0, 1, 0)});
        this.setFacingAttribute(StdAttr.FACING);
        this.setIcon(new LedIcon(false));
        this.setKeyConfigurator(new DirectionConfigurator(StdAttr.LABEL_LOC, 512));
        this.setPorts(new Port[]{new Port(0, 0, "input", 1)});
        this.setInstanceLogger(Logger.class);
    }

    @Override
    public boolean activeOnHigh(AttributeSet attrs) {
        return attrs.getValue(IoLibrary.ATTR_ACTIVE);
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        instance.addAttributeListener();
        instance.computeLabelTextField(8);
    }

    @Override
    public Bounds getOffsetBounds(AttributeSet attrs) {
        Direction facing = attrs.getValue(StdAttr.FACING);
        return Bounds.create(0, -10, 20, 20).rotate(Direction.WEST, facing, 0, 0);
    }

    @Override
    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        if (attr == StdAttr.FACING) {
            instance.recomputeBounds();
            instance.computeLabelTextField(8);
        } else if (attr == StdAttr.LABEL_LOC) {
            instance.computeLabelTextField(8);
        }
    }

    @Override
    public void paintGhost(InstancePainter painter) {
        Graphics g = painter.getGraphics();
        Bounds bds = painter.getBounds();
        GraphicsUtil.switchToWidth(g, 2);
        g.drawOval(bds.getX() + 1, bds.getY() + 1, bds.getWidth() - 2, bds.getHeight() - 2);
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        InstanceDataSingleton data = (InstanceDataSingleton)painter.getData();
        Value val = data == null ? Value.FALSE : (Value)data.getValue();
        Bounds bds = painter.getBounds().expand(-1);
        Graphics g = painter.getGraphics();
        if (painter.getShowState()) {
            Color onColor = painter.getAttributeValue(IoLibrary.ATTR_ON_COLOR);
            Color offColor = painter.getAttributeValue(IoLibrary.ATTR_OFF_COLOR);
            Boolean activ = painter.getAttributeValue(IoLibrary.ATTR_ACTIVE);
            Value desired = activ != false ? Value.TRUE : Value.FALSE;
            g.setColor(val == desired ? onColor : offColor);
            g.fillOval(bds.getX(), bds.getY(), bds.getWidth(), bds.getHeight());
        }
        g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
        GraphicsUtil.switchToWidth(g, 2);
        g.drawOval(bds.getX(), bds.getY(), bds.getWidth(), bds.getHeight());
        GraphicsUtil.switchToWidth(g, 1);
        painter.drawLabel();
        painter.drawPorts();
    }

    @Override
    public void propagate(InstanceState state) {
        Value val = state.getPortValue(0);
        InstanceDataSingleton data = (InstanceDataSingleton)state.getData();
        if (data == null) {
            state.setData(new InstanceDataSingleton(val));
        } else {
            data.setValue(val);
        }
    }

    @Override
    public DynamicElement createDynamicElement(int x, int y, DynamicElement.Path path) {
        return new LedShape(x, y, path);
    }

    public static class Logger
    extends InstanceLogger {
        @Override
        public String getLogName(InstanceState state, Object option) {
            return state.getAttributeValue(StdAttr.LABEL);
        }

        @Override
        public BitWidth getBitWidth(InstanceState state, Object option) {
            return BitWidth.ONE;
        }

        @Override
        public Value getLogValue(InstanceState state, Object option) {
            InstanceDataSingleton data = (InstanceDataSingleton)state.getData();
            if (data == null) {
                return Value.FALSE;
            }
            return data.getValue() == Value.TRUE ? Value.TRUE : Value.FALSE;
        }
    }
}

