/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.io;

import com.cburch.logisim.circuit.appear.DynamicElement;
import com.cburch.logisim.circuit.appear.DynamicElementProvider;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.fpga.data.ComponentMapInformationContainer;
import com.cburch.logisim.gui.icons.SevenSegmentIcon;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceDataSingleton;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.io.AbstractSimpleIoHdlGeneratorFactory;
import com.cburch.logisim.std.io.IoLibrary;
import com.cburch.logisim.std.io.SevenSegmentShape;
import com.cburch.logisim.tools.key.DirectionConfigurator;
import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;

public class SevenSegment
extends InstanceFactory
implements DynamicElementProvider {
    public static final String _ID = "7-Segment Display";
    public static final int Segment_A = 0;
    public static final int Segment_B = 1;
    public static final int Segment_C = 2;
    public static final int Segment_D = 3;
    public static final int Segment_E = 4;
    public static final int Segment_F = 5;
    public static final int Segment_G = 6;
    public static final int DP = 7;
    static Bounds[] SEGMENTS = null;
    static final Color DEFAULT_OFF = new Color(220, 220, 220);
    public static final Attribute<Boolean> ATTR_DP = Attributes.forBoolean("decimalPoint", Strings.S.getter("SevenSegDP"));

    static void drawBase(InstancePainter painter, boolean drawPoint) {
        SevenSegment.ensureSegments();
        InstanceDataSingleton data = (InstanceDataSingleton)painter.getData();
        int summ = data == null ? 0 : (Integer)data.getValue();
        Boolean active = painter.getAttributeValue(IoLibrary.ATTR_ACTIVE);
        int desired = active == null || active != false ? 1 : 0;
        Bounds bds = painter.getBounds();
        int x = bds.getX() + 5;
        int y = bds.getY();
        Graphics g = painter.getGraphics();
        Color onColor = painter.getAttributeValue(IoLibrary.ATTR_ON_COLOR);
        Color offColor = painter.getAttributeValue(IoLibrary.ATTR_OFF_COLOR);
        Color bgColor = painter.getAttributeValue(IoLibrary.ATTR_BACKGROUND);
        if (painter.shouldDrawColor() && bgColor.getAlpha() != 0) {
            g.setColor(bgColor);
            g.fillRect(bds.getX(), bds.getY(), bds.getWidth(), bds.getHeight());
            g.setColor(Color.BLACK);
        }
        painter.drawBounds();
        g.setColor(Color.DARK_GRAY);
        for (int i = 0; i <= 7; ++i) {
            if (painter.getShowState()) {
                g.setColor((summ >> i & 1) == desired ? onColor : offColor);
            }
            if (i < 7) {
                Bounds seg = SEGMENTS[i];
                g.fillRect(x + seg.getX(), y + seg.getY(), seg.getWidth(), seg.getHeight());
                continue;
            }
            if (!drawPoint) continue;
            g.fillOval(x + 28, y + 48, 5, 5);
        }
        g.setColor(Color.BLACK);
        painter.drawLabel();
        painter.drawPorts();
    }

    static void ensureSegments() {
        if (SEGMENTS == null) {
            SEGMENTS = new Bounds[]{Bounds.create(3, 8, 19, 4), Bounds.create(23, 10, 4, 19), Bounds.create(23, 30, 4, 19), Bounds.create(3, 47, 19, 4), Bounds.create(-2, 30, 4, 19), Bounds.create(-2, 10, 4, 19), Bounds.create(3, 28, 19, 4)};
        }
    }

    public static List<String> getLabels() {
        ArrayList<String> labelNames = new ArrayList<String>();
        for (int i = 0; i < 8; ++i) {
            labelNames.add("");
        }
        labelNames.set(0, "Segment_A");
        labelNames.set(1, "Segment_B");
        labelNames.set(2, "Segment_C");
        labelNames.set(3, "Segment_D");
        labelNames.set(4, "Segment_E");
        labelNames.set(5, "Segment_F");
        labelNames.set(6, "Segment_G");
        labelNames.set(7, "DecimalPoint");
        return labelNames;
    }

    public static String getOutputLabel(int id) {
        if (id < 0 || id > SevenSegment.getLabels().size()) {
            return "Undefined";
        }
        return SevenSegment.getLabels().get(id);
    }

    public SevenSegment() {
        super(_ID, Strings.S.getter("sevenSegmentComponent"), new AbstractSimpleIoHdlGeneratorFactory(false), true);
        this.setAttributes(new Attribute[]{IoLibrary.ATTR_ON_COLOR, IoLibrary.ATTR_OFF_COLOR, IoLibrary.ATTR_BACKGROUND, IoLibrary.ATTR_ACTIVE, ATTR_DP, StdAttr.LABEL, StdAttr.LABEL_LOC, StdAttr.LABEL_FONT, StdAttr.LABEL_VISIBILITY, StdAttr.MAPINFO}, new Object[]{new Color(240, 0, 0), DEFAULT_OFF, IoLibrary.DEFAULT_BACKGROUND, Boolean.TRUE, Boolean.TRUE, "", Direction.EAST, StdAttr.DEFAULT_LABEL_FONT, false, new ComponentMapInformationContainer(0, 8, 0, null, SevenSegment.getLabels(), null)});
        this.setOffsetBounds(Bounds.create(-5, 0, 40, 60));
        this.setIcon(new SevenSegmentIcon(false));
        this.setKeyConfigurator(new DirectionConfigurator(StdAttr.LABEL_LOC, 512));
    }

    private void updatePorts(Instance instance) {
        Boolean hasDp = instance.getAttributeValue(ATTR_DP);
        Port[] ps = new Port[hasDp != false ? 8 : 7];
        ps[0] = new Port(20, 0, "input", 1);
        ps[1] = new Port(30, 0, "input", 1);
        ps[2] = new Port(20, 60, "input", 1);
        ps[3] = new Port(10, 60, "input", 1);
        ps[4] = new Port(0, 60, "input", 1);
        ps[5] = new Port(10, 0, "input", 1);
        ps[6] = new Port(0, 0, "input", 1);
        ps[0].setToolTip(Strings.S.getter("Segment_A"));
        ps[1].setToolTip(Strings.S.getter("Segment_B"));
        ps[2].setToolTip(Strings.S.getter("Segment_C"));
        ps[3].setToolTip(Strings.S.getter("Segment_D"));
        ps[4].setToolTip(Strings.S.getter("Segment_E"));
        ps[5].setToolTip(Strings.S.getter("Segment_F"));
        ps[6].setToolTip(Strings.S.getter("Segment_G"));
        if (hasDp.booleanValue()) {
            ps[7] = new Port(30, 60, "input", 1);
            ps[7].setToolTip(Strings.S.getter("DecimalPoint"));
        }
        instance.setPorts(ps);
        instance.getAttributeValue(StdAttr.MAPINFO).setNrOfOutports(hasDp != false ? 8 : 7, SevenSegment.getLabels());
    }

    @Override
    public boolean activeOnHigh(AttributeSet attrs) {
        return attrs.getValue(IoLibrary.ATTR_ACTIVE);
    }

    public static void computeTextField(Instance instance) {
        Direction facing = instance.getAttributeValue(StdAttr.FACING);
        Object labelLoc = instance.getAttributeValue(StdAttr.LABEL_LOC);
        Bounds bds = instance.getBounds();
        int x = bds.getX() + bds.getWidth() / 2;
        int y = bds.getY() + bds.getHeight() / 2;
        int halign = 0;
        int valign = 0;
        if (labelLoc == Direction.NORTH) {
            y = bds.getY() - 2;
            valign = 2;
        } else if (labelLoc == Direction.SOUTH) {
            y = bds.getY() + bds.getHeight() + 2;
            valign = -1;
        } else if (labelLoc == Direction.EAST) {
            x = bds.getX() + bds.getWidth() + 2;
            halign = -1;
        } else if (labelLoc == Direction.WEST) {
            x = bds.getX() - 2;
            halign = 1;
        }
        if (labelLoc == facing) {
            if (labelLoc == Direction.NORTH || labelLoc == Direction.SOUTH) {
                x += 2;
                halign = -1;
            } else {
                y -= 2;
                valign = 2;
            }
        }
        instance.setTextField(StdAttr.LABEL, StdAttr.LABEL_FONT, x, y, halign, valign);
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        instance.getAttributeSet().setValue(StdAttr.MAPINFO, new ComponentMapInformationContainer(0, 8, 0, null, SevenSegment.getLabels(), null));
        instance.addAttributeListener();
        this.updatePorts(instance);
        SevenSegment.computeTextField(instance);
    }

    @Override
    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        if (attr == StdAttr.FACING) {
            instance.recomputeBounds();
            SevenSegment.computeTextField(instance);
        } else if (attr == StdAttr.LABEL_LOC) {
            SevenSegment.computeTextField(instance);
        } else if (attr == ATTR_DP) {
            this.updatePorts(instance);
        }
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        SevenSegment.drawBase(painter, painter.getAttributeValue(ATTR_DP));
    }

    @Override
    public void propagate(InstanceState state) {
        int summary = 0;
        int max = state.getAttributeValue(ATTR_DP) != false ? 8 : 7;
        for (int i = 0; i < max; ++i) {
            Value val = state.getPortValue(i);
            if (val != Value.TRUE) continue;
            summary |= 1 << i;
        }
        Integer value = summary;
        InstanceDataSingleton data = (InstanceDataSingleton)state.getData();
        if (data == null) {
            state.setData(new InstanceDataSingleton(value));
        } else {
            data.setValue(value);
        }
    }

    @Override
    public DynamicElement createDynamicElement(int x, int y, DynamicElement.Path path) {
        return new SevenSegmentShape(x, y, path);
    }
}

