/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.io;

import com.cburch.logisim.fpga.data.FpgaIoInformationContainer;
import com.cburch.logisim.fpga.data.SevenSegmentScanningDriving;
import com.cburch.logisim.fpga.hdlgenerator.AbstractHdlGeneratorFactory;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.std.io.SevenSegmendScanningSelectedHdlGenerator;
import com.cburch.logisim.std.io.SevenSegment;
import com.cburch.logisim.std.io.SevenSegmentScanningDecodedHdlGeneratorFactory;
import com.cburch.logisim.util.LineBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class SevenSegmentScanningGenericHdlGenerator {
    public static String InternalSignalName = "scanningSevenSegSegments";
    public static String SevenSegmentSegmenInputs = "allSegments";
    public static String SevenSegmentControlOutput = "digitDecodedSelect";
    public static String SevenSegmentSegmentOutput = "scannedSegments";

    public static AbstractHdlGeneratorFactory getSpecificHDLGenerator(String type) {
        char typeId = SevenSegmentScanningDriving.getId(type);
        return switch (typeId) {
            case '\u0000' -> new SevenSegmentScanningDecodedHdlGeneratorFactory();
            case '\u0001', '\u0002' -> new SevenSegmendScanningSelectedHdlGenerator();
            default -> null;
        };
    }

    public static String getSpecificHDLName(char typeId) {
        return switch (typeId) {
            case '\u0000' -> "SevenSegmentScanningDecoded";
            case '\u0001', '\u0002' -> "SevenSegmentScanning";
            default -> null;
        };
    }

    public static String getSpecificHDLName(String type) {
        return SevenSegmentScanningGenericHdlGenerator.getSpecificHDLName(SevenSegmentScanningDriving.getId(type));
    }

    public static Map<String, Integer> getInternalSignals(int nrOfRows, int identifier) {
        TreeMap<String, Integer> wires = new TreeMap<String, Integer>();
        wires.put(String.format("s_%s%d", InternalSignalName, identifier), nrOfRows * 8);
        return wires;
    }

    public static SortedMap<String, Integer> getExternalSignals(char typeId, int nrOfRows, int nrOfColumns, int identifier) {
        TreeMap<String, Integer> externals = new TreeMap<String, Integer>();
        int nrOfControlSignals = typeId == '\u0000' ? Math.max((int)Math.ceil(Math.log(nrOfRows) / Math.log(2.0)), nrOfColumns) : nrOfRows;
        for (String segmentName : SevenSegment.getLabels()) {
            externals.put(String.format("Displ%d_%s", identifier, segmentName), 1);
        }
        externals.put(String.format("Displ%dSelect", identifier), nrOfControlSignals);
        return externals;
    }

    public static List<String> getComponentMap(char typeId, int nrOfRows, int nrOfColumns, int identifier, long FpgaClockFrequency, boolean isActiveLow) {
        LineBuffer componentMap = LineBuffer.getBuffer().add(Hdl.isVhdl() ? LineBuffer.format("sevenSegScan{{1}} : {{2}}", identifier, SevenSegmentScanningGenericHdlGenerator.getSpecificHDLName(typeId)) : SevenSegmentScanningGenericHdlGenerator.getSpecificHDLName(typeId));
        switch (typeId) {
            case '\u0000': {
                componentMap.add(SevenSegmentScanningDecodedHdlGeneratorFactory.getGenericMap(nrOfRows, nrOfColumns, FpgaClockFrequency, isActiveLow, false).getWithIndent());
                break;
            }
            case '\u0001': 
            case '\u0002': {
                componentMap.add(SevenSegmendScanningSelectedHdlGenerator.getGenericMap(nrOfRows, nrOfColumns, FpgaClockFrequency, isActiveLow, typeId == '\u0001')).getWithIndent();
            }
        }
        if (Hdl.isVerilog()) {
            componentMap.add("   sevenSegScan{{1}}", identifier);
        }
        switch (typeId) {
            case '\u0000': 
            case '\u0001': 
            case '\u0002': {
                componentMap.add(SevenSegmendScanningSelectedHdlGenerator.getPortMap(identifier).getWithIndent());
            }
        }
        return componentMap.empty().get();
    }

    public static List<String> getSegmentConnections(FpgaIoInformationContainer segment, int id) {
        LineBuffer connections = LineBuffer.getHdlBuffer();
        HashMap<String, String> wires = new HashMap<String, String>();
        for (int pin = 0; pin < segment.getNrOfPins(); ++pin) {
            String seg = LineBuffer.formatHdl("s_{{1}}{{2}}{{<}}{{3}}{{>}}", InternalSignalName, id, pin);
            if (!segment.isPinMapped(pin)) {
                wires.put(seg, Hdl.zeroBit());
                continue;
            }
            wires.put(seg, segment.getPinMap(pin).getHdlSignalName(segment.getMapPin(pin)));
        }
        Hdl.addAllWiresSorted(connections, wires);
        return connections.get();
    }

    public static String getExternalSignalName(int nrOfRows, int identifier, int pinNr) {
        if (pinNr < 8) {
            return String.format("Displ%d_%s", identifier, SevenSegment.getOutputLabel(pinNr));
        }
        return String.format("Displ%dSelect[%d]", identifier, pinNr - 8);
    }
}

