/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.io;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.comp.AbstractComponentFactory;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentDrawContext;
import com.cburch.logisim.comp.ComponentEvent;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.comp.ComponentState;
import com.cburch.logisim.comp.ComponentUserEvent;
import com.cburch.logisim.comp.ManagedComponent;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeEvent;
import com.cburch.logisim.data.AttributeListener;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.AttributeSets;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.tools.ToolTipMaker;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;

class Video
extends ManagedComponent
implements ToolTipMaker,
AttributeListener {
    public static final String _ID = "RGB Video";
    public static final ComponentFactory factory = new Factory();
    static final String BLINK_YES = "Blinking Dot";
    static final String BLINK_NO = "No Cursor";
    static final String[] BLINK_OPTIONS = new String[]{"Blinking Dot", "No Cursor"};
    static final String RESET_ASYNC = "Asynchronous";
    static final String RESET_SYNC = "Synchronous";
    static final String[] RESET_OPTIONS = new String[]{"Asynchronous", "Synchronous"};
    static final String COLOR_RGB = "888 RGB (24 bit)";
    static final String COLOR_555_RGB = "555 RGB (15 bit)";
    static final String COLOR_565_RGB = "565 RGB (16 bit)";
    static final String COLOR_111_RGB = "8-Color RGB (3 bit)";
    static final String COLOR_ATARI = "Atari 2600 (7 bit)";
    static final String COLOR_XTERM16 = "XTerm16 (4 bit)";
    static final String COLOR_XTERM256 = "XTerm256 (8 bit)";
    static final String COLOR_GRAY4 = "Grayscale (4 bit)";
    static final String COLOR_VGA256 = "VGA256 (8 bit)";
    static final String[] COLOR_OPTIONS = new String[]{"888 RGB (24 bit)", "555 RGB (15 bit)", "565 RGB (16 bit)", "8-Color RGB (3 bit)", "Atari 2600 (7 bit)", "XTerm16 (4 bit)", "XTerm256 (8 bit)", "Grayscale (4 bit)", "VGA256 (8 bit)"};
    static final Integer[] SIZE_OPTIONS = new Integer[]{2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048};
    public static final Attribute<String> BLINK_OPTION = Attributes.forOption("cursor", Strings.S.getter("rgbVideoCursor"), BLINK_OPTIONS);
    public static final Attribute<String> RESET_OPTION = Attributes.forOption("reset", Strings.S.getter("rgbVideoReset"), RESET_OPTIONS);
    public static final Attribute<String> COLOR_OPTION = Attributes.forOption("color", Strings.S.getter("rgbVideoColor"), COLOR_OPTIONS);
    public static final Attribute<Integer> WIDTH_OPTION = Attributes.forOption("width", Strings.S.getter("rgbVideoWidth"), SIZE_OPTIONS);
    public static final Attribute<Integer> HEIGHT_OPTION = Attributes.forOption("height", Strings.S.getter("rgbVideoHeight"), SIZE_OPTIONS);
    public static final Attribute<Integer> SCALE_OPTION = Attributes.forIntegerRange("scale", Strings.S.getter("rgbVideoScale"), 1, 8);
    private static final Attribute<?>[] ATTRIBUTES = new Attribute[]{BLINK_OPTION, RESET_OPTION, COLOR_OPTION, WIDTH_OPTION, HEIGHT_OPTION, SCALE_OPTION};
    static final int P_RST = 0;
    static final int P_CLK = 1;
    static final int P_WE = 2;
    static final int P_X = 3;
    static final int P_Y = 4;
    static final int P_DATA = 5;
    static final DirectColorModel rgb111 = new DirectColorModel(3, 4, 2, 1);
    static final DirectColorModel rgb555 = new DirectColorModel(15, 31744, 992, 31);
    static final DirectColorModel rgb565 = new DirectColorModel(16, 63488, 2016, 31);
    static final DirectColorModel rgb = new DirectColorModel(24, 0xFF0000, 65280, 255);
    static final IndexColorModel gray4 = new IndexColorModel(4, 16, new int[]{0, 0x111111, 0x222222, 0x333333, 0x444444, 0x555555, 0x666666, 0x777777, 0x888888, 0x999999, 0xAAAAAA, 0xBBBBBB, 0xCCCCCC, 0xDDDDDD, 0xEEEEEE, 0xFFFFFF}, 0, 0, null);
    static final IndexColorModel atari = new IndexColorModel(7, 128, new int[]{0, 657930, 0x373737, 0x5F5F5F, 0x7A7A7A, 0xA1A1A1, 0xC5C5C5, 0xEDEDED, 0, 3481856, 5915904, 8481792, 10258176, 12824321, 15258406, 16775757, 0x310000, 5834496, 8203008, 10768896, 12545284, 15177003, 16759120, 16769143, 0x470000, 0x6E0000, 9638658, 12204842, 0xD55545, 16547180, 16753040, 16763320, 4915202, 7471145, 9831246, 12462709, 14239120, 16739511, 16749020, 0xFFB8FF, 3932233, 6553712, 8913044, 11478204, 13254615, 15886078, 0xFF8AFF, 0xFFB2FF, 1966205, 4522149, 6881993, 9513457, 11289855, 13855743, 16224511, 0xFFB7FF, 150, 1900733, 0x4111E1, 6896127, 8672255, 11238399, 0xCF9FFF, 0xF7C7FF, 141, 1204, 1517785, 4149503, 5925887, 8491775, 10860287, 13491967, 101, 7820, 17072, 1796824, 3573235, 6139135, 8573183, 11139327, 3877, 13900, 23152, 295576, 2071987, 4703450, 7071998, 0x92FFFF, 8192, 18177, 27429, 37709, 1748584, 4380047, 6748596, 9306075, 9984, 19968, 29184, 891398, 2667808, 5233736, 7667564, 10223508, 8704, 18944, 224768, 2856192, 4567040, 7198738, 9567286, 12189533, 2560, 473600, 2842368, 5408256, 7184640, 9816064, 12184860, 14745411, 0, 3481856, 5915904, 8481792, 10258176, 12824321, 15258406, 16775757}, 0, 0, null);
    static final IndexColorModel xterm16 = new IndexColorModel(4, 16, new int[]{0, 0x800000, 32768, 0x808000, 128, 0x800080, 32896, 0xC0C0C0, 0x808080, 0xFF0000, 65280, 0xFFFF00, 255, 0xFF00FF, 65535, 0xFFFFFF}, 0, 0, null);
    static final IndexColorModel xterm256 = new IndexColorModel(8, 256, new int[]{0, 0x800000, 32768, 0x808000, 128, 0x800080, 32896, 0xC0C0C0, 0x808080, 0xFF0000, 65280, 0xFFFF00, 255, 0xFF00FF, 65535, 0xFFFFFF, 0, 95, 135, 175, 215, 255, 24320, 24415, 24455, 24495, 24535, 24575, 34560, 34655, 34695, 34735, 34775, 34815, 44800, 44895, 44935, 44975, 45015, 45055, 55040, 55135, 55175, 55215, 55255, 55295, 65280, 65375, 65415, 65455, 65495, 65535, 0x5F0000, 0x5F005F, 6226055, 6226095, 6226135, 0x5F00FF, 0x5F5F00, 0x5F5F5F, 6250375, 0x5F5FAF, 6250455, 0x5F5FFF, 6260480, 6260575, 6260615, 6260655, 6260695, 6260735, 6270720, 0x5FAF5F, 6270855, 0x5FAFAF, 6270935, 0x5FAFFF, 6280960, 6281055, 6281095, 6281135, 6281175, 6281215, 0x5FFF00, 0x5FFF5F, 6291335, 0x5FFFAF, 6291415, 0x5FFFFF, 0x870000, 8847455, 0x870087, 8847535, 8847575, 8847615, 8871680, 8871775, 8871815, 8871855, 8871895, 8871935, 0x878700, 8882015, 0x878787, 8882095, 0x8787D7, 0x8787FF, 8892160, 8892255, 8892295, 8892335, 8892375, 8892415, 8902400, 8902495, 0x87D787, 8902575, 0x87D7D7, 8902655, 8912640, 8912735, 0x87FF87, 8912815, 8912855, 0x87FFFF, 0xAF0000, 11468895, 11468935, 0xAF00AF, 11469015, 0xAF00FF, 11493120, 0xAF5F5F, 11493255, 0xAF5FAF, 11493335, 0xAF5FFF, 11503360, 11503455, 11503495, 11503535, 11503575, 11503615, 0xAFAF00, 0xAFAF5F, 11513735, 0xAFAFAF, 11513815, 0xAFAFFF, 11523840, 11523935, 11523975, 11524015, 11524055, 11524095, 0xAFFF00, 0xAFFF5F, 11534215, 0xAFFFAF, 11534295, 0xAFFFFF, 0xD70000, 14090335, 14090375, 14090415, 0xD700D7, 14090495, 14114560, 14114655, 14114695, 14114735, 14114775, 14114815, 14124800, 14124895, 0xD78787, 14124975, 0xD787D7, 14125055, 14659328, 14659423, 14659463, 0xDFAFAF, 0xDFAFDF, 0xDFAFFF, 0xDFDF00, 0xDFDF5F, 14671751, 0xDFDFAF, 0xDFDFDF, 0xDFDFFF, 0xDFFF00, 0xDFFF5F, 14679943, 0xDFFFAF, 0xDFFFDF, 0xDFFFFF, 0xFF0000, 0xFF005F, 16711815, 0xFF00AF, 0xFF00DF, 0xFF00FF, 0xFF5F00, 0xFF5F5F, 16736135, 0xFF5FAF, 0xFF5FDF, 0xFF5FFF, 16746240, 16746335, 0xFF8787, 16746415, 16746463, 0xFF87FF, 0xFFAF00, 0xFFAF5F, 16756615, 0xFFAFAF, 0xFFAFDF, 0xFFAFFF, 0xFFDF00, 0xFFDF5F, 16768903, 0xFFDFAF, 0xFFDFDF, 0xFFDFFF, 0xFFFF00, 0xFFFF5F, 0xFFFF87, 0xFFFFAF, 0xFFFFDF, 0xFFFFFF, 526344, 0x121212, 0x1C1C1C, 0x262626, 0x303030, 0x3A3A3A, 0x444444, 0x4E4E4E, 0x585858, 0x626262, 0x6C6C6C, 0x767676, 0x808080, 0x8A8A8A, 0x949494, 0x9E9E9E, 0xA8A8A8, 0xB2B2B2, 0xBCBCBC, 0xC6C6C6, 0xD0D0D0, 0xDADADA, 0xE4E4E4, 0xEEEEEE}, 0, 0, null);
    static final IndexColorModel vga256 = new IndexColorModel(8, 256, new int[]{0, 170, 43520, 43690, 0xAA0000, 0xAA00AA, 0xAA5500, 0xAAAAAA, 0x555555, 0x5555FF, 0x55FF55, 0x55FFFF, 0xFF5555, 0xFF55FF, 0xFFFF55, 0xFFFFFF, 0, 0x141414, 0x202020, 0x2C2C2C, 0x383838, 0x454545, 0x515151, 0x616161, 0x717171, 0x828282, 0x929292, 0xA2A2A2, 0xB6B6B6, 0xCBCBCB, 0xE3E3E3, 0xFFFFFF, 255, 4260095, 8192255, 12452095, 0xFF00FF, 16711870, 16711805, 16711745, 0xFF0000, 16728320, 16743680, 16760320, 0xFFFF00, 12517120, 8257280, 4325120, 65280, 65345, 65405, 65470, 65535, 48895, 32255, 16895, 0x7D7DFF, 10386943, 12484095, 0xDF7DFF, 0xFF7DFF, 0xFF7DDF, 16743870, 16743838, 0xFF7D7D, 16752253, 16760445, 0xFFDF7D, 0xFFFF7D, 0xDFFF7D, 12517245, 10420093, 0x7DFF7D, 8257438, 8257470, 0x7DFFDF, 0x7DFFFF, 0x7DDFFF, 8240895, 8232703, 0xB6B6FF, 13088511, 14399231, 15447807, 0xFFB6FF, 16758507, 16758491, 16758471, 0xFFB6B6, 16762806, 16767926, 16772022, 0xFFFFB6, 15466422, 14417846, 13107126, 0xB6FFB6, 11993031, 11993051, 11993067, 0xB6FFFF, 11987967, 11983871, 11978751, 113, 1835121, 3670129, 5570673, 0x710071, 7405653, 7405624, 7405596, 0x710000, 7412736, 7419904, 7427328, 0x717100, 5599488, 3698944, 1863936, 28928, 28956, 28984, 29013, 29041, 21873, 14449, 7281, 3684465, 4536433, 5585009, 6371441, 7420017, 7420001, 7419989, 7419973, 7419960, 7423288, 7427384, 7430456, 7434552, 6385976, 5599544, 4550968, 3699000, 3699013, 3699029, 3699041, 3699057, 3694961, 3691889, 3687793, 0x515171, 5853553, 6377841, 6902129, 0x715171, 7426409, 7426401, 7426393, 0x715151, 7428433, 7430481, 7432529, 0x717151, 6910289, 6386001, 5861713, 0x517151, 5337433, 5337441, 5337449, 0x517171, 5335409, 5333361, 5331313, 65, 0x100041, 2097217, 3145793, 0x410041, 4259888, 4259872, 0x410010, 0x410000, 0x411000, 4268032, 4272128, 0x414100, 3162368, 2113792, 0x104100, 16640, 16656, 16672, 16688, 16705, 12353, 8257, 4161, 2105409, 2629697, 3153985, 3678273, 4268097, 4268088, 4268080, 4268072, 4268064, 4270112, 4272160, 4274208, 4276512, 3686688, 3162400, 2638112, 2113824, 2113832, 2113840, 2113848, 2113857, 2111553, 2109505, 2107457, 2894913, 3157057, 3419201, 3943489, 4271169, 4271164, 4271156, 4271152, 4271148, 4272172, 4273196, 4275244, 4276524, 3948844, 3424556, 3162412, 2900268, 2900272, 2900276, 2900284, 2900289, 2899009, 2896961, 2895937, 0, 0, 0, 0, 0, 0, 0, 0}, 0, 0, null);

    private Video(Location loc, AttributeSet attrs) {
        super(loc, attrs, 6);
        this.setEnd(0, this.getLocation().translate(0, 0), BitWidth.ONE, 1);
        this.setEnd(1, this.getLocation().translate(10, 0), BitWidth.ONE, 1);
        this.setEnd(2, this.getLocation().translate(20, 0), BitWidth.ONE, 1);
        this.configureComponent();
        attrs.addAttributeListener(this);
    }

    @Override
    public ComponentFactory getFactory() {
        return factory;
    }

    @Override
    public void setFactory(ComponentFactory fact) {
    }

    Location loc(int pin) {
        return this.getEndLocation(pin);
    }

    Value val(CircuitState s, int pin) {
        return s.getValue(this.loc(pin));
    }

    int addr(CircuitState s, int pin) {
        return (int)this.val(s, pin).toLongValue();
    }

    @Override
    public void propagate(CircuitState circuitState) {
        Graphics g;
        State state = this.getState(circuitState);
        AttributeSet attrs = this.getAttributeSet();
        int x = this.addr(circuitState, 3);
        int y = this.addr(circuitState, 4);
        int color = this.addr(circuitState, 5);
        state.lastX = x;
        state.lastY = y;
        state.color = color;
        String resetOption = attrs.getValue(RESET_OPTION);
        if (resetOption == null) {
            resetOption = RESET_OPTIONS[0];
        }
        ColorModel cm = Video.getColorModel(attrs.getValue(COLOR_OPTION));
        Integer w = attrs.getValue(WIDTH_OPTION);
        Integer h = attrs.getValue(HEIGHT_OPTION);
        if (state.tick(this.val(circuitState, 1)) && this.val(circuitState, 2) == Value.TRUE) {
            g = state.img.getGraphics();
            g.setColor(new Color(cm.getRGB(color)));
            g.fillRect(x, y, 1, 1);
            if (RESET_SYNC.equals(resetOption) && this.val(circuitState, 0) == Value.TRUE) {
                g.setColor(Color.BLACK);
                g.fillRect(0, 0, w, h);
            }
        }
        if (!RESET_SYNC.equals(resetOption) && this.val(circuitState, 0) == Value.TRUE) {
            g = state.img.getGraphics();
            g.setColor(Color.BLACK);
            g.fillRect(0, 0, w, h);
        }
    }

    @Override
    public void draw(ComponentDrawContext context) {
        Location loc = this.getLocation();
        State s = this.getState(context.getCircuitState());
        this.drawVideo(context, loc.getX(), loc.getY(), s);
    }

    static void drawVideoIcon(ComponentDrawContext context, int x, int y) {
        Graphics g = context.getGraphics().create();
        g.translate(x, y);
        g.setColor(Color.WHITE);
        g.fillRoundRect(Video.scale(2), Video.scale(2), Video.scale(15), Video.scale(15), Video.scale(3), Video.scale(3));
        g.setColor(Color.BLACK);
        g.drawRoundRect(Video.scale(2), Video.scale(2), Video.scale(15), Video.scale(15), Video.scale(3), Video.scale(3));
        int five = Video.scale(5);
        int ten = Video.scale(10);
        g.setColor(Color.RED);
        g.fillRect(five, five, five, five);
        g.setColor(Color.BLUE);
        g.fillRect(ten, five, five, five);
        g.setColor(Color.GREEN);
        g.fillRect(five, ten, five, five);
        g.setColor(Color.MAGENTA);
        g.fillRect(ten, ten, five, five);
        g.dispose();
    }

    private static int scale(int v) {
        return AppPreferences.getScaled(v);
    }

    boolean blink() {
        long now = System.currentTimeMillis();
        return now / 1000L % 2L == 0L;
    }

    static ColorModel getColorModel(Object model) {
        if (model == COLOR_RGB) {
            return rgb;
        }
        if (model == COLOR_555_RGB) {
            return rgb555;
        }
        if (model == COLOR_565_RGB) {
            return rgb565;
        }
        if (model == COLOR_111_RGB) {
            return rgb111;
        }
        if (model == COLOR_ATARI) {
            return atari;
        }
        if (model == COLOR_XTERM16) {
            return xterm16;
        }
        if (model == COLOR_XTERM256) {
            return xterm256;
        }
        if (model == COLOR_GRAY4) {
            return gray4;
        }
        if (model == COLOR_VGA256) {
            return vga256;
        }
        return rgb555;
    }

    void drawVideo(ComponentDrawContext context, int x, int y, State state) {
        Graphics g = context.getGraphics();
        AttributeSet attrs = this.getAttributeSet();
        String blinkOption = attrs.getValue(BLINK_OPTION);
        ColorModel cm = Video.getColorModel(attrs.getValue(COLOR_OPTION));
        Integer s = attrs.getValue(SCALE_OPTION);
        Integer w = attrs.getValue(WIDTH_OPTION);
        Integer h = attrs.getValue(HEIGHT_OPTION);
        int bw = Math.max(s * w + 14, 100);
        int bh = Math.max(s * h + 14, 20);
        g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
        g.drawRoundRect(x -= 30, y += -bh, bw, bh, 6, 6);
        for (int i = 0; i < 6; ++i) {
            if (i == 1) continue;
            context.drawPin(this, i);
        }
        context.drawClock(this, 1, Direction.NORTH);
        g.drawRect(x + 6, y + 6, s * w + 2, s * h + 2);
        g.drawImage(state.img, x + 7, y + 7, x + 7 + s * w, y + 7 + s * h, 0, 0, w, h, null);
        if (blinkOption == null) {
            blinkOption = BLINK_OPTIONS[0];
        }
        if (BLINK_YES.equals(blinkOption) && this.blink() && state.lastX >= 0 && state.lastX < w && state.lastY >= 0 && state.lastY < h) {
            g.setColor(new Color(cm.getRGB(state.color)));
            g.fillRect(x + 7 + state.lastX * s, y + 7 + state.lastY * s, s, s);
        }
    }

    private State getState(CircuitState circuitState) {
        State state = (State)circuitState.getData(this);
        if (state == null) {
            state = new State(new BufferedImage(256, 256, 2));
            circuitState.setData(this, state);
        }
        return state;
    }

    @Override
    public Object getFeature(Object key) {
        if (key == ToolTipMaker.class) {
            return this;
        }
        return super.getFeature(key);
    }

    @Override
    public String getToolTip(ComponentUserEvent e) {
        int end = -1;
        for (int i = this.getEnds().size() - 1; i >= 0; --i) {
            if (this.getEndLocation(i).manhattanDistanceTo(e.getX(), e.getY()) >= 10) continue;
            end = i;
            break;
        }
        switch (end) {
            case 1: {
                return Strings.S.get("rgbVideoCLK");
            }
            case 2: {
                return Strings.S.get("rgbVideoWE");
            }
            case 3: {
                return Strings.S.get("rgbVideoX");
            }
            case 4: {
                return Strings.S.get("rgbVideoY");
            }
            case 5: {
                AttributeSet attrs = this.getAttributeSet();
                return Strings.S.get("rgbVideoData", attrs.getValue(COLOR_OPTION));
            }
            case 0: {
                return Strings.S.get("rgbVideoRST");
            }
        }
        return null;
    }

    @Override
    public void attributeListChanged(AttributeEvent e) {
    }

    @Override
    public void attributeValueChanged(AttributeEvent e) {
        this.configureComponent();
    }

    void configureComponent() {
        AttributeSet attrs = this.getAttributeSet();
        int bpp = Video.getColorModel(attrs.getValue(COLOR_OPTION)).getPixelSize();
        int xs = 31 - Integer.numberOfLeadingZeros(attrs.getValue(WIDTH_OPTION));
        int ys = 31 - Integer.numberOfLeadingZeros(attrs.getValue(HEIGHT_OPTION));
        this.setEnd(3, this.getLocation().translate(40, 0), BitWidth.create(xs), 1);
        this.setEnd(4, this.getLocation().translate(50, 0), BitWidth.create(ys), 1);
        this.setEnd(5, this.getLocation().translate(60, 0), BitWidth.create(bpp), 1);
        this.recomputeBounds();
        this.fireComponentInvalidated(new ComponentEvent(this));
    }

    private static class State
    implements ComponentState,
    Cloneable {
        public Value lastClock = null;
        public final BufferedImage img;
        public int lastX;
        public int lastY;
        public int color;

        State(BufferedImage img) {
            this.img = img;
            this.reset();
        }

        public void reset() {
            Graphics g = this.img.getGraphics();
            g.setColor(Color.YELLOW);
            g.fillRect(0, 0, this.img.getWidth(), this.img.getHeight());
        }

        @Override
        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        public boolean tick(Value clk) {
            boolean rising = this.lastClock == null || this.lastClock == Value.FALSE && clk == Value.TRUE;
            this.lastClock = clk;
            return rising;
        }
    }

    private static class Factory
    extends AbstractComponentFactory {
        private Factory() {
        }

        @Override
        public String getName() {
            return Video._ID;
        }

        @Override
        public String getDisplayName() {
            return Strings.S.get("rgbVideoComponent");
        }

        @Override
        public AttributeSet createAttributeSet() {
            return AttributeSets.fixedSet(ATTRIBUTES, new Object[]{BLINK_OPTIONS[0], RESET_OPTIONS[0], COLOR_OPTIONS[0], 128, 128, 2});
        }

        @Override
        public Component createComponent(Location loc, AttributeSet attrs) {
            return new Video(loc, attrs);
        }

        @Override
        public Bounds getOffsetBounds(AttributeSet attrs) {
            Integer s = attrs.getValue(SCALE_OPTION);
            Integer w = attrs.getValue(WIDTH_OPTION);
            Integer h = attrs.getValue(HEIGHT_OPTION);
            int bw = Math.max(s * w + 14, 100);
            int bh = Math.max(s * h + 14, 20);
            return Bounds.create(-30, -bh, bw, bh);
        }

        @Override
        public void paintIcon(ComponentDrawContext context, int x, int y, AttributeSet attrs) {
            Video.drawVideoIcon(context, x, y);
        }
    }
}

