/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.memory;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.gui.hex.HexFile;
import com.cburch.logisim.gui.hex.HexFrame;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.memory.Mem;
import com.cburch.logisim.std.memory.MemContents;
import com.cburch.logisim.std.memory.MemState;
import com.cburch.logisim.std.memory.RomAttributes;
import com.cburch.logisim.tools.MenuExtender;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

class MemMenu
implements ActionListener,
MenuExtender {
    private final Mem factory;
    private final Instance instance;
    private Project proj;
    private Frame frame;
    private CircuitState circState;
    private JMenuItem edit;
    private JMenuItem clear;
    private JMenuItem load;
    private JMenuItem save;

    MemMenu(Mem factory, Instance instance) {
        this.factory = factory;
        this.instance = instance;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src == this.edit) {
            this.doEdit();
        } else if (src == this.clear) {
            this.doClear();
        } else if (src == this.load) {
            this.doLoad();
        } else if (src == this.save) {
            this.doSave();
        }
    }

    @Override
    public void configureMenu(JPopupMenu menu, Project proj) {
        this.proj = proj;
        this.frame = proj.getFrame();
        this.circState = proj.getCircuitState();
        AttributeSet attrs = this.instance.getAttributeSet();
        if (attrs instanceof RomAttributes) {
            ((RomAttributes)attrs).setProject(proj);
        }
        boolean enabled = this.circState != null;
        this.edit = this.createItem(enabled, Strings.S.get("ramEditMenuItem"));
        this.clear = this.createItem(enabled, Strings.S.get("ramClearMenuItem"));
        this.load = this.createItem(enabled, Strings.S.get("ramLoadMenuItem"));
        this.save = this.createItem(enabled, Strings.S.get("ramSaveMenuItem"));
        menu.addSeparator();
        menu.add(this.edit);
        menu.add(this.clear);
        menu.add(this.load);
        menu.add(this.save);
    }

    private JMenuItem createItem(boolean enabled, String label) {
        JMenuItem ret = new JMenuItem(label);
        ret.setEnabled(enabled);
        ret.addActionListener(this);
        return ret;
    }

    private void doClear() {
        MemState s = this.factory.getState(this.instance, this.circState);
        boolean isAllZero = s.getContents().isClear();
        if (isAllZero) {
            return;
        }
        int choice = OptionPane.showConfirmDialog(this.frame, Strings.S.get("ramConfirmClearMsg"), Strings.S.get("ramConfirmClearTitle"), 0);
        if (choice == 0) {
            s.getContents().clear();
        }
    }

    private void doEdit() {
        if (this.factory.getState(this.instance, this.circState) == null) {
            return;
        }
        HexFrame frame = this.factory.getHexFrame(this.proj, this.instance, this.circState);
        frame.setVisible(true);
        frame.toFront();
    }

    private void doLoad() {
        MemContents m = this.factory.getState(this.instance, this.circState).getContents();
        HexFile.open(m, this.frame, this.proj, this.instance);
    }

    private void doSave() {
        MemContents m = this.factory.getState(this.instance, this.circState).getContents();
        HexFile.save(m, this.frame, this.proj, this.instance);
    }
}

