/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.memory;

import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.hdlgenerator.AbstractHdlGeneratorFactory;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.fpga.hdlgenerator.HdlPorts;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.memory.Mem;
import com.cburch.logisim.std.memory.RamAppearance;
import com.cburch.logisim.std.memory.RamAttributes;
import com.cburch.logisim.util.LineBuffer;

public class RamHdlGeneratorFactory
extends AbstractHdlGeneratorFactory {
    private static final String ByteArrayStr = "byteArray";
    private static final int ByteArrayId = -1;
    private static final String RestArrayStr = "restArray";
    private static final int RestArrayId = -2;
    private static final String MemArrayStr = "memoryArray";
    private static final int MemArrayId = -3;

    public RamHdlGeneratorFactory() {
        this.getWiresPortsDuringHDLWriting = true;
    }

    private void getGenerationTimeWiresPortsLineEnables(Netlist theNetlist, AttributeSet attrs) {
        int nrOfBits = attrs.getValue(Mem.DATA_ATTR).getWidth();
        int nrOfaddressLines = attrs.getValue(Mem.ADDR_ATTR).getWidth();
        int ramEntries = 1 << nrOfaddressLines;
        int dataLines = Math.max(1, RamAppearance.getNrLEPorts(attrs));
        this.myWires.addRegister("s_writeAddressReg", nrOfaddressLines).addRegister("s_readAddressReg", nrOfaddressLines).addWire("s_ramWriteAddress", nrOfaddressLines).addWire("s_ramReadAddress", nrOfaddressLines).addRegister("s_ramDataOut", nrOfBits).addWire("s_ramWe", 1).addRegister("s_weReg", 1).addRegister("s_tickDelayReg", dataLines + 1).addRegister("s_addressOffsetReg", nrOfaddressLines + 1);
        if (dataLines == 1) {
            this.myWires.addWire("s_ramDataIn", nrOfBits);
        } else {
            this.myWires.addRegister("s_ramDataIn", nrOfBits);
        }
        if (dataLines > 1) {
            for (int idx = 0; idx < dataLines; ++idx) {
                this.myWires.addRegister(String.format("s_dataIn%dReg", idx), nrOfBits).addRegister(String.format("s_dataOut%dReg", idx), nrOfBits).addRegister(String.format("s_lineEnable%dReg", idx), 1);
                this.myPorts.add("input", String.format("data%dIn", idx), nrOfBits, RamAppearance.getDataInIndex(idx, attrs)).add("output", String.format("data%dOut", idx), nrOfBits, RamAppearance.getDataOutIndex(idx, attrs)).add("input", String.format("lineEnable%dIn", idx), 1, RamAppearance.getLEIndex(idx, attrs));
            }
        } else {
            this.myWires.addRegister("s_dataInReg", nrOfBits).addRegister("s_dataOutReg", nrOfBits);
            this.myPorts.add("input", "dataIn", nrOfBits, RamAppearance.getDataInIndex(0, attrs)).add("output", "dataOut", nrOfBits, RamAppearance.getDataOutIndex(0, attrs));
        }
        this.myTypedWires.addArray(-3, MemArrayStr, nrOfBits, ramEntries).addWire("s_memContents", -3);
        this.myPorts.add("input", "address", nrOfaddressLines, RamAppearance.getAddrIndex(0, attrs)).add("input", "we", 1, RamAppearance.getWEIndex(0, attrs)).add("clock", HdlPorts.getClockName(1), 1, RamAppearance.getClkIndex(0, attrs));
    }

    private void getGenerationTimeWiresPortsByteEnables(Netlist theNetlist, AttributeSet attrs) {
        int nrOfBits = attrs.getValue(Mem.DATA_ATTR).getWidth();
        AttributeOption be = attrs.getValue(RamAttributes.ATTR_ByteEnables);
        boolean byteEnables = be != null && be.equals(RamAttributes.BUS_WITH_BYTEENABLES);
        int byteEnableOffset = RamAppearance.getBEIndex(0, attrs);
        int nrBePorts = RamAppearance.getNrBEPorts(attrs);
        int nrOfaddressLines = attrs.getValue(Mem.ADDR_ATTR).getWidth();
        int ramEntries = 1 << nrOfaddressLines;
        boolean truncated = nrOfBits % 8 != 0;
        this.myWires.addRegister("s_ramDataOut", nrOfBits).addRegister("s_tickDelayLine", 3).addRegister("s_dataInReg", nrOfBits).addRegister("s_writeAddressReg", nrOfaddressLines).addRegister("s_readAddressReg", nrOfaddressLines).addRegister("s_weReg", 1).addRegister("s_oeReg", 1).addRegister("s_dataOutReg", nrOfBits).addWire("s_ramAddress", nrOfaddressLines);
        if (byteEnables) {
            this.myWires.addRegister("s_byteEnableReg", nrBePorts);
            for (int idx = 0; idx < nrBePorts; ++idx) {
                this.myWires.addWire(String.format("s_byteEnable%d", idx), 1).addWire(String.format("s_we%d", idx), 1);
                this.myPorts.add("input", String.format("byteEnable%d", idx), 1, byteEnableOffset + nrBePorts - idx - 1);
            }
            this.myPorts.add("input", "oe", 1, RamAppearance.getOEIndex(0, attrs));
            int nrOfMems = nrBePorts;
            if (truncated) {
                this.myTypedWires.addArray(-2, RestArrayStr, nrOfBits % 8, ramEntries).addWire("s_truncMemContents", -2);
                --nrOfMems;
            }
            this.myTypedWires.addArray(-1, ByteArrayStr, 8, ramEntries);
            for (int mem = 0; mem < nrOfMems; ++mem) {
                this.myTypedWires.addWire(String.format("s_byteMem%dContents", mem), -1);
            }
        } else {
            this.myPorts.add("input", "oe", 1, Hdl.oneBit());
            this.myTypedWires.addArray(-3, MemArrayStr, nrOfBits, ramEntries).addWire("s_memContents", -3);
            this.myWires.addWire("s_we", 1).addWire("s_oe", 1);
        }
        this.myPorts.add("input", "address", nrOfaddressLines, RamAppearance.getAddrIndex(0, attrs)).add("input", "dataIn", nrOfBits, RamAppearance.getDataInIndex(0, attrs)).add("input", "we", 1, RamAppearance.getWEIndex(0, attrs)).add("output", "dataOut", nrOfBits, RamAppearance.getDataOutIndex(0, attrs)).add("clock", HdlPorts.getClockName(1), 1, RamAppearance.getClkIndex(0, attrs));
    }

    @Override
    public void getGenerationTimeWiresPorts(Netlist theNetlist, AttributeSet attrs) {
        if (attrs.getValue(Mem.ENABLES_ATTR).equals(Mem.USELINEENABLES)) {
            this.getGenerationTimeWiresPortsLineEnables(theNetlist, attrs);
        } else {
            this.getGenerationTimeWiresPortsByteEnables(theNetlist, attrs);
        }
    }

    private LineBuffer getModuleFunctionalityByteEnables(Netlist theNetlist, AttributeSet attrs) {
        int writeTick;
        LineBuffer contents = LineBuffer.getHdlBuffer().pair("clock", HdlPorts.getClockName(1)).pair("tick", HdlPorts.getTickName(1));
        AttributeOption be = attrs.getValue(RamAttributes.ATTR_ByteEnables);
        boolean byteEnables = be != null && be.equals(RamAttributes.BUS_WITH_BYTEENABLES);
        boolean syncRead = attrs.getValue(Mem.ASYNC_READ) == false;
        boolean readAfterWrite = attrs.containsAttribute(Mem.READ_ATTR) & attrs.getValue(Mem.READ_ATTR).equals(Mem.READAFTERWRITE);
        int n = writeTick = readAfterWrite ? 0 : 2;
        if (Hdl.isVhdl()) {
            int i;
            contents.empty().addVhdlKeywords().addRemarkBlock("The control signals are defined here");
            if (byteEnables) {
                for (i = 0; i < RamAppearance.getNrBEPorts(attrs); ++i) {
                    contents.add("s_byteEnable{{1}} <= s_byteEnableReg({{1}}) {{and}} s_tickDelayLine(2) {{and}} s_oeReg;", i).add("s_we{{1}}         <= s_byteEnableReg({{1}}) {{and}} s_tickDelayLine({{2}}) {{and}} s_weReg;", i, writeTick);
                }
            } else {
                contents.add("s_oe <= s_tickDelayLine(2) {{and}} s_oeReg;").add("s_we <= s_tickDelayLine({{1}}) {{and}} s_weReg;", writeTick);
            }
            contents.empty().addRemarkBlock("The input registers are defined here").add("inputRegs : {{process}}({{clock}}, {{tick}}, address, dataIn, we, oe) {{is}}\n{{begin}}\n   {{if}} (rising_edge({{clock}})) {{then}}\n");
            if (!syncRead) {
                contents.add("      {{if}} (s_tickDelayLine(0) = '1') {{then}}\n         s_readAddressReg  <= address;\n      {{end}} {{if}};\n");
            }
            contents.add("        {{if}} ({{tick}} = '1') {{then}}\n          s_dataInReg       <= dataIn;\n          s_writeAddressReg <= address;\n");
            if (syncRead) {
                contents.add("          s_readAddressReg  <= address;");
            }
            contents.add("          s_weReg           <= we;\n          s_oeReg           <= oe;\n");
            if (byteEnables) {
                for (i = 0; i < RamAppearance.getNrBEPorts(attrs); ++i) {
                    contents.add("         s_byteEnableReg({{1}}) <= byteEnable{{1}};", i);
                }
            }
            contents.add("      {{end}} {{if}};\n   {{end}} {{if}};\n{{end}} {{process}} inputRegs;\n").empty().add("tickPipeReg : {{process}}({{clock}}) {{is}}\n{{begin}}\n   {{if}} (rising_edge({{clock}})) {{then}}\n       s_tickDelayLine(0)          <= {{tick}};\n       s_tickDelayLine(2 {{downto}} 1) <= s_tickDelayLine(1 {{downto}} 0);\n   {{end}} {{if}};\n{{end}} {{process}} tickPipeReg;\n").empty().addRemarkBlock("The actual memorie(s) is(are) defined here");
            contents.add("s_ramAddress <= s_writeAddressReg {{when}} s_tickDelayLine({{1}}) = '1' {{else}} s_readAddressReg;", writeTick).empty();
            if (byteEnables) {
                boolean truncated = attrs.getValue(Mem.DATA_ATTR).getWidth() % 8 != 0;
                for (int i2 = 0; i2 < RamAppearance.getNrBEPorts(attrs); ++i2) {
                    contents.add("mem{{1}} : {{process}}({{clock}}, s_we{{1}}, s_dataInReg, s_ramAddress) {{is}}", i2).add("{{begin}}").add("   {{if}} (rising_edge({{clock}})) {{then}}").add("      {{if}} (s_we{{1}} = '1') {{then}}", i2);
                    int startIndex = i2 * 8;
                    int endIndex = i2 == RamAppearance.getNrBEPorts(attrs) - 1 ? attrs.getValue(Mem.DATA_ATTR).getWidth() - 1 : (i2 + 1) * 8 - 1;
                    String memName = i2 == RamAppearance.getNrBEPorts(attrs) - 1 && truncated ? "s_truncMemContents" : String.format("s_byteMem%dContents", i2);
                    contents.add("         {{1}}(to_integer(unsigned(s_ramAddress))) <= s_dataInReg({{2}} {{downto}} {{3}});", memName, endIndex, startIndex).add("      {{end}} {{if}};").add("      s_ramDataOut({{1}} {{downto}} {{2}}) <= {{3}}(to_integer(unsigned(s_ramAddress)));", endIndex, startIndex, memName).add("   {{end}} {{if}};").add("{{end}} {{process}} mem{{1}};", i2).add("");
                }
            } else {
                contents.add("mem : {{process}}({{clock}} , s_we, s_dataInReg, s_ramAddress) {{is}}\n{{begin}}\n   {{if}} (rising_edge({{clock}})) {{then}}\n      {{if}} (s_we = '1') {{then}}\n         s_memContents(to_integer(unsigned(s_ramAddress))) <= s_dataInReg;\n      {{end}} {{if}};\n      s_ramDataOut <= s_memContents(to_integer(unsigned(s_ramAddress)));\n   {{end}} {{if}};\n{{end}} {{process}} mem;\n");
            }
            contents.empty().addRemarkBlock("The output register is defined here");
            if (byteEnables) {
                for (i = 0; i < RamAppearance.getNrBEPorts(attrs); ++i) {
                    contents.add("res{{1}} : {{process}}({{clock}}, s_byteEnable{{1}}, s_ramDataOut) {{is}}", i).add("{{begin}}").add("   {{if}} (rising_edge({{clock}}) {{then}}").add("      {{if}} (s_byteEnable{{1}} = '1') {{then}}", i);
                    int startIndex = i * 8;
                    int endIndex = i == RamAppearance.getNrBEPorts(attrs) - 1 ? attrs.getValue(Mem.DATA_ATTR).getWidth() - 1 : (i + 1) * 8 - 1;
                    contents.add("         dataOut({{1}} {{downto}} {{2}}) <= s_ramDataOut({{1}} {{downto}} {{2}});", endIndex, startIndex).add("      {{end}} {{if}};").add("   {{end}} {{if}};").add("{{end}} {{process}} res{{1}};", i);
                }
            } else {
                contents.add("res : {{process}}({{clock}}, s_oe, s_ramDataOut) {{is}}\n{{begin}}\n   {{if}} (rising_edge({{clock}})) {{then}}\n      {{if}} (s_oe = '1') {{then}}\n        dataOut <= s_ramDataOut;\n      {{end}} {{if}};\n   {{end}} {{if}};\n{{end}} {{process}} res;\n");
            }
        } else {
            int i;
            contents.empty().addVhdlKeywords().addRemarkBlock("The control signals are defined here");
            if (byteEnables) {
                for (i = 0; i < RamAppearance.getNrBEPorts(attrs); ++i) {
                    contents.add("assign s_byteEnable{{1}} = s_byteEnableReg[{{1}}] & s_tickDelayLine[2] & s_oeReg;", i).add("assign s_we{{1}}         = s_byteEnableReg[{{1}}] & s_tickDelayLine[{{2}}] & s_weReg;", i, writeTick);
                }
            } else {
                contents.add("assign s_oe = s_tickDelayLine[2] & s_oeReg;").add("assign s_we = s_tickDelayLine[{{1}}] & s_weReg;", writeTick);
            }
            contents.empty().addRemarkBlock("The input registers are defined here").add("always @(posedge {{clock}})\nbegin\n");
            if (!syncRead) {
                contents.add("  s_readAddressReg <= (s_tickDelayLine[0] == 1'b1) ? address : s_readAddressReg;");
            }
            contents.add("   if ({{tick}} == 1'b1)\n     begin\n       s_dataInReg       <= dataIn;\n       s_writeAddressReg <= address;\n");
            if (syncRead) {
                contents.add("       s_readAddressReg  <= address;");
            }
            contents.add("       s_weReg           <= we;\n       s_oeReg           <= oe;\n");
            if (byteEnables) {
                for (i = 0; i < RamAppearance.getNrBEPorts(attrs); ++i) {
                    contents.add("       s_byteEnableReg[{{1}}] <= byteEnable{{1}};", i);
                }
            }
            contents.add("  end\nend\n").empty().add("always @(posedge {{clock}})\n  s_tickDelayLine <= {s_tickDelayLine[1:0], tick};\n").empty().addRemarkBlock("The actual memorie(s) is(are) defined here");
            contents.add("assign s_ramAddress = (s_tickDelayLine[{{1}}] == 1'b1) ? s_writeAddressReg : s_readAddressReg;", writeTick).empty();
            if (byteEnables) {
                boolean truncated = attrs.getValue(Mem.DATA_ATTR).getWidth() % 8 != 0;
                for (int i3 = 0; i3 < RamAppearance.getNrBEPorts(attrs); ++i3) {
                    contents.add("always @(posedge {{clock}})\n  begin\n");
                    contents.add("    if (s_we{{1}} == 1'b1)", i3);
                    int startIndex = i3 * 8;
                    int endIndex = i3 == RamAppearance.getNrBEPorts(attrs) - 1 ? attrs.getValue(Mem.DATA_ATTR).getWidth() - 1 : (i3 + 1) * 8 - 1;
                    String memName = i3 == RamAppearance.getNrBEPorts(attrs) - 1 && truncated ? "s_truncMemContents" : String.format("s_byteMem%dContents", i3);
                    contents.add("      {{1}}[s_ramAddress] <= s_dataInReg[{{2}}:{{3}}];", memName, endIndex, startIndex).add("    s_ramDataOut[{{1}}:{{2}}] <= {{3}}[s_ramAddress];", endIndex, startIndex, memName).add("  end").empty();
                }
            } else {
                contents.add("always @(posedge clock)\n  begin\n    if (s_we == 1'b1)\n      s_memContents[s_ramAddress] <= s_dataInReg;\n    s_ramDataOut <= s_memContents[s_ramAddress];\n  end\n");
            }
            contents.empty().addRemarkBlock("The output register is defined here").add("assign dataOut = s_dataOutReg;");
            if (byteEnables) {
                for (i = 0; i < RamAppearance.getNrBEPorts(attrs); ++i) {
                    contents.add("always @(posedge {{clock}})").add("  if (s_byteEnable{{1}} == 1'b1)", i);
                    int startIndex = i * 8;
                    int endIndex = i == RamAppearance.getNrBEPorts(attrs) - 1 ? attrs.getValue(Mem.DATA_ATTR).getWidth() - 1 : (i + 1) * 8 - 1;
                    contents.add("    s_dataOutReg[{{1}}:{{2}}] <= s_ramDataOut[{{1}}:{{2}}];", endIndex, startIndex).empty();
                }
            } else {
                contents.add("always @(posedge {{clock}})\n  if (s_oe == 1'b1)\n    s_dataOutReg <= s_ramDataOut;\n");
            }
        }
        return contents.empty();
    }

    private LineBuffer getModuleFunctionalityLineEnables(Netlist theNetlist, AttributeSet attrs) {
        LineBuffer contents = LineBuffer.getHdlBuffer().pair("clock", HdlPorts.getClockName(1)).pair("tick", HdlPorts.getTickName(1));
        int dataLines = Math.max(1, RamAppearance.getNrLEPorts(attrs));
        int nrOfaddressLines = attrs.getValue(Mem.ADDR_ATTR).getWidth();
        if (Hdl.isVhdl()) {
            int idx;
            contents.empty().addVhdlKeywords().addRemarkBlock("The synchronous semi-dual-ported memory is defined here");
            contents.add(String.format("s_ramWriteAddress <= std_logic_vector(unsigned(s_writeAddressReg) + unsigned(s_addressOffsetReg(%d {{downto}} 0)));", nrOfaddressLines - 1));
            contents.add(String.format("s_ramReadAddress <= std_logic_vector(unsigned(s_readAddressReg) + unsigned(s_addressOffsetReg(%d {{downto}} 0)));", nrOfaddressLines - 1));
            contents.add("\nblockramwrite : {{process}}({{clock}}) {{is}}\n{{begin}}\n  {{if}} (rising_edge({{clock}})) {{then}}\n    {{if}} (s_ramWe = '1') {{then}}\n      s_memContents(to_integer(unsigned(s_ramWriteAddress))) <= s_ramDataIn;\n    {{end}} {{if}};\n  {{end}} {{if}};\n{{end}} {{process}} blockramwrite;\n\nblockramread : {{process}}({{clock}}) {{is}}\n{{begin}}\n  {{if}} (falling_edge({{clock}})) {{then}}\n    s_ramDataOut <= s_memContents(to_integer(unsigned(s_ramReadAddress)));\n  {{end}} {{if}};\n{{end}} {{process}} blockramread;\n");
            contents.empty().addRemarkBlock("The input registers are defined here");
            contents.add("inputRegs : {{process}}({{clock}}) {{is}}\n{{begin}}\n  {{if}} (rising_edge({{clock}})) {{then}}\n    {{if}} (s_tickDelayReg(0) = '1') {{then}}\n      s_readAddressReg <= address;\n    {{end}} {{if}};\n    {{if}} ({{tick}} = '1') {{then}}\n      s_writeAddressReg <= address;\n      s_weReg           <= we;\n");
            if (dataLines == 1) {
                contents.add("      s_dataInReg <= dataIn;");
            } else {
                for (idx = 0; idx < dataLines; ++idx) {
                    contents.add(String.format("      s_dataIn%dReg <= data%dIn;", idx, idx));
                    contents.add(String.format("      s_lineEnable%dReg <= lineEnable%dIn;", idx, idx));
                }
            }
            contents.add("    {{end}} {{if}};\n  {{end}} {{if}};\n{{end}} {{process}} inputRegs;\n");
            contents.empty().addRemarkBlock("The FSM's are defined here");
            contents.add("fsms : {{process}}({{clock}}) {{is}}\n{{begin}}\n   {{if}} (rising_edge({{clock}})) {{then}}\n      s_tickDelayReg(0)  <= {{tick}};\n");
            if (dataLines == 1) {
                contents.add("      s_tickDelayReg(1)  <= s_tickDelayReg(0);");
            } else {
                contents.add(String.format("      s_tickDelayReg(%d {{downto}} 1) <= s_tickDelayReg(%d {{downto}} 0);", dataLines, dataLines - 1));
            }
            contents.add("      {{if}} (s_tickDelayReg(0) = '1') {{then}}\n        s_addressOffsetReg <= (OTHERS => '0');\n");
            contents.add(String.format("      {{elsif}} (unsigned(s_addressOffsetReg) < to_unsigned(%d,%d)) {{then}}", dataLines, nrOfaddressLines + 1));
            contents.add(String.format("       s_addressOffsetReg <= std_logic_vector(unsigned(s_addressOffsetReg) + to_unsigned(1,%d));", nrOfaddressLines + 1));
            contents.add("      {{end}} {{if}};\n   {{end}} {{if}};\n{{end}} {{process}} fsms;\n");
            contents.empty().addRemarkBlock("Here the RamDatIn is defined");
            if (dataLines == 1) {
                contents.add("s_ramDataIn <= s_dataInReg;");
            } else {
                contents.add("{{with}} (s_addressOffsetReg) {{select}} s_ramDataIn <=");
                for (idx = dataLines - 1; idx > 0; --idx) {
                    String binValue = Integer.toBinaryString(idx);
                    StringBuffer extendedBinValue = new StringBuffer();
                    while (extendedBinValue.length() < nrOfaddressLines + 1 - binValue.length()) {
                        extendedBinValue.append("0");
                    }
                    extendedBinValue.append(binValue);
                    contents.add(String.format("  s_dataIn%dReg {{when}} \"%s\",", idx, extendedBinValue));
                }
                contents.add("               s_dataIn0Reg {{when}} {{others}};");
            }
            contents.empty().addRemarkBlock("Here the RamDataOut is defined");
            if (dataLines == 1) {
                contents.add("dataOut <= s_dataOutReg;\n\ndataOutReg : {{process}} ({{clock}}) {{is}}\n{{begin}}\n  {{if}} (rising_edge({{clock}})) {{then}}\n    {{if}} (s_tickDelayReg(1) = '1') {{then}}\n      s_dataOutReg <= s_ramDataOut;\n    {{end}} {{if}};\n  {{end}} {{if}};\n{{end}} {{process}} dataOutReg;\n");
            } else {
                for (idx = 0; idx < dataLines; ++idx) {
                    contents.add(String.format("data%dOut <= s_dataOut%dReg;", idx, idx));
                }
                contents.add("\ndataOutRegs : {{process}} ({{clock}}) {{is}}\n{{begin}}\n  {{if}} (rising_edge({{clock}})) {{then}}\n");
                for (idx = 0; idx < dataLines; ++idx) {
                    contents.add(String.format("    {{if}} (s_tickDelayReg(%d) = '1') {{then}}", idx + 1));
                    contents.add(String.format("      s_dataOut%dReg <= s_ramDataOut;", idx));
                    contents.add("    {{end}} {{if}};");
                }
                contents.add("  {{end}} {{if}};\n{{end}} {{process}} dataOutRegs;\n");
            }
            contents.empty().addRemarkBlock("Here the Ram write enable is defined");
            if (dataLines == 1) {
                contents.add("s_ramWe <= s_weReg {{and}} s_tickDelayReg(1);");
            } else {
                contents.add("s_ramWe <= s_weReg {{and}} (");
                for (idx = 0; idx < dataLines; ++idx) {
                    contents.add(String.format("          (s_lineEnable%dReg {{and}} s_tickDelayReg(%d))%s", idx, idx + 1, idx == dataLines - 1 ? ");" : " {{or}}"));
                }
            }
        } else {
            int idx;
            contents.empty().addRemarkBlock("The synchronous semi-dual-ported memory is defined here");
            contents.add(String.format("assign s_ramWriteAddress = s_writeAddressReg + s_addressOffsetReg[%d:0];", nrOfaddressLines - 1));
            contents.add(String.format("assign s_ramReadAddress = s_readAddressReg + s_addressOffsetReg[%d:0];", nrOfaddressLines - 1));
            contents.empty();
            contents.add("always @(posedge clock)\n  if (s_ramWe == 1'b1) s_memContents[s_ramWriteAddress] <= s_ramDataIn;\n\nalways @(negedge clock)\n  s_ramDataOut <= s_memContents[s_ramReadAddress];\n");
            contents.empty().addRemarkBlock("The input registers are defined here");
            contents.add("always @(posedge clock)\n  begin\n    if (s_tickDelayReg[0] == 1'b1)\n      s_readAddressReg <= address;\n    if ({{tick}} == 1'b1)\n      begin\n        s_writeAddressReg     <= address;\n        s_weReg               <= we;\n");
            if (dataLines == 1) {
                contents.add("        s_dataInReg      <= dataIn;");
            } else {
                for (idx = 0; idx < dataLines; ++idx) {
                    contents.add(String.format("        s_dataIn%dReg     <= data%dIn;", idx, idx));
                    contents.add(String.format("        s_lineEnable%dReg <= lineEnable%dIn;", idx, idx));
                }
            }
            contents.add("      end\n    end\n");
            contents.empty().addRemarkBlock("The FSM's are defined here");
            contents.add("always @(posedge clock)\n  begin\n    s_tickDelayReg[0] <= {{tick}};\n");
            if (dataLines == 1) {
                contents.add("    s_tickDelayReg[1] <= s_tickDelayReg[0];");
            } else {
                contents.add(String.format("    s_tickDelayReg[%d:1] <= s_tickDelayReg[%d:0];", dataLines, dataLines - 1));
            }
            contents.add(String.format("    s_addressOffsetReg <= (s_tickDelayReg[0] == 1'b1) ? %d'd0 :", nrOfaddressLines + 1));
            contents.add(String.format("                          s_addressOffsetReg != %d'd%d ? s_addressOffsetReg + %d'd1 :", nrOfaddressLines + 1, dataLines, nrOfaddressLines + 1));
            contents.add("                          s_addressOffsetReg;\n  end\n");
            contents.empty().addRemarkBlock("Here the RamDatIn is defined");
            if (dataLines == 1) {
                contents.add("assign s_ramDataIn = s_dataInReg;");
            } else {
                contents.add("always @*\n  case (s_addressOffsetReg)\n");
                for (idx = dataLines - 1; idx > 0; --idx) {
                    contents.add(String.format("    %d'd%d    : s_ramDataIn <= s_dataIn%dReg;", nrOfaddressLines + 1, idx, idx));
                }
                contents.add("    default : s_ramDataIn <= s_dataIn0Reg;\n  endcase;\n");
            }
            contents.empty().addRemarkBlock("Here the RamDatout is defined");
            if (dataLines == 1) {
                contents.add("assign dataOut = s_dataOutReg;\n\nalways @(posedge clock)\n  s_dataOutReg <= (s_tickDelayReg[1] == 1'b1) ? s_ramDataOut : s_dataOutReg;\n");
            } else {
                for (idx = 0; idx < dataLines; ++idx) {
                    contents.add(String.format("assign data%dOut = s_dataOut%dReg;", idx, idx));
                }
                contents.add("\nalways @(posedge clock)\n  begin\n");
                for (idx = 0; idx < dataLines; ++idx) {
                    contents.add(String.format("    s_dataOut%dReg <= (s_tickDelayReg[%d] == 1'b1) ? s_ramDataOut : s_dataOut%dReg;", idx, idx + 1, idx));
                }
                contents.add("  end\n");
            }
            contents.empty().addRemarkBlock("Here the Ram write enable is defined");
            if (dataLines == 1) {
                contents.add("assign s_ramWe = s_weReg & s_tickDelayReg[1];");
            } else {
                contents.add("assign s_ramWe = s_weReg & (");
                for (idx = 0; idx < dataLines; ++idx) {
                    contents.add(String.format("                 (s_lineEnable%dReg & s_tickDelayReg[%d])%s", idx, idx + 1, idx == dataLines - 1 ? ");" : "|"));
                }
            }
        }
        return contents.empty();
    }

    @Override
    public LineBuffer getModuleFunctionality(Netlist theNetlist, AttributeSet attrs) {
        if (attrs.getValue(Mem.ENABLES_ATTR).equals(Mem.USELINEENABLES)) {
            return this.getModuleFunctionalityLineEnables(theNetlist, attrs);
        }
        return this.getModuleFunctionalityByteEnables(theNetlist, attrs);
    }

    @Override
    public boolean isHdlSupportedTarget(AttributeSet attrs) {
        if (attrs == null) {
            return false;
        }
        AttributeOption busVal = attrs.getValue(RamAttributes.ATTR_DBUS);
        boolean separate = busVal != null && busVal.equals(RamAttributes.BUS_SEP);
        AttributeOption trigger = attrs.getValue(StdAttr.TRIGGER);
        boolean asynch = trigger == null || trigger.equals(StdAttr.TRIG_HIGH) || trigger.equals(StdAttr.TRIG_LOW);
        boolean clearPin = attrs.getValue(RamAttributes.CLEAR_PIN) == null ? false : attrs.getValue(RamAttributes.CLEAR_PIN);
        boolean isLineControlled = attrs.getValue(Mem.ENABLES_ATTR).equals(Mem.USELINEENABLES);
        return separate && !asynch && !clearPin || isLineControlled && !clearPin;
    }
}

