/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.memory;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.fpga.designrulecheck.netlistComponent;
import com.cburch.logisim.gui.icons.RandomIcon;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceData;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstanceLogger;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.memory.ClockState;
import com.cburch.logisim.std.memory.RandomHdlGeneratorFactory;
import com.cburch.logisim.tools.key.BitWidthConfigurator;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.StringUtil;
import java.awt.Color;
import java.awt.Graphics;

public class Random
extends InstanceFactory {
    public static final String _ID = "Random";
    static final Attribute<Integer> ATTR_SEED = Attributes.forInteger("seed", Strings.S.getter("randomSeedAttr"));
    public static final int OUT = 0;
    public static final int CK = 1;
    public static final int NXT = 2;
    public static final int RST = 3;

    public Random() {
        super(_ID, Strings.S.getter("randomComponent"), new RandomHdlGeneratorFactory());
        this.setAttributes(new Attribute[]{StdAttr.WIDTH, ATTR_SEED, StdAttr.EDGE_TRIGGER, StdAttr.LABEL, StdAttr.LABEL_FONT, StdAttr.APPEARANCE}, new Object[]{BitWidth.create(8), 0, StdAttr.TRIG_RISING, "", StdAttr.DEFAULT_LABEL_FONT, AppPreferences.getDefaultAppearance()});
        this.setKeyConfigurator(new BitWidthConfigurator(StdAttr.WIDTH));
        this.setOffsetBounds(Bounds.create(0, 0, 80, 90));
        this.setIcon(new RandomIcon());
        this.setInstanceLogger(Logger.class);
    }

    @Override
    public Bounds getOffsetBounds(AttributeSet attrs) {
        if (attrs.getValue(StdAttr.APPEARANCE) == StdAttr.APPEAR_CLASSIC) {
            return Bounds.create(0, 0, 40, 40);
        }
        return Bounds.create(0, 0, 80, 90);
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        instance.addAttributeListener();
        this.updatePorts(instance);
        Bounds bds = instance.getBounds();
        instance.setTextField(StdAttr.LABEL, StdAttr.LABEL_FONT, bds.getX() + bds.getWidth() / 2, bds.getY() - 3, 0, 1);
    }

    private void updatePorts(Instance instance) {
        Port[] ps = new Port[4];
        if (instance.getAttributeValue(StdAttr.APPEARANCE) == StdAttr.APPEAR_CLASSIC) {
            ps[0] = new Port(40, 20, "output", StdAttr.WIDTH);
            ps[1] = new Port(10, 40, "input", 1);
            ps[2] = new Port(0, 30, "input", 1);
            ps[3] = new Port(30, 40, "input", 1);
        } else {
            ps[0] = new Port(80, 80, "output", StdAttr.WIDTH);
            ps[1] = new Port(0, 50, "input", 1);
            ps[2] = new Port(0, 40, "input", 1);
            ps[3] = new Port(0, 30, "input", 1);
        }
        ps[0].setToolTip(Strings.S.getter("randomQTip"));
        ps[1].setToolTip(Strings.S.getter("randomClockTip"));
        ps[2].setToolTip(Strings.S.getter("randomNextTip"));
        ps[3].setToolTip(Strings.S.getter("randomResetTip"));
        instance.setPorts(ps);
    }

    @Override
    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        if (attr == StdAttr.APPEARANCE) {
            instance.recomputeBounds();
            this.updatePorts(instance);
        }
    }

    private void drawControl(InstancePainter painter, int xpos, int ypos, int nrOfBits) {
        Graphics g = painter.getGraphics();
        GraphicsUtil.switchToWidth(g, 2);
        g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
        g.drawLine(xpos + 10, ypos, xpos + 70, ypos);
        g.drawLine(xpos + 10, ypos, xpos + 10, ypos + 60);
        g.drawLine(xpos + 70, ypos, xpos + 70, ypos + 60);
        g.drawLine(xpos + 10, ypos + 60, xpos + 20, ypos + 60);
        g.drawLine(xpos + 60, ypos + 60, xpos + 70, ypos + 60);
        g.drawLine(xpos + 20, ypos + 60, xpos + 20, ypos + 70);
        g.drawLine(xpos + 60, ypos + 60, xpos + 60, ypos + 70);
        String Name2 = "RNG" + nrOfBits;
        GraphicsUtil.drawText(g, Name2, xpos + 40, ypos + 8, 0, 0);
        g.drawLine(xpos, ypos + 30, xpos + 10, ypos + 30);
        GraphicsUtil.drawText(g, "R", xpos + 20, ypos + 30, -1, 0);
        painter.drawPort(3);
        g.drawLine(xpos, ypos + 40, xpos + 10, ypos + 40);
        GraphicsUtil.drawText(g, "EN", xpos + 20, ypos + 40, -1, 0);
        painter.drawPort(2);
        painter.drawClockSymbol(xpos + 10, ypos + 50);
        GraphicsUtil.switchToWidth(g, 2);
        if (painter.getAttributeValue(StdAttr.EDGE_TRIGGER).equals(StdAttr.TRIG_FALLING)) {
            g.drawOval(xpos, ypos + 45, 10, 10);
        } else {
            g.drawLine(xpos, ypos + 50, xpos + 10, ypos + 50);
        }
        painter.drawPort(1);
        GraphicsUtil.switchToWidth(g, 1);
    }

    private void drawData(InstancePainter painter, int xpos, int ypos, int nrOfBits, int value) {
        Graphics g = painter.getGraphics();
        GraphicsUtil.switchToWidth(g, 2);
        g.drawRect(xpos, ypos, 80, 20);
        if (painter.getShowState()) {
            String str = StringUtil.toHexString(nrOfBits, value);
            GraphicsUtil.drawCenteredText(g, str, xpos + 40, ypos + 10);
        }
        painter.drawPort(0);
        GraphicsUtil.switchToWidth(g, 1);
    }

    private void paintInstanceClassic(InstancePainter painter) {
        String a;
        Graphics g = painter.getGraphics();
        Bounds bds = painter.getBounds();
        StateData state = (StateData)painter.getData();
        BitWidth widthVal = painter.getAttributeValue(StdAttr.WIDTH);
        int width = widthVal == null ? 8 : widthVal.getWidth();
        String b = null;
        if (painter.getShowState()) {
            int val = state == null ? 0 : state.value;
            String str = StringUtil.toHexString(width, val);
            if (str.length() <= 4) {
                a = str;
            } else {
                int split = str.length() - 4;
                a = str.substring(0, split);
                b = str.substring(split);
            }
        } else {
            a = Strings.S.get("randomLabel");
            b = Strings.S.get("randomWidthLabel", "" + widthVal.getWidth());
        }
        g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
        painter.drawBounds();
        g.setColor(painter.getAttributeValue(StdAttr.LABEL_COLOR));
        painter.drawLabel();
        if (b == null) {
            painter.drawPort(0, "Q", Direction.WEST);
        } else {
            painter.drawPort(0);
        }
        g.setColor(new Color(AppPreferences.COMPONENT_SECONDARY_COLOR.get()));
        painter.drawPort(3, "0", Direction.SOUTH);
        painter.drawPort(2, Strings.S.get("memEnableLabel"), Direction.EAST);
        g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
        painter.drawClock(1, Direction.NORTH);
        if (b == null) {
            GraphicsUtil.drawText(g, a, bds.getX() + 20, bds.getY() + 4, 0, -1);
        } else {
            GraphicsUtil.drawText(g, a, bds.getX() + 20, bds.getY() + 3, 0, -1);
            GraphicsUtil.drawText(g, b, bds.getX() + 20, bds.getY() + 15, 0, -1);
        }
    }

    private void paintInstanceEvolution(InstancePainter painter) {
        Bounds bds = painter.getBounds();
        int x = bds.getX();
        int y = bds.getY();
        StateData state = (StateData)painter.getData();
        int val = state == null ? 0 : state.value;
        BitWidth widthVal = painter.getAttributeValue(StdAttr.WIDTH);
        int width = widthVal == null ? 8 : widthVal.getWidth();
        painter.drawLabel();
        this.drawControl(painter, x, y, width);
        this.drawData(painter, x, y + 70, width, val);
    }

    @Override
    public String getHDLName(AttributeSet attrs) {
        return "LogisimRNG";
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        if (painter.getAttributeValue(StdAttr.APPEARANCE) == StdAttr.APPEAR_CLASSIC) {
            this.paintInstanceClassic(painter);
        } else {
            this.paintInstanceEvolution(painter);
        }
    }

    @Override
    public void propagate(InstanceState state) {
        StateData data = (StateData)state.getData();
        if (data == null) {
            data = new StateData(state.getAttributeValue(ATTR_SEED));
            state.setData(data);
        }
        BitWidth dataWidth = state.getAttributeValue(StdAttr.WIDTH);
        AttributeOption triggerType = state.getAttributeValue(StdAttr.EDGE_TRIGGER);
        boolean triggered = data.updateClock(state.getPortValue(1), triggerType);
        data.propagateReset(state.getPortValue(3), state.getAttributeValue(ATTR_SEED));
        if (state.getPortValue(3) == Value.TRUE) {
            data.reset(state.getAttributeValue(ATTR_SEED));
        } else if (triggered && state.getPortValue(2) != Value.FALSE) {
            data.step();
        }
        state.setPort(0, Value.createKnown(dataWidth, (long)data.value), 4);
    }

    @Override
    public boolean checkForGatedClocks(netlistComponent comp) {
        return true;
    }

    @Override
    public int[] clockPinIndex(netlistComponent comp) {
        return new int[]{1};
    }

    public static class Logger
    extends InstanceLogger {
        @Override
        public String getLogName(InstanceState state, Object option) {
            String ret = state.getAttributeValue(StdAttr.LABEL);
            return ret != null && !ret.equals("") ? ret : null;
        }

        @Override
        public BitWidth getBitWidth(InstanceState state, Object option) {
            return state.getAttributeValue(StdAttr.WIDTH);
        }

        @Override
        public Value getLogValue(InstanceState state, Object option) {
            StateData data;
            BitWidth dataWidth = state.getAttributeValue(StdAttr.WIDTH);
            if (dataWidth == null) {
                dataWidth = BitWidth.create(0);
            }
            if ((data = (StateData)state.getData()) == null) {
                return Value.createKnown(dataWidth, 0L);
            }
            return Value.createKnown(dataWidth, (long)data.value);
        }

        @Override
        public boolean isInput(InstanceState state, Object option) {
            return true;
        }
    }

    private static class StateData
    extends ClockState
    implements InstanceData {
        private static final long MULTIPLIER = 25214903917L;
        private static final long ADDEND = 11L;
        private static final long MASK = 0xFFFFFFFFFFFFL;
        private long initSeed;
        private long curSeed;
        private int value;
        private long resetValue;
        private Value oldReset;

        public StateData(Object seed) {
            this.initSeed = this.curSeed = this.getRandomSeed(seed);
            this.resetValue = this.curSeed;
            this.value = (int)this.initSeed;
            this.oldReset = Value.UNKNOWN;
        }

        private void propagateReset(Value reset, Object seed) {
            if (this.oldReset == Value.FALSE && reset == Value.TRUE) {
                this.resetValue = this.getRandomSeed(seed);
            }
            this.oldReset = reset;
        }

        public void reset(Object seed) {
            this.initSeed = this.resetValue;
            this.curSeed = this.resetValue;
            this.value = (int)this.resetValue;
        }

        private long getRandomSeed(Object seed) {
            long retValue;
            long l = retValue = seed instanceof Integer ? (long)((Integer)seed).intValue() : 0L;
            if (retValue == 0L && (retValue = (System.currentTimeMillis() ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL) == this.initSeed) {
                retValue = retValue + 25214903917L & 0xFFFFFFFFFFFFL;
            }
            return retValue;
        }

        void step() {
            long v = this.curSeed;
            this.curSeed = v = v * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
            this.value = (int)(v >> 12);
        }
    }
}

