/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.memory;

import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstancePoker;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.memory.RegisterData;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class RegisterPoker
extends InstancePoker {
    private long initValue;
    private long curValue;

    @Override
    public boolean init(InstanceState state, MouseEvent e) {
        RegisterData data = (RegisterData)state.getData();
        if (data == null) {
            data = new RegisterData(state.getAttributeValue(StdAttr.WIDTH));
            state.setData(data);
        }
        this.curValue = this.initValue = data.value.isFullyDefined() ? data.value.toLongValue() : 0L;
        return true;
    }

    @Override
    public void keyTyped(InstanceState state, KeyEvent e) {
        int val = Character.digit(e.getKeyChar(), 16);
        if (val < 0) {
            return;
        }
        BitWidth dataWidth = state.getAttributeValue(StdAttr.WIDTH);
        if (dataWidth == null) {
            dataWidth = BitWidth.create(8);
        }
        this.curValue = this.curValue * 16L + (long)val & dataWidth.getMask();
        RegisterData data = (RegisterData)state.getData();
        data.value = Value.createKnown(dataWidth, this.curValue);
        state.fireInvalidated();
    }

    @Override
    public void keyPressed(InstanceState state, KeyEvent e) {
        BitWidth dataWidth = state.getAttributeValue(StdAttr.WIDTH);
        if (dataWidth == null) {
            dataWidth = BitWidth.create(8);
        }
        if (e.getKeyCode() == 38) {
            long maxVal = dataWidth.getMask();
            if (this.curValue != maxVal) {
                ++this.curValue;
                RegisterData data = (RegisterData)state.getData();
                data.value = Value.createKnown(dataWidth, this.curValue);
                state.fireInvalidated();
            }
        } else if (e.getKeyCode() == 40 && this.curValue != 0L) {
            --this.curValue;
            RegisterData data = (RegisterData)state.getData();
            data.value = Value.createKnown(dataWidth, this.curValue);
            state.fireInvalidated();
        }
    }

    @Override
    public void paint(InstancePainter painter) {
        Bounds bds = painter.getBounds();
        BitWidth dataWidth = painter.getAttributeValue(StdAttr.WIDTH);
        int width = dataWidth == null ? 8 : dataWidth.getWidth();
        int len = (width + 3) / 4;
        Graphics g = painter.getGraphics();
        g.setColor(Color.RED);
        int wid = 8 * len + 2;
        g.drawRect(bds.getX() + (bds.getWidth() - wid) / 2, bds.getY(), wid, 16);
        g.setColor(Color.BLACK);
    }
}

