/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.memory;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.fpga.designrulecheck.netlistComponent;
import com.cburch.logisim.gui.icons.ShifterIcon;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.InstanceStateImpl;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.memory.ShiftRegisterData;
import com.cburch.logisim.std.memory.ShiftRegisterHdlGeneratorFactory;
import com.cburch.logisim.std.memory.ShiftRegisterLogger;
import com.cburch.logisim.std.memory.ShiftRegisterPoker;
import com.cburch.logisim.tools.key.BitWidthConfigurator;
import com.cburch.logisim.tools.key.IntegerConfigurator;
import com.cburch.logisim.tools.key.JoinedConfigurator;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.StringUtil;
import java.awt.Color;
import java.awt.Graphics;

public class ShiftRegister
extends InstanceFactory {
    public static final String _ID = "Shift Register";
    static final Attribute<Integer> ATTR_LENGTH = Attributes.forIntegerRange("length", Strings.S.getter("shiftRegLengthAttr"), 1, 64);
    static final Attribute<Boolean> ATTR_LOAD = Attributes.forBoolean("parallel", Strings.S.getter("shiftRegParallelAttr"));
    static final int IN = 0;
    static final int SH = 1;
    public static final int CK = 2;
    static final int CLR = 3;
    static final int OUT = 4;
    static final int LD = 5;
    static final int symbolWidth = 100;

    public ShiftRegister() {
        super(_ID, Strings.S.getter("shiftRegisterComponent"), new ShiftRegisterHdlGeneratorFactory());
        this.setAttributes(new Attribute[]{StdAttr.WIDTH, ATTR_LENGTH, ATTR_LOAD, StdAttr.EDGE_TRIGGER, StdAttr.LABEL, StdAttr.LABEL_FONT, StdAttr.APPEARANCE}, new Object[]{BitWidth.ONE, 8, Boolean.TRUE, StdAttr.TRIG_RISING, "", StdAttr.DEFAULT_LABEL_FONT, AppPreferences.getDefaultAppearance()});
        this.setKeyConfigurator(JoinedConfigurator.create(new IntegerConfigurator(ATTR_LENGTH, 1, 64, 0), new BitWidthConfigurator(StdAttr.WIDTH)));
        this.setIcon(new ShifterIcon());
        this.setInstanceLogger(ShiftRegisterLogger.class);
        this.setInstancePoker(ShiftRegisterPoker.class);
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        this.configurePorts(instance);
        instance.addAttributeListener();
    }

    private void configurePorts(Instance instance) {
        Port[] ps;
        int len;
        BitWidth widthObj = instance.getAttributeValue(StdAttr.WIDTH);
        int width = widthObj.getWidth();
        Boolean parallelObj = instance.getAttributeValue(ATTR_LOAD);
        Bounds bds = instance.getBounds();
        Integer lenObj = instance.getAttributeValue(ATTR_LENGTH);
        int n = len = lenObj == null ? 8 : lenObj;
        if (instance.getAttributeValue(StdAttr.APPEARANCE) == StdAttr.APPEAR_CLASSIC) {
            if (parallelObj == null || parallelObj.booleanValue()) {
                ps = new Port[6 + 2 * len];
                ps[5] = new Port(10, -20, "input", 1);
                ps[5].setToolTip(Strings.S.getter("shiftRegLoadTip"));
                for (int i = 0; i < len; ++i) {
                    ps[6 + 2 * i] = new Port(20 + 10 * i, -20, "input", width);
                    ps[6 + 2 * i + 1] = new Port(20 + 10 * i, 20, "output", width);
                }
            } else {
                ps = new Port[5];
            }
            ps[4] = new Port(bds.getWidth(), 0, "output", width);
            ps[0] = new Port(0, 0, "input", width);
            ps[1] = new Port(0, -10, "input", 1);
            ps[2] = new Port(0, 10, "input", 1);
            ps[3] = new Port(10, 20, "input", 1);
        } else {
            if (parallelObj == null || parallelObj.booleanValue()) {
                ps = new Port[6 + 2 * len - 1];
                ps[5] = new Port(0, 30, "input", 1);
                ps[5].setToolTip(Strings.S.getter("shiftRegLoadTip"));
                for (int i = 0; i < len; ++i) {
                    ps[6 + 2 * i] = new Port(0, 90 + i * 20, "input", width);
                    if (i >= len - 1) continue;
                    ps[6 + 2 * i + 1] = new Port(120, 90 + i * 20, "output", width);
                }
            } else {
                ps = new Port[5];
            }
            ps[4] = new Port(120, 70 + len * 20, "output", width);
            ps[0] = new Port(0, 80, "input", width);
            ps[1] = new Port(0, 40, "input", 1);
            ps[2] = new Port(0, 50, "input", 1);
            ps[3] = new Port(0, 20, "input", 1);
        }
        ps[4].setToolTip(Strings.S.getter("shiftRegOutTip"));
        ps[1].setToolTip(Strings.S.getter("shiftRegShiftTip"));
        ps[0].setToolTip(Strings.S.getter("shiftRegInTip"));
        ps[2].setToolTip(Strings.S.getter("shiftRegClockTip"));
        ps[3].setToolTip(Strings.S.getter("shiftRegClearTip"));
        instance.setPorts(ps);
        instance.setTextField(StdAttr.LABEL, StdAttr.LABEL_FONT, bds.getX() + bds.getWidth() / 2, bds.getY() - 3, 0, 1);
    }

    private void drawControl(InstancePainter painter, int xpos, int ypos, int nr_of_stages, int nr_of_bits, boolean has_load, boolean active_low_clock) {
        Graphics g = painter.getGraphics();
        GraphicsUtil.switchToWidth(g, 2);
        int blockwidth = 100;
        g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
        g.drawLine(xpos + 10, ypos, xpos + 100 + 10, ypos);
        g.drawLine(xpos + 10, ypos, xpos + 10, ypos + 60);
        g.drawLine(xpos + 100 + 10, ypos, xpos + 100 + 10, ypos + 60);
        g.drawLine(xpos + 10, ypos + 60, xpos + 20, ypos + 60);
        g.drawLine(xpos + 100, ypos + 60, xpos + 100 + 10, ypos + 60);
        g.drawLine(xpos + 20, ypos + 60, xpos + 20, ypos + 70);
        g.drawLine(xpos + 100, ypos + 60, xpos + 100, ypos + 70);
        if (nr_of_bits > 1) {
            g.drawLine(xpos + 100 + 10, ypos + 5, xpos + 100 + 15, ypos + 5);
            g.drawLine(xpos + 100 + 15, ypos + 5, xpos + 100 + 15, ypos + 65);
            g.drawLine(xpos + 100 + 5, ypos + 65, xpos + 100 + 15, ypos + 65);
            g.drawLine(xpos + 100 + 5, ypos + 65, xpos + 100 + 5, ypos + 70);
            if (nr_of_bits > 2) {
                g.drawLine(xpos + 100 + 15, ypos + 10, xpos + 100 + 20, ypos + 10);
                g.drawLine(xpos + 100 + 20, ypos + 10, xpos + 100 + 20, ypos + 70);
                g.drawLine(xpos + 100 + 10, ypos + 70, xpos + 100 + 20, ypos + 70);
            }
        }
        String Identifier2 = "SRG" + nr_of_stages;
        GraphicsUtil.drawCenteredText(g, Identifier2, xpos + 50 + 10, ypos + 5);
        painter.drawClockSymbol(xpos + 10, ypos + 50);
        GraphicsUtil.switchToWidth(g, 2);
        if (active_low_clock) {
            g.drawOval(xpos, ypos + 45, 10, 10);
        } else {
            g.drawLine(xpos, ypos + 50, xpos + 10, ypos + 50);
        }
        painter.drawPort(2);
        String cntrl = "1\u2192/C3";
        GraphicsUtil.drawText(g, "1\u2192/C3", xpos + 20, ypos + 50, -1, 0);
        g.drawLine(xpos, ypos + 40, xpos + 10, ypos + 40);
        GraphicsUtil.drawText(g, "M1 [shift]", xpos + 20, ypos + 40, -1, 0);
        painter.drawPort(1);
        if (has_load) {
            g.drawLine(xpos, ypos + 30, xpos + 10, ypos + 30);
            GraphicsUtil.drawText(g, "M2 [load]", xpos + 20, ypos + 30, -1, 0);
            painter.drawPort(5);
        }
        g.drawLine(xpos, ypos + 20, xpos + 10, ypos + 20);
        GraphicsUtil.drawText(g, "R", xpos + 20, ypos + 20, -1, 0);
        painter.drawPort(3);
        GraphicsUtil.switchToWidth(g, 1);
    }

    private void drawDataBlock(InstancePainter painter, int xpos, int ypos, int nrOfStages, int nrOfBits, int currentStage, Value data_value, boolean hasLoad) {
        int realYpos = ypos + 70 + currentStage * 20;
        if (currentStage > 0) {
            realYpos += 10;
        }
        int realXpos = xpos + 10;
        int dataWidth = nrOfBits == 1 ? 2 : 5;
        int lineFix = nrOfBits == 1 ? 1 : 2;
        Color componentColor = new Color(AppPreferences.COMPONENT_COLOR.get());
        Color inOutputConectionColor = nrOfBits == 1 ? componentColor : Value.multiColor;
        int height = currentStage == 0 ? 30 : 20;
        boolean lastBlock = currentStage == nrOfStages - 1;
        int blockWidth = 100;
        Graphics g = painter.getGraphics();
        GraphicsUtil.switchToWidth(g, 2);
        g.drawRect(realXpos, realYpos, 100, height);
        if (nrOfBits > 1) {
            g.drawLine(realXpos + 100, realYpos + 5, realXpos + 100 + 5, realYpos + 5);
            g.drawLine(realXpos + 100 + 5, realYpos + 5, realXpos + 100 + 5, realYpos + height + 5);
            if (lastBlock) {
                g.drawLine(realXpos + 5, realYpos + height + 5, realXpos + 100 + 5, realYpos + height + 5);
                g.drawLine(realXpos + 5, realYpos + height, realXpos + 5, realYpos + height + 5);
            }
            if (nrOfBits > 2) {
                g.drawLine(realXpos + 100 + 5, realYpos + 10, realXpos + 100 + 10, realYpos + 10);
                g.drawLine(realXpos + 100 + 10, realYpos + 10, realXpos + 100 + 10, realYpos + height + 10);
                if (lastBlock) {
                    g.drawLine(realXpos + 10, realYpos + height + 10, realXpos + 100 + 10, realYpos + height + 10);
                    g.drawLine(realXpos + 10, realYpos + height + 5, realXpos + 10, realYpos + height + 10);
                }
            }
        }
        if (currentStage == 0 || hasLoad) {
            GraphicsUtil.switchToWidth(g, dataWidth);
            g.setColor(inOutputConectionColor);
            g.drawLine(realXpos - 10, realYpos + 10, realXpos - lineFix, realYpos + 10);
            g.setColor(componentColor);
            if (currentStage == 0) {
                painter.drawPort(0);
                GraphicsUtil.drawText(g, "1,3D", realXpos + 1, realYpos + 10, -1, 0);
                if (hasLoad) {
                    g.setColor(inOutputConectionColor);
                    g.drawLine(realXpos - 10, realYpos + 20, realXpos - lineFix, realYpos + 20);
                    g.setColor(componentColor);
                    GraphicsUtil.drawText(g, "2,3D", realXpos + 1, realYpos + 20, -1, 0);
                }
            } else {
                GraphicsUtil.drawText(g, "2,3D", realXpos + 1, realYpos + 10, -1, 0);
            }
            if (hasLoad) {
                painter.drawPort(6 + 2 * currentStage);
            }
            GraphicsUtil.switchToWidth(g, 1);
        }
        GraphicsUtil.switchToWidth(g, 1);
        GraphicsUtil.switchToWidth(g, dataWidth);
        g.setColor(inOutputConectionColor);
        if (hasLoad || lastBlock) {
            if (currentStage == 0) {
                g.drawLine(realXpos + 100 + lineFix, realYpos + 20, realXpos + 100 + 10, realYpos + 20);
            } else {
                g.drawLine(realXpos + 100 + lineFix, realYpos + 10, realXpos + 100 + 10, realYpos + 10);
            }
        }
        if (lastBlock) {
            painter.drawPort(4);
        } else if (hasLoad) {
            painter.drawPort(6 + 2 * currentStage + 1);
        }
        GraphicsUtil.switchToWidth(g, 1);
        g.setColor(componentColor);
        if (painter.getShowState() && data_value != null) {
            String value;
            if (data_value.isFullyDefined()) {
                g.setColor(Color.LIGHT_GRAY);
            } else if (data_value.isErrorValue()) {
                g.setColor(Color.RED);
            } else {
                g.setColor(Color.BLUE);
            }
            int yoff = currentStage == 0 ? 10 : 0;
            int len = (nrOfBits + 3) / 4;
            int boxXpos = 65 - len * 4;
            g.fillRect(realXpos + boxXpos, realYpos + yoff + 2, 2 + len * 8, 16);
            if (data_value.isFullyDefined()) {
                g.setColor(Color.DARK_GRAY);
                value = StringUtil.toHexString(nrOfBits, data_value.toLongValue());
            } else {
                g.setColor(Color.YELLOW);
                value = data_value.isUnknown() ? "?" : "!";
            }
            GraphicsUtil.drawText(g, value, realXpos + boxXpos + 1, realYpos + yoff + 10, -1, 0);
            g.setColor(componentColor);
        }
    }

    private ShiftRegisterData getData(InstanceState state) {
        BitWidth width = state.getAttributeValue(StdAttr.WIDTH);
        Integer lenObj = state.getAttributeValue(ATTR_LENGTH);
        int length = lenObj == null ? 8 : lenObj;
        ShiftRegisterData data = (ShiftRegisterData)state.getData();
        if (data == null) {
            data = new ShiftRegisterData(width, length);
            state.setData(data);
        } else {
            data.setDimensions(width, length);
        }
        return data;
    }

    private void updateData(Instance instance) {
        Integer lenObj;
        InstanceStateImpl comp = instance.getComponent().getInstanceStateImpl();
        if (comp == null) {
            return;
        }
        CircuitState circuitState = comp.getCircuitState();
        if (circuitState == null) {
            return;
        }
        InstanceState state = circuitState.getInstanceState(instance);
        if (state == null) {
            return;
        }
        ShiftRegisterData data = (ShiftRegisterData)state.getData();
        if (data == null) {
            return;
        }
        data.setDimensions(state.getAttributeValue(StdAttr.WIDTH), (lenObj = state.getAttributeValue(ATTR_LENGTH)) == null ? 8 : lenObj);
    }

    @Override
    public Bounds getOffsetBounds(AttributeSet attrs) {
        if (attrs.getValue(StdAttr.APPEARANCE) == StdAttr.APPEAR_CLASSIC) {
            Boolean parallel = attrs.getValue(ATTR_LOAD);
            if (parallel == null || parallel.booleanValue()) {
                return Bounds.create(0, -20, 20 + 10 * attrs.getValue(ATTR_LENGTH), 40);
            }
            return Bounds.create(0, -20, 30, 40);
        }
        return Bounds.create(0, 0, 120, 80 + 20 * attrs.getValue(ATTR_LENGTH));
    }

    @Override
    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        if (attr == ATTR_LOAD || attr == ATTR_LENGTH || attr == StdAttr.WIDTH || attr == StdAttr.APPEARANCE) {
            instance.recomputeBounds();
            this.configurePorts(instance);
            this.updateData(instance);
        }
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        if (painter.getAttributeValue(StdAttr.APPEARANCE) == StdAttr.APPEAR_CLASSIC) {
            this.paintInstanceClassic(painter);
        } else {
            this.paintInstanceEvolution(painter);
        }
    }

    private void paintInstanceEvolution(InstancePainter painter) {
        painter.drawLabel();
        int xpos = painter.getLocation().getX();
        int ypos = painter.getLocation().getY();
        int wid = painter.getAttributeValue(StdAttr.WIDTH).getWidth();
        Integer lenObj = painter.getAttributeValue(ATTR_LENGTH);
        int len = lenObj == null ? 8 : lenObj;
        Boolean parallelObj = painter.getAttributeValue(ATTR_LOAD);
        boolean negEdge = painter.getAttributeValue(StdAttr.EDGE_TRIGGER).equals(StdAttr.TRIG_FALLING);
        this.drawControl(painter, xpos, ypos, len, wid, parallelObj, negEdge);
        ShiftRegisterData data = (ShiftRegisterData)painter.getData();
        if (data == null) {
            for (int stage = 0; stage < len; ++stage) {
                this.drawDataBlock(painter, xpos, ypos, len, wid, stage, null, parallelObj);
            }
        } else {
            for (int stage = 0; stage < len; ++stage) {
                this.drawDataBlock(painter, xpos, ypos, len, wid, stage, data.get(len - stage - 1), parallelObj);
            }
        }
    }

    private void paintInstanceClassic(InstancePainter painter) {
        painter.drawBounds();
        painter.drawLabel();
        boolean parallel = painter.getAttributeValue(ATTR_LOAD);
        if (parallel) {
            int len;
            BitWidth widObj = painter.getAttributeValue(StdAttr.WIDTH);
            int wid = widObj.getWidth();
            Integer lenObj = painter.getAttributeValue(ATTR_LENGTH);
            int n = len = lenObj == null ? 8 : lenObj;
            if (painter.getShowState()) {
                if (wid <= 4) {
                    ShiftRegisterData data = this.getData(painter);
                    Bounds bds = painter.getBounds();
                    int x = bds.getX() + 20;
                    int y = bds.getY();
                    String label = painter.getAttributeValue(StdAttr.LABEL);
                    y = label == null || label.equals("") ? (y += bds.getHeight() / 2) : (y += 3 * bds.getHeight() / 4);
                    Graphics g = painter.getGraphics();
                    for (int i = 0; i < len; ++i) {
                        if (data != null && data.get(len - 1 - i) != null) {
                            String s = data.get(len - 1 - i).toHexString();
                            GraphicsUtil.drawCenteredText(g, s, x, y);
                        }
                        x += 10;
                    }
                }
            } else {
                Bounds bds = painter.getBounds();
                int x = bds.getX() + bds.getWidth() / 2;
                int y = bds.getY();
                int h = bds.getHeight();
                Graphics g = painter.getGraphics();
                String label = painter.getAttributeValue(StdAttr.LABEL);
                if (label == null || label.equals("")) {
                    String a = Strings.S.get("shiftRegisterLabel1");
                    GraphicsUtil.drawCenteredText(g, a, x, y + h / 4);
                }
                String b = Strings.S.get("shiftRegisterLabel2", "" + len, "" + wid);
                GraphicsUtil.drawCenteredText(g, b, x, y + 3 * h / 4);
            }
        }
        int ports = painter.getInstance().getPorts().size();
        for (int i = 0; i < ports; ++i) {
            if (i == 2) continue;
            painter.drawPort(i);
        }
        painter.drawClock(2, Direction.EAST);
    }

    @Override
    public void propagate(InstanceState state) {
        AttributeOption triggerType = state.getAttributeValue(StdAttr.EDGE_TRIGGER);
        Boolean parallel = state.getAttributeValue(ATTR_LOAD);
        ShiftRegisterData data = this.getData(state);
        int len = data.getLength();
        boolean triggered = data.updateClock(state.getPortValue(2), triggerType);
        if (state.getPortValue(3) == Value.TRUE) {
            data.clear();
        } else if (triggered) {
            if (parallel.booleanValue() && state.getPortValue(5) == Value.TRUE) {
                data.clear();
                for (int i = len - 1; i >= 0; --i) {
                    data.push(state.getPortValue(6 + 2 * i));
                }
            } else if (state.getPortValue(1) != Value.FALSE) {
                data.push(state.getPortValue(0));
            }
        }
        state.setPort(4, data.get(0), 4);
        if (parallel.booleanValue()) {
            int nrOfBits = state.getAttributeValue(StdAttr.APPEARANCE) == StdAttr.APPEAR_CLASSIC ? len : len - 1;
            for (int i = 0; i < nrOfBits; ++i) {
                state.setPort(6 + 2 * i + 1, data.get(len - 1 - i), 4);
            }
        }
    }

    @Override
    public boolean checkForGatedClocks(netlistComponent comp) {
        return true;
    }

    @Override
    public int[] clockPinIndex(netlistComponent comp) {
        return new int[]{2};
    }
}

