/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.tcl;

import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.InstanceData;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.InstanceStateImpl;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.std.tcl.TclWrapper;
import com.cburch.logisim.std.tcl.TclWrapperListenerThread;
import com.cburch.logisim.util.SocketClient;

public class TclComponentData
implements InstanceData {
    private final SocketClient tclClient;
    private TclWrapperListenerThread tclWrapperListenerThread;
    private final TclWrapper tclWrapper;
    private final InstanceState instanceState;
    private Value prevClockValue = Value.UNKNOWN;

    public static TclComponentData get(InstanceState state) {
        TclComponentData ret = (TclComponentData)state.getData();
        if (ret == null) {
            ret = new TclComponentData(state);
            state.setData(ret);
        }
        return ret;
    }

    TclComponentData(InstanceState state) {
        this.instanceState = state;
        this.tclClient = new SocketClient();
        this.tclWrapper = new TclWrapper(this);
    }

    @Override
    public Object clone() {
        return null;
    }

    public InstanceState getState() {
        return this.instanceState;
    }

    public SocketClient getTclClient() {
        return this.tclClient;
    }

    public TclWrapper getTclWrapper() {
        return this.tclWrapper;
    }

    public boolean isConnected() {
        return this.tclClient.isConnected();
    }

    public boolean isNewTick() {
        boolean newTick = false;
        boolean found = false;
        for (Port p : this.instanceState.getInstance().getPorts()) {
            if (!p.getToolTip().equals("sysclk_i")) continue;
            Value val = this.instanceState.getPortValue(this.instanceState.getPortIndex(p));
            boolean bl = newTick = val != this.prevClockValue;
            if (newTick) {
                this.prevClockValue = val;
            }
            found = true;
            break;
        }
        if (!found) {
            throw new UnsupportedOperationException("Could not find the 'sysclock' in the TCL component");
        }
        return newTick;
    }

    public String receive() {
        return this.tclWrapperListenerThread.receive();
    }

    public void send(String message) {
        this.tclClient.send(message);
    }

    public void tclWrapperStartCallback() {
        this.tclClient.start();
        this.tclWrapperListenerThread = new TclWrapperListenerThread(this.tclClient, ((InstanceStateImpl)this.instanceState).getCircuitState().getProject().getSimulator());
        this.tclWrapperListenerThread.start();
    }
}

