/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.ttl;

import com.cburch.logisim.fpga.hdlgenerator.HdlGeneratorFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.std.ttl.AbstractGateHdlGenerator;
import com.cburch.logisim.std.ttl.AbstractTtlGate;
import com.cburch.logisim.std.ttl.Drawgates;
import com.cburch.logisim.util.LineBuffer;
import java.awt.Graphics;

public class Ttl7402
extends AbstractTtlGate {
    public static final String _ID = "7402";
    private static final byte portCount = 14;
    private static final byte[] outPorts = new byte[]{1, 4, 10, 13};

    public Ttl7402() {
        super(_ID, (byte)14, outPorts, true, (HdlGeneratorFactory)new NorGateHdlGeneratorFactory());
    }

    public Ttl7402(String name) {
        super(name, (byte)14, outPorts, true, (HdlGeneratorFactory)new NorGateHdlGeneratorFactory());
    }

    @Override
    public void paintInternal(InstancePainter painter, int x, int y, int height, boolean up) {
        Graphics g = painter.getGraphics();
        int portwidth = 18;
        int portheight = 15;
        int youtput = y + (up ? 20 : 40);
        Drawgates.paintOr(g, x + 20, youtput, 14, 15, true, true);
        Drawgates.paintOutputgate(g, x + 10, y, x + 16, youtput, up, height);
        Drawgates.paintDoubleInputgate(g, x + 50, y, x + 16 + 18, youtput, 15, up, true, height);
    }

    @Override
    public void propagateTtl(InstanceState state) {
        int i;
        for (i = 0; i < 6; i += 3) {
            state.setPort(i, state.getPortValue(i + 1).or(state.getPortValue(i + 2)).not(), 1);
        }
        for (i = 8; i < 12; i += 3) {
            state.setPort(i, state.getPortValue(i - 1).or(state.getPortValue(i - 2)).not(), 1);
        }
    }

    private static class NorGateHdlGeneratorFactory
    extends AbstractGateHdlGenerator {
        private NorGateHdlGeneratorFactory() {
        }

        @Override
        public LineBuffer getLogicFunction(int index) {
            return LineBuffer.getHdlBuffer().add("{{assign}}gateO{{1}}{{=}}{{not}}(gateA{{1}}{{or}}gateB{{1}});", index);
        }
    }
}

