/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.ttl;

import com.cburch.logisim.data.Value;
import com.cburch.logisim.fpga.hdlgenerator.HdlGeneratorFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.std.ttl.AbstractTtlGate;
import com.cburch.logisim.std.ttl.Drawgates;
import com.cburch.logisim.std.ttl.Ttl7413HdlGenerator;
import java.awt.Graphics;

public class Ttl7413
extends AbstractTtlGate {
    public static final String _ID = "7413";
    private boolean inverted = true;
    private static final byte pinCount = 14;
    private static final byte[] outPorts = new byte[]{6, 8};
    private static final byte[] unusedPorts = new byte[]{3, 11};
    private static final String[] portNames = new String[]{"A0", "B0", "C0", "D0", "Y0", "Y1", "D1", "C1", "B1", "A1"};

    public Ttl7413(String name, boolean inv) {
        super(name, (byte)14, outPorts, unusedPorts, portNames, (HdlGeneratorFactory)new Ttl7413HdlGenerator(inv));
        this.inverted = inv;
    }

    public Ttl7413(String name) {
        super(name, (byte)14, outPorts, unusedPorts, portNames, (HdlGeneratorFactory)new Ttl7413HdlGenerator(true));
    }

    public Ttl7413() {
        super(_ID, (byte)14, outPorts, unusedPorts, portNames, (HdlGeneratorFactory)new Ttl7413HdlGenerator(true));
    }

    @Override
    public void paintInternal(InstancePainter painter, int x, int y, int height, boolean up) {
        super.paintBase(painter, false, false);
        Graphics g = painter.getGraphics();
        Drawgates.paintAnd(g, x + 125, y + 20, 10, 10, this.inverted);
        Drawgates.paintAnd(g, x + 105, y + 40, 10, 10, this.inverted);
        int offset = this.inverted ? 0 : -4;
        g.drawLine(x + 129 + offset, y + 20, x + 130, y + 20);
        g.drawLine(x + 130, y + 7, x + 130, y + 20);
        g.drawLine(x + 109 + offset, y + 40, x + 110, y + 40);
        g.drawLine(x + 110, y + height - 7, x + 110, y + 40);
        for (int i = 0; i < 5; ++i) {
            if (i == 2) continue;
            g.drawLine(x + 10 + i * 20, y + height - 7, x + 10 + i * 20, y + 36 + i * 2);
            g.drawLine(x + 10 + i * 20, y + 36 + i * 2, x + 95, y + 36 + i * 2);
            g.drawLine(x + 30 + i * 20, y + 7, x + 30 + i * 20, y + 24 - i * 2);
            g.drawLine(x + 30 + i * 20, y + 24 - i * 2, x + 115, y + 24 - i * 2);
        }
    }

    @Override
    public void propagateTtl(InstanceState state) {
        Value val = state.getPortValue(0).and(state.getPortValue(1).and(state.getPortValue(2).and(state.getPortValue(3))));
        state.setPort(4, this.inverted ? val.not() : val, 3);
        val = state.getPortValue(6).and(state.getPortValue(7).and(state.getPortValue(8).and(state.getPortValue(9))));
        state.setPort(5, this.inverted ? val.not() : val, 4);
    }
}

