/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.ttl;

import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.std.ttl.AbstractTtlGate;
import java.awt.BasicStroke;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Stroke;

public class Ttl74153
extends AbstractTtlGate {
    public static final String _ID = "74153";
    public static final int DELAY = 1;
    public static final byte S0 = 14;
    public static final byte S1 = 2;
    public static final byte L1_En = 1;
    public static final byte L1_D0 = 6;
    public static final byte L1_D1 = 5;
    public static final byte L1_D2 = 4;
    public static final byte L1_D3 = 3;
    public static final byte L2_En = 15;
    public static final byte L2_D0 = 10;
    public static final byte L2_D1 = 11;
    public static final byte L2_D2 = 12;
    public static final byte L2_D3 = 13;
    public static final byte L1_Y = 7;
    public static final byte L2_Y = 9;
    public static final byte GND = 8;
    public static final byte VCC = 16;
    private InstanceState _state;

    public Ttl74153() {
        super(_ID, (byte)16, new byte[]{7, 9}, new String[]{"n1E", "S1", "1D3", "1D2", "1D1", "1D0", "1Y", "2Y", "2D0", "2D1", "2D2", "2D3", "S0", "n2E"}, 80, null);
    }

    private void drawMux(Graphics2D graphics, int x, int y, int top, int bottom, Direction direction) {
        Graphics2D g = (Graphics2D)graphics.create();
        Stroke defStroke = g.getStroke();
        FontMetrics metrics = g.getFontMetrics();
        Polygon mux = direction == Direction.NORTH ? new Polygon(new int[]{x, x + 80, x + 74, x + 6}, new int[]{y, y, y - 18, y - 18}, 4) : new Polygon(new int[]{x, x + 80, x + 74, x + 6}, new int[]{y, y, y + 18, y + 18}, 4);
        g.setStroke(new BasicStroke(2.0f));
        g.drawPolygon(mux);
        g.setStroke(defStroke);
        int height = metrics.getAscent();
        for (int i = 0; i < 4; ++i) {
            String str = Integer.toString(3 - i);
            int width = metrics.stringWidth(str);
            if (direction == Direction.NORTH) {
                g.drawLine(x + 10 + i * 20, bottom - 7, x + 10 + i * 20, y + 1);
                g.drawString(str, x + 10 + i * 20 - width / 2, y - 1);
                continue;
            }
            g.drawLine(x + 10 + i * 20, top + 7, x + 10 + i * 20, y - 1);
            g.drawString(str, x + 10 + i * 20 - width / 2, y + height - 1);
        }
        if (direction == Direction.NORTH) {
            g.drawString("S", x + 1 + metrics.stringWidth("S") / 2, y - 8 + height / 2);
            g.drawString("E", x + 3 + metrics.stringWidth("E") / 2, y - 14 + height / 2);
            g.drawOval(x - 3 + metrics.stringWidth("E") / 2, y - 18 + height / 2, 4, 4);
            g.drawLine(x + 40, y - 19, x + 40, y - 22);
        } else {
            g.drawString("S", x + 1 + metrics.stringWidth("S") / 2, y + 2 + height);
            g.drawString("E", x + 3 + metrics.stringWidth("E") / 2, y + 8 + height);
            g.drawOval(x - 3 + metrics.stringWidth("E") / 2, y + 18 - height, 4, 4);
            g.drawLine(x + 40, y + 19, x + 40, y + 22);
        }
    }

    @Override
    public void paintInternal(InstancePainter painter, int x, int y, int height, boolean up) {
        super.paintBase(painter, false, false);
        Graphics2D g = (Graphics2D)painter.getGraphics();
        this.drawMux(g, x + 40, y + 65, y, y + height, Direction.NORTH);
        g.drawPolyline(new int[]{x + 80, x + 130, x + 130}, new int[]{y + height - 37, y + height - 37, y + height - 7}, 3);
        g.drawPolyline(new int[]{x + 10, x + 10, x + 38}, new int[]{y + height - 7, y + height - 28, y + height - 28}, 3);
        this.drawMux(g, x + 60, y + 15, y, y + height, Direction.SOUTH);
        g.drawPolyline(new int[]{x + 100, x + 150, x + 150}, new int[]{y + 37, y + 37, y + 7}, 3);
        g.drawPolyline(new int[]{x + 30, x + 30, x + 58}, new int[]{y + 7, y + 28, y + 28}, 3);
        g.drawPolyline(new int[]{x + 30, x + 30, x + 33}, new int[]{y + height - 7, y + 68, y + 65}, 3);
        g.drawPolyline(new int[]{x + 50, x + 50, x + 53}, new int[]{y + 7, y + 12, y + 15}, 3);
        g.setStroke(new BasicStroke(2.0f));
        g.drawPolyline(new int[]{x + 33, x + 33, x + 53, x + 53}, new int[]{y + 65, y + 40, y + 40, y + 15}, 4);
        g.drawLine(x + 33, y + height - 22, x + 41, y + height - 22);
        g.drawLine(x + 53, y + 22, x + 61, y + 22);
    }

    private byte pinNrToPortNr(byte dsPinNr) {
        return (byte)(dsPinNr <= 8 ? dsPinNr - 1 : dsPinNr - 2);
    }

    private boolean getPort(byte dsPinNr) {
        return this._state.getPortValue(this.pinNrToPortNr(dsPinNr)) == Value.TRUE;
    }

    private void setPort(byte dsPinNr, boolean b) {
        this._state.setPort(this.pinNrToPortNr(dsPinNr), b ? Value.TRUE : Value.FALSE, 1);
    }

    @Override
    public void propagateTtl(InstanceState state) {
        this._state = state;
        boolean[] data1 = new boolean[]{this.getPort((byte)6), this.getPort((byte)5), this.getPort((byte)4), this.getPort((byte)3)};
        boolean[] data2 = new boolean[]{this.getPort((byte)10), this.getPort((byte)11), this.getPort((byte)12), this.getPort((byte)13)};
        int select = (this.getPort((byte)2) ? 2 : 0) + (this.getPort((byte)14) ? 1 : 0);
        this.setPort((byte)7, !this.getPort((byte)1) && data1[select]);
        this.setPort((byte)9, !this.getPort((byte)15) && data2[select]);
    }
}

