/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.ttl;

import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.fpga.designrulecheck.netlistComponent;
import com.cburch.logisim.fpga.hdlgenerator.HdlGeneratorFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstancePoker;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.ttl.AbstractTtlGate;
import com.cburch.logisim.std.ttl.Drawgates;
import com.cburch.logisim.std.ttl.ShiftRegisterData;
import com.cburch.logisim.std.ttl.Ttl74165HdlGenerator;
import com.cburch.logisim.std.ttl.TtlLibrary;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class Ttl74165
extends AbstractTtlGate {
    public static final String _ID = "74165";

    public Ttl74165() {
        super(_ID, (byte)16, new byte[]{7, 9}, new String[]{"Shift/Load", "Clock", "P4", "P5", "P6", "P7", "Q7n", "Q7", "Serial Input", "P0", "P1", "P2", "P3", "Clock Inhibit"}, (HdlGeneratorFactory)new Ttl74165HdlGenerator());
        super.setInstancePoker(Poker.class);
    }

    private ShiftRegisterData getData(InstanceState state) {
        ShiftRegisterData data = (ShiftRegisterData)state.getData();
        if (data == null) {
            data = new ShiftRegisterData(BitWidth.ONE, 8);
            state.setData(data);
        }
        return data;
    }

    @Override
    public void paintInternal(InstancePainter painter, int x, int y, int height, boolean up) {
        Graphics2D g = (Graphics2D)painter.getGraphics();
        super.paintBase(painter, false, false);
        Drawgates.paintPortNames(painter, x, y, height, new String[]{"ShLd", "CK", "P4", "P5", "P6", "P7", "Q7n", "Q7", "SER", "P0", "P1", "P2", "P3", "CkIh"});
        ShiftRegisterData data = this.getData(painter);
        this.drawState(g, x, y, height, data);
    }

    private void drawState(Graphics2D g, int x, int y, int height, ShiftRegisterData state) {
        if (state == null) {
            return;
        }
        for (int i = 0; i < 8; ++i) {
            g.setColor(state.get(7 - i).getColor());
            g.fillOval(x + 36 + i * 10, y + height / 2 - 4, 8, 8);
            g.setColor(Color.WHITE);
            GraphicsUtil.drawCenteredText(g, state.get(7 - i).toDisplayString(), x + 40 + i * 10, y + height / 2);
        }
        g.setColor(Color.BLACK);
    }

    @Override
    public void propagateTtl(InstanceState state) {
        ShiftRegisterData data = this.getData(state);
        boolean triggered = data.updateClock(state.getPortValue(1), StdAttr.TRIG_RISING);
        if (state.getPortValue(0) == Value.FALSE) {
            data.clear();
            data.pushDown(state.getPortValue(5));
            data.pushDown(state.getPortValue(4));
            data.pushDown(state.getPortValue(3));
            data.pushDown(state.getPortValue(2));
            data.pushDown(state.getPortValue(12));
            data.pushDown(state.getPortValue(11));
            data.pushDown(state.getPortValue(10));
            data.pushDown(state.getPortValue(9));
        } else if (triggered && state.getPortValue(13) == Value.FALSE) {
            data.pushDown(state.getPortValue(8));
        }
        state.setPort(6, data.get(0).not(), 4);
        state.setPort(7, data.get(0), 4);
    }

    @Override
    public boolean checkForGatedClocks(netlistComponent comp) {
        return true;
    }

    @Override
    public int[] clockPinIndex(netlistComponent comp) {
        return new int[]{1};
    }

    public static class Poker
    extends InstancePoker {
        boolean isPressed = true;

        private boolean isInside(InstanceState state, MouseEvent e) {
            Point p = AbstractTtlGate.getTranslatedTtlXY(state, e);
            boolean inside = false;
            for (int i = 0; i < 8; ++i) {
                int dx = p.x - (40 + i * 10);
                int dy = p.y - 30;
                int d2 = dx * dx + dy * dy;
                inside |= d2 < 16;
            }
            return inside;
        }

        private int getIndex(InstanceState state, MouseEvent e) {
            Point p = AbstractTtlGate.getTranslatedTtlXY(state, e);
            for (int i = 0; i < 8; ++i) {
                int dx = p.x - (40 + i * 10);
                int dy = p.y - 30;
                int d2 = dx * dx + dy * dy;
                if (d2 >= 16) continue;
                return 7 - i;
            }
            return 0;
        }

        @Override
        public void mousePressed(InstanceState state, MouseEvent e) {
            this.isPressed = this.isInside(state, e);
        }

        @Override
        public void mouseReleased(InstanceState state, MouseEvent e) {
            if (!state.getAttributeValue(TtlLibrary.DRAW_INTERNAL_STRUCTURE).booleanValue()) {
                return;
            }
            if (this.isPressed && this.isInside(state, e)) {
                int index = this.getIndex(state, e);
                ShiftRegisterData myState = (ShiftRegisterData)state.getData();
                if (myState == null) {
                    return;
                }
                if (myState.get(index).isFullyDefined()) {
                    myState.set(index, myState.get(index).not());
                } else {
                    myState.set(index, Value.createKnown(1, 0L));
                }
                state.fireInvalidated();
            }
            this.isPressed = false;
        }
    }
}

