/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.ttl;

import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.hdlgenerator.AbstractHdlGeneratorFactory;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.std.ttl.TtlLibrary;
import com.cburch.logisim.util.LineBuffer;

public class Ttl74283HdlGenerator
extends AbstractHdlGeneratorFactory {
    public Ttl74283HdlGenerator() {
        this.myWires.addWire("oppA", 5).addWire("oppB", 5).addWire("oppC", 5).addWire("result", 5);
        this.myPorts.add("input", "A1", 1, 4).add("input", "A2", 1, 2).add("input", "A3", 1, 12).add("input", "A4", 1, 10).add("input", "B1", 1, 5).add("input", "B2", 1, 1).add("input", "B3", 1, 13).add("input", "B4", 1, 9).add("input", "Cin", 1, 6).add("output", "S1", 1, 3).add("output", "S2", 1, 0).add("output", "S3", 1, 11).add("output", "S4", 1, 8).add("output", "Cout", 1, 7);
    }

    @Override
    public LineBuffer getModuleFunctionality(Netlist TheNetlist, AttributeSet attrs) {
        LineBuffer contents = LineBuffer.getHdlBuffer();
        if (Hdl.isVhdl()) {
            contents.empty().add("oppA   <= \"0\"&A4&A3&A2&A1;\noppB   <= \"0\"&B4&B3&B2&B1;\noppC   <= \"0000\"&Cin;\nresult <= std_logic_vector(unsigned(oppA)+unsigned(oppB)+unsigned(oppC));\nS1     <= result(0);\nS2     <= result(1);\nS3     <= result(2);\nS4     <= result(3);\nCout   <= result(4);\n");
        } else {
            contents.add("assign   oppA = {A4, A3, A2, A1};\nassign   oppB = {B4, B4, B2, B1};\nassign   S1   = result[0];\nassign   S2   = result[1];\nassign   S3   = result[2];\nassign   S4   = result[3];\nassign   {Cout, result} = oppA + oppB + Cin;\n");
        }
        return contents.empty();
    }

    @Override
    public boolean isHdlSupportedTarget(AttributeSet attrs) {
        if (attrs == null) {
            return false;
        }
        return attrs.getValue(TtlLibrary.VCC_GND) == false;
    }
}

