/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.ttl;

import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.hdlgenerator.AbstractHdlGeneratorFactory;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.fpga.hdlgenerator.HdlPorts;
import com.cburch.logisim.std.ttl.TtlLibrary;
import com.cburch.logisim.util.LineBuffer;

public class Ttl7474HdlGenerator
extends AbstractHdlGeneratorFactory {
    public Ttl7474HdlGenerator() {
        this.myWires.addWire("state1", 1).addWire("state2", 1).addWire("next1", 1).addWire("next2", 1);
        this.myPorts.add("clock", HdlPorts.getClockName(1), 1, 2).add("clock", HdlPorts.getClockName(2), 2, 9).add("input", "nCLR1", 1, 0).add("input", "D1", 1, 1).add("input", "nPRE1", 1, 3).add("input", "nCLR2", 1, 11).add("input", "D2", 1, 10).add("input", "nPRE2", 1, 8).add("output", "Q1", 1, 4).add("output", "nQ1", 1, 5).add("output", "Q2", 1, 7).add("output", "nQ2", 1, 6);
    }

    @Override
    public LineBuffer getModuleFunctionality(Netlist theNetlist, AttributeSet attrs) {
        LineBuffer contents = LineBuffer.getHdlBuffer().pair("CLK1", HdlPorts.getClockName(1)).pair("CLK2", HdlPorts.getClockName(2)).pair("tick1", HdlPorts.getTickName(1)).pair("tick2", HdlPorts.getTickName(2));
        if (Hdl.isVhdl()) {
            contents.empty().addVhdlKeywords().add(" Q1  <= state1;\n nQ1 <= {{not}}(state1);\n Q2  <= state1;\n nQ2 <= {{not}}(state1);\n\n next1 <= D1 {{when}} {{tick1}}='1' {{else}} state1;\n next2 <= D2 {{when}} {{tick2}}='1' {{else}} state2;\n\n ff1 : {{process}} ( {{CLK1}} , nCLR1 , nPRE1 ) {{is}}\n    BEGIN\n       {{if}} (nCLR1 = '0') {{then}} state1 <= '0';\n       {{elsif}} (nPRE1 = '0') {{then}} state1 <= '1';\n       {{elsif}} (rising_edge({{CLK1}})) {{then}} state1 <= next1;\n       {{end}} {{if}};\n    {{end}} {{process}} ff1;\n\n ff2 : {{process}} ( {{CLK2}} , nCLR2 , nPRE2 ) {{is}}\n    BEGIN\n       {{if}} (nCLR2 = '0') {{then}} state2 <= '0';\n       {{elsif}} (nPRE2 = '0') {{then}} state2 <= '1';\n       {{elsif}} (rising_edge({{CLK2}})) {{then}} state2 <= next2;\n       {{end}} {{if}};\n    {{end}} {{process}} ff2;\n");
        } else {
            contents.add("assign Q1    = state1;\nassign nQ1   = ~state1;\nassign Q2    = state2;\nassign nQ2   = ~state2;\nassign next1 = tick1 == 1 ? D1 : state1;\nassign next2 = tick2 == 1 ? D2 : state2;\n\nalways @(posedge {{CLK1}} or negedge nCLR1 or negedge nPRE1)\nbegin\n   if (nCLR1 == 0) state1 <= 0;\n   else if (nPRE1 == 0) state1 <= 1;\n   else state1 <= next1;\nend\n\nalways @(posedge {{CLK2}} or negedge nCLR2 or negedge nPRE2)\nbegin\n   if (nCLR2 == 0) state2 <= 0;\n   else if (nPRE2 == 0) state2 <= 1;\n   else state2 <= next2;\nend\n");
        }
        return contents.empty();
    }

    @Override
    public boolean isHdlSupportedTarget(AttributeSet attrs) {
        if (attrs == null) {
            return false;
        }
        return attrs.getValue(TtlLibrary.VCC_GND) == false;
    }
}

