/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.wiring;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.util.StringGetter;
import java.awt.Component;
import javax.swing.JTextField;

public class DurationAttribute
extends Attribute<Integer> {
    private final int min;
    private final int max;
    private final boolean TickUnits;

    public DurationAttribute(String name, StringGetter disp, int min, int max, boolean IsTicks) {
        super(name, disp);
        this.min = min;
        this.max = max;
        this.TickUnits = IsTicks;
    }

    @Override
    public Component getCellEditor(Integer value) {
        JTextField field = new JTextField();
        field.setText(value.toString());
        return field;
    }

    @Override
    public Integer parse(String value) {
        try {
            int ret = Integer.parseInt(value);
            if (ret < this.min) {
                throw new NumberFormatException(Strings.S.get("durationSmallMessage", "" + this.min));
            }
            if (ret > this.max) {
                throw new NumberFormatException(Strings.S.get("durationLargeMessage", "" + this.max));
            }
            return ret;
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException(Strings.S.get("freqInvalidMessage"));
        }
    }

    @Override
    public String toDisplayString(Integer value) {
        if (this.TickUnits) {
            if (value.equals(1)) {
                return Strings.S.get("clockDurationOneValue");
            }
            return Strings.S.get("clockDurationValue", value.toString());
        }
        if (value.equals(1)) {
            return Strings.S.get("PORDurationOneValue");
        }
        return Strings.S.get("PORDurationValue", value.toString());
    }
}

