/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.util;

import com.cburch.draw.util.TextMetrics;
import com.cburch.logisim.circuit.RadixOption;
import com.cburch.logisim.data.Value;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public final class GraphicsUtil {
    public static final int H_LEFT = -1;
    public static final int H_CENTER = 0;
    public static final int H_RIGHT = 1;
    public static final int V_TOP = -1;
    public static final int V_CENTER = 0;
    public static final int V_BASELINE = 1;
    public static final int V_BOTTOM = 2;
    public static final int V_CENTER_OVERALL = 3;
    public static final int CONTROL_WIDTH = 2;
    public static final int NEGATED_WIDTH = 2;
    public static final int DATA_SINGLE_WIDTH = 3;
    public static final int DATA_MULTI_WIDTH = 4;

    private GraphicsUtil() {
        throw new IllegalStateException("Utility class. No instantiation allowed.");
    }

    public static void drawArrow(Graphics g, int x0, int y0, int x1, int y1, int headLength, int headAngle) {
        double offs = (double)headAngle * Math.PI / 180.0;
        double angle = Math.atan2(y0 - y1, x0 - x1);
        int[] xs = new int[]{x1 + (int)((double)headLength * Math.cos(angle + offs)), x1, x1 + (int)((double)headLength * Math.cos(angle - offs))};
        int[] ys = new int[]{y1 + (int)((double)headLength * Math.sin(angle + offs)), y1, y1 + (int)((double)headLength * Math.sin(angle - offs))};
        g.drawLine(x0, y0, x1, y1);
        g.drawPolyline(xs, ys, 3);
    }

    public static void drawArrow2(Graphics g, int x0, int y0, int x1, int y1, int x2, int y2) {
        int[] xs = new int[]{x0, x1, x2};
        int[] ys = new int[]{y0, y1, y2};
        GraphicsUtil.switchToWidth(g, 7);
        g.drawPolyline(xs, ys, 3);
        Color oldColor = g.getColor();
        g.setColor(Color.WHITE);
        GraphicsUtil.switchToWidth(g, 3);
        g.drawPolyline(xs, ys, 3);
        g.setColor(oldColor);
        GraphicsUtil.switchToWidth(g, 1);
    }

    public static void drawCenteredArc(Graphics g, int x, int y, int r, int start, int dist) {
        g.drawArc(x - r, y - r, 2 * r, 2 * r, start, dist);
    }

    public static void drawCenteredText(Graphics g, String text, int x, int y) {
        GraphicsUtil.drawText(g, text, x, y, 0, 0);
    }

    public static void drawCenteredText(Graphics g, Font font, String text, int x, int y, Color fg, Color bg) {
        GraphicsUtil.drawText(g, text, x, y, 0, 0);
    }

    public static void drawCenteredValue(Graphics2D gfx, Value value, RadixOption radix, int x, int y) {
        String valueString = radix.toString(value);
        String radixIdentifier = radix.getIndexChar();
        FontMetrics fontMetrics = gfx.getFontMetrics();
        Rectangle2D valueBounds = fontMetrics.getStringBounds(valueString, gfx);
        gfx.drawString(valueString, x - (int)(valueBounds.getWidth() / 2.0), y + (int)(valueBounds.getHeight() / 2.0));
        gfx.scale(0.7, 0.7);
        Rectangle2D radixBounds = fontMetrics.getStringBounds(radixIdentifier, gfx);
        Color currentColor = gfx.getColor();
        gfx.setColor(Color.BLUE);
        double radixXpos = (double)x + valueBounds.getWidth() / 2.0 + 1.0;
        double radixYpos = (double)y + valueBounds.getHeight() - radixBounds.getHeight() / 3.0;
        gfx.drawString(radixIdentifier, (int)(radixXpos / 0.7), (int)(radixYpos / 0.7));
        gfx.scale(1.4285714285714286, 1.4285714285714286);
        gfx.setColor(currentColor);
    }

    public static void drawCenteredColoredText(Graphics g, String text, Color fg, Color bg, int x, int y) {
        GraphicsUtil.drawText(g, text, x, y, 0, 0, fg, bg);
    }

    public static Rectangle getTextCursor(Graphics g, String text, int x, int y, int pos, int halign, int valign) {
        Rectangle r = GraphicsUtil.getTextBounds(g, text, x, y, halign, valign);
        if (pos > 0) {
            r.x += new TextMetrics((Graphics)g, (String)text.substring((int)0, (int)pos)).width;
        }
        r.width = 1;
        return r;
    }

    public static int getTextPosition(Graphics g, String text, int x, int y, int halign, int valign) {
        Rectangle r = GraphicsUtil.getTextBounds(g, text, 0, 0, halign, valign);
        x -= r.x;
        int last = 0;
        Font font = g.getFont();
        FontRenderContext fr = ((Graphics2D)g).getFontRenderContext();
        for (int i = 0; i < text.length(); ++i) {
            int cur = (int)font.getStringBounds(text.substring(0, i + 1), fr).getWidth();
            if (x <= (last + cur) / 2) {
                return i;
            }
            last = cur;
        }
        return text.length();
    }

    public static void drawText(Graphics g, Font font, String text, int x, int y, int halign, int valign, Color fg, Color bg) {
        Font oldfont = g.getFont();
        if (font != null) {
            g.setFont(font);
        }
        GraphicsUtil.drawText(g, text, x, y, halign, valign, fg, bg);
        if (font != null) {
            g.setFont(oldfont);
        }
    }

    public static void drawText(Graphics g, Font font, String text, int x, int y, int halign, int valign) {
        Font oldfont = g.getFont();
        if (font != null) {
            g.setFont(font);
        }
        GraphicsUtil.drawText(g, text, x, y, halign, valign);
        if (font != null) {
            g.setFont(oldfont);
        }
    }

    public static void drawText(Graphics g, String text, int x, int y, int halign, int valign) {
        if (text.length() == 0) {
            return;
        }
        Rectangle bd = GraphicsUtil.getTextBounds(g, text, x, y, halign, valign);
        TextMetrics tm = new TextMetrics(g, text);
        g.drawString(text, bd.x, bd.y + tm.ascent);
    }

    public static void drawText(Graphics g, String text, int x, int y, int halign, int valign, Color fg, Color bg) {
        if (text.length() == 0) {
            return;
        }
        Rectangle bd = GraphicsUtil.getTextBounds(g, text, x, y, halign, valign);
        TextMetrics tm = new TextMetrics(g, text);
        if (g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setPaint(bg);
            g.fillRect(bd.x, bd.y, bd.width, bd.height);
            g2d.setPaint(fg);
        }
        g.drawString(text, bd.x, bd.y + tm.ascent);
    }

    public static void outlineText(Graphics g, String text, int x, int y, Color fg, Color bg) {
        Graphics2D g2 = (Graphics2D)g;
        GlyphVector glyphVector = g2.getFont().createGlyphVector(g2.getFontRenderContext(), text);
        Shape textShape = glyphVector.getOutline();
        AffineTransform transform = g2.getTransform();
        g2.translate(x, y);
        g2.setColor(bg);
        g2.draw(textShape);
        g2.setColor(fg);
        g2.fill(textShape);
        g2.setTransform(transform);
    }

    public static Rectangle getTextBounds(Graphics g, Font font, String text, int x, int y, int halign, int valign) {
        if (g == null) {
            return new Rectangle(x, y, 0, 0);
        }
        Font oldfont = g.getFont();
        if (font != null) {
            g.setFont(font);
        }
        Rectangle ret = GraphicsUtil.getTextBounds(g, text, x, y, halign, valign);
        if (font != null) {
            g.setFont(oldfont);
        }
        return ret;
    }

    public static Rectangle getTextBounds(Graphics g, String text, int x, int y, int halign, int valign) {
        if (g == null) {
            return new Rectangle(x, y, 0, 0);
        }
        TextMetrics tm = new TextMetrics(g, text);
        int width = tm.width;
        int ascent = tm.ascent;
        int height = tm.height;
        Rectangle ret = new Rectangle(x, y, width, height);
        switch (halign) {
            case 0: {
                ret.translate(-(width / 2), 0);
                break;
            }
            case 1: {
                ret.translate(-width, 0);
                break;
            }
        }
        switch (valign) {
            case -1: {
                break;
            }
            case 0: {
                ret.translate(0, -(ascent / 2));
                break;
            }
            case 3: {
                ret.translate(0, -(height / 2));
                break;
            }
            case 1: {
                ret.translate(0, -ascent);
                break;
            }
            case 2: {
                ret.translate(0, -height);
                break;
            }
        }
        return ret;
    }

    public static void switchToWidth(Graphics gfx, int width) {
        if (gfx instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)gfx;
            g2d.setStroke(new BasicStroke(width));
        }
    }
}

