/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.util;

import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.fpga.hdlgenerator.Vhdl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.text.WordUtils;

public class LineBuffer
implements RandomAccess {
    public static final int MAX_LINE_LENGTH = 80;
    public static final String DEFAULT_INDENT_STR = "   ";
    public static final int DEFAULT_INDENT = 1;
    public static final int MAX_ALLOWED_INDENT = 74;
    private final ArrayList<String> contents = new ArrayList();
    private final Pairs pairs = new Pairs();
    private final String SPACE = " ";
    private List<String> placeholders = new ArrayList<String>();
    private final List<String> positionalPlaceholders = new ArrayList<String>();
    private final List<String> pairedPlaceholders = new ArrayList<String>();

    protected LineBuffer() {
        this.addDefaultPairs();
    }

    public LineBuffer(String line) {
        this();
        this.add(line);
    }

    public LineBuffer(String line, Pairs pairsToAdd) {
        this();
        this.pairs.addPairs(pairsToAdd);
        this.add(line);
    }

    public LineBuffer(Pairs pairsToAdd) {
        this();
        this.pairs.addPairs(pairsToAdd);
    }

    public static LineBuffer getBuffer() {
        return new LineBuffer();
    }

    public static LineBuffer getHdlBuffer() {
        return LineBuffer.getBuffer().addHdlPairs();
    }

    public int size() {
        return this.contents.size();
    }

    public boolean isEmpty() {
        return this.contents.isEmpty();
    }

    public boolean contains(String line) {
        return this.contents.contains(line);
    }

    public LineBuffer addPairs(Pairs pairsToAdd) {
        this.pairs.addPairs(pairsToAdd);
        return this;
    }

    protected LineBuffer addDefaultPairs() {
        return this.pair("1u", LineBuffer.getDefaultIndent()).pair("2u", LineBuffer.getIndent(2)).pair("3u", LineBuffer.getIndent(3));
    }

    public LineBuffer addHdlPairs() {
        return this.pair("assign", Hdl.assignPreamble()).pair("=", Hdl.assignOperator()).pair("==", Hdl.equalOperator()).pair("!=", Hdl.notEqualOperator()).pair("or", Hdl.orOperator()).pair("and", Hdl.andOperator()).pair("xor", Hdl.xorOperator()).pair("not", Hdl.notOperator()).pair("<", Hdl.bracketOpen()).pair(">", Hdl.bracketClose()).pair("else", Hdl.elseStatement()).pair("endif", Hdl.endIf()).pair("0b", Hdl.zeroBit()).pair("1b", Hdl.oneBit());
    }

    public LineBuffer addVhdlKeywords() {
        for (String keyword : Vhdl.getVhdlKeywords()) {
            this.pair(keyword.toLowerCase(), keyword);
        }
        return this;
    }

    public LineBuffer clear() {
        this.clearBuffer();
        this.clearPairs();
        return this;
    }

    public LineBuffer clearPairs() {
        this.pairs.clear();
        return this;
    }

    public LineBuffer clearBuffer() {
        this.contents.clear();
        return this;
    }

    public LineBuffer addUnique(String fmt, Object ... args) {
        String line = this.applyPairs(LineBuffer.format(fmt, args));
        if (!this.contents.contains(line)) {
            this.add(line, true);
        }
        return this;
    }

    public LineBuffer addUnique(String line) {
        if (!this.contents.contains(line = this.applyPairs(line))) {
            this.add(line, true);
        }
        return this;
    }

    public LineBuffer add(String line) {
        return this.add(line, true);
    }

    public LineBuffer add(String line, boolean applyMap) {
        if (applyMap) {
            line = LineBuffer.applyPairs(line, this.pairs);
        }
        this.validateLineNoPositionals(line);
        this.contents.add(line);
        return this;
    }

    public LineBuffer add(StringBuilder stringBuilder) {
        return this.add(stringBuilder.toString());
    }

    public LineBuffer add(String fmt, Object ... args) {
        return this.add(fmt, Pairs.fromArgs(args));
    }

    public LineBuffer add(String fmt, Pairs pairs) {
        fmt = LineBuffer.applyPairs(fmt, pairs);
        this.validateLineNoPositionals(fmt);
        return this.add(fmt);
    }

    public LineBuffer add(Collection<String> lines) {
        for (String line : lines) {
            this.add(line);
        }
        return this;
    }

    public LineBuffer addLines(String ... lines) {
        return this.add(Arrays.asList(lines));
    }

    public LineBuffer add(LineBuffer otherBuffer) {
        return this.add(otherBuffer.get());
    }

    public String applyPairs(String fnt) {
        return LineBuffer.applyPairs(fnt, this.pairs);
    }

    public static String applyPairs(String format, Pairs pairs) {
        if (pairs != null) {
            for (Map.Entry<String, Object> set : pairs.getContainer().entrySet()) {
                String searchRegExp = String.format("\\{\\{\\s*%s\\s*\\}\\}", set.getKey());
                String replacement = Matcher.quoteReplacement(set.getValue().toString());
                format = format.replaceAll(searchRegExp, replacement);
            }
        }
        return format;
    }

    public LineBuffer repeat(int count, String line) {
        for (int i = 0; i < count; ++i) {
            this.add(line);
        }
        return this;
    }

    public LineBuffer empty() {
        return this.repeat(1, "");
    }

    public LineBuffer empty(int count) {
        return this.repeat(count, "");
    }

    public String get(int index) {
        return this.contents.get(index);
    }

    public List<String> get() {
        return this.contents;
    }

    public List<String> getWithIndent() {
        return this.getWithIndent(LineBuffer.getDefaultIndent());
    }

    public List<String> getWithIndent(int howMany) {
        return this.getWithIndent(LineBuffer.getIndent(howMany));
    }

    public List<String> getWithIndent(int howMany, String indent) {
        return this.getWithIndent(indent.repeat(howMany));
    }

    public List<String> getWithIndent(String indent) {
        ArrayList<String> result = new ArrayList<String>();
        for (String content : this.contents) {
            String[] lines;
            for (String line : lines = content.split("\n")) {
                result.add((String)(line.length() == 0 ? line : indent + line));
            }
        }
        return result;
    }

    public Pairs getPairCopy() {
        Pairs clone = this.pairs.clone();
        return clone;
    }

    public static String getDefaultIndent() {
        return LineBuffer.getIndent(1, DEFAULT_INDENT_STR);
    }

    public static String getIndent(int indentUnits) {
        return LineBuffer.getIndent(indentUnits, DEFAULT_INDENT_STR);
    }

    public static String getIndent(int indentUnits, String indentString) {
        return indentString.repeat(indentUnits);
    }

    public LineBuffer addRemarkBlock(String remarkText) {
        return this.addRemarkBlock(remarkText, 0);
    }

    public LineBuffer addRemarkBlock(String remarkText, int nrOfIndentSpaces) {
        this.add(this.buildRemarkBlock(remarkText, nrOfIndentSpaces));
        return this;
    }

    protected ArrayList<String> buildRemarkBlock(String remarkText, int indentSpaces) {
        if (indentSpaces < 0) {
            throw new IllegalArgumentException("Negative indentation is not allowed.");
        }
        if (indentSpaces > 74) {
            throw new IllegalArgumentException(LineBuffer.format("Max allowed indentation is {{1}}, {{2}} given.", 74, indentSpaces));
        }
        int maxRemarkLineLength = 80 - indentSpaces - 6;
        String indent = " ".repeat(indentSpaces);
        ArrayList<String> contents = new ArrayList<String>();
        StringBuilder oneLine = new StringBuilder();
        List<String> remarkLines = List.of(WordUtils.wrap(remarkText, maxRemarkLineLength, "\n", true).split("\n"));
        oneLine.append(indent).append(Hdl.getRemarkBlockStart()).append(Hdl.getRemarkChar().repeat(80 - oneLine.length()));
        contents.add(oneLine.toString());
        oneLine.setLength(0);
        for (String remarkLine : remarkLines) {
            oneLine.append(indent).append(Hdl.getRemarkBlockLineStart()).append(remarkLine);
            if (remarkLine.length() < maxRemarkLineLength) {
                oneLine.append(" ".repeat(maxRemarkLineLength - remarkLine.length()));
            }
            oneLine.append(Hdl.getRemarkBlockLineEnd());
            contents.add(oneLine.toString());
            oneLine.setLength(0);
        }
        oneLine.append(indent).append(Hdl.getRemarkChar().repeat(80 - oneLine.length() - 3)).append(Hdl.getRemarkBlockEnd());
        contents.add(oneLine.toString());
        return contents;
    }

    public LineBuffer addRemarkLine(String remarkText) {
        this.add("{{1}}{{2}}", Hdl.getLineCommentStart(), remarkText);
        return this;
    }

    public static String format(String fmt, Object ... args) {
        return LineBuffer.applyPairs(fmt, Pairs.fromArgs(args));
    }

    public static String formatHdl(String fmt, Object ... args) {
        return LineBuffer.getHdlBuffer().add(fmt, args).get(0);
    }

    public static String formatVhdl(String fmt, Object ... args) {
        return LineBuffer.getHdlBuffer().addVhdlKeywords().add(fmt, args).get(0);
    }

    private LineBuffer warn(String fmt, Object ... args) {
        System.out.println(LineBuffer.format("WARNING: " + fmt, args));
        return this;
    }

    private void abort(String msg) {
        throw new RuntimeException(msg);
    }

    private void abort(String fmt, Object ... args) {
        this.abort(LineBuffer.format(fmt, args));
    }

    protected LineBuffer initValidator(String fmt) {
        this.placeholders = this.extractPlaceholders(fmt);
        this.positionalPlaceholders.clear();
        this.pairedPlaceholders.clear();
        Pattern pattern = Pattern.compile("^\\d+$");
        for (String phKey : this.placeholders) {
            if (pattern.matcher(phKey).find()) {
                this.positionalPlaceholders.add(phKey);
                continue;
            }
            this.pairedPlaceholders.add(phKey);
        }
        return this;
    }

    public void validateLineNoPositionals(String fmt) {
        this.validateLine(fmt, null);
    }

    protected void validateLineWithPositionalArgs(String fmt, Object ... args) {
        this.initValidator(fmt);
        int posArgsCnt = this.positionalPlaceholders.size();
        if (this.positionalPlaceholders.isEmpty()) {
            if (args.length > 0) {
                this.warn("#E004: Useless positional arguments. Expected nothing, but received {{2}} for '{{1}}'.", fmt, posArgsCnt);
            }
        } else {
            if (posArgsCnt < args.length) {
                this.abort("#E001: Too many positional arguments, Expected {{2}}, but received {{3}} for '{{1}}'.", fmt, posArgsCnt, args.length);
            }
            if (posArgsCnt > args.length) {
                this.abort("#E002: Insufficient positional arguments. Expected {{2}}, but received {{3}} for '{{1}}'.", fmt, posArgsCnt, args.length);
            }
            for (String posKey : this.positionalPlaceholders) {
                if (Integer.parseInt(posKey) <= posArgsCnt) continue;
                this.warn("#E003: Invalid positional argument. '{{1}}' used, but max value is {{2}} for '{{3}}'.", posKey, posArgsCnt, fmt);
            }
        }
    }

    protected void validateLineWithPairedPlaceholders(String fmt) {
        this.initValidator(fmt);
        for (String key : this.pairedPlaceholders) {
            if (this.placeholders.contains(key)) continue;
            this.abort("#E005: Placeholder '{{1}}' has no mapping while processing '{{2}}'.", key, fmt);
        }
    }

    protected void validateLine(String fmt, Pairs argPairs) {
        this.initValidator(fmt);
        if (argPairs != null) {
            this.validateLineWithPositionalArgs(fmt, argPairs);
        } else if (this.positionalPlaceholders.size() > 0) {
            this.abort("#E004: No positional arguments, but expected {{2}} for '{{1}}'.", fmt, this.positionalPlaceholders.size());
        }
        for (String key : this.pairedPlaceholders) {
            if (this.pairs.getContainer().containsKey(key) || argPairs != null && argPairs.getContainer().containsKey(key)) continue;
            this.abort("#E006: No mapping for '{{1}}' placeholder in '{{2}}'.", key, fmt);
        }
    }

    public List<String> extractPlaceholders(String fmt) {
        ArrayList<String> keys = new ArrayList<String>();
        String regex = "(\\{\\{.+?\\}\\})+";
        Pattern pattern = Pattern.compile("(\\{\\{.+?\\}\\})+", 10);
        Matcher matcher = pattern.matcher(fmt);
        while (matcher.find()) {
            int bracketsCharCount = 2;
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                String keyStr = matcher.group(i);
                if (keys.contains(keyStr = keyStr.substring(2, keyStr.length() - 2).strip())) continue;
                keys.add(keyStr);
            }
        }
        return keys;
    }

    public boolean equals(Object other) {
        if (!(other instanceof LineBuffer) || this.size() != ((LineBuffer)other).size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            String otherLine;
            String thisLine = this.get().get(i);
            if (thisLine.equals(otherLine = ((LineBuffer)other).get().get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.contents.toString();
    }

    public LineBuffer pair(String key, Object value) {
        this.pairs.pair(key, value);
        return this;
    }

    public static class Pairs
    implements Cloneable {
        private final HashMap<String, Object> pairContainer = new HashMap();

        public Pairs() {
        }

        public Pairs(String key, Object value) {
            this.pair(key, value);
        }

        public static Pairs fromArgs(Object ... args) {
            Pairs map = new Pairs();
            int idx = 1;
            for (Object arg : args) {
                map.addPositionalPair(String.valueOf(idx++), arg.toString());
            }
            return map;
        }

        public Pairs pair(String key, Object value) {
            return this.addNonPositionalPair(key, value);
        }

        public Pairs addNonPositionalPair(String key, Object value) {
            if (key.matches("^\\d+$")) {
                throw new RuntimeException(LineBuffer.format("Invalid pair key '{{1}}'. You cannot add positional arguments as pairs.", key));
            }
            this.pairContainer.put(key, value);
            return this;
        }

        public Pairs addPairs(Pairs pairs) {
            for (Map.Entry<String, Object> pair : pairs.entrySet()) {
                this.addNonPositionalPair(pair.getKey(), pair.getValue());
            }
            return this;
        }

        public Pairs addPositionalPair(String key, Object value) {
            if (!key.matches("^\\d+$")) {
                throw new RuntimeException(LineBuffer.format("Invalid pair key '{{1}}'. Positional arguments' keys must be numeric.", key));
            }
            this.pairContainer.put(key, value);
            return this;
        }

        public Pairs clear() {
            this.pairContainer.clear();
            return this;
        }

        protected HashMap<String, Object> getContainer() {
            return this.pairContainer;
        }

        public Set<Map.Entry<String, Object>> entrySet() {
            return this.pairContainer.entrySet();
        }

        protected Pairs clone() {
            Pairs clone = new Pairs();
            for (Map.Entry<String, Object> pair : this.pairContainer.entrySet()) {
                clone.pair(pair.getKey(), pair.getValue());
            }
            return clone;
        }

        public String toString() {
            return this.pairContainer.toString();
        }
    }
}

