/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.util;

import com.cburch.logisim.util.QNode;
import com.cburch.logisim.util.QNodeQueue;

public class LinkedQueue<T extends QNode>
implements QNodeQueue<T> {
    private QNode head;
    private QNode tail;
    private int size;

    @Override
    public boolean add(T t) {
        ++this.size;
        if (this.tail == null) {
            this.head = this.tail = t;
            ((QNode)t).right = null;
            ((QNode)t).left = null;
            return true;
        }
        QNode p = this.tail;
        while (p != null && ((QNode)t).compareTo(p) < 0) {
            p = p.left;
        }
        if (p == null) {
            ((QNode)t).right = this.head;
            ((QNode)t).left = null;
            this.head.left = t;
            this.head = t;
        } else {
            ((QNode)t).right = p.right;
            ((QNode)t).left = p;
            if (p.right == null) {
                this.tail = t;
            } else {
                p.right.left = t;
            }
            p.right = t;
        }
        return true;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        this.tail = null;
        this.head = null;
        this.size = 0;
    }

    @Override
    public T peek() {
        QNode ret = this.head;
        return (T)ret;
    }

    @Override
    public T remove() {
        if (this.head == null) {
            return null;
        }
        --this.size;
        QNode t = this.head;
        this.head = this.head.right;
        if (this.head == null) {
            this.tail = null;
        } else {
            this.head.left = null;
        }
        return (T)t;
    }

    String id(QNode n) {
        if (n == null) {
            return "null";
        }
        return "@" + n.hashCode();
    }
}

