/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.util;

import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.util.LocaleListener;
import com.cburch.logisim.util.LocaleManager;
import java.util.Locale;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class LocaleSelector
extends JList
implements LocaleListener,
ListSelectionListener {
    private static final long serialVersionUID = 1L;
    private final LocaleOption[] items;

    LocaleSelector(Locale[] locales) {
        this.setSelectionMode(0);
        DefaultListModel<LocaleOption> model = new DefaultListModel<LocaleOption>();
        this.items = new LocaleOption[locales.length];
        for (int i = 0; i < locales.length; ++i) {
            this.items[i] = new LocaleOption(locales[i]);
            model.addElement(this.items[i]);
        }
        this.setModel(model);
        this.setVisibleRowCount(Math.min(this.items.length, 8));
        LocaleManager.addLocaleListener(this);
        this.localeChanged();
        this.addListSelectionListener(this);
    }

    @Override
    public void localeChanged() {
        Locale current = LocaleManager.getLocale();
        LocaleOption sel = null;
        for (LocaleOption item : this.items) {
            item.update(current);
            if (!current.equals(item.locale)) continue;
            sel = item;
        }
        if (sel != null) {
            this.setSelectedValue(sel, true);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        LocaleOption opt = (LocaleOption)this.getSelectedValue();
        if (opt != null) {
            SwingUtilities.invokeLater(opt);
        }
    }

    private static class LocaleOption
    implements Runnable {
        private final Locale locale;
        private String text;

        LocaleOption(Locale locale) {
            this.locale = locale;
            this.update(locale);
        }

        @Override
        public void run() {
            if (!LocaleManager.getLocale().equals(this.locale)) {
                LocaleManager.setLocale(this.locale);
                AppPreferences.LOCALE.set(this.locale.getLanguage());
            }
        }

        public String toString() {
            return this.text;
        }

        void update(Locale current) {
            this.text = current != null && current.equals(this.locale) ? this.locale.getDisplayName(this.locale) : this.locale.getDisplayName(this.locale) + " / " + this.locale.getDisplayName(current);
        }
    }
}

