/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketClient {
    static final Logger logger = LoggerFactory.getLogger(SocketClient.class);
    private static ServerSocket server = null;
    private boolean connected = false;
    private Socket socket;
    private BufferedReader socketReader;
    private PrintWriter socketWriter;

    public SocketClient() {
        if (server == null) {
            try {
                server = new ServerSocket(0);
            }
            catch (IOException e) {
                logger.error("Cannot create server socket");
                e.printStackTrace();
                return;
            }
        }
    }

    public int getServerPort() {
        if (server != null) {
            return server.getLocalPort();
        }
        return 0;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public Boolean isConnected() {
        return this.connected;
    }

    public String receive() {
        try {
            return this.socketReader.readLine();
        }
        catch (Exception e) {
            logger.error("Cannot read from socket : {}", (Object)e.getMessage());
            return null;
        }
    }

    public void send(String message) {
        try {
            this.socketWriter.println(message);
        }
        catch (Exception e) {
            logger.error("Cannot write {} to socket {}", (Object)message, (Object)e.getMessage());
        }
    }

    public void start() {
        try {
            this.socket = server.accept();
            this.socketReader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.socketWriter = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream())), true);
            this.connected = true;
            return;
        }
        catch (IOException e) {
            logger.error("Error at accepting new client");
            this.connected = false;
            return;
        }
    }

    public void stop() {
        if (!this.isConnected().booleanValue()) {
            return;
        }
        try {
            this.socket.close();
            this.connected = false;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

