/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.util;

import com.cburch.contracts.BaseWindowListenerContract;
import com.cburch.logisim.util.WindowMenu;
import com.cburch.logisim.util.WindowMenuItem;
import com.cburch.logisim.util.WindowMenuManager;
import java.awt.Component;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import javax.swing.JFrame;
import javax.swing.JRadioButtonMenuItem;

public abstract class WindowMenuItemManager {
    private final MyListener myListener = new MyListener();
    private String text;
    private final boolean persistent;
    private boolean listenerAdded = false;
    private boolean inManager = false;
    private final HashMap<WindowMenu, JRadioButtonMenuItem> menuItems = new HashMap();

    public WindowMenuItemManager(String text, boolean persistent) {
        this.text = text;
        this.persistent = persistent;
        if (persistent) {
            WindowMenuManager.addManager(this);
        }
    }

    private void addToManager() {
        if (!this.persistent && !this.inManager) {
            WindowMenuManager.addManager(this);
            this.inManager = true;
        }
    }

    void createMenuItem(WindowMenu menu) {
        WindowMenuItem ret = new WindowMenuItem(this);
        this.menuItems.put(menu, ret);
        menu.addMenuItem(this, ret, this.persistent);
    }

    public void frameClosed(JFrame frame) {
        if (!this.persistent) {
            if (this.listenerAdded) {
                frame.removeWindowListener(this.myListener);
                this.listenerAdded = false;
            }
            this.removeFromManager();
        }
    }

    public void frameOpened(JFrame frame) {
        if (!this.listenerAdded) {
            frame.addWindowListener(this.myListener);
            this.listenerAdded = true;
        }
        this.addToManager();
        WindowMenuManager.setCurrentManager(this);
    }

    public abstract JFrame getJFrame(boolean var1, Component var2);

    JRadioButtonMenuItem getMenuItem(WindowMenu key) {
        return this.menuItems.get(key);
    }

    public String getText() {
        return this.text;
    }

    private void removeFromManager() {
        if (!this.persistent && this.inManager) {
            this.inManager = false;
            for (WindowMenu menu : WindowMenuManager.getMenus()) {
                JRadioButtonMenuItem menuItem = this.menuItems.get(menu);
                menu.removeMenuItem(this, menuItem);
            }
            WindowMenuManager.removeManager(this);
        }
    }

    void removeMenuItem(WindowMenu menu) {
        JRadioButtonMenuItem item = this.menuItems.remove(menu);
        if (item != null) {
            menu.removeMenuItem(this, item);
        }
    }

    void setSelected(boolean selected) {
        for (JRadioButtonMenuItem item : this.menuItems.values()) {
            item.setSelected(selected);
        }
    }

    public void setText(String value) {
        this.text = value;
        for (JRadioButtonMenuItem menuItem : this.menuItems.values()) {
            menuItem.setText(this.text);
        }
    }

    private class MyListener
    implements BaseWindowListenerContract {
        private MyListener() {
        }

        @Override
        public void windowActivated(WindowEvent event) {
            WindowMenuItemManager.this.addToManager();
            WindowMenuManager.setCurrentManager(WindowMenuItemManager.this);
        }

        @Override
        public void windowClosed(WindowEvent event) {
            WindowMenuItemManager.this.removeFromManager();
        }

        @Override
        public void windowClosing(WindowEvent event) {
            JFrame frame = WindowMenuItemManager.this.getJFrame(false, null);
            if (frame.getDefaultCloseOperation() == 1) {
                WindowMenuItemManager.this.removeFromManager();
            }
        }

        @Override
        public void windowDeactivated(WindowEvent event) {
            WindowMenuManager.unsetCurrentManager(WindowMenuItemManager.this);
        }

        @Override
        public void windowIconified(WindowEvent event) {
            WindowMenuItemManager.this.addToManager();
            WindowMenuManager.setCurrentManager(WindowMenuItemManager.this);
        }
    }
}

