/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.vhdl.base;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.file.LogisimFile;
import com.cburch.logisim.fpga.hdlgenerator.Vhdl;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.util.Softwares;
import com.cburch.logisim.vhdl.Strings;
import com.cburch.logisim.vhdl.base.HdlContent;
import com.cburch.logisim.vhdl.base.HdlModel;
import com.cburch.logisim.vhdl.base.VhdlEntityAttributes;
import com.cburch.logisim.vhdl.base.VhdlParser;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class VhdlContent
extends HdlContent {
    private static final String RESOURCE = "/resources/logisim/hdl/vhdl_component.templ";
    private static final String TEMPLATE = VhdlContent.loadTemplate();
    protected AttributeSet staticAttrs;
    protected StringBuilder content;
    protected boolean valid;
    protected final List<VhdlParser.PortDescription> ports;
    protected Generic[] generics;
    protected List<Attribute<Integer>> genericAttrs;
    protected String name;
    protected AttributeOption appearance = StdAttr.APPEAR_EVOLUTION;
    protected String libraries;
    protected String architecture;
    private final LogisimFile logiFile;
    static final String ENTITY_PATTERN = "(\\s*\\bentity\\s+)%entityname%(\\s+is)\\b";
    static final String ARCH_PATTERN = "(\\s*\\barchitecture\\s+\\w+\\s+of\\s+)%entityname%\\b";
    static final String END_PATTERN = "(\\s*\\bend\\s+)%entityname%(\\s*;)";
    private final StringBuilder errTitle = new StringBuilder();
    private final StringBuilder errMessage = new StringBuilder();
    private int errCode = 0;
    private Exception errException;

    public static VhdlContent create(String name, LogisimFile file) {
        VhdlContent content = new VhdlContent(name, file);
        if (!content.setContent(TEMPLATE.replaceAll("%entityname%", name))) {
            content.showErrors();
        }
        return content;
    }

    public static VhdlContent parse(String name, String vhdl, LogisimFile file) {
        VhdlContent content = new VhdlContent(name, file);
        if (!content.setContent(vhdl)) {
            content.showErrors();
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String loadTemplate() {
        InputStream input = VhdlContent.class.getResourceAsStream(RESOURCE);
        BufferedReader in = new BufferedReader(new InputStreamReader(input));
        StringBuilder tmp = new StringBuilder();
        String line = "";
        try {
            while ((line = in.readLine()) != null) {
                tmp.append(line);
                tmp.append(System.getProperty("line.separator"));
            }
        }
        catch (IOException ex) {
            String string = "";
            return string;
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(VhdlContent.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return tmp.toString();
    }

    protected VhdlContent(String name, LogisimFile file) {
        this.logiFile = file;
        this.name = name;
        this.ports = new ArrayList<VhdlParser.PortDescription>();
    }

    @Override
    public VhdlContent clone() {
        try {
            VhdlContent ret = (VhdlContent)super.clone();
            ret.content = new StringBuilder(this.content);
            ret.valid = this.valid;
            return ret;
        }
        catch (CloneNotSupportedException ex) {
            return this;
        }
    }

    @Override
    public boolean compare(HdlModel model) {
        return this.compare(model.getContent());
    }

    @Override
    public boolean compare(String value) {
        return this.content.toString().replaceAll("\\r\\n|\\r|\\n", " ").equals(value.replaceAll("\\r\\n|\\r|\\n", " "));
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    public String getArchitecture() {
        if (this.architecture == null) {
            return "";
        }
        return this.architecture;
    }

    @Override
    public String getContent() {
        return this.content.toString();
    }

    public Generic[] getGenerics() {
        if (this.generics == null) {
            return new Generic[0];
        }
        return this.generics;
    }

    public List<Attribute<Integer>> getGenericAttributes() {
        if (this.genericAttrs == null) {
            this.genericAttrs = new ArrayList<Attribute<Integer>>();
            for (Generic g : this.getGenerics()) {
                this.genericAttrs.add(VhdlEntityAttributes.forGeneric(g));
            }
        }
        return this.genericAttrs;
    }

    public String getLibraries() {
        if (this.libraries == null) {
            return "";
        }
        return this.libraries;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public AttributeOption getAppearance() {
        return this.appearance;
    }

    public void setAppearance(AttributeOption a) {
        this.appearance = a;
        this.fireAppearanceChanged();
    }

    public List<VhdlParser.PortDescription> getPorts() {
        return this.ports;
    }

    public AttributeSet getStaticAttributes() {
        return this.staticAttrs;
    }

    public void aboutToSave() {
        this.fireAboutToSave();
    }

    public static boolean labelVHDLInvalid(String label) {
        if (!label.matches("^[A-Za-z]\\w*") || label.endsWith("_") || label.matches(".*__.*")) {
            return true;
        }
        return Vhdl.VHDL_KEYWORDS.contains(label.toLowerCase());
    }

    public static boolean labelVHDLInvalidNotify(String label, LogisimFile file) {
        String err = null;
        if (!label.matches("^[A-Za-z]\\w*") || label.endsWith("_") || label.matches(".*__.*")) {
            err = Strings.S.get("vhdlInvalidNameError");
        } else if (Vhdl.VHDL_KEYWORDS.contains(label.toLowerCase())) {
            err = Strings.S.get("vhdlKeywordNameError");
        } else if (file != null && file.containsFactory(label)) {
            err = Strings.S.get("vhdlDuplicateNameError");
        } else {
            return false;
        }
        OptionPane.showMessageDialog(null, label + ": " + err, Strings.S.get("validationParseError"), 0);
        return true;
    }

    public boolean setName(String name) {
        if (name == null || VhdlContent.labelVHDLInvalidNotify(name, this.logiFile)) {
            return false;
        }
        String entPat = ENTITY_PATTERN.replaceAll("%entityname%", this.name);
        String archPat = ARCH_PATTERN.replaceAll("%entityname%", this.name);
        String endPat = END_PATTERN.replaceAll("%entityname%", this.name);
        String str = this.content.toString();
        str = str.replaceAll("(?is)" + entPat, "$1" + name + "$2");
        str = str.replaceAll("(?is)" + archPat, "$1" + name);
        str = str.replaceAll("(?is)" + endPat, "$1" + name + "$2");
        return this.setContent(str);
    }

    @Override
    public void showErrors() {
        if (this.valid && this.errTitle.length() == 0 && this.errMessage.length() == 0) {
            return;
        }
        if (this.errException != null) {
            this.errException.printStackTrace();
        }
        if (this.errCode == 1) {
            JTextArea message = new JTextArea();
            message.setText(this.errMessage.toString());
            message.setEditable(false);
            message.setLineWrap(false);
            message.setMargin(new Insets(5, 5, 5, 5));
            JScrollPane sp = new JScrollPane(message);
            sp.setPreferredSize(new Dimension(700, 400));
            OptionPane.showOptionDialog(null, sp, this.errTitle.toString(), 0, 0, null, new String[]{Strings.S.get("validationErrorButton")}, Strings.S.get("validationErrorButton"));
        } else if (this.errCode == 2) {
            OptionPane.showMessageDialog(null, this.errMessage.toString(), this.errTitle.toString(), 1);
        } else {
            OptionPane.showMessageDialog(null, this.errMessage.toString(), this.errTitle.toString(), 0);
        }
    }

    @Override
    public boolean setContentNoValidation(String vhdl) {
        if (this.valid && this.content.toString().equals(vhdl)) {
            return true;
        }
        this.content = new StringBuilder(vhdl);
        this.valid = false;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setContent(String vhdl) {
        if (this.setContentNoValidation(vhdl)) {
            return true;
        }
        try {
            this.errTitle.setLength(0);
            this.errMessage.setLength(0);
            this.errCode = Softwares.validateVhdl(this.content.toString(), this.errTitle, this.errMessage);
            if (this.errCode != 0) {
                boolean bl = false;
                return bl;
            }
            VhdlParser parser = new VhdlParser(this.content.toString());
            try {
                parser.parse();
            }
            catch (Exception ex) {
                String msg = ex.getMessage();
                if (msg == null || msg.length() == 0) {
                    msg = ex.toString();
                }
                this.errTitle.append(Strings.S.get("validationParseError"));
                this.errMessage.append(msg);
                this.errException = ex;
                boolean bl = false;
                this.fireContentSet();
                return bl;
            }
            if (!parser.getName().equals(this.name)) {
                if (VhdlContent.labelVHDLInvalidNotify(parser.getName(), this.logiFile)) {
                    boolean ex = false;
                    return ex;
                }
            } else if (VhdlContent.labelVHDLInvalidNotify(parser.getName(), null)) {
                boolean ex = false;
                return ex;
            }
            this.valid = true;
            this.name = parser.getName();
            this.libraries = parser.getLibraries();
            this.architecture = parser.getArchitecture();
            this.ports.clear();
            this.ports.addAll(parser.getInputs());
            this.ports.addAll(parser.getOutputs());
            Generic[] oldGenerics = this.generics;
            List<Attribute<Integer>> oldAttrs = this.genericAttrs;
            this.generics = new Generic[parser.getGenerics().size()];
            this.genericAttrs = new ArrayList<Attribute<Integer>>();
            int i = 0;
            for (VhdlParser.GenericDescription g : parser.getGenerics()) {
                boolean found = false;
                if (oldGenerics != null) {
                    for (int j = 0; j < oldGenerics.length; ++j) {
                        Generic old = oldGenerics[j];
                        if (old == null || !old.getName().equals(g.getName()) || !old.getType().equals(g.getType())) continue;
                        this.generics[i] = old;
                        oldGenerics[j] = null;
                        this.genericAttrs.add(oldAttrs.get(j));
                        found = true;
                        break;
                    }
                }
                if (!found) {
                    this.generics[i] = new Generic(g);
                    this.genericAttrs.add(VhdlEntityAttributes.forGeneric(this.generics[i]));
                }
                ++i;
            }
            this.staticAttrs = VhdlEntityAttributes.createBaseAttrs(this);
            this.valid = true;
            boolean bl = true;
            return bl;
        }
        finally {
            this.fireContentSet();
        }
    }

    public static class Generic
    extends VhdlParser.GenericDescription {
        public Generic(VhdlParser.GenericDescription g) {
            super(g.name, g.type, g.dval);
        }

        public Generic(Generic g) {
            super(g.name, g.type, g.dval);
        }
    }
}

